/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;

    SloppyPhraseScorer(Weight weight, TermPositions[] tps, int[] positions, Similarity similarity, int slop, byte[] norms) {
        super(weight, tps, positions, similarity, norms);
        this.slop = slop;
    }

    protected final float phraseFreq() throws IOException {
        this.pq.clear();
        int end = 0;
        PhrasePositions pp = this.first;
        while (pp != null) {
            pp.firstPosition();
            if (pp.position > end) {
                end = pp.position;
            }
            this.pq.put(pp);
            pp = pp.next;
        }
        float freq = 0.0f;
        boolean done = false;
        do {
            PhrasePositions pp2 = (PhrasePositions)this.pq.pop();
            int start = pp2.position;
            int next = ((PhrasePositions)this.pq.top()).position;
            int pos = start;
            while (pos <= next) {
                start = pos;
                if (!pp2.nextPosition()) {
                    done = true;
                    break;
                }
                pos = pp2.position;
            }
            int matchLength = end - start;
            if (matchLength <= this.slop) {
                freq += this.getSimilarity().sloppyFreq(matchLength);
            }
            if (pp2.position > end) {
                end = pp2.position;
            }
            this.pq.put(pp2);
        } while (!done);
        return freq;
    }
}

