<?php
    /*
    *  $Id: codeCoverageMain.php 16428 2005-04-15 16:37:04Z npac $
    *  
    *  Copyright(c) 2004-2005, SpikeSource Inc. All Rights Reserved.
    *  Licensed under the Open Source License version 2.1
    *  (See http://www.spikesource.com/license.html)
    */
?>
<?php
    require_once "phpcoverage.inc.php";
    require_once PHPCOVERAGE_HOME . "/remote/RemoteCoverageRecorder.php";
    require_once PHPCOVERAGE_HOME . "/reporter/HtmlCoverageReporter.php";

    $web_url = "http://localhost/web/";
    $cov_url = $web_url . "phpcoverage.remote.top.inc.php";
    file_get_contents($cov_url . "?phpcoverage-action=init&cov-file-name=". urlencode("phpcoverage.data.xml") . "&tmp-dir=". urlencode("/tmp"));

    file_get_contents($web_url . "sample.php");

    // Get the code coverage XML back
    $xml = file_get_contents($cov_url . "?phpcoverage-action=get-coverage-xml");
    // Clean up
    file_get_contents($cov_url . "?phpcoverage-action=cleanup");

    // Configure reporter, and generate report
    $covReporter = new HtmlCoverageReporter(
        "Sample Web Test Code Coverage", "", "report");
    $excludePaths = array(); 
    // Set the include path for the web-app
    // PHPCOVERAGE_APPBASE_PATH is passed on the commandline
    $includePaths = array(realpath($PHPCOVERAGE_APPBASE_PATH));

    // Notice the coverage recorder is of type RemoteCoverageRecorder
    $cov = new RemoteCoverageRecorder($includePaths, $excludePaths, $covReporter);
    $cov->generateReport($xml);
    $covReporter->printTextSummary("report/report.txt");

?>
