<?php
    /*
    *  $Id: CoverageXmlParser.php 14663 2005-03-23 19:27:27Z npac $
    *  
    *  Copyright(c) 2004-2005, SpikeSource Inc. All Rights Reserved.
    *  Licensed under the Open Source License version 2.1
    *  (See http://www.spikesource.com/license.html)
    */
?>
<?php

    require_once dirname(__FILE__) . "/BasicXmlParser.php";

    /** 
    * Special parser for SpikePHPCoverage data parsing 
    * 
    * @author Nimish Pachapurkar <npac@spikesource.com>
    * @version $Revision: $
    * @package SpikePHPCoverage_Parser
    */
    class CoverageXmlParser extends BasicXmlParser {
        /*{{{ Members */

        protected $data = array();
        protected $lastFilePath;

        /*}}}*/
        /*{{{ public function startHandler() */

        public function startHandler($xp, $name, $attrs) {
            switch($name) {
            case "FILE":
                $fileAttributes = $this->handleAttrTag($name, $attrs);
                $this->lastFilePath = $fileAttributes["PATH"];
                if(!isset($this->data[$this->lastFilePath])) {
                    $this->data[$this->lastFilePath] = array();
                }
                break;

            case "LINE":
                $lineAttributes = $this->handleAttrTag($name, $attrs);
                $this->data[$this->lastFilePath][(int)$lineAttributes["LINE-NUMBER"]] += (int)$lineAttributes["FREQUENCY"];
                break;
            }
        }

        /*}}}*/
        /*{{{ public function getCoverageData() */

        public function getCoverageData() {
            return $this->data;
        }

        /*}}}*/
    }
?>
