<?php
/*
 *  $Id: phpcoverage.remote.top.inc.php 14666 2005-03-23 19:39:55Z npac $
 *  
 *  Copyright(c) 2004-2005, SpikeSource Inc. All Rights Reserved.
 *  Licensed under the Open Source License version 2.1
 *  (See http://www.spikesource.com/license.html)
 */
?>
<?php
    if(isset($_REQUEST)){
        error_log("[phpcoverage.remote.top.inc.php] ################## START ###################");

        $PHPCOVERAGE_HOME = false;
        global $PHPCOVERAGE_HOME;

        $basedir = dirname(__FILE__);
        $this_script = basename(__FILE__);
        $called_script = basename($_SERVER["SCRIPT_FILENAME"]);

        if(!empty($_REQUEST["PHPCOVERAGE_HOME"])) {
            $PHPCOVERAGE_HOME = $_REQUEST["PHPCOVERAGE_HOME"];
        }
        if(empty($PHPCOVERAGE_HOME)) {
            $env_var = getenv("PHPCOVERAGE_HOME");
            if(empty($env_var)) {
                $share_home = getenv("LOCAL_CACHE");
                $PHPCOVERAGE_HOME = $share_home . "/common/spikephpcoverage/src/";
            }
            else {
                $PHPCOVERAGE_HOME = $env_var;
            }
        }

        if(empty($PHPCOVERAGE_HOME) || !is_dir($PHPCOVERAGE_HOME)) {
            $msg = "ERROR: Could not locate PHPCOVERAGE_HOME [$PHPCOVERAGE_HOME]. ";
            $msg .= "Use 'php <filename> PHPCOVERAGE_HOME=/path/to/coverage/home'\n";
            die($msg);
        }


        // Fallback
        if(!defined("PHPCOVERAGE_HOME")) {
            $include_path = get_include_path();
            set_include_path($PHPCOVERAGE_HOME. ":" . $include_path);
            define('PHPCOVERAGE_HOME', $PHPCOVERAGE_HOME);
        }

        error_log("[phpcoverage.remote.top.inc.php] PHPCOVERAGE_HOME=" . $PHPCOVERAGE_HOME);

        require_once PHPCOVERAGE_HOME . "/remote/RemoteCoverageRecorder.php";
        require_once PHPCOVERAGE_HOME . "/reporter/HtmlCoverageReporter.php";

        // Create a distinct hash (may or may not be unique)
        $session_id = md5($_SERVER["REMOTE_ADDR"] . $_SERVER["SERVER_NAME"]);
        $tmpFile = "/tmp/phpcoverage.session." . $session_id;
        error_log("[phpcoverage.remote.top.inc.php] Session id: " . $session_id);
        if(file_exists($tmpFile)) {
            $object = file_get_contents($tmpFile);
            $cov = unserialize($object);
            error_log("[phpcoverage.remote.top.inc.php] Coverage object found: " . $cov);
        }
        else {
            $covReporter = new HtmlCoverageReporter("PHPCoverage report", 
            "", "/tmp/php-coverage-report");
            $cov = new RemoteCoverageRecorder(array(), array(), $covReporter);
            $object = serialize($cov);
            file_put_contents($tmpFile, $object);
            error_log("[phpcoverage.remote.top.inc.php] Stored coverage object: " . $cov);
        }

        if(!empty($_REQUEST["phpcoverage-action"])) {
            error_log("[phpcoverage.remote.top.inc.php] phpcoverage-action=" . strtolower($_REQUEST["phpcoverage-action"]));
            switch(strtolower($_REQUEST["phpcoverage-action"])) {
            case "init":
                $cov->setTmpDir($_REQUEST["tmp-dir"]);
                $cov->setCoverageFileName($_REQUEST["cov-file-name"]);
                if(!$cov->cleanCoverageFile()) {
                    die("Cannot delete existing coverage data.");
                }
                break;

            case "instrument":
                break;

            case "get-coverage-xml":
                $xml = $cov->getCoverageXml();
                echo $xml;
                // error_log("[phpcoverage.remote.top.inc.php] Got coverage xml: " . $xml);
                break;

            case "cleanup":
                if(file_exists($tmpFile) && is_writable($tmpFile)) {
                    unlink($tmpFile);
                    unset($cov);
                    error_log("[phpcoverage.remote.top.inc.php] Cleaned up!");
                    return;
                }
                else {
                    error_log("[phpcoverage.remote.top.inc.php] Error deleting file: " . $tmpFile);
                }
                break;
            }
        }

        if(!empty($called_script) && $this_script != $called_script) {
            $cov->startInstrumentation();
            error_log("[phpcoverage.remote.top.inc.php] Instrumentation turned on.");
        }
        $object = serialize($cov);
        file_put_contents($tmpFile, $object);
        error_log("[phpcoverage.remote.top.inc.php] BEGIN: " . $called_script);
    }
?>
