<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//


/** The Parse Class<br>
 *  The parser for PhpDoc, also has a renderer, but thats ok i don't want to rename everything right now
 *  @author Joshua Eichorn
 *  @version 0.1.2
 *  @copyright 2000 Joshua Eichorn 
 */

class Parse
{
        /** The directory where files are written */
        var $targetDir;

        /** An array holding all parsed information, used to generate files (replacement for the $output array) */
        var $docTree;

        /** Variable that hold the class Template, is instaniated in the constructor */
        var $template;

        /** Variable that hold the class Io, is instaniated in the constructor */
        var $io;


        /** Default constructor, loads the Template Class into $this->template */
        function parse()
        {
		$this->template = new Template;
		$this->io = new Io;
        }

        
        /** The main action function of parse, call to create a new
         *  phpdoc html file, output is a file in the $targerDir with
         *  same name only a .html instead of .php or .inc
         *  @param $file File to be parsed
         *  @see $targetDir
         */
        function create($file) 
        {
                //$class is in the format of $class[className] = lineNumber 
                
                $checkCode = file($file);

                // Check to see the file is a php file
                foreach($checkCode as $line)
                {
                        if (stristr($line,"<?php") || $phpfile == 1) {
                                $code[] = $line;
                                $phpfile = 1;
                        }
                }

                if (count($code) == 0) {
                        echo "No <?php tag was found in $file, it must not be a php file\n";
                } else {
                
                        // Pass One find all Class's in file
                        foreach($code as $lineNum => $line)
                        {
                                if (stristr($line,"class ")) {
                                        //Code in block comments needs to be ignored at somepoint

                                        //Make sure there is nothing in front of class except for spaces
                                        if ($this->keywordCheck("class",$line)) {       
                                                $class[$this->getName("class",$line)] = $lineNum;
                                        }
                                }
                        }

                        if (is_array($class)) {
                                foreach($class as $className => $classNum) {
                                        $this->docTree[$className][lineNum] = $classNum;

                                        // Does the class extend another class
                                        $extend = $this->getName("extends",$code[$classNum]);
                                        if (!empty($extend)) {
                                                $this->docTree[$className][extend] = $extend;
                                        }

                                        $this->docTree[$className][located] = $file;

                                        // Get description from phpdoc
                                        $ret = $this->getPhpDoc($code,$classNum);
                        
                                        $this->docTree[$className][description] = $ret[description];
                                        if (!empty($ret[author])) {  
                                                $this->docTree[$className][author] = $ret[author];
                                        }
                                        if (!empty($ret[version])) {  
                                                $this->docTree[$className][version] = $ret[version];
                                        }

                                        // Make variable and method list
                                        $i = $classNum;
        
                                        $stop = $this->getClassStop($class,$className);
                                        if (!$stop) {
                                                $stop = count($code);
                                        }
                                        while ($i < $stop) {
                                                if (stristr($code[$i],"var ")) {
                                                        //Code in block comments needs to be ignored at somepoint

                                                        //Make sure there is nothing in front of var except for spaces
                                                        if ($this->keywordCheck("var",$code[$i])) {
                                                                $ret = $this->getPhpDoc($code,$i);
                                                
                                                                $varname = $this->getName("var",$code[$i]);
                                                                foreach($ret as $key => $val) {
                                                                        $this->docTree[$className]["vars"][$varname][$key] = $val;
                                                                }
                                                        }
                                                }
                                                if (stristr($code[$i],"function ")) {
                                                        //Code in block comments needs to be ignored at somepoint

                                                        //Make sure there is nothing in front of var except for spaces
                                                        if ($this->keywordCheck("function",$code[$i])) {
                                                                $ret = $this->getPhpDoc($code,$i);
                                                
                                                                $funcName = $this->getName("function",$code[$i]);
                                                                $para = $this->getParameters($code[$i]);
                                                                if (strcasecmp($funcName,$className) == 0) {
                                                                        foreach($ret as $key => $val) {
                                                                                $this->docTree[$className]["constructors"][$funcName][$key] = $val;
                                                                                $this->docTree[$className]["constructors"][$funcName][paralist] = $para;
                                                                        }
                                                                } else {
                                                                        foreach($ret as $key => $val) {
                                                                                $this->docTree[$className]["functions"][$funcName][$key] = $val;
                                                                                $this->docTree[$className]["functions"][$funcName][paralist] = $para;
                                                                        }
                                                                }
                                                        }
                                                }
                                                $i++;
                                        }
                                }

                        } else {
                                echo "File: $file doesn't contain a class, documentation is only support in classes\n";
                        }
                }       
        }
        
        /** render creates the output files for each class from the $docTree array */
        function render()
        {
                
                foreach($this->docTree as $class => $info) {

                        $output[] = $this->template->pageTop("Class $class");
			$output[] = $this->template->navBar();

                        $output[] = "<!-- Start of Class Data -->";
                        $output[] = "<H2>";
                        $output[] = "Class $class";
                        $output[] = "</H2>";

			$output[] = $this->extend($class);
                        
                        $output[] = "<b><i>Located in File: $info[located]</i></b><br>";

			$output[] = $this->template->extendedDesc($info,"class");

                        $output[] = "</DL>";
                        $output[] = "<HR>";

                        $output[] = $this->template->summaryHeader("Variable");

                        if (is_array($info["vars"])) {
                                foreach($info["vars"] as $varname => $data) {
                                        $output[] = "<TR BGCOLOR='white' CLASS='TableRowColor'>";
                                        $output[] = "<TD><CODE><B><A HREF='$class.html#$varname'>$varname</A></B></CODE>";
                                        $output[] = "<BR>";
                                        $output[] = "<blockquote><pre>$data[description]</pre></blockquote></TD>";
                                        $output[] = "</TR>\n";
                                }
                        }

                        $output[] = "</TABLE>";

                        $output[] = "<BR>";
                        $output[] = $this->template->summaryHeader("Constructor");

                        if (is_array($info["constructors"])) {
                                foreach($info["constructors"] as $name => $data) {
                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[paralist] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }

                                        $output[] = "<TR BGCOLOR='white' CLASS='TableRowColor'>";
                                        $output[] = "<TD><CODE><B><A HREF='$class.html#$name'>$name</A></B>($paralist)</CODE>";
                                        $output[] = "<BR>";
                                        $output[] = "<blockquote><pre>$data[description]</pre></blockquote></TD>";
                                        $output[] = "</TR>\n";
                                }
                        }

                        $output[] = "</TABLE>";

                        $output[] = "<BR>";

                        $output[] = $this->template->summaryHeader("Method");

                        if (is_array($info["functions"])) {
                                foreach($info["functions"] as $name => $data) {
                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[paralist] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }
                                        $paralist = substr($paralist,0,(strlen($paralist) -2));

                                        $output[] = "<TR BGCOLOR='white' CLASS='TableRowColor'>";
                                        $output[] = "<TD><CODE><B><A HREF='$class.html#$name'>$name</A></B>($paralist)</CODE>";
                                        $output[] = "<BR>";
                                        $output[] = "<blockquote><pre>$data[description]</pre></blockquote></TD>";
                                        $output[] = "</TR>\n";
                                }
                        }

                        $output[] = "</TABLE>";

                        $output[] = "<BR>";
                        $output[] = "<BR>";

                        $output[] = "<!-- ============ VARIABLE DETAIL =========== -->";
                        $output[] = "";
                        $output[] = "<A NAME='variable_detail'></A>";
                        $output[] = "<TABLE BORDER='1' CELLPADDING='3' CELLSPACING='0' WIDTH='100%'>";
                        $output[] = "<TR BGCOLOR='#CCCCFF' CLASS='TableHeadingColor'>";
                        $output[] = "<TD COLSPAN=1><FONT SIZE='+2'>";
                        $output[] = "<B>Variable Detail</B></FONT></TD>";
                        $output[] = "</TR>";
                        $output[] = "</TABLE>";

                        if (is_array($info[vars])) {
                                foreach($info[vars] as $name => $data) {
                                        $output[] = "<A NAME='$name'><!-- --></A><H3>";
                                        $output[] = "$name</H3>";

                                        $output[] = $this->template->extendedDesc($data,"variable");

                                        $output[] = "<HR>";
                                }
                        }


                        $output[] = "<BR>";
                        $output[] = "<BR>";

                        $output[] = "<!-- ============ CONSTRUCTOR DETAIL =========== -->";
                        $output[] = "";
                        $output[] = "<A NAME='constructor_detail'></A>";
                        $output[] = "<TABLE BORDER='1' CELLPADDING='3' CELLSPACING='0' WIDTH='100%'>";
                        $output[] = "<TR BGCOLOR='#CCCCFF' CLASS='TableHeadingColor'>";
                        $output[] = "<TD COLSPAN=1><FONT SIZE='+2'>";
                        $output[] = "<B>Constructor Detail</B></FONT></TD>";
                        $output[] = "</TR>";
                        $output[] = "</TABLE>";

                        if (is_array($info[constructors])) {
                                foreach($info[constructors] as $name => $data) {
                                        $output[] = "<A NAME='$name'><!-- --></A><H3>";
                                        $output[] = "$name</H3>";
                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[paralist] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }
                                        $paralist = substr($paralist,0,(strlen($paralist) -2));

                                        $output[] = "<CODE><B>$name</B>($paralist)</CODE>";

                                        $output[] = $this->template->extendedDesc($data,"constructor");

                                        $output[] = "<HR>";
                                }
                        }


                        
                        $output[] = "<BR>";
                        $output[] = "<BR>";

                        $output[] = "<!-- ============ METHOD DETAIL =========== -->";
                        $output[] = "";
                        $output[] = "<A NAME='method_detail'></A>";
                        $output[] = "<TABLE BORDER='1' CELLPADDING='3' CELLSPACING='0' WIDTH='100%'>";
                        $output[] = "<TR BGCOLOR='#CCCCFF' CLASS='TableHeadingColor'>";
                        $output[] = "<TD COLSPAN=1><FONT SIZE='+2'>";
                        $output[] = "<B>Method Detail</B></FONT></TD>";
                        $output[] = "</TR>";
                        $output[] = "</TABLE>";

                        if (is_array($info[functions])) {
                                foreach($info[functions] as $name => $data) {
                                        $output[] = "<A NAME='$name'><!-- --></A><H3>";
                                        $output[] = "$name</H3>";

                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[paralist] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }
                                        $paralist = substr($paralist,0,(strlen($paralist) -2));

                                        $output[] = "<CODE><B>$name</B>($paralist)</CODE>";

                                        $output[] = $this->template->extendedDesc($data,"function");

                                        $output[] = "<HR>";
                                }
                        }


                        $filename = $this->targetDir . "/" . $class . ".html";
                        $this->io->writeArray($filename,$output);
                        unset($output);
                }
        }
                                
        /** getName returns the first word after the keyword in the input string
         *  @param $keyword The keyword your getting the name for
         *  @param $line The line of code your looking at
         *  @return The name of the keyword ex. function bob
         */
        function getName($keyword, $line)
        {       
                if (stristr($line,$keyword)) {
                        $keywordPos = strpos($line,$keyword);
                        $namePosStart = strpos($line," ",$keywordPos) + 1;
                        $namePosEnd = strpos($line," ",$namePosStart);

                        if ( (int)$namePosEnd == 0) {
                                $namePosEnd = strlen($line);
                        }
                        $ret = trim(substr($line,(int)$namePosStart,($namePosEnd - $namePosStart)));
                        if (strstr(substr($ret,-1),";")) {
                                $ret = substr($ret,0,(strlen($ret) -1));
                        }

                        // Look for a functions ()
                        if (strstr($ret,"(")) {
                                $pos = strpos($ret,"(");
                                $ret = substr($ret,0,$pos);
                        }
                        return $ret;
                }
        }

        /** getParameters returns a functions parameters in an array 
         *  @param $line The line of code with a function definition 
         *  @return functions parameters in an array 
         */
        function getParameters($line)
        {
                $startPos = strpos(trim($line),"(") + 1;
                $endPos = strpos(trim($line),")");
                $len = $endPos - $startPos;     
                
                $tmp = substr(trim($line),$startPos,$len);
                return explode(",",$tmp);
        }
                

        /** keywordCheck checks to make sure there is nothing in front of a keyword except for spaces
         *  @param $keyword the keyword your check ex. class
         *  @param $line a line of code to be checked
         *  @return true if nothing but spaces false if something else
         */
        function keywordCheck($keyword,$line)
        {
                $pos = strpos(strtolower($line),$keyword);
                $check = substr($line,0,$pos);
                if (strlen(trim($check)) == 0) {
                        return true;
                } else {
                        return false;
                }
        }


        /** getPhpDoc returns an array containing data taken from the phpDoc comments in the code
         *  @param code Array containing code that is being parsed
         *  @param keywordLineNum int of line where keyword is located
         *  @return Array containing description and words after @ as key
         */
        function getPhpDoc($code, $keywordLineNum)
        {
                $i = ($keywordLineNum - 1);
                $inret = 0;
                while ($stop != 1)
                {
                        if ($inret == 0) {
                                if (strstr($code[$i],"*/")) {
                                        $inret = 1;
                                } else {
                                        if (strlen(trim($code[$i])) != 0) {
                                                $stop = 1;
                                        }
                                }
                        }
                                
                        if ($stop != 1) {
                                $tmp[] = $code[$i];
                        }
                        if (strstr($code[$i],"/**")) {
                                $stop = 1;
                        }
                        if (strstr($code[$i],"/*")) {
                                $stop = 1;
                        }
                        $i--;
                }
                
                if (is_array($tmp)) {
                        $tmp = array_reverse($tmp);

			$continue = 0;
			$desdone = 0;

                        foreach($tmp as $line)
                        {
				$look = substr(ltrim($line),2);
				if (strstr(substr($look,0,1),"*")) {
					$look = substr(ltrim($line),1);
				}
				if (strstr(substr($look,0,1),"/")) {
					$look = substr(ltrim($line),1);
				}
				if (strstr(substr($look,0,2),"**")) {
					$look = substr(ltrim($line),3);
				}

				if ($continue == 1) {
					if (strstr($look,"@")) {
						$continue = 0;
					} else {
						if (strcmp($keyword,"param") == 0) {
							$ret[$keyword][(count($ret[$keyword]) -1)] .= " $look";
						} else {
							$ret[$keyword] .= " $look";
						}
					}
				} 
				
                                if (strstr($look,"@")) {
					$desdone = 1;
                                        $pos = strpos($look," ",1);
                                        $keyword = trim(strtolower(substr($look,1,$pos)));
					if (strcmp("@",substr($keyword,0,1)) == 0) {
        		                       	$keyword = substr($keyword,1);
                        		}
					$continue = 1;
                                        if (strcmp($keyword,"param") == 0) {
                                               	$ret[$keyword][] = trim(substr($look,$pos));
	                                } else {
        	                        	$ret[$keyword] = trim(substr($look,$pos));
					}
                                } else if ($desdone != 1) {
					$continue = 0;
                                        $ret[description] .= $look;
                                }
				unset($look);
                        }
                        if (strstr(substr($ret[description],-3),"*/")) {
                                $ret[description] = substr($ret[description],0,(strlen($ret[description]) -3));
                        }
                } else {
                        $ret[description] = "Not Documented";
                }
                return $ret;
        }       

        /** Finds the beginning of the next class
         *  @param $class An array with name => linenum pairs
         *  @param $className the name of the current class
         *  @return line number of next class
         */
        function getClassStop($class,$className)
        {
                // get starting line number of next class in file
                while( list($key,$val) = each($class)) {
                        if ($returnNext == 1) {
                                return $val;
                        }
                        if (strcmp($key,$className) == 0) {
                                $returnNext = 1;
                        }
                }
        }

        /** Creates index.html with frame code and a left pane listing all classes
         */
        function createIndex()
        {

                $left[] = $this->template->pageTop("All Classes");

                $left[] = "<FONT size='+1' CLASS='FrameHeadingFont'>";
                $left[] = "<B>All Classes</B></FONT>";
                $left[] = "<BR>";
                $left[] = "<TABLE BORDER='0' WIDTH='100%'>";

                foreach($this->docTree as $className => $data)
                {
                        $tmp[] = $className;
                }
                reset($tmp);
                sort($tmp);

                foreach($tmp as $className)
                {
                        if (!$start) {
                                $start = "$className.html";
                        }
                        $left[] = "<TR><TD NOWRAP>";
                        $left[] = "<FONT CLASS='FrameItemFont'><A HREF='$className.html' TARGET='right'>$className</A>";
                        $left[] = "<BR></FONT></TD></TR>";
                }
                $left[] = "</TABLE>";
                $left[] = "</BODY>";
                $left[] = "</HTML>";
                        
                $this->io->writeArray($this->targetDir . "/left.html",$left);

		
                $indexHtml[] = $this->template->index($start);
	
                $this->io->writeArray($this->targetDir . "/index.html",$indexHtml);
        }


	/**
	 *  Creates the style sheet
	 */
	function createStyleSheet()
	{
		$output[] = $this->template->styleSheet();
		$this->io->writeArray($this->targetDir . "/stylesheet.css",$output);
	}

	/**
	 *  Uses docTree to create an index of all functions
	 */
	function createObjectIndex()
	{
		foreach($this->docTree as $className => $data)
		{
			foreach($data as $key => $val) {
				if (is_array($val)) {
					switch ($key) {
					case "functions":
						foreach($val as $funcName => $data)
						{
							$funcTree[$funcName][type] = "Method";
							$funcTree[$funcName][className] = $className;
							$funcTree[$funcName][data] = $data;
						}
					break;	
					case "constructors":	
						foreach($val as $conName => $data)
						{
							$funcTree[$conName][type] = "Constructor";
							$funcTree[$conName][className] = $className;
							$funcTree[$conName][data] = $data;
						}
					break;	
					case "vars":
						foreach($val as $varName => $data)
						{
							$varName = substr($varName,1);
							$funcTree[$varName][type] = "Variable";
							$funcTree[$varName][className] = $className;
							$funcTree[$varName][data] = $data;
						}
					break;	
					}
				}
			}
		}
	
		uksort($funcTree, "cmp");

		$output[] = $this->template->pageTop();
		$output[] = $this->template->navbar();
		$output[] = "alphabet links\n";
		foreach($funcTree as $funcName => $data)
		{
			$letter = strtoupper(substr($funcName,0,1));
			if (strcmp($cletter,$letter) != 0) {
				$cletter = $letter;
				$output[] = "<h2>$letter</h2><a name=$letter></a>\n";

				$alpha .= "&nbsp;<a href='#$letter'>$letter</a>&nbsp;\n";
			}
			
			$output[] = "<b><a href='$data[className].html#$funcName'>$funcName</a></b>";
			$output[] = "$data[type] of class <a href='$data[className].html'>$data[className]</a>";
			$output[] = "<blockquote><pre>" . $data[data][description] . "</pre></blockquote><hr>";
		}

		$output[2] = $alpha;

		$this->io->writeArray($this->targetDir . "/index-index.html",$output);
	}




	/** handle classes extending other classes follow tree all the way to base 
	 *  @param $currentClass Centains name of class that current class extends
	 *  @param $className Centains name of class that current class extends
	 *  @return preformated tree with class extend info in it
	 */
	function extend($currentClass)
	{
		$classTree[] = "$currentClass";
        	$out = "<pre>";

		while ($this->docTree[$currentClass][extend]) {	
			$currentClass = $this->docTree[$currentClass][extend];
			$classTree[] = $currentClass;
		}

		$numSpaces = 2;
		$i = count($classTree) -1;
		if ($i > 0) {
			$out .= "$classTree[$i]\n";
		}
		$i--;
		while ($i > 0) {
        		$out .= str_repeat(" ",$numSpaces) . "|\n";
			$out .= str_repeat(" ",$numSpaces) . "+--$classTree[$i]\n";

			$i--;
			$numSpaces = $numSpaces + 3;
		}

		if ($i == 0) {
        		$out .= str_repeat(" ",$numSpaces) . "|\n";
			$out .= str_repeat(" ",$numSpaces) . "+--<B>$classTree[$i]</B>\n";

			$out .= "</pre>";
		
        	        $out .= "<b>Extends: <a href='$classTree[1].html'>$classTree[1]</a></b><br>";
		}

		$out .= "<hr>";
		return $out;
	}

	/** Sets the output directory of create
         *  @param $dir the output directory
         *  @see create
         */
        function setTargetDir($dir)
        {
                if (strlen($dir) > 0) {
                        $this->targetDir = $dir;
                } else {
                        echo "a target directory must be specified\n try phpdoc -h\n";
                        die();
                }
        }

}
?>
