<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

/** PHP auto documentor, like javadoc
 *  Web interface
 *  @author Joshua Eichorn
 *  @version 0.1.3
 *  @copyright Joshua Eichorn
 */

include("Parse.inc");
include("Template.inc");
include("Io.inc");

function cmp ($a, $b) {
        $a = strtoupper($a);
        $b = strtoupper($b);
        return strcmp($a,$b);
}

$phpdoc = new Parse;
if ($HTTP_POST_VARS[submit]) {
	$setting = $HTTP_POST_VARS[setting];
} else {
	echo $phpdoc->template->webInterface($phpdoc->io->phpDocOptions);
	die();
}
$phpdoc->setTargetDir($setting[target]);

if (strlen($setting[filename]) > 0)
{
        $files = explode(",",$setting[filename]);
        foreach($files as $file)
        {
                $phpdoc->create($file);
        }
}
if (strlen($setting[directory]) > 0)
{
        $dirs = explode(",",$setting[directory]);
        foreach($dirs as $dir)
        {
                $files = $phpdoc->io->dirList($dir);
                foreach($files as $file)
                {
                        $phpdoc->create($file);
                }
        }
}

echo "<pre>\n";
$phpdoc->render();
$phpdoc->createIndex();
$phpdoc->createObjectIndex();
$phpdoc->createStyleSheet();
echo "</pre>\n";

?>
