<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
					
//
// Copyright 2000 Joshua Eichorn
// Email jeichorn@users.sourceforge.net
// Web http://phpdocu.sourceforge.net/
//     http://sourceforge.net/projects/phpdocu/
//

/**
 *  Class to handle file and user io opperations
 */
class Io 
{
	
	/** Holds all the options that are avaible to the cmd line interface
	 *  and to the different web interfaces
	 */
	var $phpDocOptions;

	/**
	 *  creates an array $this->phpDocOptions and sets program options in it
	 *  Array is in the format of:
	 *  [filename][tag][] = "f";
	 *  [filename][tag][] = "-file";
	 *  [filename][desc] "name of file to parse"
	 */
	function setupPhpDocOptions()
	{
		$this->phpDocOptions[filename][tag] = array( "-f", "--filename");
		$this->phpDocOptions[filename][desc] = "name of file(s) to parse ',' file1,file2";
		$this->phpDocOptions[filename][type] = "text";

		$this->phpDocOptions[directory][tag] = array( "-d", "--directory");
		$this->phpDocOptions[directory][desc] = "name of a directory(s) to parse directory1,directory2";
		$this->phpDocOptions[directory][type] = "text";

		$this->phpDocOptions[target][tag] = array("-t", "--target");
		$this->phpDocOptions[target][desc] = "	path where to save the generated files";
		$this->phpDocOptions[target][type] = "type";
		
		$this->phpDocOptions[help][tag] = array("-h", "--help");
		$this->phpDocOptions[help][desc] = "	show this help message";

		$this->phpDocOptions[general][message] = "You can have multiple directories and multiple files, as well as a combination of both options";
	}

	
	/** created a help message
	 *  @return a string containing a help message
	 */
	function displayHelpMsg()
	{
		unset($ret);
		$ret = "\n";
		foreach($this->phpDocOptions as $data)
		{
			unset($tag);
			if (is_array($data[tag])) {
				foreach($data[tag] as $param) {
					$tag .= "$param ";
				}
			}
			$ret .= "  $tag		$data[desc]\n";
		}
		$ret .= "\n$data[message]\n";
		return $ret; 
	}


	/** write an array out to a file
         *  @param $fileName The name of the file to be written
         *  @param $array The to be wrote
         */
        function writeArray($fileName, $array)
        {
                $fp = fopen($fileName, "w");
                echo "Creating $fileName\n";
                foreach($array as $line) {
                        fputs($fp,$line . "\n");
                }
                fclose($fp);
        }

	/** Parses $GLOBALS[argv] and creates a setup array
	 *  @return a setup array
	 */
	function parseArgv()
	{
		$valnext = "junk";
		foreach ( $GLOBALS[argv] as $cmd )
		{
		        $setting[$valnext] = $cmd;
		        foreach( $this->phpDocOptions as $name => $data )
			{
			if (is_array($data[tag])) {
					if (in_array($cmd,$data[tag])) {
						$valnext = $name;
						break;
					} else {
						$valnext = "junk";
					}
				}
			}
		}
		if (count($setting) < 2) {
			echo $this->displayhelpMsg();
			die();
		}
		return $setting;
	}


	/** Returns an array containing a list of files in a directory
         *  @param $directory full path to the directory you want the list of
         */
        function dirList($directory)
        {
                $d = dir($directory);
                while($entry=$d->read()) {
                        if (strcmp($entry,".") != 0 && strcmp($entry,"..") != 0) {
                                if (is_file("$directory/$entry")) {
                                        $ret[] = "$directory/$entry";
                                }
                                if (is_dir("$directory/$entry")) {
                                        $tmp = $this->dirList("$directory/$entry");
					if (is_array($tmp)) {
	                                        foreach($tmp as $ent) {
        	                                        $ret[] = $ent;
                	                        }
					}
                                }
                        }
                }
                $d->close();
                return $ret;
        }
}
