<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000 Joshua Eichorn
// Email jeichorn@users.sourceforge.net
// Web http://phpdocu.sourceforge.net/
//     http://sourceforge.net/projects/phpdocu/
//

// Main Define Block, where all Constants are named

// Actions
define("START_FILE"		,			1001	);
define("STOP_FILE"		,			1002	);
define("START_PHP"		,			1003	);
define("STOP_PHP"		,			1004	);
define("START_CLASS"		,			1005	);
define("STOP_CLASS"		,			1006	);
define("START_GLOBAL"		,			1007	);
define("STOP_GLOBAL"		,			1008	);
define("START_FUNC"		,			1009	);
define("STOP_FUNC"		,			1010	);
define("START_DEFINE"		,			1011	);
define("STOP_DEFINE"		,			1012	);
define("START_VAR"		,			1013	);
define("STOP_VAR"		,			1014	);
define("START_COMMENT"		,			1015	);
define("STOP_COMMENT"		,			1016	);
define("START_METHOD"		,			1017	);
define("STOP_METHOD"		,			1018	);
define("START_CONSTRUCT"	,			1019	);
define("STOP_CONSTRUCT"		,			1020	);
define("START_BLOCK_COMMENT"	,			1021	);
define("STOP_BLOCK_COMMENT"	,			1022	);
define("START_BLOCK"		,			1023	);
define("STOP_BLOCK"		,			1024	);
define("_CSTYLE_COMMENT"	,			1025	);
define("_SHELL_COMMENT"		,			1026	);
define("_KEYWORD"		,			1027	);
define("_COMMENT_CHAR"		,			1028	);



/** The Parse Class<br>
 *  Big changes were made at version 0.1.6, the 'New Parse Engine' was intoduced, this totally reorganized
 *  The entire layout of the program, adding a new class, and creating an inheritence stucture
 *  @author Joshua Eichorn
 *  @version 0.1.6
 *  @copyright 2000 Joshua Eichorn 
 */

class Parse extends Render 
{
        /** An array holding all parsed information, used to generate files */
        var $docTree;

	/** An array to hold the state of the parse engine */
	var $eventStack;

	/** The file to be parsed */
	var $store;

	/** The current line you are parsing */
	var $line;

	/** The Array index of store that we are in */
	var $currentLineNum;

	/** String to hold working current phpDoc comment in */
	var $currentComment;
	
	/** String to hold temporay working phpDoc comment in */
	var $workComment;

	/** String to hold current filename */
	var $currentFile;
	
	/** If true extra debuging info is show */
	var $debug;
	
	/**
	 *  Main constructor for class Parse
	 */
	function Parse()
	{
	//	$this->debug =1;
		$this->currentLineNum = -1;
		$this->setupPhpDocOptions();
	}


	/**
	 *  The main user function, call this function with the filename to create the entries in the docTree array
	 *  @param $file the file to be parsed
	 */
	function create($file)
	{
		$this->store = file($file);

		// Check to see the file is a php file
		foreach($this->store as $line)
		{
			if (stristr($line,"<?php") || $phpfile == 1) {
				$code[] = $line;
				$phpfile = 1;
			}
		}

		if (count($code) == 0) {
			echo "No <?php tag was found in $file, it must not be a php file\n";
		} else {
			$this->currentFile = $file;
			$this->eventStack[] = START_FILE;
			$this->parser();
		}
	}


	/**
	 *  Puts the next store into line, uses currentLineNum
	 */
	function getLine()
	{
		$this->currentLineNum++;
		if ($this->currentLineNum < count($this->store)) {
			$this->line = $this->store[$this->currentLineNum];
		} else {
			$this->throwEvent(STOP_FILE);
		}
	}


	/**
	 *  The main action function of parse, Is based on a Event driven main parser
	 *  which throws actions to action(), and error to exception()
	 *  Order is kept using the eventStack var
	 */
	function parser()
	{
		$event = $this->getCurrentEvent();
		while ( $event != STOP_FILE )
		{
			$lastLineNumProcessed = $this->currentLineNum;

			// Get a new Line to parse if old line is fully processed
			if (strlen(trim($this->line)) == 0) {
				$this->getLine();
			}
				
			// Get Current Event, Check for any event it allows
			$lastevent = $event;
			$event = $this->getCurrentEvent();
			if ($this->debug == 1) {
				echo("line #$this->currentLineNum = $this->line");
				echo $this->codeToEvent($event) . "\n";
			}

			// Error Checking, if on same line and same event > 50 times die with error message
			if ($lastevent == $event) {
				$eventcount++;
			} else {
				$eventcount = 0;
				$linecount = 0;
			}

			if ($lastLineNumProcessed == $this->currentLineNum) {
				$linecount++;
			} else {
				$eventcount = 0;
				$linecount = 0;
			}

			if ( $eventcount > 50 && $linecount > 50) {
				// We are stuck in a loop die with a message
				die(	"\n\n######################################################\n" .
					"FATAL Error unparsable line\n" .
					"In File: $this->currentFile\n" .
					"currentLineNum = $this->currentLineNum\n" .
					"Line # " . ($this->currentLineNum - 1) . " is: " . $this->store[$this->currentLineNum -1] . 
					"Line # " . $this->currentLineNum .     " is: " . $this->store[$this->currentLineNum] . 
					"Line # " . ($this->currentLineNum + 1) . " is: " . $this->store[$this->currentLineNum +1] .
					"\nthis->line = $this->line" .
					"The current event is: " . $this->codeToEvent($event) . "\n" .
					"\n\nPlease email this error message to forestg@users.sourceforge.net\n" .
					"It would also be handy to have the file that this error happened in\n" .
					"If that is a possibility just attach it to the email\n" .
					"Thanks,\n    Joshua Eichorn\n" .
					"\nEvent Stack Dump\n" .
					$this->debugDumpEventStack() . "\n" .
					"######################################################\n\n");
			}
					
			switch ($event)
			{
				case START_FILE:
					if ( !$this->checkStartPhp() ) {
						unset($this->line);
					}
				break; 
				case START_PHP:
					// Get rid of tag that causes event to be thrown
					$this->textRemoveLeft("<?php");

					if (! ($this->checkStartClass() || $this->checkStartGlobal() ||
						$this->checkStartComment() || $this->checkComment()) ) {
						unset( $this->line);
					}
				break;
				case STOP_PHP:
					$this->checkStartPhp();
				break;
				case START_GLOBAL:
					// set class to global class
					$class_name = "Global_" . basename($this->currentFile);;
					$dont_parse_class = 1;
					$this->throwEvent(STOP_GLOBAL);
					if (! $this->checkComment() || $this->checkStartComment() ) {
						if ( ($this->checkStartDefine() == false) &&
							( $this->checkStartVar() == false) &&
							( $this->checkStartFunc() == false)
						) {
							$this->popEvent();
						} else if (! $this->checkStopGlobal() || $this->checkStopPhp() ) {
							//unset($this->line); bad breaks define
						}
					}
							
				break;
				case STOP_GLOBAL:
					$dont_parse_class = 0;
					unset($class_name);
					$this->stackRemoveAbove(START_GLOBAL);
				break;
				case START_CLASS:	
					// Process Class Stuff extends name etc
					if ( (strlen($class_name) < 1) && ($dont_parse_class == 0) ) {
						$class_name = $this->textGetFirstWord();
						$this->textRemoveLeft($class_name);
						if (stristr($this->line,"extends")) {
							$parent_class = $this->textGetWordAfter("extends");
							$this->textRemoveLeft($parent_class);
						}

						// Create first entry for class in docTree
						$this->docTree[$class_name][parent] = $parent_class;
						$this->docTree[$class_name][file] = $this->textGetFileBaseName($this->currentFile);
						$this->docTree[$class_name][data][data] = $this->textParseComment();
					}

					$this->checkStartBlock(STOP_CLASS);
				break;
				case STOP_CLASS:
					unset( $class_name );
					unset( $parent_class );
					$this->stackRemoveAbove(START_CLASS);
				break;
				case START_BLOCK:
					if (!$this->checkStartComment()) {
						if (	( $this->checkComment() == false ) &&
							( $this->checkStopBlock() == false ) &&
							( $this->checkStartDefine() == false ) &&
							( $this->checkStartVar() == false ) &&
							( $this->checkStartFunc() == false ) && 
							( $this->checkStartBlock() == false )
						) {
							unset($this->line);
						} 
					}
				break;
				case STOP_BLOCK:
					$this->stackRemoveAbove(START_BLOCK);
				break;
				case START_FUNC:
					if (! $this->checkComment() || $this->checkStopPhp() || $this->checkStartComment() ) {
						$this->checkStartMethod( $class_name );
						$this->checkStartConstruct( $class_name );
					}
				break;
				case STOP_FUNC:
					$this->stackRemoveAbove(START_FUNC);
				break;
				case START_DEFINE:
					if ( 	 $this->checkStopPhp() == false &&
						 $this->checkComment() == false
					) {
						if ( ($this->checkStopDefine() == false) ) {
							// do define stuff
						}
					}
				break;
				case STOP_DEFINE:
					$this->stackRemoveAbove(START_DEFINE);
				break;
				case START_VAR:
					if ( 	( $this->checkStopPhp() == false ) &&
						( $this->checkComment() == false ) 
					) {
						if (!$var_name) {	
							$var_name = $this->textGetFirstWord();
							$this->textRemoveLeft($var_name);
							$this->docTree[$class_name][vars][$var_name][data] = $this->textParseComment();
							$this->throwEvent(STOP_VAR);
						}
					}
				break;
				case STOP_VAR:
					unset($var_name);
					$this->stackRemoveAbove(START_VAR);
				break;
				case START_COMMENT:
					$this->checkStopComment();
					$this->checkStopPhp();
					if ($this->checkComment() ||
						$this->checkStopBlock() ||
						$this->checkStartDefine() ||
						$this->checkStartVar() ||
						$this->checkStartFunc() ||
						$this->checkStartBlock()
					) {

					} else {
						$this->workComment[] = $this->line;
						unset($this->line);
					}
				break;
				case STOP_COMMENT:
					$this->currentComment = $this->workComment;
					unset($this->workComment);
					$this->stackRemoveAbove(START_COMMENT);
				break;
				case START_METHOD:
					if (($this->checkStopPhp() == false) && ($this->checkComment() == false) ) {
						if (!$method_name) {	
							$method_name = $this->textGetBeforeString( "(" );
							$this->textRemoveLeft("(");
							$parameter_list = $this->textGetBeforeString( ")" );
							$this->textRemoveLeft(")");

							$this->docTree[$class_name][method][$method_name][data] = $this->textParseComment();
							$this->docTree[$class_name][method][$method_name][params] = explode(",",$parameter_list);
							$this->throwEvent(STOP_METHOD);
						} else if ( ! $this->checkStartBlock() ) {
							unset($this->line);
						}
					}
				break;
				case STOP_METHOD:
					unset($method_name);
					$this->stackRemoveAbove(START_METHOD);
				break;
				case START_CONSTRUCT:
					if (($this->checkStopPhp() == false) && ($this->checkComment() == false) ) {
						if (empty($constructor_name)) {	
							$constructor_name = $this->textGetBeforeString( "(" );
							$this->textRemoveLeft("(");
							$parameter_list = $this->textGetBeforeString( ")" );
							$this->textRemoveLeft(")");

							$this->docTree[$class_name][constructor][$constructor_name][data] = $this->textParseComment();
							$this->docTree[$class_name][constructor][$constructor_name][params] = explode(",",$parameter_list);
							$this->throwEvent(STOP_CONSTRUCT);
						} else if ( ! $this->checkStartBlock() ) {
						}
					}
				break;
				case STOP_CONSTRUCT:
					unset($constructor_name);
					$this->stackRemoveAbove(START_CONSTRUCT);
				break;
				case START_BLOCK_COMMENT:
					if (!$this->checkStopBlockComment()) {
						$this->line = "";
					}
				break;
				case STOP_BLOCK_COMMENT:
					$this->stackRemoveAbove(START_BLOCK_COMMENT);
				break;
				case _CSTYLE_COMMENT:
					$this->popEvent();
				break;
				case _SHELL_COMMENT:
					$this->popEvent();
				break;
			}
		}		
		// Reset vars that were used
		unset( $this->eventStack);
		unset( $this->store);
		unset( $this->line);
		unset( $this->currentComment);
		unset( $this->workComment);
		unset( $this->currentFile);
		$this->currentLineNum = -1;
	}


	// Line Check functions
	
	/**
	 *  Checks for START_PHP in line
	 */
	function checkStartPhp()
	{
		if (stristr($this->line,"<?php")) {
			//We are in a php tag, cut any junk from the left, and throw the event
			$this->textRemoveLeft("<?php");
			$this->throwEvent(START_PHP);
			return true;
		} else {
			return false;
		}
	}

	/**
	 *  Checks for STOP_PHP in line
	 *  @return ture is STOP_PHP is thrown
	 */
	function checkStopPhp()
	{
		if ($this->textIsPhpKeyword("?>")) {
			if (stristr($this->line,"?>")) {
				//We are outside of php code cut to right and throw event
				$this->textRemoveRight("?>");	
				$this->throwEvent(STOP_PHP);
				return true;
			}
		}
	}

	/**
	 *  Check for START_CLASS in line
	 *  @return true is START_CLASS is thrown
	 */
	function checkStartClass()
	{
		if (stristr($this->line,"class ")) {
			// Check to see if line before is closed
			if ($this->textIsStatementClosed( $this->store[$this->currentLineNum -1]) ) {
				// check to see if if class keyword is first thing on the line
				if (strlen(trim(substr($this->store[$this->currentLineNum],0,
					strpos(strtolower($this->store[$this->currentLineNum]),"class")))) == 0) {
					$this->textRemoveLeft("class");
					$this->throwEvent(START_CLASS);
					return true;
				}
			}
		}
	}

	/**
	 *  Check for START_BLOCK in line
	 *  @param Event you want thrown before START_BLOCK
	 *  @return True is START_BLOCK is thrown
	 */
	function checkStartBlock( $throwBefore = 1 )
	{
		if (strstr($this->line,"{")) {
			$this->textRemoveLeft("{");
			$this->line = ltrim($this->line);
			if ($throwBefore != 1) {
				$this->throwEvent($throwBefore);
			}
			$this->throwEvent(START_BLOCK);
			return true;
		}
	}
	

	/**
	 *  Check for START_GLOBAL in line
	 *  @return returns true if START_GLOBAL is thrown
	 */
	function checkStartGlobal()
	{
		if ($this->textIsPhpKeyword("function") || $this->textIsPhpKeyword("define") || $this->textIsPhpKeyword("class") ) {
			$this->throwEvent(START_GLOBAL);
			return true;
		}
	}


	/**
	 *  Check for START_COMMEMT in line
	 *  @return True if event is thrown
	 */
	function checkStartComment()
	{
		if (stristr($this->line,"/**")) {
			// Check to see if line before is closed
			if ($this->textIsStatementClosed( $this->store[$this->currentLineNum -1]) ) {
				// check to see if if define keyword is first thing on the line
				if (strlen(trim(substr($this->store[$this->currentLineNum],0,
					strpos(strtolower($this->store[$this->currentLineNum]),"/**")))) == 0) {
					$this->textRemoveLeft("/**");
					$this->throwEvent(START_COMMENT);
					return TRUE;
				}
			}
		}
	}

	/**
	 *  Check for START_DEFINE in line
	 *  @return true is START_DEFINE event is thrown
	 */
	function checkStartDefine()
	{
		if ($this->textIsPhpKeyword("define")) {
			$this->textRemoveLeft("define");
			$this->throwEvent(START_DEFINE);
			return true;
		}
	}

	/**
	 *  Check for START_VAR in line
	 *  @return true is START_VAR event is thrown
	 */
	function checkStartVar()
	{
		if ($this->textIsPhpKeyword("var")) {
			$this->textRemoveLeft("var");
			$this->throwEvent(START_VAR);
			return true;
		}
	}

	/**
	 *  Check for START_FUNC in line
	 *  @return true is START_FUNC event is thrown
	 */
	function checkStartFunc()
	{
		//echo "line# = $this->currentLineNum, code = " . rtrim($this->line) . "\n";
		if (stristr($this->line,"function ")) {
			// Check to see if line before is closed
			if ($this->textIsStatementClosed( $this->store[$this->currentLineNum -1]) ) {
				// check to see if if function keyword is first thing on the line
				if (strlen(trim(substr($this->store[$this->currentLineNum],0,
					strpos(strtolower($this->store[$this->currentLineNum]),"function")))) == 0) {
					$this->textRemoveLeft("function");
					$this->throwEvent(START_FUNC);
					return true;
				}
			}
		}
	}

	/**
	 *  Check for START_METHOD in line
	 *  @param The name of the class that the method is in
	 */
	function checkStartMethod( $class_name )
	{
		if (strcmp(strtolower($this->textGetFunctionName()),strtolower($class_name))) {
			$this->throwEvent(STOP_FUNC);
			$this->throwEvent(START_METHOD);
		}
	}

	/**
	 *  Check for START_CONSTRUCT in line
	 *  @param The name of the class that the constructor  is in
	 */
	function checkStartConstruct( $class_name )
	{
		if (strcmp(strtolower($this->textGetFunctionName()),strtolower($class_name)) == 0) {
			$this->throwEvent(STOP_FUNC);
			$this->throwEvent(START_CONSTRUCT);
		}
	}

		

	/**
	 *  Check for START_COMMENT in line
	 *  @return True if a comment is found
	 */
	function checkComment()
	{
		if (strstr($this->line,"//")) {
			$this->textRemoveRight("//");
			$this->throwEvent(_CSTYLE_COMMENT);
			return true;
		}
		if (strstr($this->line,"#")) {
			$this->textRemoveRight("#");
			$this->throwEvent(_SHELL_COMMENT);
			return true;
		}
		if (strstr($this->line,"/*") && !strstr($this->line,"/**")) {
			$this->textRemoveLeft("/*");
			$this->throwEvent(START_BLOCK_COMMENT);
			return true;
		}
	}

	/**
	 *  Check for STOP_GLOBAL
	 *  @return true if STOP_GLOBAL is thrown
	 */
	function checkStopGlobal()
	{
		if (stristr($this->line,"class ")) {
			$this->throwEvent(STOP_GLOBAL);
			return true;
		}
	}

	/**
	 *  Check for STOP_DEFINE
	 *  @return true if STOP_DEFINE is thrown
	 */
	function checkStopDefine()
	{
		if (stristr($this->line,";")) {
			$this->textRemoveLeft(";");
			$this->throwEvent(STOP_DEFINE);
			return true;
		}
	}

	/**
	 *  Check for STOP_COMMENT
	 *  @return true is STOP_COMMENT is thrown
	 */
	function checkStopComment()
	{
		if (strstr($this->line,"*/")) {
			$this->textRemoveRight("*/");
			$this->throwEvent(STOP_COMMENT);
			return true;
		}
	}

	/**
	 *  Check for STOP_BLOCK
	 *  @return True if STOP_BLOCK event is thrown
	 */
	function checkStopBlock()
	{
		if (strstr($this->line,"}")) {
			$this->textRemoveLeft("}");
			$this->line = ltrim($this->line);
			$this->throwEvent(STOP_BLOCK);
			return true;
		}
	}

	/**
	 *  Check for STOP_BLOCK_COMMENT
	 *  @return True if STOP_BLOCK_COMMENT event is thrown
	 */
	function checkStopBlockComment()
	{
		if (strstr($this->line,"*/")) {
			$this->textRemoveLeft("*/");
			$this->throwEvent(STOP_BLOCK_COMMENT);
			return true;
		}
	}

	/**
	 *  Check for STOP_VAR
	 */
	function checkStopVar()
	{
		if (strstr($this->line,";")) {
			$this->textRemoveLeft(";");
			$this->throwEvent(STOP_VAR);
		}
		
	}

		

	// Stack functions
	/**
	 *  Returns last event from stack
	 *  @return last item of eventStack array, the current Event
	 */
	function getCurrentEvent()
	{
		$ret = array_pop($this->eventStack);
		$this->eventStack[] = $ret;
		return $ret;
	}

	/**
	 *  Adds an event to the stack
	 *  @param $event Event to be added to the stack
	 */
	function throwEvent( $event )
	{
		$this->eventStack[] = $event;
	}
	
	/**
	 *  Removes from last event in stack up, until $event has been reached
	 *  @param $event The event to remove upto
	 */
	function stackRemoveAbove( $event )
	{
		//echo "stackRemoveAbove " . $this->codeToEvent($event) . "\n";
		$i = count($this->eventStack);
		$last = 0;
		while ($last != $event)
		{
			$last = array_pop($this->eventStack); 
			if ($i == 0) {
				die("Fatal Error, tried to remove above to event that doesn't exist\n");
			}
			$i--;
		}
	}


	/**
	 *  Removes last event from the stack and returns it
	 *  Returns same value as getCurrentEvent only the event is removed from the stack
	 *  @return the last event in the stack
	 */
	function popEvent()
	{
		return array_pop($this->eventStack); 
	}



	// To be moved to Class Basic Funcs

	/**
	 *  Gets first word and clips junk from the end
	 *  @return function name
	 */
	function textGetFunctionName()
	{
		$ret = $this->textGetFirstWord();
		$i = strpos($ret,"(");
		return substr($ret,0,$i);
	}


	/**
	 *  Removes any characters from the left of the end of the string in line 
	 */
	function textRemoveLeft( $string )
	{
		if (stristr($this->line,$string)) {
			$i = strpos(strtolower($this->line),strtolower($string)) + strlen($string);
			$this->line = substr($this->line, $i);
		}
	}

	/**
	 *  Removes any characters from the right of the beginning of the string in line 
	 */
	function textRemoveRight( $string )
	{
		$i = strpos(strtolower($this->line),strtolower($string));
		$this->line = substr($this->line, 0, $i);
	}

	/**
	 *  Gets the first word from line
	 *  @param $string Optioninal is no uses $this->line to get first word from
	 *  @return The first word in line
	 */
	function textGetFirstWord( $string = "" )
	{
		if (strlen($string) == 0) {
			$string = $this->line;
		}
		if (strlen(trim($string)) > 0) {
			$i = strpos(trim($string)," ");
			if ($i < 1) {
				$i = strlen(trim($string));
			}
			$ret = substr(trim($string),0,$i);
			if (strstr($ret,";")) {
				$ret = substr($ret,0,(strlen($ret) -1));
			}
			return $ret;
		}
	}

	/**
	 *  Gets text before not including 
	 *  @param $string the word you want text before
	 *  @return The text before $string
	 */
	function textGetBeforeString( $string )
	{
		if (strlen(trim($this->line)) > 0) {
			$i = strpos(trim($this->line),$string);
			return substr(trim($this->line),0,$i);
		}
	}

	/**
	 *  gets the word after string from line
	 *  @param $string The string before what you want returned
	 *  @return The word after string
	 */
	function textGetWordAfter( $string )
	{
		if (stristr($this->line,$string)) {
			$i = strpos(strtolower($this->line),strtolower($string)) + strlen($string);
			$tmp = ltrim(substr($this->line,$i));
			$e = strpos($tmp," ");	
			if ($e < 1) {
				$e = strlen(trim($tmp));
			}

			return trim(substr(trim($tmp),0,$e));
		}
	}

	/**
	 *  gets the text after string
	 *  @param $string the string 
	 *  @return All text after the string
	 */
	function textGetStringAfter( $string )
	{
		if (stristr($this->line,$string)) {
			$i = strpos(strtolower($this->line),strtolower($string)) + strlen($string);
			return ltrim(substr($this->line,$i));
		}
	}

	/**
	 *  @param $string what you want the last character from
	 *  @return the last char in string
	 */
	function textGetLastCharFromString( $string )
	{
		return substr($string,(strlen($string) - 1));
	}

	/**
	 *  Checks to if string is a php keyword , class, function define etc
	 *  @param $string what you are checking
	 *  @return true if is keyword otherwise false
	 */
	function textIsPhpKeyword ($string)
	{
		if (stristr($this->line,$string)) {
			// Check to see if line before is closed
			if ($this->textIsStatementClosed( $this->store[$this->currentLineNum -1]) ) {
				// check to see if if function keyword is first thing on the line
				if (strlen(trim(substr($this->store[$this->currentLineNum],0,
					strpos(strtolower($this->store[$this->currentLineNum]),$string)))) == 0) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 *  Checks to see if the string is a php statement that is closed
	 *  @param $string the string you are checking
	 *  @return true is string us closed
	 */
	function textIsStatementClosed( $string )
	{
		//trim spaces from the end of the line
		$string = trim( $string );

		// if statement begins with a quote // or # its automatically closed
		if (strstr(substr($string,0,2),"//") || strstr(substr($string,0,1),"#")) {
			return true;
		} else if (strlen(trim($string)) == 0) {
			//We need to handle this differently look up a line which means passing line num and letting
			//this function access store instead of passing in a string
			return true;
		} else {
	        	//we remove end line comments
		        $string = eregi_replace( "//[[:print:]]+$", "", $string );
		        $string = eregi_replace( "/\*[[:print:]]\*/$", "", $string ); 
       	 		//trim extra spaces again
		        $string = rtrim( $string );
		        //check if last character is a semicolon... checking for "{"  and "}" might be an option
			$lastchar = substr($string,(strlen($string) - 1));
			switch ($lastchar) {
				case "/":
				case ";":
				case "{":
				case "}":
				case ":":
					return true;
				break;
				default:
					return false;
				break;
			}
			
		}
	}

	/**
	 *  Parses this->currentComment and returns a data array
	 *  @return a data array
	 */
	function textParseComment()
	{
		if (is_array($this->currentComment)) {
			foreach ($this->currentComment as $line)
			{
				// Get rid of / and \ and *'s
				$line = ltrim($line);
				$firstchar = substr($line,0,1);
				while (strcmp($firstchar,"/") == 0 || strcmp($firstchar,"*") == 0)
				{
					$line = ltrim(substr($line,1));
					$firstchar = substr($line,0,1);
				}
				$firstchar = substr($line,0,1);
				if (strcmp($firstchar,"@") == 0) {
					$keyword = substr($this->textGetFirstWord($line),1);
					$line = ltrim(substr(ltrim($line),strlen($keyword) + 1));
					// Keyword switch for formatting and junk like that
					switch($keyword) {
						// this is where param gets chaned to parameter and the like
						case "param":
							$keyword = "parameter";
						break;
					}
						
					$data[keys][$keyword][] = $line;
				} else {
					$data[desc] .= $line;
				}
			}
		}
		unset($this->currentComent);
		return $data;
	}

	
	function textGetFileBaseName( $file)
	{
		//At some point this should just cut off anything that was put into -d when phpdoc was callled
		return array_pop(explode("/",$file));
	}
	/**
	 *  Inserts $value into store by moving everything after index up one
	 *  @param $index numeric index of store
	 *  @param $value what your inserting into store
	 */
	function arrayInsert( $index, $value )
	{
		$i = $index;
		while ($i < count($this->store))
		{
			$this->store[$i] = $this->store[++$i];
		}
		$this->store[$index] = $value;
	}

	// Debug Functions
	function codeToEvent($code)
	{
		switch	($code) {
			case 1001:
				return "START_FILE";
			break;
			case 1002:
				return "STOP_FILE";
			break;
			case 1003:
				return "START_PHP";
			break;
			case 1004:
				return "STOP_PHP";
			break;
			case 1005:
				return "START_CLASS";
			break;
			case 1006:
				return "STOP_CLASS";
			break;
			case 1007:
				return "START_GLOBAL";
			break;
			case 1008:
				return "STOP_GLOBAL";
			break;
			case 1009:
				return "START_FUNC";
			break;
			case 1010:
				return "STOP_FUNC";
			break;
			case 1011:
				return "START_DEFINE";
			break;
			case 1012:
				return "STOP_DEFINE";
			break;
			case 1013:
				return "START_VAR";
			break;
			case 1014:
				return "STOP_VAR";
			break;
			case 1015:
				return "START_COMMENT";
			break;
			case 1016:
				return "STOP_COMMENT";
			break;
			case 1017:
				return "START_METHOD";
			break;
			case 1018:	
				return "STOP_METHOD";
			break;
			case 1019:
				return "START_CONSTRUCT";
			break;
			case 1020:
				return "STOP_CONSTRUCT";
			break;
			case 1021:
				return "START_BLOCK_COMMENT";
			break;
			case 1022:
				return "STOP_BLOCK_COMMENT";
			break;
			case 1023:
				return "START_BLOCK";
			break;
			case 1024:
				return "STOP_BLOCK";
			break;
			case 1025:
				return "_CSTYLE_COMMENT";
			break;
			case 1026:
				return "_SHELL_COMMENT";
			break;
			case 1027:
				return "_KEYWORD";
			break;
			case 1028:
				return "_COMMENT_CHAR";
			break;
		}
	}

	function debugDumpEventStack()
	{
		foreach($this->eventStack as $event)
		{
			$ret .= $this->codeToEvent($event) . "\n";
		}
		return $ret;
	}
}

