<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000 Joshua Eichorn
// Email jeichorn@users.sourceforge.net
// Web http://phpdocu.sourceforge.net/
//     http://sourceforge.net/projects/phpdocu/
//

/** The Render Class<br>
 *  The Main render enfine for Php Documentor
 *  @author Joshua Eichorn
 *  @version 0.1.6
 *  @copyright 2000 Joshua Eichorn 
 */
class Render extends Template
{
        /** render creates the output files for each class from the $docTree array */
        function render( )
        {
		echo "\n\n Begining Render \n\n";
                foreach($this->docTree as $class => $info) {

                        $output[] = $this->pageTop("Class $class");
			$output[] = $this->navBar($class);

                        $output[] = "<!-- Start of Class Data -->";
                        $output[] = "<H2>";
                        $output[] = "Class $class";
                        $output[] = "</H2>";

			$output[] = $this->extend($class);
                        
                        $output[] = "<b><i>Located in File: $info[file]</i></b><br>";

			$output[] = $this->extendedDesc($info[data]);

                        $output[] = "</DL>";
                        $output[] = "<HR>";

                        $output[] = $this->summaryHeader("Variables");

                        if (is_array($info["vars"])) {
                                foreach($info["vars"] as $varname => $data) {
                                        $output[] = "<TR BGCOLOR='white' CLASS='TableRowColor'>";
                                        $output[] = "<TD><CODE><B><A HREF='$class.html#$varname'>$varname</A></B></CODE>";
                                        $output[] = "<BR>";
                                        $output[] = "<blockquote><pre>" . $data[data][desc] . "</pre></blockquote></TD>";
                                        $output[] = "</TR>\n";
                                }
                        }

                        $output[] = "</TABLE>";

                        $output[] = "<BR>";
                        $output[] = $this->summaryHeader("Constructors");

                        if (is_array($info["constructor"])) {
                                foreach($info["constructor"] as $name => $data) {
                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[params] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }
					$paralist = substr($paralist,0,strlen($paralist) -2);

                                        $output[] = "<TR BGCOLOR='white' CLASS='TableRowColor'>";
                                        $output[] = "<TD><CODE><B><A HREF='$class.html#$name'>$name</A></B>( $paralist )</CODE>";
                                        $output[] = "<BR>";
                                        $output[] = "<blockquote><pre>" . $data[data][desc] . "</pre></blockquote></TD>";
                                        $output[] = "</TR>\n";
                                }
                        }

                        $output[] = "</TABLE>";

                        $output[] = "<BR>";

                        $output[] = $this->summaryHeader("Method");

                        if (is_array($info["method"])) {
                                foreach($info["method"] as $name => $data) {
                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[params] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }
                                        $paralist = substr($paralist,0,(strlen($paralist) -2));

                                        $output[] = "<TR BGCOLOR='white' CLASS='TableRowColor'>";
                                        $output[] = "<TD><CODE><B><A HREF='$class.html#$name'>$name</A></B>($paralist)</CODE>";
                                        $output[] = "<BR>";
                                        $output[] = "<blockquote><pre>" . $data[data][desc] . "</pre></blockquote></TD>";
                                        $output[] = "</TR>\n";
                                }
                        }

                        $output[] = "</TABLE>";

                        $output[] = "<BR>";
                        $output[] = "<BR>";

                        $output[] = "<!-- ============ VARIABLE DETAIL =========== -->";
                        $output[] = "";
                        $output[] = "<A NAME='variable_detail'></A>";
                        $output[] = "<TABLE BORDER='1' CELLPADDING='3' CELLSPACING='0' WIDTH='100%'>";
                        $output[] = "<TR BGCOLOR='#CCCCFF' CLASS='TableHeadingColor'>";
                        $output[] = "<TD COLSPAN=1><FONT SIZE='+2'>";
                        $output[] = "<B>Variable Detail</B></FONT></TD>";
                        $output[] = "</TR>";
                        $output[] = "</TABLE>";

                        if (is_array($info[vars])) {
                                foreach($info[vars] as $name => $data) {
                                        $output[] = "<A NAME='$name'><!-- --></A><H3>";
                                        $output[] = "$name</H3>";

					$output[] = "<blockquote>\n";
                                        $output[] = $this->extendedDesc($data,"variable");

					$output[] = "</blockquote>\n";
                                        $output[] = "<HR>";
                                }
                        }


                        $output[] = "<BR>";
                        $output[] = "<BR>";

                        $output[] = "<!-- ============ CONSTRUCTOR DETAIL =========== -->";
                        $output[] = "";
                        $output[] = "<A NAME='constructor_detail'></A>";
                        $output[] = "<TABLE BORDER='1' CELLPADDING='3' CELLSPACING='0' WIDTH='100%'>";
                        $output[] = "<TR BGCOLOR='#CCCCFF' CLASS='TableHeadingColor'>";
                        $output[] = "<TD COLSPAN=1><FONT SIZE='+2'>";
                        $output[] = "<B>Constructor Detail</B></FONT></TD>";
                        $output[] = "</TR>";
                        $output[] = "</TABLE>";

                        if (is_array($info[constructor])) {
                                foreach($info[constructor] as $name => $data) {
                                        $output[] = "<A NAME='$name'><!-- --></A><H3>";
                                        $output[] = "$name</H3>";
                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[params] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }
                                        $paralist = substr($paralist,0,(strlen($paralist) -2));

					$output[] = "<blockquote>\n";
                                        $output[] = "<CODE><B>$name</B>($paralist)</CODE>";

                                        $output[] = $this->extendedDesc($data,"constructor");

					$output[] = "</blockquote>\n";
                                        $output[] = "<HR>";
                                }
                        }


                        
                        $output[] = "<BR>";
                        $output[] = "<BR>";

                        $output[] = "<!-- ============ METHOD DETAIL =========== -->";
                        $output[] = "";
                        $output[] = "<A NAME='method_detail'></A>";
                        $output[] = "<TABLE BORDER='1' CELLPADDING='3' CELLSPACING='0' WIDTH='100%'>";
                        $output[] = "<TR BGCOLOR='#CCCCFF' CLASS='TableHeadingColor'>";
                        $output[] = "<TD COLSPAN=1><FONT SIZE='+2'>";
                        $output[] = "<B>Method Detail</B></FONT></TD>";
                        $output[] = "</TR>";
                        $output[] = "</TABLE>";

                        if (is_array($info[method])) {
                                foreach($info[method] as $name => $data) {
                                        $output[] = "<A NAME='$name'><!-- --></A><H3>";
                                        $output[] = "$name</H3>";

                                        // Unroll paralist
                                        unset($paralist);
                                        foreach($data[params] as $val) {
                                                $val = trim($val);
                                                if (strlen($val) > 0) {
                                                        $paralist .= $val . ", ";
                                                }
                                        }
                                        $paralist = substr($paralist,0,(strlen($paralist) -2));

					$output[] = "<blockquote>\n";
                                        $output[] = "<CODE><B>$name</B>($paralist)</CODE>";

                                        $output[] = $this->extendedDesc($data,"function");

					$output[] = "</blockquote>\n";
                                        $output[] = "<HR>";
                                }
                        }


                        $filename = $this->targetDir . "/" . $class . ".html";
                        $this->writeArray($filename,$output);
                        unset($output);

			// Create perclass index
			$tmp[$class] = $info; 
			$this->createObjectIndex("index_" . $class , $tmp);	
			$this->createTree("tree_" . $class , $tmp);	
			unset($tmp);
		}

        }
                                

        /** Creates index.html with frame code and a left pane listing all classes
         */
        function createIndex()
        {

                $left[] = $this->pageTop("All Classes");

                $left[] = "<FONT size='+1' CLASS='FrameHeadingFont'>";
                $left[] = "<B>All Classes</B></FONT>";
                $left[] = "<BR>";
                $left[] = "<TABLE BORDER='0' WIDTH='100%'>";

                foreach($this->docTree as $className => $data)
                {
                        $tmp[] = $className;
                }
                reset($tmp);
                sort($tmp);

                foreach($tmp as $className)
                {
                        if (!$start) {
                                $start = "$className.html";
                        }
                        $left[] = "<TR><TD NOWRAP>";
                        $left[] = "<FONT CLASS='FrameItemFont'><A HREF='$className.html' TARGET='right'>$className</A>";
                        $left[] = "<BR></FONT></TD></TR>";
                }
                $left[] = "</TABLE>";
                $left[] = "</BODY>";
                $left[] = "</HTML>";
                        
                $this->writeArray($this->targetDir . "/left.html",$left);

		
                $indexHtml[] = $this->index($start);
	
                $this->writeArray($this->targetDir . "/index.html",$indexHtml);
        }


	/**
	 *  Creates the style sheet
	 */
	function createStyleSheet()
	{
		$output[] = $this->styleSheet();
		$this->writeArray($this->targetDir . "/stylesheet.css",$output);
	}

	/**
	 *  Creates a tree file
	 *  @param $filename the name of the file that will be written no .html
	 *  @param $dataset the piece of docTree to be parsed
	 */
	function createTree($filename, $dataset)
	{
		foreach($dataset as $className => $data)
		{
			$output[] = "<h2><a href='$className.html'>$className:</a></h2>\n";
			$output[] = "<blockquote>\n";
			
			foreach($data as $key => $val) {
				if (is_array($val))
				{
					$output[] = "<blockquote>\n";
					switch( $key ) {
						case "vars":
							foreach ($val as $name => $ldata)
							{
								$output[] = "<p>Class Variable <a href='$className.html#$name'>$name</a></p>\n";
							}
						break;
						case "method":
							foreach ($val as $name => $ldata)
							{
								$output[] = "<p>Method <a href='$className.html#$name'>$name</a></p>\n";
							}
						break;
						case "construct":
							foreach ($val as $name => $ldata)
							{
								$output[] = "<p>Class Constructor <a href='$className.html#$name'>$name</a></p>\n";
							}
						break;
						case "define":
							foreach ($val as $name => $ldata)
							{
								$output[] = "<p>Global Definition <a href='$className.html#$name'>$name</a></p>\n";
							}
						break;
					}
					$output[] = "</blockquote>\n";
				}
			}
			$output[] = "</blockquote>\n";
		}
		$this->writeArray($this->targetDir . "/$filename.html",$output);
	}
	
	/**
	 *  Uses docTree to create an index of all functions
	 *  @param $filename the name of the file that will be written no .html
	 *  @param $dataset the piece of docTree to be parsed
	 */
	function createObjectIndex($filename, $dataset)
	{
		foreach($dataset as $className => $data)
		{
			foreach($data as $key => $val) {
				if (is_array($val))
				{
					foreach($val as $inner_name => $inner_data)
					{
						$objectTree[$inner_name] = $inner_data;
						$objectTree[$inner_name][type] = $key;
						$objectTree[$inner_name][className] = $className;
					}
				}
			}
		}
		uksort($objectTree, "allUCstrCmp");
	

		$output[] = $this->pageTop();
		$output[] = $this->navBar($class);
		$output[] = "alphabet links\n";
		foreach($objectTree as $objectName => $data)
		{
			$letter = strtoupper(substr($objectName,0,1));
			if (strcmp($cletter,$letter) != 0) {
				$cletter = $letter;
				$output[] = "<h2>$letter</h2><a name=$letter></a>\n";

				$alpha .= "&nbsp;<a href='#$letter'>$letter</a>&nbsp;\n";
			}
			
			$output[] = "<b><a href='$data[className].html#$objectName'>$objectName</a></b>";
			$output[] = "$data[type] of class <a href='$data[className].html'>$data[className]</a>";
			$output[] = "<blockquote><pre>" . $data[description] . "</pre></blockquote><hr>";
		}

		$output[2] = $alpha;

		$this->writeArray($this->targetDir . "/$filename.html",$output);
	}




	/**  handle classes extending other classes follow tree all the way to base 
	 *  @param $currentClass Centains name of class that current class extends
	 *  @param $className Centains name of class that current class extends
	 *  @return preformated tree with class extend info in it
	 */
	function extend($currentClass)
	{
		$classTree[] = "$currentClass";
        	$out = "<pre>";

		while ($this->docTree[$currentClass][extend]) {	
			$currentClass = $this->docTree[$currentClass][extend];
			$classTree[] = $currentClass;
		}

		$numSpaces = 2;
		$i = count($classTree) -1;
		if ($i > 0) {
			$out .= "$classTree[$i]\n";
		}
		$i--;
		while ($i > 0) {
        		$out .= str_repeat(" ",$numSpaces) . "|\n";
			$out .= str_repeat(" ",$numSpaces) . "+--$classTree[$i]\n";

			$i--;
			$numSpaces = $numSpaces + 3;
		}

		if ($i == 0) {
        		$out .= str_repeat(" ",$numSpaces) . "|\n";
			$out .= str_repeat(" ",$numSpaces) . "+--<B>$classTree[$i]</B>\n";

			$out .= "</pre>";
		
        	        $out .= "<b>Extends: <a href='$classTree[1].html'>$classTree[1]</a></b><br>";
		}

		$out .= "<hr>";
		return $out;
	}

	/** Sets the output directory of create
         *  @param $dir the output directory
         *  @see create
         */
        function setTargetDir($dir)
        {
                if (strlen($dir) > 0) {
                        $this->targetDir = $dir;
                } else {
                        echo "a target directory must be specified\n try phpdoc -h\n";
                        die();
                }
        }

}
?>
