<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//


//
// Copyright 2000 Joshua Eichorn
// Email jeichorn@users.sourceforge.net
// Web http://phpdocu.sourceforge.net/
//     http://sourceforge.net/projects/phpdocu/
//

/** 
 *  Template functions that specify the layout of the files phpdoc generates
 */
Class Template extends Io
{

	/**
	 *  Template for index.html
	 *  @param $start The first page to be shown in the right frame and the non-frames page
	 *  @param $title The title of the html page
	 *  @return a string containing the index.html page <html> to </html>
	 */
	function index($start, $title = "Untitled")
	{
		return "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.0 Transitional//EN''http://www.w3.org/TR/REC-html40/loose.dtd'>" .
                "<!--NewPage-->" .
                "<HTML>" .
                "<HEAD>" .
                "<!-- Generated by PhpDoc on " . date("D M d Y , H:i:s",time()) . " -->" .
                "<TITLE>Generated Documentation ($title)</TITLE>" .
                "</HEAD>" .
		" " .
                "<FRAMESET cols='20%,80%'>" .
                "<FRAME src='left.html' name='left'>" .
                "<FRAME src='$start' name='right'>" . 
                "</FRAMESET>" .
                "<NOFRAMES>" .
                "<H2>Frame Alert</H2>" .
                "<P>This document is designed to be viewed using the frames feature." .
                "If you see this message, you are using a non-frame-capable web client.  <BR>" .
                "Link to <A HREF='$start'>Non-frame version.</A></NOFRAMES>" .
                "</HTML>";
	}


	/**
	 *  Generic Page top, the default Top of every page made by phpdoc
	 *  @param $title The title of the html page
	 *  @return A string with the top of an html page in it <html> to <body>
	 */
	function pageTop($title = "Generated Documentation")
	{
		return "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.0 Frameset//EN''http://www.w3.org/TR/REC-html40/frameset.dtd'>" .
                "<!--NewPage-->" .
                "<HTML>" .
                "<HEAD>" .
                "<!-- Generated by PhpDoc on " . date("D M d Y , H:i:s",time()) . " -->" .
                "<TITLE>All Classes</TITLE>" .
                "<LINK REL ='stylesheet' TYPE='text/css' HREF='stylesheet.css' TITLE='Style'>" .
                "</HEAD>" .
                "<BODY BGCOLOR='white'>";
	}


	/** Summary Header
	 *  @param $type The type of summary, used in title,anchor,and comment
	 *  @return A string with the summary header
	 */
	function summaryHeader($type)
	{
		return " " .
		"<!-- =========== " . strtoupper($type) . " SUMMARY =========== -->" .
		" " .
                "<A NAME='" . strtolower($type) . "_summary'><!-- --></A>" .
                "<TABLE BORDER='1' CELLPADDING='3' CELLSPACING='0' WIDTH='100%'>" .
                "<TR BGCOLOR='#CCCCFF' CLASS='TableHeadingColor'>" .
                "<TD><FONT SIZE='+2'>" .
                "<B>$type Summary</B></FONT></TD>" .
                "</TR>";
	}


	/** extendedDesc uses the data array to return a string descrtion and keyword list
         *  @param $dataTree data array
         *  @return string with extended descrtion
         */
        function extendedDesc($dataTree)
        {
                $out .= "<pre>" . $dataTree[data][desc] . "</pre>\n";
                $out .= "<DL>\n";


		if (is_array($dataTree[data][keys])) {
			foreach($dataTree[data][keys] as $keyword => $data)
			{
				if (count($data) == 1) {
					$out .= "<DT><B>" . ucfirst($keyword) . ": </B><DD>$data[0]</DD>\n";
				} else {
					$out .= "<DT><B>" . ucfirst($keyword) . ": </b>\n";
					foreach($data as $line)
					{
						$line = trim($line);
						$p = $this->textGetFirstWord($line);

						$line = substr($line,strlen($p));

						$out .= "<DD><i>$p</i> - $line</DD>\n";
					}
				}
			}
		}

                $out .= "</DL>\n";
                return $out;
        }


	/** paramList returns a string of a formated parameter list
         *  @param $param array of parameters
         *  @return a formated parameter list
         */
        function paramList($param)
        {
                $out = "<BR><BR><DT><B>Parameters:</B>";
                foreach($param as $line) {
                        $pos = strpos($line," ");
                        $name = substr($line,0,$pos);
                        $desc = trim(substr($line,$pos));
                        $out .= "<DD><CODE>$name</CODE> - $desc";
                }
                return $out;
        }


	function navBar($class)
	{
		return "<!-- ========== START OF NAVBAR ========== -->\n" .
		"<A NAME='navbar_top'><!-- --></A>\n" .
		"<TABLE BORDER='0' WIDTH='100%' CELLPADDING='1' CELLSPACING='0'>\n" .
		"<TR>" .
		"<TD COLSPAN=2 BGCOLOR='#EEEEFF' CLASS='NavBarCell1'>\n" .
		"<A NAME='navbar_top_firstrow'><!-- --></A>\n" .
		"<TABLE BORDER='0' CELLPADDING='0' CELLSPACING='3'>\n" .
		"  <TR ALIGN='center' VALIGN='top'>\n" .
		"  <TD BGCOLOR='#EEEEFF' CLASS='NavBarCell1'><FONT CLASS='NavBarFont1'>Class $class</FONT></TD>\n" .
		"  <TD BGCOLOR='#FFFFFF' CLASS='NavBarCell1Rev'><FONT CLASS='NavBarFont1Rev'>" .
		"  &nbsp;&nbsp;<B>Class: </B></FONT>\n" .
		"  <a href='index_" . "$class.html'>Index</a></FONT>\n" .
		"  <a href='tree_" . "$class.html'>Tree</a></FONT>\n" .
		"  &nbsp;&nbsp;<B>Full: </B></FONT>\n" .
		"  <a href='index_full.html'>Index</a></FONT>\n" .
		"  <a href='tree_full.html'>Tree</a></FONT></TD>\n" .
		"  </TR>\n" .
		"</TABLE>\n" .
		"</TD>\n" .
		"<TD ALIGN='right' VALIGN='top' ROWSPAN=3><EM>\n" .
		"</EM>\n" .
		"</TD>\n" .
		"</TR>\n" .
		"\n" .
		"<TR>\n" .
		"<TD BGCOLOR='white' CLASS='NavBarCell2'><FONT SIZE='-2'>\n" .
		"&nbsp;PREV&nbsp;&nbsp;NEXT</FONT></TD>\n" .
		"<TD BGCOLOR='white' CLASS='NavBarCell2'><FONT SIZE='-2'>\n" .
		"</TR>\n" .
		"</TABLE>\n";
	}


	/** An interface for the web to phpdocu
	 *  @param $options an array containing name as the key and the type as the value
	 *  @return a string containing the web interface
	 */
	function webInterface($options)
	{
		$out = "<form method='post' action='phpdoc.php'>\n" .
		$options[general][message] . "<br>\n";
		foreach($options as $name => $type)
		{
			if (count($type) > 2) {
				$out .= "$name: <input type='$type' name='setting[$name]'><br>\n";
			}
		}
		$out .= "<input type='submit' value='submit' name='submit'><br>\n" .
		"</form>\n";	

		return $out;
	}

	
	/** StyleSheet for phpdocu
	 *  @return a stylesheet
	 */	
	function styleSheet()
	{
		return "<!-- Style sheet place holder til i right a real one -->\n";
	}
}
