<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/** The Render Class
 *
 *  The Main render engine for Php Documentor
 *
 *  @author Joshua Eichorn
 *  @version 0.2.3
 *  @copyright 2000-2001 Joshua Eichorn 
 */
class Render extends Template
{
	var $last	= "";

	var $output	=	array();

	/**
	* Where files will be created by render
	*/
	var $targetDir	= "";

	/**
	* Where the template files are located
	*/
	var $templateDir= "";

	// buches of vars used as we build files up from templates
	var $page	= array();
	var $constants	= array();

	/**
	* The extenstion that the files will be output with
	*/
	var $outputExt	=	".html";

	/**
	* Holds wheter a page has had something set to it
	*/
	var $outPage	=	array();

	/**
	* The parent object
	*/
	var $parent	=	"";

	/**
	* Where vars, constants, and functions are stored til they are registered into the template
	*/
	var $current	= array();

	/**
	* Used by the comparision function used in uksort
	*/
	var $rcnatcmpkey	= "";

	/**
	* The current output file
	*/
	var $file	=	"";

	/**
	* The array used to build the package and class index-files
	*/
	var $index	=	array();

	/**
	* The last type of element handled
	*/
	var $lasttype;

	/**
	* The current type of element handled
	*/
	var $type;

	function Render()
	{
	}

	// $data is always a class from DataTypes
	function HandleEvent($event,$data)
	{
		if ($event == PHPDOC_EVENT_NEWSTATE)
		{
//			echo $data . "\n";
		} 
		 else 
		{
			$this->lasttype = $this->type;
			$type = $data->getType();
			$this->type = $type;
			//echo $type . "\n";
			
			switch($type)
			{
				case "docblock":
					if ($this->lasttype == "docblock" && isset($this->page['template']))
					{
						$this->page['template']->register("sdesc",$this->last->getShortDesc());
						$this->page['template']->register("desc",$this->last->getDesc());
						$this->page['template']->register("docblock",$this->last->listKeywords());

						// add this procedural page to the index
						if ($this->last->getKeyword('package'))
						{
							for($i = 0;$i < count($this->index['default']['_$pro']); $i++)
							{
								if ($this->index['default']['_$pro'][$i] == $this->page['name'])
								{
									unset($this->index['default']['_$pro'][$i]);
								}
							}

							if ($this->last->getKeyword('subpackage'))
							{
								$this->index[$this->last->getKeyword('package')][$this->last->getKeyword('subpackage')]['_$pro'][] = $this->page['name'];
							} else {
								$this->index[$this->last->getKeyword('package')]['_$pro'][] =  $this->page['name'];
							}
						}
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					} 
					$this->last = $data;
					unset($data);
				break;
				case "page":
					$this->registerCurrent();

					if (count($this->page >0))
					{
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					}
					// Create a new template, this is where non class stuff goes
					$this->page['template'] = new Template($this->templateDir,"page.html");
					
					// Setting stuff about the page
					$this->file = "_" . $data->getName() . $this->outputExt;
					$this->page['name'] = "_" . $data->getName();
					$this->parent = "_" . $data->getName();
					$this->index['default']['_$pro'][] =  $this->page['name'];

					// registering stuff on the template
					$this->page['template']->register("source_location",$data->getSourceLocation());
					$this->page['template']->register("date",date("r",time()));
					$this->page['template']->register("type","Function");
					$this->page['template']->register("page",$this->file);
					$this->page['template']->register("title","Docs on page $this->file");
				break;
				case "class":
					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
					}
					$this->registerCurrent();
					// We have a new class, so were going to create a new file
					$template = new Template($this->templateDir,"class.html");
					$this->output[$data->getName()] =& $template;
					$template->register("type","Method");

					// add this class to the index
					if ($this->last->getKeyword('package'))
					{
						if ($this->last->getKeyword('subpackage'))
						{
							$this->index[$this->last->getKeyword('package')][$this->last->getKeyword('subpackage')]['_$class'][] = $data->getName();
						} else {
							$this->index[$this->last->getKeyword('package')]['_$class'][] = $data->getName();
						}
					} else {
						$this->index['default']['_$class'][] = $data->getName();
					}

					// Register Nothing to variable that might not be set latter
					//$template->register("vars",array());
					//$template->register("var_detail",array());
					//$template->register("functions",array());
					//$template->register("function_detail",array());
					
					$template->register("title","Docs For Class " . $data->getName());
					$template->register("page",$data->getName() . $this->outputExt);
					$template->register("class_name",$data->getName());
					$template->register("sdesc",$this->last->getShortDesc());
					$template->register("desc",$this->last->getDesc());
					$template->register("docblock",$this->last->listKeywords());

					// This is only a simple class tree coving the class that is directly extended
					if ($parent = $data->getExtends())
					{
						$template->register("class_tree",
							"$parent\n" .
							"   |\n" .
							"   +----" . $data->getName() . "\n"
						);
					} else {
						$template->register("class_tree",""); 
					}
					
					$template->register("source_location",$data->getSourceLocation());
					$template->register("date",date("r",time()));

					$this->parent = $data->getName();
					$this->outPage[$this->parent] = 1;

					unset($this->last);
				break;
				case "define":
					if (count($this->page >0))
					{
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					}

					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
					}
					$data->setParent($this->parent);	
					$this->outPage[$this->parent] = 1;


					$this->current['constant'][] = 
						array(
							"constant_name" => $data->getName(), 
							"constant_value" => $data->getValue(),
							"constant_sdesc" => $this->last->getShortDesc()
						);
					$this->current['constant_detail'][] = 
						array(
							"constant_name" 	=> $data->getName(), 
							"constant_value" 	=> $data->getValue(), 
							"sdesc" 		=> $this->last->getShortDesc(),
							"desc" 			=> $this->last->getDesc(),
							"inner_loop"		=> array("docblock" => $this->last->listKeywords())
						);

					$this->constant[$data->getName()] = array(
						"constant" =>
							array(
								"constant_name" => $data->getName(), 
								"constant_value" => $data->getValue(),
								"constant_sdesc" => $this->last->getShortDesc()
							)
						,
						"constant_detail" =>
							array(
								"constant_name" 	=> $data->getName(), 
								"constant_value" 	=> $data->getValue(), 
								"sdesc" 		=> $this->last->getShortDesc(),
								"desc" 			=> $this->last->getDesc(),
								"inner_loop"		=> array("docblock" => $this->last->listKeywords())
							)
					);
					unset($this->last);
				break;
				case "function":
					if (count($this->page >0))
					{
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					}

					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
					}
					$data->setParent($this->parent);	
					$this->outPage[$this->parent] = 1;

					$function_call = $data->getName() . " ( ";
					$tmp = 0;
					foreach($data->listParams() as $param)
					{
						if ($tmp == 0)
						{
							$tmp = 1;
						} else {
							$function_call .= ", ";
						}
						if (!empty($param[1]))
						{
							$function_call .= "[$param[0] = $param[1]]";
						} else {
							$function_call .= $param[0];
						}
					}
					$function_call .= " )";

					$this->current['function'][] = 
						array(
							"function_name" 	=> $data->getName(),
							"function_sdesc" 	=> $this->last->getShortDesc(),
							"function_call" 	=> $function_call
						);
						/*
						print_r(array(
							"docblock" => $this->last->listKeywords(),
							"params" => $this->last->listParams()));
						//	*/
					$this->current['function_detail'][] = 
						array(
							"function_name" 	=> $data->getName(), 
							"sdesc"		 	=> $this->last->getShortDesc(),
							"function_call" 	=> $function_call,
							"desc" 			=> $this->last->getDesc(),
							"inner_loop"		=> array(
											"docblock" => $this->last->listKeywords(),
											"params" => $this->last->listParams()
											)
						);

					unset($this->last);
				break;
				case "var":
					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
					}
					$this->current['var'][] = 
						array(
							"var_name" => $data->getName(), 
							"var_default" => $data->getValue(), 
							"var_sdesc" => $this->last->getShortDesc()
						);
					$this->current['var_detail'][] = 
						array(
							"var_name" => $data->getName(), 
							"sdesc" => $this->last->getShortDesc(),
							"desc" => $this->last->getDesc(),
							"inner_loop" => array("docblock" => $this->last->listKeywords())
						);

					unset($this->last);
				break;
			}

		}
	}

	/**
	* Registers anything that is being stored in $this->current, sorts them first
	*/
	function registerCurrent()
	{
		if (!empty($this->current['constant']))
		{
			$this->rcnatcmpkey = "constant_name";
			uasort($this->current['constant'],array($this,"rcNetCmp"));
			$this->output[$this->parent]->register("constants",$this->current['constant']);
		}
		if (!empty($this->current['constant_detail']))
		{
			$this->rcnatcmpkey = "constant_name";
			uasort($this->current['constant_detail'],array($this,"rcNetCmp"));
			$this->output[$this->parent]->register("constant_detail",$this->current['constant_detail']);
		}
		if (!empty($this->current['function']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->current['function'],array($this,"rcNetCmp"));
			$this->output[$this->parent]->register("functions",$this->current['function']);
		}
		if (!empty($this->current['function_detail']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->current['function_detail'],array($this,"rcNetCmp"));
		//	print_R($this->current['function_detail']);
			$this->output[$this->parent]->register("function_detail",$this->current['function_detail']);
		}
		if (!empty($this->current['var']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->current['var'],array($this,"rcNetCmp"));
			$this->output[$this->parent]->register("vars",$this->current['var']);
		}
		if (!empty($this->current['var_detail']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->current['var_detail'],array($this,"rcNetCmp"));
			$this->output[$this->parent]->register("var_detail",$this->current['var_detail']);
		}
		unset($this->current);
	}

	/**
	* does a nat case sort on the specified second level value of the array
	*
	* @param	mixed	$a
	* @param	mixed	$b
	* @return	int
	*/
	function rcNatCmp ($a, $b)
	{
		return strnatcasecmp($a[$this->rcnatcmpkey], $b[$this->rcnatcmpkey]);
	}

	/** this is where we handle sorting stuff and adding inheirentance information to pages */
	function PreOutput ()
	{
		// Created index.html
		$index = new Template($this->templateDir,"index.html");
		$this->output['index'] =& $index;
		
		$index->register("date",date("r",time()));
		$index->register("title","Generated Documentation");
		list($start,) = each($this->index);
		$index->register("start","li_$start" . $this->outputExt);

		/*
		if (is_array($nonclass_index))
		{
			uksort($nonclass_index,"strnatcasecmp");
		}
		if (is_array($class_index))
		{
			uksort($class_index,"strnatcasecmp");
		}
		*/

		foreach($this->index as $key => $val)
		{
			$package_index[$key] = array('link' => "li_$key". $this->outputExt, 'title' => $key);
		}
		//uksort($package_index,"strnatcasecmp");

		// Create package index
		$package = new Template($this->templateDir,"packages.html");
		$package->register("date",date("r",time()));
		$package->register("packages",$package_index);

		$this->output['packages'] = $package;

		// create indexes for each package
		foreach($this->index as $key => $val)
		{
			unset($nonclass_index);
			unset($class_index);
			unset($subpackage_index);
			// loop through subpackages and classes in package
			foreach($val as $ikey => $ival)
			{
				if ($ikey == '_$pro')
				{
					foreach($ival as $cval)
					{
						if (isset($this->outPage[$cval]))
						{
							$nonclass_index[] = array("link" => $cval . $this->outputExt, "title" => $cval);
						}
					}
				} 
				else if ($ikey == '_$class')
				{
					foreach($ival as $cval)
					{
						$class_index[] = array("link" => $cval . $this->outputExt, "title" => $cval);
					}
				} 
				else 
				{
					$tpro = array();
					$tclass = array();
					foreach($ival as $iikey => $iival)
					{
						if ($iikey == '_$pro')
						{
							foreach($iival as $cval)
							{
								if (isset($this->outPage[$cval]))
								{
									$tpro[] = array("link" => $cval . $this->outputExt, "title" => $cval);
								}
							}
						} 
						else if ($iikey == '_$class')
						{
							foreach($iival as $cval)
							{
								$tclass[] = array("link" => $cval . $this->outputExt, "title" => $cval);
							}
						}
					}
					$subpackage_index[] = array("subpackage" => $ikey, 
						"inner_loop" => array("classes" => $tclass,"procedural" => $tpro));
				}
			}

			if (is_array($nonclass_index))
			{
				uksort($nonclass_index,"strnatcasecmp");
			}
			if (is_array($class_index))
			{
				uksort($class_index,"strnatcasecmp");
			}

			$this->output["li_$key"] = new Template($this->templateDir,"left.html");
			$this->output["li_$key"]->register("date",date("r",time()));
			$this->output["li_$key"]->register("nonclass",$nonclass_index);
			$this->output["li_$key"]->register("class",$class_index);
			$this->output["li_$key"]->register("subpackages",$subpackage_index);

			$this->outPage["li_$key"] = 1;

		}

		
		// Create constants page
		$this->output['constants'] = new Template($this->templateDir,"constant.html");
		
		// Natural Order constants by name
		uksort($this->constants,"strnatcasecmp");
		
		// Register constants
		$this->output['constants']->register("constants",$this->constants['constant']);
		$this->output['constants']->register("constant_detail",$this->constants['constant_detail']);

		$this->outPage['index'] = 1;
		$this->outPage['packages'] = 1;
		$this->outPage['constants'] = 1;
	}

	function Output ()
	{
		$this->registerCurrent();
		$this->PreOutput();
		foreach($this->output as $page => $data)
		{
			if ($this->outPage[$page])
			{
				echo "Writing $page$this->outputExt\n";
				$this->writeFile($page . $this->outputExt,$data->ret());
			}
		}

		// generate a blank stylesheet, so you don't get errors
		echo "Writing stylesheet.css\n";
		$this->writeFile("stylesheet.css","");
		echo "Writing blank.html\n";
		$this->writeFile("blank.html",":-)");
	}

	/**
	 *  Creates the style sheet
	 */
	function createStyleSheet()
	{
	}

	/** Sets the output directory of create
	*  @param $dir the output directory
	*/
	function setTargetDir($dir)
	{
		if (strlen($dir) > 0) 
		{
			$this->targetDir = $dir;
			// if directory does exist create it, this should have more error checking in the future
			if (!file_exists($dir))
			{
				mkdir($dir,0775);
			} 
			 else if (!is_dir($dir))
			{
				echo "Output path: '$dir' is not a directory\n";
				die();
			}
		} else {
			echo "a target directory must be specified\n try phpdoc -h\n";
			die();
		}
	}

	/**
	* Set template dir
	*
	* @param	string	$dir
	*/
	function setTemplateDir($dir)
	{
		$this->templateDir = $dir;
	}

	/**
	* Writes a file to target dir
	*/
	function writeFile($file,$data)
	{
		$fp = fopen($this->targetDir . "/$file","w");
		set_file_buffer( $fp, 0 );
		fwrite($fp,$data,strlen($data));
		fclose($fp);
	}
}
?>
