<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/**
* A simple template class that uses xml tags for special functions and has user setable surrounding tags for varible
*
* This class has been testing in 4.0.4pl1 and 4.0.5-dev
*
* I'm picky about the syntax to keep things fast, loop and include tags must be lowercase, and you must use double quotes (")
*
* <include filename="file"/>
*
* normal include files can contain other includes in them, includes with an if attribute cannot
*
* <loop name="loopname">
* </loop name="loopname">
*
* {A_VAR_TO_BE_REPLACED}
*/
class Template
{
	var $template	=	"";

	var $start	=	"{";
	var $end	=	"}";


	var $vars	=	array();
	var $loops	=	array();

	var $template_dir = "templates/";

	/**
	* Holds the value of strnatecasecmp(phpversion(),"4.0.4pl1"), so its 1 if the version is greater
	*/
	var $phpver	=	0;

	var $filename;

	/**
	* Loads the template file into the class
	*
	* @param	string	$dir
	* @param	string	$file
	*/
	function Template ($dir,$file)
	{
		$this->filename=$file;
		$this->template_dir = $dir;
		$file = $this->template_dir . $file;
		// setup phpver
		$this->phpver = strnatcasecmp(phpversion(),"4.0.4pl1");

		$fp = fopen($file,"r");
		$this->template = fread($fp,filesize($file));
		fclose($fp);
		if (!$this->PreParse())
		{
			die("Error PreParsing Template: $file\n");
		}
	}

	/**
	* Register a variable
	*
	* For loops $data is an array, the format is
	*
	* $data[0][name] = val
	* $data[0][name2] = val
	* $data[1][name] = val
	* $data[1][name2] = val
	*
	* this can also be created with the array construct like so
	* $data = array(
	*	array("name" =>  "val","name2" => "val"),
	*	array("name" =>  "val","name2" => "val"),
	*	array("name" =>  "val","name2" => "val")
	* };
	*
	* Or in terms of a table
	* [row][column] = value
	*
	* I've added support for loops within loops
	*
	* <loop name="loop1">
	*	{loop1_val}
	* 	<loop name="loop2">
	*		{loop2_val}
	* 	</loop name="loop2">
	* </loop name="loop1">
	*
	* To register for this you just need to add an inner_loop array inside your normal data array
	* $inner_array = array(
	*	array("name" =>  "val","name2" => "val"),
	*	array("name" =>  "val","name2" => "val"),
	*	array("name" =>  "val","name2" => "val")
	* };
	* $data = array(
	*	array("name" =>  "val","name2" => "val", "inner_loop" => array("loop_name" => $inner_array)),
	*	array("name" =>  "val","name2" => "val", "inner_loop" => array("loop_name" => $inner_array))
	* };
	*
	* Since I use foreach, arrays don't have to be numerically index, they can be associative and sorted to what ever order you need
	*/
	function Register ($name, $data)
	{
		if (is_array($data))
		{
			foreach($data as $row => $data2)
			{
				foreach($data2 as $colname =>$val)
				{
					//echo "[$name][$row]\n";
					if (strcmp($colname,"inner_loop") == 0)
					{
						//print_r($val);
						//list($iname,$ival) = each($val);
						foreach($val as $iname => $ival)
						{
							//echo "$iname\n";
							//print_r($ival);
							foreach($ival as $irow => $idata2)
							{
								//echo "	$irow\n";
								foreach($idata2 as $icolname =>$ival2)
								{
								//	echo "got here - [$name][$row]['inner_loop'][$iname][$irow]\n";
									$this->loops[$name][$row]['inner_loop'][$iname][$irow]['names'][] = 
									$this->start . $icolname .  $this->end;

									$this->loops[$name][$row]['inner_loop'][$iname][$irow]['data'][] = $ival2;
								}
							}
						}
					} else {
							$this->loops[$name][$row]['names'][] = $this->start . $colname . $this->end;
							$this->loops[$name][$row]['data'][] = $val;
					}
				}
			}
			if (count($data) == 0)
			{
				$this->loops[$name][] = "";
			}
		} else {
			$this->vars[names][] = $this->start . $name . $this->end;
			$this->vars[data][]  = $data;
		}
	}

	/**
	* PreParse the template including any files included with its include tag
	*
	* @return	false on error
	*/
	function PreParse()
	{
		$pos = 0;
		while ($pos < strlen($this->template))
		{
			$inc = strpos($this->template,"<include filename=");
			if ($inc === false)
			{
				// no includes to do get out of here
				return true;
			} 
			 else 
			{
				$pos = strpos($this->template,">",$inc) + 1;

				if (strpos($this->template,"/>",$inc))
				{
					$less = 2;
				} else {
					$less = 1;
				}

				$file = $this->template_dir . str_replace("\"","",substr($this->template,($inc+18),($pos-$less-$inc-18)));
				$this->includeFile($file,$inc,$pos);
			}
		}
		return true;
	}


	/**
	* Includes a file, with minimal error checking
	*
	* @param	string	$file	file to be included, full path
	* @param	int	$start	The start of insertion is $this->template
	* @param	int	$end	The end of the insertion in $this->template
	*/
	function includeFile($file,$start,$end)
	{
		if (is_file($file))
		{
			$fp = fopen($file,"r");
			$this->template = substr($this->template,0,$start) .  fread($fp,filesize($file)) . substr($this->template,$end);
			fclose($fp);
		} else {
			die( "\n\n\nTemplate File Not Found\n\n\n");
		}
	}

	/**
	* This is used for php4.04pl1 and lower
	* since str_replace can take arrays as arguments
	*
	* not really complete since $search and $replace have to be arrays, but this could be easily changed if you wanted to use this elsewhere
	*/
	function Replace($search,$replace,$target)
	{
		while((list(,$sval) = each($search)) && (list(,$rval) = each($replace)))
		{
			$target = str_replace($sval,$rval,$target);
				
		}
		return $target;
	}

	/**
	* Parse Loops in text
	*
	* @param	array	$loops
	* @param	string	$text
	* @return	string
	*/
	function ParseLoops($loops, $text)
	{
		//echo "Staring ParseLoops I got " . count($loops) . " root items in my loop and " . strlen($text) . " characters of text\n";
		//print_r($loops);
		//die(print_r($loops));
		// replace loops first
		if (is_array($loops))
		{
			$pos = 0;
			foreach($loops as $name => $data)
			{
				//echo "Working on loop $name\n";
				//print_r($data);
				$start = 0;
				$start = strpos($text,"<loop name=\"$name\">",$pos);
				$stag_len = strlen("<loop name=\"$name\">");
				$end   = strpos($text,"</loop name=\"$name\">",$start);
				$etag_len = $stag_len+1;

				if (!($start === false))
				{
					$loop = substr($text,$start + $stag_len ,($end-$start-$stag_len));

					$out = "";
					// build up code in loop
					$didareplace = false;
					foreach($data as $key => $row)
					{
						//echo "Working on row $key\n";
						//print_r($row);

						if (is_array($row['inner_loop']))
						{
							//echo "got here \n\n";
							//print_r($row['inner_loop']);
							$wout = $this->ParseLoops($row['inner_loop'],$loop);
							//die();
						} else {
							$wout = $loop;
						}
						
						if (is_array($row))
						{
							$didareplace = true;
							//print_r($row);
							//echo "Were going to do a replace\n";
							if ($this->phpver)
							{
								//echo "called real str_replace\n";
								$wout = str_replace($row['names'],$row['data'],$wout);
							} else {
								//echo "called fake str_replace\n";
								$wout = $this->replace($row['names'],$row['data'],$wout);
							}
							//echo "Done with the replace\n";
							if ($name == "docblock")
							{
								//echo $out;
							}
							unset($row);
						}
						$out .= $wout;
					}
				//	echo "Doing a substr\n";
					if ($didareplace)
					{
						$text = substr($text,0,$start) . $out . substr($text,$end + $etag_len);
					} else {
						$text = substr($text,0,$start) . substr($text,$end + $etag_len);
					}
				//	echo "Done with a substr\n";
				}
			}
		}
		//echo "Done with ParseLoops\n"
		//."Returning text of size " . strlen($text) . "\n";
		return $text;
	}

	/**
	* Replaces all the varibale in a template
	*/
	function Parse()
	{
		//$fp = fopen(tempnam("/tmp/phpXmlTransform","test"),"w");
		//fwrite($fp,$this->template,strlen($this->template));
		//fclose($fp);
		// parse out loops
		$this->template = $this->ParseLoops($this->loops,$this->template);

		// remove any loops that are still hanging around
		// /*
		$pos = 0;
		while ($pos < strlen($this->template))
		{
			$lastpos = $pos;
			$inc = strpos($this->template,"<loop name=",$pos);

			if ($inc === false)
			{
				$pos = strlen($this->template);
				// no more loops left
			} 
			 else 
			{
				unset($name);
				// find name
				$len = strpos($this->template,"\"",($inc + 12));
				if ($len === false)
				{
					die("There is an error in once of your templates you have an unclosed loop");
				}
				$name = substr($this->template,($inc + 12),($len - $inc -12) );
				

				$pos = strpos($this->template,"</loop name=\"$name\">",$pos) + strlen("</loop name=\"$name\">");

				//echo "\n\n\n" . substr($this->template,$inc,$pos - $inc) . "\n\n\n";
				$this->template = substr($this->template,0,$inc) . substr($this->template,$pos);
				
				// error check
				if ($pos == $lastpos)
				{
					echo ("There is an error in one of your templates, you have an unclosed loop\n");
				}

				$pos = 0;
			}

		}
		//*/

		//echo $this->template;
		// replace single vars
		if (count($this->vars) > 0)
		{
			if ($this->phpver)
			{
				$this->template = str_replace($this->vars[names],$this->vars[data],$this->template);
			} else {
				$this->template = $this->replace($this->vars[names],$this->vars[data],$this->template);
			}
		}

	}

	/**
	* Returns the template with all variable replaced
	*/
	function Ret()
	{
		$this->Parse();
		return $this->template;
	}
}
?>
