<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

// Include all needed files
include("Io.inc");
include("Template.inc");
include("Render.inc");
include("WordParser.inc");
include("EventStack.inc");
include("DataTypes.inc");
include("Parser.inc");

// set runtime to a large value since this can take quite a while
set_time_limit(360);	// six minute timeout

// This function lives here cause i don't know howto make uksort call a function in a class
// use a array like array($this,allUCstrCmp) to do this call from the class, but i don't know where the call comes from anywmore
function allUCstrCmp ($a, $b) {   
	$a = strtoupper($a);
	$b = strtoupper($b);
	return strcmp($a,$b); 
}


// create new classes
$setup = new Io;
$parse = new Parser;
$render = new Render;

//error_reporting(E_ALL); // if you want to turn this on, lots of bad indexes in arrays and other related stuff would have to be checked
// subcribe $render class to $parse class events
$parse->subscribe("*",$render);

if ($interface !="web")
{
	// Parse the argv settings
	$setting = $setup->parseArgv();
}

// Setup the different classes
$render->setTargetDir($setting['target']);
$render->setTemplateDir("templates/default/");

// parse the directory
if (!empty($setting['filename']))
{
	$files = explode(",",$setting['filename']);
	foreach($files as $file)
	{
		echo "Parsing file $file";
		flush();
        	$parse->parse($setup->readPhpFile($file),$file);
	}
}
if (!empty($setting['directory']))
{
	$dirs = explode(",",$setting['directory']);
	foreach($dirs as $dir)
	{
		if (substr($dir,-1) == "/" || substr($dir,-1) == "\\")
		{
			$dir = substr($dir,0,-1);
		}
		$base = count(explode("/",$dir));
		$base = $base + count(explode("\\",$dir)) - 2; // support windows
		$base++;

	        $files = $setup->dirList($dir);
        	foreach($files as $file)
	        {
			// Make sure the file isn't a hidden file
			$test = array_pop(explode("/",$file));
			if (strcmp(substr($test,0,1),".") != 0) {
				echo "Reading file $file";
				flush();
	        	        $parse->parse($setup->readPhpFile($file),$file,$base);
			}
	        }
	}
}

// render output
echo "\nWriting Files\n";
$render->output();

?>
