<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/**
*  Class to handle file and user io opperations
*/
class Io 
{
	
	/** Holds all the options that are avaible to the cmd line interface
	 *  and to the different web interfaces
	 */
	var $phpDocOptions;

	/**
	 *  creates an array $this->phpDocOptions and sets program options in it
	 *  Array is in the format of:
	 *  [filename][tag][] = "f";
	 *  [filename][tag][] = "-file";
	 *  [filename][desc] "name of file to parse"
	 */
	function Io()
	{
		$this->phpDocOptions[filename][tag] = array( "-f", "--filename");
		$this->phpDocOptions[filename][desc] = "name of file(s) to parse ',' file1,file2";
		$this->phpDocOptions[filename][type] = "path";

		$this->phpDocOptions[directory][tag] = array( "-d", "--directory");
		$this->phpDocOptions[directory][desc] = "name of a directory(s) to parse directory1,directory2";
		$this->phpDocOptions[directory][type] = "path";

		$this->phpDocOptions[target][tag] = array("-t", "--target");
		$this->phpDocOptions[target][desc] = "path where to save the generated files";
		$this->phpDocOptions[target][type] = "path";
/*		
		$this->phpDocOptions[ignore][tag] = array("-i", "--ignore");
		$this->phpDocOptions[ignore][desc] = "directories that will be ignored multiple seperated by ','";
		$this->phpDocOptions[ignore][type] = "path";

		$this->phpDocOptions[ignoref][tag] = array("-if", "--ignore-file");
		$this->phpDocOptions[ignoref][desc] = "file(s) that will be ignored multiple seperated by ','";
		$this->phpDocOptions[ignoref][type] = "path";
*/
		$this->phpDocOptions[hidden][tag] = array("-dh", "--hidden");
		$this->phpDocOptions[hidden][desc] = "set equal to on (-dh on) to descend into hidden directories\n\t\t\t\t\t(directories starting with '.'), default is off";
		$this->phpDocOptions[hidden][type] = "value";

		$this->phpDocOptions[template][tag] = array("-td", "--template");
		$this->phpDocOptions[template][desc] = "template directory, default is 'templates/default/'";
		$this->phpDocOptions[template][type] = "path";

		$this->phpDocOptions[help][tag] = array("-h", "--help");
		$this->phpDocOptions[help][desc] = "	show this help message";

		$this->phpDocOptions[help][tag] = array("-q", "--quiet");
		$this->phpDocOptions[help][desc] = "	do not be verbose";

		$this->phpDocOptions[general][message] ="You can have multiple directories and multiple files, as well as a combination of both options\n";
		$this->phpDocOptions[general][message] .="When ignoring directories and filenames you can use the * wildcard.  For example */hold would\n";
		$this->phpDocOptions[general][message] .="ignore any hold subdirectory\n";
	}

	
	/** created a help message
	 *  @return a string containing a help message
	 */
	function displayHelpMsg()
	{
		unset($ret);
		$ret = "\n";
		foreach($this->phpDocOptions as $data)
		{
			unset($tag);
			if (is_array($data[tag])) {
				foreach($data[tag] as $param) {
					$tag .= "$param	";
				}
			}
			$ret .= "  $tag		$data[desc]\n\n";
		}
		$ret .= "\n$data[message]\n";
		return $ret; 
	}


	/** write an array out to a file
         *  @param $fileName The name of the file to be written
         *  @param $array The to be wrote
         */
        function writeArray($fileName, $array)
        {
                $fp = fopen($fileName, "w");
                echo "Creating $fileName\n";
                foreach($array as $line) {
                        fputs($fp,$line . "\n");
                }
                fclose($fp);
        }

	/** Parses $GLOBALS[argv] and creates a setup array
	 *  @return a setup array
	 */
	function parseArgv()
	{
		// defaults for setting
		$setting['hidden'] = "off";
		$setting['template'] = 'templates' . PATH_DELIMITER .'default' . PATH_DELIMITER;

		$valnext = "junk";
		foreach ( $GLOBALS['argv'] as $cmd )
		{
		        $setting[$valnext] = $cmd;
		        foreach( $this->phpDocOptions as $name => $data )
			{
				if (!empty($data['tag'])) {
					if (in_array($cmd,$data['tag'])) {
						$valnext = $name;
						break;
					} else {
						$valnext = "junk";
					}
				}
			}
		}
		if (count($setting) < 2) {
			echo $this->displayhelpMsg();
			die();
		}
		return $setting;
	}


	/** Returns an array containing a list of files in a directory
         *  @param $directory full path to the directory you want the list of
         */
        function dirList($directory,$hidden = "off")
        {
		if (is_dir($directory))
		{
			$d = dir($directory);
			while($entry=$d->read()) {
				if (strcmp($entry,".") != 0 && strcmp($entry,"..") != 0) {
					if ($hidden == "off")
					{
						if (substr($entry,0,1) == ".")
						{
							$getentry = false;
						} else {
							$getentry = true;
						}
							
					} else {
						$getentry = true;
					}

					if ($getentry == true)
					{
						if (is_file($directory . PATH_DELIMITER . $entry)) {
							$ret[] = $directory . PATH_DELIMITER . $entry;
						}
						if (is_dir($directory . PATH_DELIMITER . $entry)) {
							$tmp = $this->dirList($directory . PATH_DELIMITER . $entry, $hidden);
							if (is_array($tmp)) {
								foreach($tmp as $ent) {
									$ret[] = $ent;
								}
							}
						}
					}
				}
			}
			$d->close();
		} else {
			die("directory: '$directory'  not found\n");
		}
		return $ret;
        }

	/**
	* Reads a file and returns it as a string
	* Does basic error checking
	*
	* At some point make allowable extension user setable
	*
	* @param	string	$path
	*/
	function readPhpFile($path, $quietMode = false)
	{
		$ext = array("php","php3","phtml","inc","php4");
		if (file_exists($path))
		{
			if (is_file($path))
			{
				// check extension
				$tmp = explode(".",$path);
				if (in_array(array_pop($tmp),$ext))
				{
					if ( $quietMode === false ) 
					{
						echo " -- Parsing file\n";
					}
					$fp = fopen($path,"r");
					$ret = fread($fp,filesize($path));
					fclose($fp);
					return $ret;
				} elseif ( $quietMode === false ) 
				{
					echo " -- File not parsed, not a php file\n";
				}
			} else {
				echo " -- Unable to read file, not a file\n";
			}
		} else {
			echo " -- Unable to read file, file does not exist\n";
		}
	}

	/**
	* Tell wheter to ignore a file or a directory
	*
	* @param	string	$file	just the file name of the file or directory, the the case of directories this is the last dir
	* @param	string	$path	the full path
	* @param	array	$ignore
	* @return 	bool		true if $path should be ignored, false if it should not
	*/
	function checkIgnore($file,$path,$ignore)
	{
		/*
		// compatablility function i haven't checked if this works, i just copied it out of the manual notes
		// thanks to bear@datasys.org and kerry@lothrop.de for this compatability function
		if (!function_exists("array_search")) {
		 function array_search ($needle, $haystack, $strict = FALSE) {
		 foreach($haystack as $key => $value) {
		 if ($strict) {
		 if ($value === $needle) return $key;
		 } else {
		 if ($value == $needle) return $key;
		 }
		 }
		 return FALSE;
		 }
		}

		if (is_array($ignore))
		{
			$pos = array_search($file,$ignore);
		} else {
			$pos = false;
		}

		if ($pos === true)
		{
			return true;
		} else {
			// get the ignore path and do futher checking
			$ig = $ignore[$pos];

			if ($ig === $path)
			{
				return true;	// exact match ignore
			} else {
				// check for wildcards
				if (strstr("*",$ig))
				{
					// we have a wildcard do something with it
					$matchup = explode("*",$ig);

					if (count($matchup != 2))
					{
						echo "Your ignore string had more then one wildcard, i only support a single wildcard per string\n";
						die();
					}


				} else {
					// no wildcards no exact match were done don't ignore
					return false;
				}
			}
		}
		*/
		return false;
	}
}
