<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
/**
* @package phpDocumentor
* @subpackage data
*/
/**
* smart htmlentities, doesn't entity the allowed tags list
* @param string $s
* @return string browser-displayable page
*/
function adv_htmlentities($s)
{
	global $___html,$PHPDOC_HTML_ALLOWED;
	$result = htmlentities($s);
	$entities = array_flip(get_html_translation_table(HTML_ENTITIES));
	$result = strtr($result,$___html);
	$matches = array();
	preg_match_all('/(&lt;img.*;&gt;)/',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	preg_match_all('/(&lt;ol.*;&gt;)/',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	preg_match_all('/(&lt;ul.*;&gt;)/',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	preg_match_all('/(&lt;li.*;&gt;)/',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	return $result;
}

/**
* The base class for data
*
* @author	Joshua Eichorn <jeichorn@phpdoc.org>
* @version	$Id: DataTypes.inc,v 1.27 2002/04/13 05:36:08 CelloG Exp $
* @package 	phpDocumentor
* @subpackage	data
*/
class Data
{
	/** directory this element's documentation file will be output to */
	var $dir;

	var $store;

	var $htmlentities = true;

	function setDir(&$docblock)
	{
		$this->dir = !empty($docblock->dir) ? $docblock->dir : 'default';
	}
	
	function getDir()
	{
		return $this->dir;
	}
	
	function setType ($type)
	{
		$this->store['type'] = $type;
	}

	function getType ()
	{
		return $this->store['type'];
	}

	function setName ($name)
	{
		$this->store['name'] = $name;
	}

	function getName ()
	{
		if (!isset($this->store['name'])) return false;
		if ($this->htmlentities)
		{
			return htmlentities($this->store['name']);
		} else {
			return $this->store['name'];
		}
	}

	function setValue ($val)
	{
		$this->store['value'] = $val;
	}

	function getValue ()
	{
		if (!isset($this->store['value'])) return false;
		if ($this->htmlentities)
		{
			return htmlentities($this->store['value']);
		} else {
			return $this->store['value'];
		}
	}

	function setDocblock ($obj)
	{
		$this->store['docblock'] = $obj->store;
	}

	function getDocblock ()
	{
		if (!isset($this->store['docblock'])) return false;
		return $this->store['docblock'];
	}

	function setParent ($val)
	{
		$this->store['parent'] = $val;
	}

	function getParent ()
	{
		if (!isset($this->store['parent'])) return false;
		return $this->store['parent'];
	}

	function setSourceLocation ($val)
	{
		$this->store['sourcelocation'] = $val;
	}

	function getSourceLocation ()
	{
		if (!isset($this->store['sourcelocation'])) return false;
		return $this->store['sourcelocation'];
	}

	function dump()
	{
		print_r($this->store);
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataFile extends Data
{
	function DataFile ()
	{
		$this->setType("file");
	}

	function setPath($path)
	{
		$this->store['path'] = $path;
	}

	function getPath()
	{
		if (!isset($this->store['path'])) return false;
		return $this->store['path'];
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataDefine extends Data
{
	function DataDefine ()
	{
		$this->setType("define");
	}

}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataDocBlock extends Data
{
	function DataDocBlock ()
	{
		$this->setType("docblock");
	}

	function getDirFromPackage()
	{
		$a = isset($this->store['data']['subpackage']) ? PATH_DELIMITER . $this->store['data']['subpackage'][0] : '';
		return isset($this->store['data']['package']) ? $this->store['data']['package'][0].$a : 'default';
	}

	function setShortDesc ($sdesc)
	{
		$this->store['sdesc'] = $sdesc;
	}

	function getShortDesc ()
	{
		if (!isset($this->store['sdesc'])) return '';
		return adv_htmlentities($this->store['sdesc']);
	}

	function setDesc ( $desc )
	{
		$this->store['desc'] = $desc;
	}

	function getDesc ()
	{
		if (!isset($this->store['desc'])) return '';
		return adv_htmlentities($this->store['desc']);
	}

	function addKeyword ($keyword, $data)
	{
		if ($keyword=='package') $this->dir = $data;
		if ($keyword=='subpackage') $this->dir .= PATH_DELIMITER . $data;
		$this->store['data'][$keyword][] = $data;
	}

	function getKeyword ($keyword)
	{
		if (!isset($this->store['data'][$keyword])) return false;
		if (count($this->store['data'][$keyword]) == 1)
		{
			if ($this->htmlentities)
			{
				if ($keyword != 'see')
				{
					return adv_htmlentities($this->store['data'][$keyword][0]);
				}
				else
				{
					return $this->store['data'][$keyword][0];
				}
			} else {
				return $this->store['data'][$keyword][0];
			}
		} else {
			if ($this->htmlentities)
			{
				if ($keyword != 'see')
				{
					return array_map("htmlentities",$this->store['data'][$keyword]);
				}
				else
				{
					return $this->store['data'][$keyword];
				}
			} else {
				return $this->store['data'][$keyword];
			}
		}
	}

	function listKeywords ()
	{
		if (isset($this->store['data']))
		{
			foreach($this->store['data'] as $key => $val)
			{
				$ret = array();
				if ($this->htmlentities)
				{
					// this be a hack but the whole htmlentities is an html specific hack, xml output may take some changes
					switch ($key)
					{
						case "author":
							foreach($val as $val2)
							{
								$ret[] = array("keyword" => ucfirst($key),"data" => $val2);
							}
						break;
						case "link":
							foreach($val as $val2)
							{
								$ret[] = array(
										"keyword" => ucfirst($key),
										"data" => "<A target='_blank' href='$val2'>" . htmlentities($val2) . "</a>"
									);
							}
						break;
						case "see":
							foreach($val as $val2)
							{
								$ret[] = array("keyword" => ucfirst($key),"data" => $val2);
							}
						break;
						default:
							foreach($val as $val2)
							{
								$ret[] = array("keyword" => ucfirst($key),"data" => adv_htmlentities($val2));
							}
						break;
					}
				} else {
					foreach($val as $val2)
					{
						$ret[] = array("keyword" => ucfirst($key),"data" => $val2);
					}
				}
			}
			return $ret;
		} else {
			return array();
		}
	}

	function addParam($keyword,$data)
	{
		$this->store['params'][$keyword] = $data;
	}

	function getParam($keyword)
	{
		if (!isset($this->store['params'][$keyword])) return false;
		if ($this->htmlentities)
		{
			return adv_htmlentities($this->store['params'][$keyword]);
		} else {
			return $this->store['params'][$keyword];
		}
	}

	function listParams ()
	{
		if (isset($this->store['params']))
		{
			$ret = array();
			foreach($this->store['params'] as $key => $val)
			{
				if ($this->htmlentities)
				{
					$ret[] = array("var" => ucfirst($key),"data" => adv_htmlentities($val));
				} else {
					$ret[] = array("var" => ucfirst($key),"data" => $val);
				}
			}
			return $ret;
		} else {
			return array();
		}
	}
}
		
/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataVar extends Data
{
	function DataVar ()
	{
		$this->setType("var");
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataFunction extends Data
{
	function DataFunction ()
	{
		$this->setType("function");
	}

	function addParam ($name, $val)
	{
		$this->store['params'][$name] = $val;
	}

	function getParam ($name)
	{
		if (!isset($this->store['params'][$name])) return false;
		if ($this->htmlentities)
		{
			return adv_htmlentities($this->store['params'][$name]);
		} else {
			return $this->store['params'][$name];
		}
	}

	function listParams ()
	{
		if (isset($this->store['params']))
		{
			foreach($this->store['params'] as $key => $val)
			{
				if ($this->htmlentities)
				{
					$ret[] = array($key,adv_htmlentities($val));
				} else {
					$ret[] = array($key,$val);
				}
			}
			return $ret;
		} else {
			return array();
		}
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataClass extends Data
{
	var $dir;
	function DataClass ()
	{
		$this->setType("class");
	}

	function setExtends($e)
	{
		$this->store["extends"] = $e;
	}

	
	function getExtends()
	{
		if (!isset($this->store['extends'])) return false;
		return $this->store["extends"];
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataPage extends Data
{
	function DataPage ()
	{
		$this->setType("page");
	}

	function setFile($file)
	{
		$this->store["file"] = $file;
	}

	function getFile()
	{
		if (!isset($this->store['file'])) return false;
		return $this->store["file"];
	}

	function setPath($path)
	{
		$this->store["path"] = $path;
	}

	function getPath()
	{
		if (!isset($this->store['path'])) return false;
		return $this->store["path"];
	}
}

class DataPackagePage extends Data
{
	function DataPackagePage($total,$package,$subpackage)
	{
		$a = $subpackage ? SMART_PATH_DELIMITER . $subpackage : '';
		$this->dir = isset($package) ? $package.$a : 'default';
		$this->setTotal($total);
		$this->setType('packagepage');
	}
	
	function setTotal($total)
	{
		$this->store['total'] = $total;
	}
	
	function getTotal()
	{
		if (!isset($this->store['total'])) return '';
		return $this->store['total'];
	}
	
	function ret()
	{
		return $this->getTotal();
	}
}
?>
