<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/** The Render Class
 *
 *  The Main render engine for Php Documentor
 *
 *  @author Joshua Eichorn
 *  @version 0.2.3
 *  @copyright 2000-2001 Joshua Eichorn 
 *  @package 	phpDocumentor
 */
class Render extends Template
{
	var $last	= "";

	var $cur_page = "";

	var $output	=	array();

	var $linker;
	
	var $package;
	
	var $dir;

	/**
	* Where files will be created by render
	*/
	var $targetDir	= "";

	/**
	* Where the template files are located
	*/
	var $templateDir= "";

	/**
	 * suppress all messages like "parsing file etc.".
	 * Usefull for cron jobs.
	 */
	var $quietMode = false;
	
	/**
	* suppress display of private elements marked with @access private in output docs
	*/
	var $parsePrivate = false;

	// buches of vars used as we build files up from templates
	var $page	= array();
	var $constants	= array();

	/**
	* The extenstion that the files will be output with
	*/
	var $outputExt	=	".html";

	/**
	* Holds wheter a page has had something set to it
	*/
	var $outPage	=	array();

	/**
	* The parent object
	*/
	var $parent	=	"";
	
	/**
	* @access private
	*/
	var $private_class = false;

	/**
	* Where vars, constants, and functions are stored til they are registered into the template
	*/
	var $current	= array();

	/**
	* Where vars and methods are stored til they are registered into the template
	*/
	var $currentclass	= array();

	/**
	* Used by the comparision function used in uksort
	*/
	var $rcnatcmpkey	= "";

	/**
	* The current output file
	*/
	var $file	=	"";

	/**
	* The array used to build the package and class index-files
	*/
	var $index	=	array();

	/**
	* The last type of element handled
	*/
	var $lasttype = '';

	/**
	* The current type of element handled
	*/
	var $type = '';

	/**
	* state constant lookup
	*/
	var $state_lookup = array();
	
	/**
	* State variable to find @package tags
	*/
	var $top_docblock = 1;

	function Render(&$linker)
	{
		$this->linker =& $linker;
	}

	// $data is always a class from DataTypes
	function HandleEvent($event,$data)
	{
		if ($event == PHPDOC_EVENT_NEWSTATE)
		{
			if ($data == STATE_END_CLASS)
			{
				$this->registerCurrentClass();
				$this->private_class = false;
			} elseif ($data == PHPDOC_EVENT_END_PAGE)
			{
				$this->registerCurrent();
			}
			//echo $this->state_lookup[$data] . "\n";
			//echo $data."\n";
		} 
		 else 
		{
			$this->lasttype = $this->type;
			$type = $data->getType();
			$this->type = $type;
			//echo $type . "\n";
			
			switch($type)
			{
				case "docblock":
					if ($this->lasttype == "docblock" && isset($this->page['template']))
					{
						$a = $this->last->getShortDesc();
						if (!is_string($a)) $a = '';
						$this->page['template']->register("sdesc",$a);
						$a = $this->last->getDesc();
						if (!is_string($a)) $a = '';
						$this->page['template']->register("desc",$a);
						unset($a);
						$this->page['template']->register("docblock",$this->last->listKeywords());
						$this->page['template']->register("name", (( is_null($this->last->getKeyword('name')) ) ? $this->file : $this->last->getKeyword('name')) ); // fc@fc.clever-soft.com

						// add this procedural page to the index
						if ($this->last->getKeyword('package'))
						{
							$this->dir = $this->package = $this->last->getKeyword('package');
							if (!isset($this->outPage['package_' . $this->package]) || !$this->outPage['package_' . $this->package])
							{
								if (file_exists(dirname($this->page_path) . PATH_DELIMITER . $this->package . $this->outputExt))
								{
									if ($this->quietMode === false)
									{
										echo "Reading package-level file ".$this->package . $this->outputExt;
										flush();
									}
									$fp = fopen(dirname($this->page_path) . PATH_DELIMITER . $this->package . $this->outputExt,"r");
									$ret = fread($fp,filesize(dirname($this->page_path) . PATH_DELIMITER . $this->package . $this->outputExt));
									fclose($fp);
									unset($fp);
									if ($this->quietMode === false)
									{
										echo " -- Parsing File\n";
										flush();
									}
									$my_events = $GLOBALS['event_stack'];
									$pageParser = new ppageParser;
									$pageParser->subscribe('*',$this);
									$pageParser->parse($ret,$this->package,$this->last->getKeyword('subpackage'));
									$GLOBALS['event_stack'] = $my_events;
									unset($my_events);
									unset($pageParser);
								}
							}
							$a = array_flip($this->index['default']['_$pro']);
							unset($this->index['default']['_$pro'][$a[$this->page['name']]]);

							if ($this->last->getKeyword('subpackage'))
							{
								$this->dir .= PATH_DELIMITER . $this->subpackage = $this->last->getKeyword('subpackage');
								$this->index[$this->last->getKeyword('package')][$this->last->getKeyword('subpackage')]['_$pro'][] = $this->page['name'];
							} else {
								$this->index[$this->last->getKeyword('package')]['_$pro'][] =  $this->page['name'];
							}
						} else
						{
							$this->dir = 'default';
							$this->package = 'default';
							$this->page['template']->register("desc","");
							$this->page['template']->register("sdesc","");
						}
						$this->page['template']->dir = $this->dir;
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					}
					$this->last = $data;
					unset($data);
				break;
				case "page":

					if (count($this->page) > 0)
					{
						if (!isset($this->page['template']->registered['desc']))
						$this->page['template']->register("desc","");
						if (!isset($this->page['template']->registered['sdesc']))
						$this->page['template']->register("sdesc","");
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					}
					// Create a new template, this is where non class stuff goes
					$this->page['template'] = new Template($this->templateDir,"page.html");
					if (isset($this->dir))
					$this->page['template']->dir = $this->dir;
					
					// Setting stuff about the page
					$this->file = "_" . $data->getName() . $this->outputExt;
					$this->page_path = $data->getPath();
					$this->parent = $this->cur_page = $this->page['name'] = "_" . $data->getName();
					$this->package = $this->page['template']->dir = 'default';
					$this->index['default']['_$pro'][] =  $this->page['name'];

					// registering stuff on the template
					$this->page['template']->register("source_location",$data->getSourceLocation());
					$this->page['template']->register("date",date("r",time()));
					$this->page['template']->register("type","Function");
					$this->page['template']->register("page",$this->file);
					$this->page['template']->register("title","Docs on page $this->file");
				break;
				case "class":
					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
						$this->last->dir = 'default';
					}
					if ($access = $this->last->getKeyword('access'))
					{
						if (($access == 'private') && (!$this->parsePrivate))
						{
							$access = false;
							$this->parent = $data->getName();
							$this->private_class = true;
							unset($this->last);
							break;
						}
					}
					$this->private_class = false;
					// set the package directory
					$data->setDir($this->last);
					// We have a new class, so were going to create a new file
					$template = new Template($this->templateDir,"class.html");
					$this->output[$data->getName()] =& $template;
					$template->register("type","Method");
					$template->dir = $data->getDir();

					// add this class to the index
					if ($this->last->getKeyword('package'))
					{
						if (!isset($this->outPage[$this->last->getKeyword('package')]) || !$this->outPage[$this->last->getKeyword('package')])
						{
							if (file_exists(dirname($this->page_path) . PATH_DELIMITER . $this->package . $this->outputExt))
							{
								if ($this->quietMode === false)
								{
									echo "Reading package-level file ".$this->package . '.' . $this->outputExt . "\n";
									flush();
								}
								$fp = fopen(dirname($this->page_path) . PATH_DELIMITER . $this->last->getKeyword('package') . $this->outputExt,"r");
								$ret = fread($fp,filesize(dirname($this->page_path) . PATH_DELIMITER . $this->last->getKeyword('package') . $this->outputExt));
								fclose($fp);
								unset($fp);
								if ($this->quietMode === false)
								{
									echo " -- Parsing File\n";
									flush();
								}
								$my_events = $GLOBALS['event_stack'];
								$pageParser = new ppageParser;
								$pageParser->subscribe('*',$this);
								$pageParser->parse($ret,$this->last->getKeyword('package'),$this->last->getKeyword('subpackage'));
								$GLOBALS['event_stack'] = $my_events;
								unset($my_events);
								unset($pageParser);
							}
						}
						if ($this->last->getKeyword('subpackage'))
						{
							$this->index[$this->last->getKeyword('package')][$this->last->getKeyword('subpackage')]['_$class'][] = $data->getName();
						} else {
							$this->index[$this->last->getKeyword('package')]['_$class'][] = $data->getName();
						}
					} else {
						$this->index['default']['_$class'][] = $data->getName();
					}

					// Register Nothing to variable that might not be set latter
					//$template->register("vars",array());
					//$template->register("var_detail",array());
					//$template->register("functions",array());
					//$template->register("function_detail",array());
					
					$template->register("title","Docs For Class " . $data->getName());
					$template->register("page",$data->getName() . $this->outputExt);
					$template->register("class_name",$data->getName());
					$template->register("sdesc",$this->last->getShortDesc());
					$template->register("desc",$this->last->getDesc());
					$template->register("docblock",$this->last->listKeywords());

					$template->register("class_tree", $this->linker->generateFormattedClassTree($data->getName()));
					
					$template->register("source_location",$data->getSourceLocation());
					$template->register("date",date("r",time()));

					$this->parent = $data->getName();
					$this->outPage[$this->parent] = 1;

					$inherited_vars = $this->linker->getFormattedInheritedVars($data->getName());
					if (!empty($inherited_vars))
					{
						$template->register("vars_inherited",$inherited_vars);
					}
					$inherited_methods = $this->linker->getFormattedInheritedMethods($data->getName());
					if (!empty($inherited_methods))
					{
						$template->register("inherited_functions",$inherited_methods);
					}
					unset($this->last);
				break;
				case "define":
					if (count($this->page) > 0)
					{
						if (!isset($this->page['template']->registered['desc']))
						$this->page['template']->register("desc","");
						if (!isset($this->page['template']->registered['sdesc']))
						$this->page['template']->register("sdesc","");
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					}

					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
						$this->last->setDir($this->dir);
					}
					if ($access = $this->last->getKeyword('access'))
					{
						if (($access == 'private') && (!$this->parsePrivate))
						{
							unset($this->last);
							break;
						}
					}
					// set the package directory
					$data->setDir($this->last);
					$data->setParent($this->parent);	
					$this->outPage[$this->parent] = 1;


					$this->current['constant'][] = 
						array(
							"constant_name" => $data->getName(), 
							"constant_value" => $data->getValue(),
							"constant_sdesc" => $this->last->getShortDesc()
						);
					$this->current['constant_detail'][] = 
						array(
							"constant_name" 	=> $data->getName(), 
							"constant_value" 	=> $data->getValue(), 
							"sdesc" 		=> $this->last->getShortDesc(),
							"desc" 			=> $this->last->getDesc(),
							"inner_loop"		=> array("docblock" => $this->last->listKeywords())
						);

					$this->constants[$data->getName()] = array(
						"constant" =>
							array(
								"constant_name" => $data->getName(), 
								"constant_value" => $data->getValue(),
								"constant_sdesc" => $this->last->getShortDesc()
							)
						,
						"constant_detail" =>
							array(
								"constant_name" 	=> $data->getName(), 
								"constant_value" 	=> $data->getValue(), 
								"sdesc" 		=> $this->last->getShortDesc(),
								"desc" 			=> $this->last->getDesc(),
								"inner_loop"		=> array("docblock" => $this->last->listKeywords())
							)
					);
					unset($this->last);
				break;
				case "function":
					if (count($this->page) > 0)
					{
						if (!isset($this->page['template']->registered['desc']))
						$this->page['template']->register("desc","");
						if (!isset($this->page['template']->registered['sdesc']))
						$this->page['template']->register("sdesc","");
						$this->output[$this->page['name']] = $this->page['template'];
						$this->page = array();
					}

					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
						$this->last->setDir($this->dir);
					}
					if ($this->parent != $this->cur_page)
					{
						if (($this->private_class) && (!$this->parsePrivate))
						{
							unset($this->last);
							break;
						}
					}
					if ($access = $this->last->getKeyword('access'))
					{
						if (($access == 'private') && (!$this->parsePrivate))
						{
							unset($this->last);
							break;
						}
					}
					$data->setParent($this->parent);	
					$this->outPage[$this->parent] = 1;

					$function_call = $data->getName() . " ( ";
					$tmp = 0;
					foreach($data->listParams() as $param)
					{
						if ($tmp == 0)
						{
							$tmp = 1;
						} else {
							$function_call .= ", ";
						}
						if (!empty($param[1]))
						{
							$function_call .= "[$param[0] = $param[1]]";
						} else {
							$function_call .= $param[0];
						}
					}
					$function_call .= " )";

					$fname = $data->getName();
					if ($this->parent != $this->cur_page)
					{
						if ($data->getName() == $this->parent) $fname = 'constructor '.$data->getName();
					}

					if ($this->parent != $this->cur_page)
					{
						$this->currentclass['function'][] = 
							array(
								"function_name" 	=> $fname, // $data->getName(), 
								"function_sdesc" 	=> $this->last->getShortDesc(),
								"function_call" 	=> $function_call
							);
							/*
							print_r(array(
								"docblock" => $this->last->listKeywords(),
								"params" => $this->last->listParams()));
							//	*/
						$this->currentclass['function_detail'][] = 
							array(
								"function_name" 	=> $fname, // $data->getName(), 
								"sdesc"		 	=> $this->last->getShortDesc(),
								"function_call" 	=> $function_call,
								"desc" 			=> $this->last->getDesc(),
								"inner_loop"		=> array(
												"docblock" => $this->last->listKeywords(),
												"params" => $this->last->listParams()
												)
							);
					} else
					{
						$this->current['function'][] = 
							array(
								"function_name" 	=> $fname, // $data->getName(), 
								"function_sdesc" 	=> $this->last->getShortDesc(),
								"function_call" 	=> $function_call
							);
							/*
							print_r(array(
								"docblock" => $this->last->listKeywords(),
								"params" => $this->last->listParams()));
							//	*/
						$this->current['function_detail'][] = 
							array(
								"function_name" 	=> $fname, // $data->getName(), 
								"sdesc"		 	=> $this->last->getShortDesc(),
								"function_call" 	=> $function_call,
								"desc" 			=> $this->last->getDesc(),
								"inner_loop"		=> array(
												"docblock" => $this->last->listKeywords(),
												"params" => $this->last->listParams()
												)
							);
					}

					unset($this->last);
				break;
				case "var":
					if (empty($this->last))
					{
						// we don't have a docblock, create an empty one to get rid of errors
						$this->last = new DataDocblock();
						$this->last->setDir($this->dir);
					}
					if ($this->private_class)
					{
						unset($this->last);
						break;
					}
					if ($access = $this->last->getKeyword('access'))
					{
						if (($access == 'private') && (!$this->parsePrivate))
						{
							unset($this->last);
							break;
						}
					}
					// set the package directory
					$data->setDir($this->last);
					$this->currentclass['var'][] = 
						array(
							"var_name" => $data->getName(), 
							"var_default" => $data->getValue(), 
							"var_sdesc" => $this->last->getShortDesc()
						);
					$this->currentclass['var_detail'][] = 
						array(
							"var_name" => $data->getName(), 
							"sdesc" => $this->last->getShortDesc(),
							"desc" => $this->last->getDesc(),
							"inner_loop" => array("docblock" => $this->last->listKeywords())
						);
					unset($this->last);
				break;
				case "packagepage":
					$this->outPage['package_' . $this->package] = 1;
					$this->output['package_' . $this->package] = $data;
					unset($data);
				break;
			}

		}
	}

	/**
	* Registers anything that is being stored in $this->current, sorts them first
	*/
	function registerCurrent()
	{
		if ($this->parent != $this->cur_page) $this->registerCurrentClass();
		if (!empty($this->current['constant']))
		{
			$this->rcnatcmpkey = "constant_name";
			uasort($this->current['constant'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("constants",$this->current['constant']);
		}
		if (!empty($this->current['constant_detail']))
		{
			$this->rcnatcmpkey = "constant_name";
			uasort($this->current['constant_detail'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("constant_detail",$this->current['constant_detail']);
		}
		if (!empty($this->current['function']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->current['function'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("functions",$this->current['function']);
		}
		if (!empty($this->current['function_detail']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->current['function_detail'],array($this,"rcNatCmp"));
//			print_r($this->current['function_detail']);
			$this->output[$this->parent]->register("function_detail",$this->current['function_detail']);
		}
		if (!empty($this->current['var']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->current['var'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("vars",$this->current['var']);
		}
		if (!empty($this->current['var_detail']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->current['var_detail'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("var_detail",$this->current['var_detail']);
		}
		unset($this->current);
	}
	
	function registerCurrentClass()
	{
		if (!empty($this->currentclass['function']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->currentclass['function'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("functions",$this->currentclass['function']);
		}
		if (!empty($this->currentclass['function_detail']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->currentclass['function_detail'],array($this,"rcNatCmp"));
		//	print_R($this->current['function_detail']);
			$this->output[$this->parent]->register("function_detail",$this->currentclass['function_detail']);
		}
		if (!empty($this->currentclass['var']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->currentclass['var'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("vars",$this->currentclass['var']);
		}
		if (!empty($this->currentclass['var_detail']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->currentclass['var_detail'],array($this,"rcNatCmp"));
			$this->output[$this->parent]->register("var_detail",$this->currentclass['var_detail']);
		}
		unset($this->currentclass);
		$this->parent = $this->cur_page;
	}

	/**
	* does a nat case sort on the specified second level value of the array
	*
	* @param	mixed	$a
	* @param	mixed	$b
	* @return	int
	*/
	function rcNatCmp ($a, $b)
	{
		$aa = strtoupper($a[$this->rcnatcmpkey]);
		$bb = strtoupper($b[$this->rcnatcmpkey]);
		
		return strnatcasecmp($aa, $bb);
	}

	/** this is where we handle sorting stuff and adding inheirentance information to pages */
	function PreOutput ()
	{
		// Created index.html
		$index = new Template($this->templateDir,"index.html");
		$this->output['index'] =& $index;
		
		$index->register("date",date("r",time()));
		$index->register("title","Generated Documentation");
		list($start,) = each($this->index);
		$index->register("start","li_$start" . $this->outputExt);

		/*
		if (is_array($nonclass_index))
		{
			uksort($nonclass_index,"strnatcasecmp");
		}
		if (is_array($class_index))
		{
			uksort($class_index,"strnatcasecmp");
		}
		*/

		foreach($this->index as $key => $val)
		{
			$package_index[$key] = array('link' => "li_$key". $this->outputExt, 'title' => $key);
		}
		//uksort($package_index,"strnatcasecmp");

		// Create package index
		$package = new Template($this->templateDir,"packages.html");
		$package->register("date",date("r",time()));
		$package->register("packages",$package_index);

		$this->output['packages'] = $package;

		// create indexes for each package
		foreach($this->index as $key => $val)
		{
			unset($nonclass_index);
			unset($class_index);
			unset($subpackage_index);
			// loop through subpackages and classes in package
			foreach($val as $ikey => $ival)
			{
				if ($ikey == '_$pro')
				{
					foreach($ival as $cval)
					{
						if (isset($this->outPage[$cval]))
						{
							$nonclass_index[] = array("link" => $this->output[$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $cval);
						}
					}
				} 
				else if ($ikey == '_$class')
				{
					foreach($ival as $cval)
					{
						$class_index[] = array("link" => $this->output[$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $cval);
					}
				} 
				else 
				{
					$tpro = array();
					$tclass = array();
					foreach($ival as $iikey => $iival)
					{
						if ($iikey == '_$pro')
						{
							foreach($iival as $cval)
							{
								if (isset($this->outPage[$cval]))
								{
									$tpro[] = array("link" => $this->output[$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $cval);
								}
							}
						} 
						else if ($iikey == '_$class')
						{
							foreach($iival as $cval)
							{
								$tclass[] = array("link" => $this->output[$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $cval);
							}
						}
					}
					$subpackage_index[] = array("subpackage" => $ikey, 
						"inner_loop" => array("classes" => $tclass,"procedural" => $tpro));
				}
			}

			if (!isset($subpackage_index)) $subpackage_index = false;
			if (!isset($class_index)) $class_index = false;
			if (!isset($nonclass_index)) $nonclass_index = false;
			
			if (is_array($nonclass_index))
			{
				uksort($nonclass_index,"strnatcasecmp");
			}
			if (is_array($class_index))
			{
				uksort($class_index,"strnatcasecmp");
			}
			

			$this->output["li_$key"] = new Template($this->templateDir,"left.html");
			$this->output["li_$key"]->register("date",date("r",time()));
			$this->output["li_$key"]->register("nonclass",$nonclass_index);
			$this->output["li_$key"]->register("class",$class_index);
			$this->output["li_$key"]->register("subpackages",$subpackage_index);
			$this->output["li_$key"]->register("packagename",$key);
			if (isset($this->output['package_'.$key]))
			{
				$this->output["li_$key"]->register("packagedoc",'<a target="right" href="' . $key . PATH_DELIMITER . 'package_' . $key . $this->outputExt . '">'.$key.' Package-level Docs</a><br>');
			} else
			{
				$this->output["li_$key"]->register("packagedoc","");
			}

			$this->outPage["li_$key"] = 1;

		}

		
		// Create class tree page
		$this->output['classtrees'] = new Template($this->templateDir,"classtrees.html");
		$this->output['classtrees']->register("classtrees",$this->linker->generateFormattedClassTrees());
		$this->output['classtrees']->register("title","Class Trees");
		$this->outPage['classtrees'] = 1;

		// Create element index page
		list($package_indexes,$packages) = $this->linker->generatePkgElementIndexes();
		$this->output['elementindex'] = new Template($this->templateDir,"elementindex.html");
		$this->output['elementindex']->register("elementindex",$this->linker->generateElementIndex());
		$this->output['elementindex']->register("title","Element Index");
		$this->output['elementindex']->register("page","elementindex.html");
		$this->output['elementindex']->register("packageindexes",$packages);
		$this->outPage['elementindex'] = 1;
		for($i=0;$i<count($package_indexes);$i++)
		{
			$template = new Template($this->templateDir,"pkgelementindex.html");
			$this->output['elementindex_'.$package_indexes[$i]['package']] = $template;
			$this->output['elementindex_'.$package_indexes[$i]['package']]->register("pindex",$package_indexes[$i]['inner_loop']['pindex']);
			$this->output['elementindex_'.$package_indexes[$i]['package']]->register("package",$package_indexes[$i]['package']);
			$this->outPage['elementindex_'.$package_indexes[$i]['package']] = 1;
		}

		// Create constants page
/*		$this->output['constants'] = new Template($this->templateDir,"constant.html");
		
		// Natural Order constants by name
		uksort($this->constants,"strnatcasecmp");

		if (!isset($this->constants['constant'])) $this->constants['constant'] = false;
		if (!isset($this->constants['constant_detail'])) $this->constants['constant_detail'] = false;
		// Register constants
		$this->output['constants']->register("constants",$this->constants['constant']);
		$this->output['constants']->register("constant_detail",$this->constants['constant_detail']);
*/

		$this->outPage['index'] = 1;
		$this->outPage['packages'] = 1;
//		$this->outPage['constants'] = 1;
	}

	function Output ()
	{
		$this->registerCurrent();
		$this->registerCurrentClass();
		$this->PreOutput();
		$wroteto = array();
		$target = $this->targetDir;
		foreach($this->output as $page => $data)
		{
			if (isset($this->outPage[$page]) && $this->outPage[$page])
			{
				if (isset($data->dir)) $data->dir .= SMART_PATH_DELIMITER; else $data->dir = '';
				$this->setTargetdir($target.SMART_PATH_DELIMITER.$data->dir);
				if (!empty($data->dir) && !isset($wroteto[$target.SMART_PATH_DELIMITER.$data->dir]))
				{
					$wroteto[$target.SMART_PATH_DELIMITER.$data->dir] = 1;
					if ( $this->quietMode === false ) 
					{
						echo "Writing stylesheet.css to ".$target.SMART_PATH_DELIMITER.$data->dir."\n";
					}
					$this->writeFile("stylesheet.css",implode("",file($this->templateDir."/stylesheet.css"))); // fc@fc.clever-soft.com
					$template_images = array("bg_left.png");
					foreach($template_images as $image)
					{
						if (file_exists($this->templateDir.$image))
						{
							$this->writeFile($image,implode("",file($this->templateDir.$image)));
						}
					}
				}
				if ( $this->quietMode == false ) 
				{
					echo "Writing ".$this->targetDir."$page$this->outputExt\n";
				}
				$this->writeFile($page . $this->outputExt,$data->ret());
			}
		}

		$this->setTargetdir($target);
		if ( $this->quietMode === false ) 
		{
			echo "Writing stylesheet.css\n";
		}
		$this->writeFile("stylesheet.css",implode("",file($this->templateDir."/stylesheet.css"))); // fc@fc.clever-soft.com
		if ( $this->quietMode === false ) 
		{
			echo "Writing blank.html\n";
		}
		$this->writeFile("blank.html",":-)");
		if ( $this->quietMode === false ) 
		{
			echo "Copying Any Template Images\n";
		}
		$template_images = array("bg_left.png");
		foreach($template_images as $image)
		{
			if (file_exists($this->templateDir.$image))
			{
				$this->writeFile($image,implode("",file($this->templateDir.$image)));
			}
		}
	}

	/** Sets the output directory of create
	*  @param $dir the output directory
	*/
	function setTargetDir($dir)
	{
		if (strlen($dir) > 0) 
		{
			$this->targetDir = $dir;
			// if directory does exist create it, this should have more error checking in the future
			if (!file_exists($dir))
			{
				$tmp = str_replace(array("/","\\"),SMART_PATH_DELIMITER,$dir);
				if (substr($tmp,-1) == SMART_PATH_DELIMITER)
				{
					$tmp = substr($tmp,0,(strlen($tmp)-1));
				}
				$tmp = explode(SMART_PATH_DELIMITER,$tmp);
				array_pop($tmp);
				$parent = implode(SMART_PATH_DELIMITER,$tmp);
				if (!file_exists($parent))
				{
					echo "Creating Parent Directory $parent\n";
					mkdir($parent,0775);
				}
				echo "Creating Directory $dir\n";
				mkdir($dir,0775);
			} 
			 else if (!is_dir($dir))
			{
				echo "Output path: '$dir' is not a directory\n";
				die();
			}
		} else {
			echo "a target directory must be specified\n try phpdoc -h\n";
			die();
		}
	}

	/**
	* Set template dir
	*
	* @param	string	$dir
	*/
	function setTemplateDir($dir)
	{
		$this->templateDir = $dir;
	}

	/**
	 * set mode (quiet or verbose)
	 *
	 * @param	bool $quietMode
	 */
	function setQuietMode($quietMode) {
		$this->quietMode = $quietMode;
	}
	
	/**
	* set parsing (on or off)
	*
	* @param	bool $parse
	*/
	function setParsePrivate($parse)
	{
		$this->parsePrivate = $parse;
	}

	/**
	* Writes a file to target dir
	*/
	function writeFile($file,$data)
	{
		if (!file_exists($this->targetDir))
		{
			mkdir($this->targetDir,0775);
		}
		$fp = fopen($this->targetDir . PATH_DELIMITER . $file,"w");
		set_file_buffer( $fp, 0 );
		fwrite($fp,$data,strlen($data));
		fclose($fp);
	}
}
?>
