<?php
/**
* @package 	phpDocumentor
*/
// 
// 
// An HTML interface for Joshua Eichorn's PhpDoc
// Author: Juan Pablo Morales 	<ju-moral@uniandes.edu.co>
//	   Joshua Eichorn	<jeichorn@phpdoc.org>
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//
// Copyleft 2001 Juan Pablo Morales
?>
<html>
<head>
<title>Form to submit to PhpDoc</title>
</head>
<?php
//Find out if we are submitting and if we are, send it
// This code originally by Joshua Eichorn on phpdoc.php
//
if($HTTP_POST_VARS["submit"]) {
	echo "<body bgcolor=\"#ffffff\">";
	echo "<h1>Parsing Files ...</h1>";
	flush();
	echo "<pre>\n";
	include("phpdoc.inc");
	echo "</pre>\n";
	echo "<h1>Operation Completed!!</h1>";
} else {
	?>
<SCRIPT LANGUAGE="Javascript">
/**
   Creates some global variables
*/
function initializate() {
	//
	//The "platform independent" newLine
	//
	//Taken from http://developer.netscape.com/docs/manuals/communicator/jsref/brow1.htm#1010426
if (navigator.appVersion.lastIndexOf('Win') != -1)
		$newLine="\r\n";
	else 
		$newLine="\n";
/*	for($a=0;$a<document.dataForm.elements.length;$a++) {
	alert("The name is '"+document.dataForm.elements[$a].name+"' "+$a);
	}
*/
}
/**Adds the contents of the help box as a directory
*/
function addDirectory($object) {
	$object.value = prepareString($object.value)+document.helpForm.fileName.value;
}
/**Adds the contents of the help box as a file to the given control
*/
function addFile($object) {
	$object.value = prepareString($object.value)+document.helpForm.fileName.value;
}
/**Takes a given string and leaves it ready to add a new string
   That is, puts the comma and the new line if needed
*/
function prepareString($myString) {
	//First verify that a comma is not at the end
	if($myString.lastIndexOf(",") >= $myString.length-2) {
		//We have a comma at the end
		return $myString;
	}
	if($myString.length > 0) {
		$myString+=","+$newLine;
	}
	return $myString;
}
/**Do the validation needed before sending the from and return a truth value indicating if the form can be sent
*/
 function validate() {
	 //Take out all newLines and change them by nothing
	 //This could be done by using javascript function's replacebut that was implemented only until Navigator 4.0 and so it is better to use more backward compatible functions like substr 
	 document.dataForm.elements[1].value= stripNewLines(document.dataForm.elements[1].value);
	 document.dataForm.elements[2].value= stripNewLines(document.dataForm.elements[2].value);
	 //By returning true we are allowing the form to be submitted
	 return true;
 }
/**Takes a string and removes all the ocurrences of new lines
Could have been implemented a lot easier with replace but it's not very backwards compatible
*/
 function stripNewLines($myString) {
	 return myReplace($myString,$newLine,'');
 }
 function myReplace($string,$text,$by) {
 // Replaces text with by in string
     var $strLength = $string.length, $txtLength = $text.length;
     if (($strLength == 0) || ($txtLength == 0)) return $string;

     var $i = $string.indexOf($text);
     if ((!$i) && ($text != $string.substring(0,$txtLength))) return $string;
     if ($i == -1) return $string;

     var $newstr = $string.substring(0,$i) + $by;

     if ($i+$txtLength < $strLength)
         $newstr += myReplace($string.substring($i+$txtLength,$strLength),$text,$by);

     return $newstr;
 }
</SCRIPT>
<body bgcolor="#ffffff" onLoad="javascript:initializate()">
<h1>Form to submit to PHPDoc</h1>
<form name="dataForm" action="phpdoc.php" method ="POST" onSubmit="return validate()">
<div align="center">
<table cellpadding=0 cellspacing=0 border=0 width="80%" bgcolor="#000000">
<tr>
<td>
<table cellpadding=0 cellspacing=1 border=0 width="100%">
<tr>
<td bgcolor="#ffdddd">
<b>Target</b>
</td>
</tr>
<tr>
<td bgcolor="#eeeeee">
Target is the localization of a directory where the .html files produced by PhpDoc will reside Do not end with the directory separating character (\ or /)
<br>
<input type=TEXT name= "setting[target]" SIZE=80><br>
<A HREF="javascript:addDirectory(document.dataForm.elements[0])">Add the directory in the help box
</a>
</td>
</tr>
<tr>
<td bgcolor="#ffdddd">
<b>Files to parse</b>
</td>
</tr>
<tr>
<td bgcolor="#eeeeee">
The parameter filename is a group of comma separated names of .php or .inc files that will be processed by PhpDoc. It is completely necessary that all filenames are separated by comma and they can also be optionally separated by a newLine character
<br>
<TEXTAREA ROWS=6 COLS=80 name="setting[filename]">
</TEXTAREA>
<BR>
<A HREF="javascript:addFile(document.dataForm.elements[1])">Add the file in the help box
</a>
</td>
</tr>
<tr>
<td bgcolor="#ffdddd">
<b>Directory to parse</b>
</td>
</tr>
<tr>
<td bgcolor="#eeeeee">
The parameter directory is a group of comma separated, not \ or / ended directories
<TEXTAREA ROWS=6 COLS=80 name= "setting[directory]">
</textarea>
<br>
<A HREF="javascript:addDirectory(document.dataForm.elements[2])">Add the directory in the help box
</a>
</td>
</tr>
<tr>
<td bgcolor="#ffdddd">
<b>Template</b>
</td>
</tr>
<tr>
<td bgcolor="#eeeeee">
<br>Template is the localization of the directory where template files for the generation of the documentation are.
Must end with the directory separating character ( \ or /).
<input type=TEXT name= "setting[template]" value="templates/default/" SIZE=80><br>
<A HREF="javascript:addDirectory(document.dataForm.elements[3])">Add the directory in the help box
</a>
</td>
</tr>
</table>
</td>
</tr>
</table>
<input type=HIDDEN name= "interface" value="web">
<input type=HIDDEN name="submit" value="true">
<input type=SUBMIT value= "Send Form" name="submitButton">
</div>
</form>
<br>
<br>
<div align="center">
<table cellpadding=0 cellspacing=0 border=0 width="80%" bgcolor="#000000">
<tr>
<td>
<table cellpadding=0 cellspacing=1 border=0 width="100%">
<tr>
<td bgcolor="#ffdddd">
<b>A little help</b>
</td>
</tr>
<tr>
<td bgcolor="#eeeeee">
Since remember long path is not that easy here is a little file control to view names of files that can the be aggregated to the different properties
<form name="helpForm" action="" method="post" ENCTYPE="multipart/form-data">
<input size=80 type=file name="fileName">
</form>
</td>
</tr>
</table>
</td>
</tr>
</table>
</div>
<br>
<b>Web-Interface Author: </b>Juan Pablo Morales<br>
<a href="mailto:ju-moral@uniandes.edu.co">ju-moral@uniandes.edu.co</a>
<br>
<p>If you have any problems with phpdoc, please visit the website: <A href='http://phpdocu.sourceforge.net'>phpdocu.sourceforge.net</a> and submit a bug</p>
<!-- Created: Tue Jun 26 18:52:40 MEST 2001 -->
<!-- hhmts start -->
<pre>
Last modified: $Date: 2002/04/07 04:59:53 $
Revision: $Revision: 1.11 $
</pre>
<!-- hhmts end -->
<? } //End the else that prints all code
?>
</body>
</html> 
