<?php
/**
* @package phpDocumentor
*/
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/** Debugging output */
function debug($s)
{
	echo "$s\n";
}

/** Debug Constant */
define("DEBUG",false);	// set to true to get debug output from the parser

// fix from David Norman, make things work with non-standard php.ini settings
ini_set('register_argc_argv',1);
ini_set('register_globals',1);
//ini_set('error_reporting',0); // we should get to the point that we dont need this

// Include all needed files
include("Io.inc");
include("Template.inc");
include("Publisher.inc");
include("Render.inc");
include("WordParser.inc");
include("EventStack.inc");
include("DataTypes.inc");
include("Parser.inc");
include("Linker.inc");


// set runtime to a large value since this can take quite a while
set_time_limit(0);	// six minute timeout
$parse_start_time = time();
define('SMART_PATH_DELIMITER', (substr(PHP_OS, 0, 3) == 'WIN') ? '\\' : '/' ); // set the correct path delimiter
// we just replace all the \ with / so that we can just operate on /
define('PATH_DELIMITER', '/' ); // set the correct path delimiter
$PHPDOC_PHPFILE_EXTS = array("php","php3","phtml","inc","php4");
// html tags that will not be escaped in docblocks
$PHPDOC_HTML_ALLOWED
	= array("ul",
			"ol",
			"li",
			"dt",
			"dd",
			"dl",
			"p",
			"br",
			"blockquote",
			"hr",
			"img",
			"font",
			"sub",
			"sup",
			"b",
			"i",
			"em",
			"strong",
			"pre",
			"a",
			"code",
			);

$___htmltemp = array_flip($PHPDOC_HTML_ALLOWED);
$___html1 = array();
foreach($___htmltemp as $tag => $trans)
{
	$___html1['<'.$tag.'>'] = htmlentities('<'.$tag.'>');
	$___html1['</'.$tag.'>'] = htmlentities('</'.$tag.'>');
	$___html = array_flip($___html1);
}
unset($___htmltemp);
unset($___html1);

// This function lives here cause i don't know howto make uksort call a function in a class
// use a array like array($this,allUCstrCmp) to do this call from the class, but i don't know where the call comes from anywmore
function allUCstrCmp ($a, $b) {   
	$a = strtoupper($a);
	$b = strtoupper($b);
	return strcmp($a,$b); 
}


// create new classes
$setup = new Io;
$parse = new Parser;
$linker = new Linker;
$render = new Render(&$linker);
$linker->setRenderer(&$render);

/**
* Returns a formatted var_dump for debugging purposes.
* @param string $s string to display
* @param mixed $v variable to display with var_dump()
* @param mixed $v... unlimited number of additional variables to display with var_dump()
*/
function fancy_debug($s,$v)
{
	if (isset($GLOBALS['dont_debug']) && $GLOBALS['dont_debug']) return;
	debug($s."\n\n</pre><blockquote><pre>");
	var_dump($v);
	if (func_num_args()>2)
	{
		for($i=2;$i<func_num_args();$i++)
		{
			$a = func_get_arg($i);
//			debug(" ");
			var_dump($a);
		}
	}
	debug("</pre></blockquote><pre>\n\n");
}

error_reporting(E_ALL); // if you want to turn this on, lots of bad indexes in arrays and other related stuff would have to be checked
// subcribe $render class to $parse class events

if (!isset($interface))
{
	// Parse the argv settings
	$setting = $setup->parseArgv();
}
if (!isset($setting['junk'])) $setting['junk'] = '';
if (isset($setting['help']) || $setting['junk'] == "-h" || $setting['junk'] == "--help")
{
	echo $setup->displayHelpMsg();
	die();
}

if (!isset($setting['hidden'])) $setting['hidden'] = 'off';
if (!isset($ignore_dirs)) $ignore_dirs = false;

// set to parse elements marked private with @access private
if (isset($setting['parseprivate']) && $setting['parseprivate'] == 'on')
{
	$render->setParsePrivate(true);
}

// set the mode (quiet or verbose)
if ( isset($setting['quiet']) || strcasecmp($setting['junk'], "-q") == 0 || strcasecmp($setting['junk'], "--quiet") == 0) 
{
	$render->setQuietMode(true);
}

// Setup the different classes
if (isset($setting['target']))
{
	$render->setTargetDir($setting['target']);
}
else
{
	echo "a target directory must be specified\n try phpdoc -h\n";
	die();
}
	

if (!file_exists($setting['template']))
{
	die("Template Directory '$setting[template]' does not exists, please check template path you are passing phpdoc\n");
}
else
{
	// make sure it has a / on the end
	$setting['template'] = str_replace("\\","/",$setting['template']);
	if (substr($setting['template'],-1) != "/")
	{
		$setting['template'] .= "/";
	}
}
$render->setTemplateDir($setting['template']);

// setup ignore  list
$ignore_files =array();
if(isset($setting['ignore']))
{
	if (strstr($setting['ignore'],","))
	{
		$ignore_files = explode(",",$setting['ignore']);
	} else {
		$ignore_files = array($setting['ignore']);
	}
}

for($count = 0; $count < 2;$count++)
{
	switch($count)
	{
		case 0:
			$parse->subscribe("*",$linker);
			echo "\n\nCreate Inheritance Trees and @see lookup tables\n\n";
			flush();
		break;
		case 1:
			echo "\n\nGeneral Parsing Stage\n\n";
			flush();
			$parse->subscribe("*",$render);
		break;
	}
	// parse the directory
	if (!empty($setting['filename']))
	{
		$files = explode(",",$setting['filename']);
		foreach($files as $file)
		{
			echo "Parsing file $file";
			flush();

			if (!$setup->checkIgnore(basename($file),dirname($file),$ignore_files))
			{
				$parse->parse($setup->readPhpFile($file, $render->quietMode),$file);
			} else {
				echo " File Ignored\n";
			}
		}
	}

	if (!empty($setting['directory']))
	{
		$dirs = explode(",",$setting['directory']);
		foreach($dirs as $dir)
		{
			// strip trailing directory seperator
			if (substr($dir,-1) == "/" || substr($dir,-1) == "\\")
			{
				$dir = substr($dir,0,-1);
			}
			$dir = strtr($dir, "\\", "/");
			$base = count(explode("/",$dir));

			$files = $setup->dirList($dir,$setting['hidden']);
			if (is_array($files))
			{
				foreach($files as $file)
				{
					// Make sure the file isn't a hidden file
					$file = strtr($file, "\\", "/");
					$test = array_pop(explode("/",$file));
					if (substr($test,0,1) != ".") 
					{
						if ( $render->quietMode === false ) 
						{
							echo "Reading file $file";
							flush();
						}
						if (!$setup->checkIgnore(basename($file),str_replace('\\','/',dirname($file)),$ignore_files))
						{
							$parse->parse($setup->readPhpFile($file),str_replace('\\','/',$file),$base);
						} else {
							echo " File Ignored\n";
						}
					}
				}
			}
		}
	}
}

// render output
if ( $render->quietMode === false ) 
{
	echo "\nWriting Files\n";
}
$render->output();
$a = (time() - $parse_start_time);
echo "\nTotal Documentation Time: $a seconds\n";
?>
