<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
/**
* @package phpDocumentor
* @subpackage data
*/
/**
* smart htmlentities, doesn't entity the allowed tags list
* @param string $s
* @return string browser-displayable page
*/
function adv_htmlentities($s)
{
	global $___html,$PHPDOC_HTML_ALLOWED;
	$result = htmlentities($s);
	$entities = array_flip(get_html_translation_table(HTML_ENTITIES));
	$result = strtr($result,$___html);
	$matches = array();
	preg_match_all('/(&lt;img.*&gt;)/U',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	preg_match_all('/(&lt;ol.*&gt;)/U',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	preg_match_all('/(&lt;ul.*&gt;)/U',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	preg_match_all('/(&lt;li.*&gt;)/U',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	preg_match_all('/(&lt;a .*&gt;)/U',$result,$matches);
	for($i=0;$i<count($matches[1]);$i++)
	{
		$result = str_replace($matches[1][$i],strtr($matches[1][$i],array_flip(get_html_translation_table(HTML_ENTITIES))),$result);
	}
	return $result;
}

/**
* The base class for data
*
* @author	Joshua Eichorn <jeichorn@phpdoc.org>
* @version	$Id: DataTypes.inc,v 1.54 2002/05/23 19:28:53 CelloG Exp $
* @package 	phpDocumentor
* @subpackage	data
*/
class Data
{
	/** directory this element's documentation file will be output to */
	var $dir;

	var $store;

	var $htmlentities = true;

	function setDir(&$docblock)
	{
		$this->dir = !empty($docblock->dir) ? $docblock->dir : $GLOBALS['PHPDocumentor_DefaultPackageName'];
	}
	
	function getDir()
	{
		return $this->dir;
	}
	
	function setType ($type)
	{
		$this->store['type'] = $type;
	}

	function getType ()
	{
		return $this->store['type'];
	}

	function setName ($name)
	{
		$this->store['name'] = $name;
	}

	function getName ()
	{
		if (!isset($this->store['name'])) return false;
		if ($this->htmlentities)
		{
			return adv_htmlentities($this->store['name']);
		} else {
			return $this->store['name'];
		}
	}

	function setValue ($val)
	{
		$this->store['value'] = $val;
	}

	function getValue ()
	{
		if (!isset($this->store['value'])) return false;
		if ($this->htmlentities)
		{
			return adv_htmlentities($this->store['value']);
		} else {
			return $this->store['value'];
		}
	}

	function setDocblock ($obj)
	{
		$this->store['docblock'] = $obj->store;
	}

	function getDocblock ()
	{
		if (!isset($this->store['docblock'])) return false;
		return $this->store['docblock'];
	}

	function setParent ($val)
	{
		$this->store['parent'] = $val;
	}

	function getParent ()
	{
		if (!isset($this->store['parent'])) return false;
		return $this->store['parent'];
	}

	function setSourceLocation ($val)
	{
		$this->store['sourcelocation'] = $val;
	}

	function getSourceLocation ()
	{
		if (!isset($this->store['sourcelocation'])) return false;
		return $this->store['sourcelocation'];
	}

	function dump()
	{
		print_r($this->store);
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataFile extends Data
{
	function DataFile ()
	{
		$this->setType("file");
	}

	function setPath($path)
	{
		$this->store['path'] = $path;
	}

	function getPath()
	{
		if (!isset($this->store['path'])) return false;
		return $this->store['path'];
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataDefine extends Data
{
	function DataDefine ()
	{
		$this->setType("define");
	}

}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataDocBlock extends Data
{
	var $returntype = 'void';
	var $vartype = 'mixed';
	function DataDocBlock ()
	{
		$this->setType("docblock");
	}

	function getDirFromPackage()
	{
		$a = isset($this->store['data']['subpackage']) ? PATH_DELIMITER . $this->store['data']['subpackage'][0] : '';
		return isset($this->store['data']['package']) ? $this->store['data']['package'][0].$a : $GLOBALS['PHPDocumentor_DefaultPackageName'];
	}

	function setShortDesc ($sdesc)
	{
		$this->store['sdesc'] = $sdesc;
	}
	
	function nopackages()
	{
		if (isset($this->store['data']))
		unset($this->store['data']['package']);
		if (isset($this->store['data']))
		unset($this->store['data']['subpackage']);
	}

	function getShortDesc ()
	{
		if (!isset($this->store['sdesc'])) return '';
		return adv_htmlentities($this->store['sdesc']);
	}

	function setDesc ( $desc )
	{
		$this->store['desc'] = $desc;
	}

	function getDesc ()
	{
		if (!isset($this->store['desc'])) return '';
		return adv_htmlentities($this->store['desc']);
	}
	
	function setPackage($package)
	{
		if (!isset($this->store['data']['package']))
		{
			$this->store['data']['package'][] = $package;
		} else
		{
			// raise error
		}
	}
	
	function setSubPackage($subpackage)
	{
		if (!isset($this->store['data']['subpackage']))
		{
			$this->store['data']['subpackage'][] = $subpackage;
		} else
		{
			// raise error
		}
	}
	
	function setReturn($data)
	{
		if (!isset($this->store['data']['return']))
		{
			$this->returntype = $data[0];
			if (!empty($data[1]))
			{
				$this->store['data']['return'][] = $data[1];
			}
		} else
		{
			// raise error
		}
	}
	
	function getReturnType()
	{
		return $this->returntype;
	}

	function setVar($data)
	{
		if (!isset($this->store['data']['var']))
		{
			if (is_array($data))
			{
				$this->vartype = $data[0];
				if (!empty($data[1]))
				{
					$this->store['data']['var'][] = $data[1];
				}
			}
		} else
		{
			// raise error
		}
	}
	
	function getVarType()
	{
		return $this->vartype;
	}

	function addKeyword ($keyword, $data)
	{
		if (strtolower($keyword)=='return')
		{
			$this->setReturn($data);
			return;
		}
		if (strtolower($keyword)=='var')
		{
			$this->setVar($data);
			return;
		}
		if ($keyword=='package')
		{
			$this->dir = $data;
			$this->setPackage($data);
			return;
		}
		if ($keyword=='subpackage')
		{
			$this->dir .= PATH_DELIMITER . $data;
			$this->setSubPackage($data);
			return;
		}
		$this->store['data'][$keyword][] = $data;
	}

	function getKeyword ($keyword)
	{
		if (!isset($this->store['data'][$keyword])) return false;
		switch($keyword)
		{
			case "package":
			case "subpackage":
				if ($this->htmlentities)
				{
					return adv_htmlentities($this->store['data'][$keyword][0]);
				} else {
					return $this->store['data'][$keyword][0];
				}
			break;
			default:
				if (count($this->store['data'][$keyword]) == 1)
				{
					if ($this->htmlentities)
					{
						if ($keyword != 'see')
						{
							return adv_htmlentities($this->store['data'][$keyword][0]);
						}
						else
						{
							return $this->store['data'][$keyword][0];
						}
					} else {
						return $this->store['data'][$keyword][0];
					}
				} else {
					if ($this->htmlentities)
					{
						if ($keyword != 'see')
						{
							return array_map("adv_htmlentities",$this->store['data'][$keyword]);
						}
						else
						{
							return $this->store['data'][$keyword];
						}
					} else {
						return $this->store['data'][$keyword];
					}
				}
			break;
		}
	}

	function listKeywords ()
	{
		if (isset($this->store['data']))
		{
			$ret = array();
			if (isset($this->store['data']['return']))
			{
				foreach($this->store['data']['return'] as $val)
				{
					$ret[] = array("keyword" => 'Return',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['var']))
			{
				foreach($this->store['data']['var'] as $val)
				{
					$ret[] = array("keyword" => 'Var',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['package']))
			{
				foreach($this->store['data']['package'] as $val)
				{
					$ret[] = array("keyword" => 'Package',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['subpackage']))
			{
				foreach($this->store['data']['subpackage'] as $val)
				{
					$ret[] = array("keyword" => 'Sub-Package',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['author']))
			{
				foreach($this->store['data']['author'] as $val)
				{
					$ret[] = array("keyword" => 'Author',"data" => $val);
				}
			}
			if (isset($this->store['data']['version']))
			{
				foreach($this->store['data']['version'] as $val)
				{
					$ret[] = array("keyword" => 'Version',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['see']))
			{
				foreach($this->store['data']['see'] as $val)
				{
					$ret[] = array("keyword" => 'See',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['link']))
			{
				foreach($this->store['data']['link'] as $val)
				{
					$ret[] = array(
							"keyword" => 'Link',
							"data" => "<A target='_blank' href='$val'>" . htmlentities($val) . "</a>"
						);
				}
			}
			if (isset($this->store['data']['deprecated']))
			{
				foreach($this->store['data']['deprecated'] as $val)
				{
					$ret[] = array("keyword" => 'Deprecated',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['deprec']))
			{
				foreach($this->store['data']['deprec'] as $val)
				{
					$ret[] = array("keyword" => 'Deprecated',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['todo']))
			{
				foreach($this->store['data']['todo'] as $val)
				{
					$ret[] = array("keyword" => 'TODO',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['TODO']))
			{
				foreach($this->store['data']['TODO'] as $val)
				{
					$ret[] = array("keyword" => 'TODO',"data" => adv_htmlentities($val));
				}
			}
			if (isset($this->store['data']['abstract']))
			{
				$ret[] = array("keyword" => 'Abstract Element',"data" => '');
			}
			foreach($this->store['data'] as $key => $val)
			{
				if ($this->htmlentities)
				{
					// this be a hack but the whole htmlentities is an html specific hack, xml output may take some changes
					switch ($key)
					{
						case "package":
						case "subpackage":
						case "author":
						case "link":
						case "see":
						case "var":
						case "version":
						case "return":
						case "deprecated":
						case "deprec":
						case "todo":
						case "TODO":
						case "abstract":
						break;
						default:
							foreach($val as $val2)
							{
								$ret[] = array("keyword" => ucfirst($key),"data" => adv_htmlentities($val2));
							}
						break;
					}
				} else {
					switch ($key)
					{
						case "package":
						case "subpackage":
						case "author":
						case "link":
						case "see":
						case "var":
						case "version":
						case "return":
						case "deprecated":
						case "deprec":
						case "todo":
						case "TODO":
						case "abstract":
						break;
						default:
							foreach($val as $val2)
							{
								$ret[] = array("keyword" => ucfirst($key),"data" => $val2);
							}
						break;
					}
				}
			}
			return $ret;
		} else {
			return array();
		}
	}

	function addParam($keyword,$data)
	{
		if (empty($keyword))
		$this->store['params'][] = $data;
		else
		$this->store['params'][$keyword] = $data;
	}
	
	function changeParam($index,$name)
	{
		$this->store['params'][$name] = $this->store['params'][$index];
		unset($this->store['params'][$index]);
	}
	
	function updateParams($params)
	{
		for($i=0;$i<count($params);$i++)
		{
			if (isset($this->store['params'][$i]))
			{
				$this->changeParam($i,$params[$i]);
			}
		}
		if (isset($this->store['data']))
		unset($this->store['data']['param']);
	}

	function getParam($keyword)
	{
		if (!isset($this->store['params'][$keyword])) return false;
		if ($this->htmlentities)
		{
			return adv_htmlentities($this->store['params'][$keyword]);
		} else {
			return $this->store['params'][$keyword];
		}
	}

	function listParams ()
	{
		if (isset($this->store['params']))
		{
			$ret = array();
			foreach($this->store['params'] as $key => $val)
			{
				if ($this->htmlentities)
				{
					$ret[] = array("var" => ucfirst($key),"data" => adv_htmlentities($val));
				} else {
					$ret[] = array("var" => ucfirst($key),"data" => $val);
				}
			}
			return $ret;
		} else {
			return array();
		}
	}
}
		
/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataVar extends Data
{
	function DataVar ()
	{
		$this->setType("var");
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataFunction extends Data
{
	var $returnsreference = false;
	
	function getReturnsReference()
	{
		return $this->returnsreference;
	}
	
	function DataFunction ()
	{
		$this->setType("function");
	}
	
	function setDescendedMethods($meth)
	{
		$this->store['descmethods'] = $meth;
	}
	
	function getDescendedMethods()
	{
		if (!isset($this->store['descmethods'])) return '';
		return $this->store['descmethods'];
	}

	function addParam ($name, $val)
	{
		$this->store['params'][$name] = $val;
	}

	function getParam ($name)
	{
		if (!isset($this->store['params'][$name])) return false;
		if ($this->htmlentities)
		{
			return adv_htmlentities($this->store['params'][$name]);
		} else {
			return $this->store['params'][$name];
		}
	}

	function listParams ()
	{
		if (isset($this->store['params']))
		{
			foreach($this->store['params'] as $key => $val)
			{
				if ($this->htmlentities)
				{
					$ret[] = array($key,adv_htmlentities($val));
				} else {
					$ret[] = array($key,$val);
				}
			}
			return $ret;
		} else {
			return array();
		}
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataInclude extends Data
{
	function DataInclude()
	{
		$this->setType('include');
	}
	
	function setFile($file)
	{
		$this->store['file'] = $file;
	}
	
	function getFile()
	{
		if (!isset($this->store['file'])) return false;
		return $this->store['file'];
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataClass extends Data
{
	var $dir;
	var $classtree;
	var $inheritedvars;
	var $inheritedmethods;
	var $cp;
	var $childlist;
	
	function DataClass ()
	{
		$this->setType("class");
	}

	function setExtends($e)
	{
		$this->store["extends"] = $e;
	}

	
	function getExtends()
	{
		if (!isset($this->store['extends'])) return false;
		return $this->store["extends"];
	}
	
	function setClassTree($classtree)
	{
		$this->classtree = $classtree;
	}
	
	function getClassTree()
	{
		if (!isset($this->classtree)) return false;
		return $this->classtree;
	}
	
	function setInheritedVars($v)
	{
		$this->inheritedvars = $v;
	}
	
	function setInheritedMethods($m)
	{
		$this->inheritedmethods = $m;
	}
	
	function getInheritedVars()
	{
		if (!isset($this->inheritedvars)) return false;
		return $this->inheritedvars;
	}

	function getInheritedMethods()
	{
		if (!isset($this->inheritedmethods)) return false;
		return $this->inheritedmethods;
	}
	
	function getClassPackage()
	{
		if (!isset($this->classpackage)) return false;
		return $this->classpackage;
	}
	
	function setClassPackage($cp)
	{
		$this->classpackage = $cp;
	}
	
	function setChildClassList($sl)
	{
		$this->childlist = $sl;
	}
	
	function getChildClassList()
	{
		return $this->childlist;
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataPage extends Data
{
	function DataPage ()
	{
		$this->setType("page");
	}
	
	function setClasses($classes)
	{
		$this->store['classes'] = $classes;
	}
	
	function getClasses()
	{
		if (!isset($this->store['classes'])) return '';
		return $this->store['classes'];
	}
	
	function setPackageOutput($packages)
	{
		$this->store['packageoutput'] = $packages;
	}
	
	function getPackageOutput()
	{
		if (!isset($this->store['packageoutput'])) return false;
		return $this->store['packageoutput'];
	}

	function setFile($file)
	{
		$this->store["file"] = $file;
	}

	function getFile()
	{
		if (!isset($this->store['file'])) return false;
		return $this->store["file"];
	}

	function setPath($path)
	{
		$this->store["path"] = $path;
	}

	function getPath()
	{
		if (!isset($this->store['path'])) return false;
		return $this->store["path"];
	}
}

/**
* @package 	phpDocumentor
* @subpackage	data
*/
class DataPackagePage extends Data
{
	var $package;
	function DataPackagePage($total,$package)
	{
		$this->setTotal($total);
		$this->package = $package;
		$this->setType('packagepage');
	}
	
	function setTotal($total)
	{
		$this->store['total'] = $total;
	}
	
	function getTotal()
	{
		if (!isset($this->store['total'])) return '';
		return $this->store['total'];
	}
	
	function ret()
	{
		return $this->getTotal();
	}
}
?>
