<?php
/**
* @package phpDocumentor
* @subpackage Errors
* @author Gregory Beaver <cellog@users.sourceforge.net>
* @version $Id: Errors.inc,v 1.17 2002/05/24 06:20:28 CelloG Exp $
*/
/**
* warning triggered when inheritance could be from more than one class
*/
define("PDERROR_MULTIPLE_PARENT",1);
/**
* warning triggered when parent class doesn't exist
*/
define("PDERROR_PARENT_NOT_FOUND",2);
/**
* warning triggered when an {@inline tag} is not terminated (no } before the &#42;/ ending the comment)
*/
define("PDERROR_UNTERMINATED_INLINE_TAG",3);
/**
* warning triggered when inheritance could be from more than one class
*/
define("PDERROR_CLASS_EXISTS",4);
/**
* warning triggered when inheritance could be from more than one class
*/
define("PDERROR_INHERITANCE_CONFLICT",5);
/**
* warning triggered when a converter is passed to {@link IntermediateParser::addConverter()} that is not a class
*/
define("PDERROR_CONVERTER_NOT_FOUND",6);
/**
* warning triggered when a converter is passed to {@link IntermediateParser::addConverter()} that is not a class
*/
define("PDERROR_NO_CONVERTERS",7);
/**
* warning triggered when the arguments to @access are neither public nor private
*/
define("PDERROR_ACCESS_WRONG_PARAM",8);
/**
* warning triggered when there are multiple @access tags in a docblock
*/
define("PDERROR_MULTIPLE_ACCESS_TAGS",9);
/**
* warning triggered when there are multiple @return tags in a docblock
*/
define("PDERROR_MULTIPLE_RETURN_TAGS",10);
/**
* warning triggered when there are multiple @var tags in a docblock
*/
define("PDERROR_MULTIPLE_VAR_TAGS",11);
/**
* warning triggered when there are multiple @package tags in a docblock
*/
define("PDERROR_MULTIPLE_PACKAGE_TAGS",12);
/**
* warning triggered when there are multiple @subpackage tags in a docblock
*/
define("PDERROR_MULTIPLE_SUBPACKAGE_TAGS",13);
/**
* warning triggered when the package or subpackage name is illegal
*/
define("PDERROR_ILLEGAL_PACKAGENAME",14);
/**
* warning triggered when there a @package tag is used in a function, define, method, var or include
*/
define("PDERROR_OVERRIDDEN_PACKAGE_TAGS",15);
/**
* warning triggered when there a @subpackage tag is used in a function, define, method, var or include
*/
define("PDERROR_OVERRIDDEN_SUBPACKAGE_TAGS",16);
/**
* warning triggered when classes in the same package have the same name
*/
define("PDERROR_CLASS_CONFLICT",17);
/**
* warning triggered when classes in the same package have the same name
*/
define("PDERROR_UNKNOWN_TAG",18);



$GLOBALS['PHPDocumentor_warning_descrip'] = array();
$GLOBALS['PHPDocumentor_error_descrip'] = array();

$GLOBALS['PHPDocumentor_warning_descrip'][PDERROR_MULTIPLE_PARENT] = 'Class %s has multiple possible parents, package inheritance aborted';
$GLOBALS['PHPDocumentor_warning_descrip'][PDERROR_PARENT_NOT_FOUND] = 'Class %s parent %s not found';
$GLOBALS['PHPDocumentor_warning_descrip'][PDERROR_INHERITANCE_CONFLICT] = 'Class %s in file %s has multiple possible parents named %s.  Cannot resolve name conflict, try ignoring a file that contains the conflicting parent class';
$GLOBALS['PHPDocumentor_warning_descrip'][PDERROR_UNKNOWN_TAG] = 'Unknown tag "@%s" used';

$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_UNTERMINATED_INLINE_TAG] = 'Inline tag {@%s} in tag %s is unterminated, "%s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_CLASS_EXISTS] = 'Class %s already exists in package "%s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_CONVERTER_NOT_FOUND] = 'Converter %s specified by --converters command-line option is not a class';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_NO_CONVERTERS] = 'No Converters have been specified by --converters command-line option';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_ACCESS_WRONG_PARAM] = '@access was passed neither "public" nor "private."  Was passed: "%s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_MULTIPLE_ACCESS_TAGS] = 'DocBlock has multiple @access tags, illegal. ignoring additional tag "@access %s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_MULTIPLE_RETURN_TAGS] = 'DocBlock has multiple @return tags, illegal. ignoring additional tag "@return %s %s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_MULTIPLE_VAR_TAGS] = 'DocBlock has multiple @var tags, illegal. ignoring additional tag "@var %s %s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_MULTIPLE_PACKAGE_TAGS] = 'DocBlock has multiple @package tags, illegal. ignoring additional tag "@package %s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_MULTIPLE_SUBPACKAGE_TAGS] = 'DocBlock has multiple @subpackage tags, illegal. ignoring additional tag "@subpackage %s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_ILLEGAL_PACKAGENAME] = '@%s tag has illegal %s name "%s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_OVERRIDDEN_PACKAGE_TAGS] = '%s %s\'s DocBlock has @package tag, illegal. ignoring tag "@package %s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_OVERRIDDEN_SUBPACKAGE_TAGS] = '"%s" %s\'s DocBlock has @subpackage tags, illegal. ignoring tag "@subpackage %s"';
$GLOBALS['PHPDocumentor_error_descrip'][PDERROR_CLASS_CONFLICT] = 'class "%s" has multiple declarations in package %s, in file %s and file %s, documentation will have output errors!';

/**
* encapsulates warning information
* @package phpDocumentor
* @subpackage Errors
*/
class RecordWarning
{
	/**
	* name of global variable that descriptors for this warning/error is kept
	* @var string
	*/
	var $type = 'PHPDocumentor_warning_descrip';
	/**
	* file this error occurred in
	* @var string
	*/
	var $file = false;
	/**
	* line number of the file this error occurred in
	* @var integer
	*/
	var $linenum;
	/**
	* error string
	* @var string
	*/
	var $data;
	/**
	* error number
	* @see Errors.inc
	* @var string
	*/
	var $num;
	/**
	* @param string $file filename this error occurred in ({@link $file})
	* @param integer $linenum line number this error occurred on ({@link $linenum})
	* @param integer $num Error number defined in {@link Errors.inc}
	* @param string $data... variable number of strings, up to 4, to sprintf based on the error number
	*/
	function RecordWarning($file,$linenum,$num)
	{
		$this->file = $file;
		$this->linenum = $linenum;
		$a = array('','','','');
		if (func_num_args()>3)
		{
			for($i=3;$i<func_num_args();$i++)
			{
				$a[$i - 3] = func_get_arg($i);
			}
		}

		$this->num = $num;
		$this->data = sprintf($GLOBALS[$this->type][$this->num],$a[0],$a[1],$a[2],$a[3]);
		$this->output();
	}
	
	/**
	* prints the warning
	*/
	function output($string = false)
	{
		if ($string)
		{
			if ($this->file)
			return "WARNING in $this->file on line $this->linenum: $this->data\n";
			else
			return "WARNING: $this->data\n";
		}
		if ($this->file)
		phpdoc_out("WARNING in $this->file on line $this->linenum: $this->data\n");
		else
		phpdoc_out("WARNING: $this->data\n");
	}
}

/**
* encapsulates error information
* @package phpDocumentor
* @subpackage Errors
*/
class RecordError extends RecordWarning
{
	/**
	* name of global variable that descriptors for this warning/error is kept
	* @var string
	*/
	var $type = 'PHPDocumentor_error_descrip';

	/**
	* prints the error
	*/
	function output($string = false)
	{
		if ($string)
		{
			if ($this->file)
			return "\n\tERROR in $this->file on line $this->linenum: $this->data\n";
			else
			return "\n\tERROR: $this->data\n";
		}
		if ($this->file)
		phpdoc_out("\n\tERROR in $this->file on line $this->linenum: $this->data\n");
		else
		phpdoc_out("\n\tERROR: $this->data\n");
	}
}

/**
* contains all the errors/warnings
* @see $errors, $warnings
* @package phpDocumentor
* @subpackage Errors
*/
class ErrorTracker
{
	/**
	* array of {@link RecordError}s
	* @var array
	*/
	var $errors = array();
	/**
	* array of {@link RecordWarning}s
	* @var array
	*/
	var $warnings = array();
	/**
	* @var string
	*/
	var $curfile = '';
	/**
	* @var integer
	*/
	var $linenum = 0;
	
	var $lasterror = false;
	
	var $lastwarning = false;
	
	/**
	* This function subscribes to two events in the Parser in order to keep track of line number information and file name.
	* @param integer $num parser-passed event (see {@link PHPDOC_EVENT_NEWLINENUM, PHPDOC_EVENT_NEWFILE})
	* @param mixed $data either a line number if $num is PHPDOC_EVENT_NEWLINENUM or a file name if $num is PHPDOC_EVENT_NEWFILE
	*/
	function handleEvent($num,$data)
	{
		switch($num)
		{
			case PHPDOC_EVENT_NEWLINENUM :
				$this->linenum = $data;
			break;
			case PHPDOC_EVENT_NEWFILE :
				$this->linenum = 0;
				$this->curfile = $data;
			break;
			// debugging
			case 1000000635 :
				phpdoc_out($this->curfile.' has '.$this->linenum.' lines'."\n");
			break;
		}
	}

	/**
	* add a new warning to the {@link $warnings} array
	* @param integer $num error number from {@link Errors.inc}
	* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
	*/
	function addWarning($num)
	{
		$a = array('','','','');
		if (func_num_args()>1)
		{
			for($i=1;$i<func_num_args();$i++)
			{
				$a[$i - 1] = func_get_arg($i);
			}
		}
		$this->warnings[] = new RecordWarning($this->curfile,$this->linenum,$num,$a[0],$a[1],$a[2],$a[3]);
		$this->lastwarning = count($this->warnings) - 1;
	}

	/**
	* add a new error to the {@link $errors} array
	* @param integer $num error number from {@link Errors.inc}
	* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
	*/
	function addError($num)
	{
		$a = array('','','','');
		if (func_num_args()>1)
		{
			for($i=1;$i<func_num_args();$i++)
			{
				$a[$i - 1] = func_get_arg($i);
			}
		}
		$this->errors[] = new RecordError($this->curfile,$this->linenum,$num,$a[0],$a[1],$a[2],$a[3]);
		$this->lasterror = count($this->errors) - 1;
	}
	
	/**
	* add a new error to the {@link $errors} array and returns the error string
	* @param integer $num error number from {@link Errors.inc}
	* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
	*/
	function addErrorReturn($num)
	{
		$a = array('','','','');
		if (func_num_args()>1)
		{
			for($i=1;$i<func_num_args();$i++)
			{
				$a[$i - 1] = func_get_arg($i);
			}
		}
		$this->errors[] = new RecordError($this->curfile,$this->linenum,$num,$a[0],$a[1],$a[2],$a[3],false);
		$this->lasterror = count($this->errors) - 1;
	}
	
	function returnLastError()
	{
		return $this->errors[$this->lasterror]->output(true);
	}

	function returnLastWarning()
	{
		return $this->warnings[$this->lastwarning]->output(true);
	}
}

$GLOBALS['PHPDocumentor_errors'] = new ErrorTracker;

/**
* @param integer $num error number from {@link Errors.inc}
* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
* @see ErrorTracker::addError()
*/
function addError($num)
{
	global $PHPDocumentor_errors;
	$a = array('','','','');
	if (func_num_args()>1)
	{
		for($i=1;$i<func_num_args();$i++)
		{
			$a[$i - 1] = func_get_arg($i);
		}
	}
	$PHPDocumentor_errors->addError($num,$a[0],$a[1],$a[2],$a[3]);
}

/**
* like {@link addError()} but exits parsing
* @param integer $num error number from {@link Errors.inc}
* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
* @see ErrorTracker::addError()
*/
function addErrorDie($num)
{
	global $PHPDocumentor_errors;
	$a = array('','','','');
	if (func_num_args()>1)
	{
		for($i=1;$i<func_num_args();$i++)
		{
			$a[$i - 1] = func_get_arg($i);
		}
	}
	$PHPDocumentor_errors->addErrorReturn($num,$a[0],$a[1],$a[2],$a[3]);
	die($PHPDocumentor_errors->returnLastError());
}

/**
* @param integer $num warning number from {@link Errors.inc}
* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
* @see ErrorTracker::addWarning()
*/
function addWarning($num)
{
	global $PHPDocumentor_errors;
	$a = array('','','','');
	if (func_num_args()>1)
	{
		for($i=1;$i<func_num_args();$i++)
		{
			$a[$i - 1] = func_get_arg($i);
		}
	}

	$PHPDocumentor_errors->addWarning($num,$a[0],$a[1],$a[2],$a[3]);
}
?>