<?php
/**
* HTML output converter.
* This Converter takes output from the {@link Parser} and converts it to HTML-ready output for use with {@link Template}.
*
* @package phpDocumentor
* @subpackage Converters
* @abstract
* @see parserDocBlock, parserInclude, parserPage, parserClass, parserDefine, parserFunction, parserMethod, parserVar
* @author Greg Beaver <cellog@users.sourceforge.net>
* @since 1.0rc1
* @version $Id: HTMLConverter.inc,v 1.11 2002/05/23 19:28:01 CelloG Exp $
*/
/**
* HTML output converter.
* This Converter takes output from the {@link Parser} and converts it to HTML-ready output for use with {@link Template}.
*
* @package phpDocumentor
* @subpackage Converters
* @abstract
* @see parserDocBlock, parserInclude, parserPage, parserClass, parserDefine, parserFunction, parserMethod, parserVar
* @author Greg Beaver <cellog@users.sourceforge.net>
* @since 1.0rc1
* @version $Id: HTMLConverter.inc,v 1.11 2002/05/23 19:28:01 CelloG Exp $
*/
class HTMLConverter extends Converter
{
	var $render;
	
	function HTMLConverter(&$methods, &$vars, &$links, &$linksw, &$c, $po, &$cp, &$els, &$pkg_els, $pp, $qm, &$classes, $templateDir, $targetDir)
	{
		Converter::Converter($methods,$vars,$links,$linksw,$c,$po,$cp,$els, $pkg_els, $pp, $qm, $classes, $templateDir, $targetDir);
		$this->render = new Render;
		$this->render->setTemplatedir($templateDir);
		$this->render->setTargetdir($targetDir);
		$this->render->setParsePrivate($pp);
		$this->render->setQuietMode($qm);
		foreach($this->links as $package => $notused)
		{
			$this->render->setClassTree($package, $this->generateFormattedClassTrees($package));
		}
		$this->render->setPkgIndexes($this->generatePkgElementIndexes());
		$this->render->setIndex($this->generateElementIndex());
	}
	
	function endClass()
	{
		$this->render->handleEvent(PHPDOC_EVENT_NEWSTATE,STATE_END_CLASS);
	}
	
	function endPage()
	{
		$this->render->handleEvent(PHPDOC_EVENT_NEWSTATE,PHPDOC_EVENT_END_PAGE);
	}
	
	function returnLink($link,$text)
	{
		return '<a href="'.$link.'">'.$text.'</a>';
	}
	
	/**
	*
	* @param abstractLink &$element a descendant of abstractlink should be passed, and never text
	*/
	function returnSee(&$element, $eltext = false, $local = true, $with_a = true)
	{
		if (!$element) return false;
		if (!$eltext)
		{
			$eltext = '';
			switch($element->type)
			{
				case 'method' :
				case 'var' :
				$eltext .= $element->class.'::';
				case 'page' :
				case 'define' :
				case 'class' :
				case 'function' :
				default :
				$eltext .= $element->name;
				if ($element->type == 'function' || $element->type == 'method') $eltext .= '()';
				break;
			}
		}
		$a = 1;
		$b = '';
		$c = '';
		if (!empty($this->subpackage))
		{
			$a++;
		}
		if (!empty($element->subpackage))
		{
			$c = '/'.$element->subpackage;
		}
		if ($local)
		{
			for($i=0;$i<$a;$i++) $b .= '../';
		}
		switch ($element->type)
		{
			case 'page' :
			return '<a href="'.$b.$element->package.$c.'/_'.$element->fileAlias.'.html">'.$eltext.'</a>';
			break;
			case 'define' :
			return '<a href="'.$b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.$element->name.'">'.$eltext.'</a>';
			break;
			case 'class' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/'.$element->name.'.html">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/'.$element->name.'.html';
			break;
			case 'function' :
			return '<a href="'.$b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.$element->name.'">'.$eltext.'</a>';
			break;
			case 'method' :
			return '<a href="'.$b.$element->package.$c.'/'.$element->class.'.html#'.$element->name.'">'.$eltext.'</a>';
			break;
			case 'var' :
			return '<a href="'.$b.$element->package.$c.'/'.$element->class.'.html#'.$element->name.'">'.$eltext.'</a>';
			break;
		}
	}
	
	/**
	* pass abstract $element to {@link render}
	*/
	function Convert(&$element)
	{
		if ($element->type != 'page')
		{
			$this->render->handleEvent(1,$this->convertDocBlock($element->docblock));
		}
		switch($element->type)
		{
			case 'method' :
				$this->render->handleEvent(1,$this->convertMethod($element));
			break;
			case 'function' :
				$this->render->handleEvent(1,$this->convertFunction($element));
			break;
			case 'var' :
				$this->render->handleEvent(1,$this->convertVar($element));
			break;
			case 'class' :
				$this->render->handleEvent(1,$this->convertClass($element));
			break;
			case 'define' :
				$this->render->handleEvent(1,$this->convertDefine($element));
			break;
			case 'include' :
				$this->render->handleEvent(1,$this->convertInclude($element));
			break;
			case 'page' :
				$this->render->handleEvent(1,$this->convertPage($element));
				if ($element->docblock)
				$this->render->handleEvent(1,$this->convertDocBlock($element->docblock));
			break;
			case 'packagepage' :
				$this->render->handleEvent(1,$this->convertPackagePage($element));
			break;
		}
	}
	
	function convertPackagePage(&$element)
	{
		$page = new DataPackagePage($element->Convert($this),$element->package);
		return $page;
	}
	
	function convertVar(&$element)
	{
		$var = new DataVar;
		$var->setName($element->getName());
		$var->setValue($element->getValue());
		return $var;
	}
	
	function convertClass(&$element)
	{
		$class = new DataClass;
		$class->setName($element->getName());
		$class->setSourceLocation($element->getSourceLocation());
		$class->setClassTree($this->generateFormattedClassTree($element));
		$class->setChildClassList($this->generateChildClassList($element));
		$class->setInheritedVars($this->getFormattedInheritedVars($element));
		$class->setInheritedMethods($this->getFormattedInheritedMethods($element));
		$class->setClassPackage($this->getClassPackage($element->getName()));
		return $class;
	}
	
	function convertMethod(&$element)
	{
		$function = $this->convertFunction($element);
		$function->setDescendedMethods($this->getFormattedDescMethods($element));
		return $function;
	}
	
	function convertFunction(&$element)
	{
		$function = new DataFunction;
		$function->returnsreference = $element->getReturnsReference();
		$function->setName($element->getName());
		if ($element->params)
		foreach($element->params as $param => $val)
		{
			$function->addParam($param,$val);
		}
		return $function;
	}
	
	function convertInclude(&$element)
	{
		$include = new DataInclude;
		$include->setName($element->getName());
		preg_match('/"\.\/(.*\..*)"/',$element->getValue(),$match);
		if (!isset($match[1]))
		preg_match('/"(.*\..*)"/',$element->getValue(),$match);
		if (isset($match[1]))
		{
			if ($per = $this->getPageLink($match[1],$element->docblock->package))
			$include->setValue($per);
			else
			$include->setValue($element->getValue());
		} else
		$include->setValue($element->getValue());
		$include->setFile($element->getValue());
		return $include;
	}
	
	function convertDefine(&$element)
	{
		$define = new DataDefine;
		$define->setName($element->getName());
		$define->setValue($element->getValue());
		return $define;
	}
	
	function convertPage(&$element)
	{
		$page = new DataPage;
		$page->setName($element->parent->getName());
		$page->setFile($element->parent->getFile());
		$page->setPath($element->parent->getPath());
		$page->setClasses($this->getClassesOnPage($element));
		$page->setSourceLocation($element->parent->getSourceLocation());
		$page->setPackageOutput($this->package_output);
		return $page;
	}
	
	function convertDocBlock(&$docblock)
	{
		$doc = new DataDocBlock;
		if ($docblock->return)
		{
			$doc->setReturn(array($docblock->return->returnType,$docblock->return->Convert($this)));
		}
		if ($docblock->var)
		{
			$doc->setVar(array($docblock->var->returnType,$docblock->var->Convert($this)));
		}
		if ($docblock->sdesc)
		$doc->setShortDesc($docblock->sdesc->Convert($this));
		if ($docblock->desc)
		$doc->setDesc($docblock->desc->Convert($this));
		$doc->addKeyword('package',$docblock->package);
		if ($docblock->subpackage != '') $doc->addKeyword('subpackage',$docblock->subpackage);
		if (isset($docblock->tags))
		foreach($docblock->tags as $keyword => $tag)
		{
			for($i=0; $i<count($tag); $i++)
			$doc->addKeyword($keyword, $tag[$i]->Convert($this));
		}
		if (isset($docblock->params))
		foreach($docblock->params as $param => $obj)
		{
			$doc->addParam($param, $obj->Convert($this));
		}
		return $doc;
	}
	
	/**
	* gets a list of all classes declared on a procedural page represented by $element, a {@link parserData} class
	* @param parserData &$element
	* @return string comma-delimited list of links to each classes documentation
	*/
	function getClassesOnPage(&$element)
	{
		$a = $element->getClasses($this);
		$r = '';
		foreach($a as $package => $classes)
		{
			for($i=0; $i<count($classes); $i++)
			{
				if (!empty($r)) $r .= ', ';
				$r .= $this->getClassLink($classes[$i]->getName(),$package);
			}
		}
		return $r;
	}
	
	function getFormattedDescMethods(&$element)
	{
		$meths = $element->getOverridingMethods($this);
		$r = '';
		for($i=0; $i<count($meths); $i++)
		{
			if (!empty($r)) $r .= ', ';
			$r .= $this->getMethodLink($meths[$i]->getName(),$meths[$i]->class,$meths[$i]->docblock->package);
		}
		if (!empty($r)) $r = "Overridden in child class(es) as: $r<br>";
		return $r;
	}
	
	/**
	* returns a string containing a comma-delimited list of child classes
	*
	* @param parserClass class variable
	* @see parserClass::getChildClassList()
	*/
	
	function generateChildClassList($class)
	{
		$kids = $class->getChildClassList($this);
		$list = '';
		if (count($kids))
		{
			for($i=0; $i<count($kids); $i++)
			{
				if (!empty($list)) $list .= ', ';
				$list .= $this->getClassLink($kids[$i]->getName(),$kids[$i]->docblock->package, false, true);
			}
		}
		return $list;
	}

	/**
	* returns a string containing the class inheritance tree from the root object to the class
	*
	* @param parserClass	class variable
	* @see parserClass::getParentClassTree()
	*/
	
	function generateFormattedClassTree($class)
	{
		$tree = $class->getParentClassTree($this);
		$out = '';
		if (count($tree) - 1)
		{
			$result = array($class->getName());
			$parent = $tree[$class->getName()];
			while ($parent)
			{
				$subpackage = $parent->docblock->subpackage;
				$package = $parent->docblock->package;
				$x = $parent;
				if (is_object($parent))
				$x = $this->returnSee($this->links[$package][$subpackage]['class'][$parent->getName()]);
				if (!$x) $x = $parent->getName();
				$result[] = 
					$x."\n" .
					"%s|\n" .
					"%s--";
				if (is_object($parent))
				$parent = $tree[$parent->getName()];
				else
				$parent = $tree[$parent];
			}
			$nbsp = '   ';
			for($i=count($result) - 1;$i>=0;$i--)
			{
				$my_nbsp = '';
				for($j=0;$j<count($result) - $i;$j++) $my_nbsp .= $nbsp;
				$out .= sprintf($result[$i],$my_nbsp,$my_nbsp);
			}
			return "<pre>$out</pre>";
		} else
		{
			return $class->getName();
		}
	}
	
	function sortVar($a, $b)
	{
		return strnatcasecmp($a->getName(),$b->getName());
	}
	
	function sortMethod($a, $b)
	{
		if ($a->isConstructor) return -1;
		if ($b->isConstructor) return 1;
		return strnatcasecmp($a->getName(),$b->getName());
	}
	
	/**
	* Return template-enabled list of inherited variables
	*
	* uses parserVar helper function getInheritedVars and generates a template-enabled list using getClassLink()
	* @param parserVar $child class method
	* @see getClassLink(), parserVar::getInheritedVars()
	* @return array {@link Template}-ready array
	*/
	
	function getFormattedInheritedVars($child)
	{
		$package = $child->docblock->package;
		$subpackage = $child->docblock->subpackage;
		$ivars = $child->getInheritedVars($this);
		$results = array();
		if (!count($ivars)) return $results;
		foreach($ivars as $parent => $vars)
		{
			$file = $vars['file'];
			$vars = $vars['vars'];
			$par = $this->classes->getClass($parent,$file);
			$package = $par->docblock->package;
			usort($vars,array($this,"sortVar"));
			$a = '..'.PATH_DELIMITER;
			if ($subpackage != '')
			$a .= '..'.PATH_DELIMITER;
			$result['parent_class'] = $this->getClassLink($parent,$package);
			foreach($vars as $var)
			{
				$info = array();
				if ($b = $this->getClassLink($parent,$package, false, false, false))
				{
					$info['ipath'] = $a . $b;
				}
				$info['ivar_name'] = $var->getName();
				$info['ivar_default'] = $var->getValue();
				if ($var->docblock)
				$info['ivar_sdesc'] = $var->docblock->getSDesc($this);
				else
				$info['ivar_sdesc'] = '';
				$info['ipage'] = $this->class . $this->render->outputExt;
				$result['inner_loop']["ivars"][] = $info;
			}
			$results[] = $result;
			$result = array();
		}
		return $results;
	}
	
	/**
	* Return template-enabled list of inherited methods
	*
	* uses parserMethod helper function getInheritedMethods and generates a template-enabled list using getClassLink()
	* @param parserMethod $child class method
	* @see getClassLink(), parserMethod::getInheritedMethods()
	* @return array {@link Template}-ready array
	*/

	function getFormattedInheritedMethods($child)
	{
		$package = $child->docblock->package;
		$subpackage = $child->docblock->subpackage;
		$imethods = $child->getInheritedMethods($this);
		$results = array();
		if (!count($imethods)) return $results;
		foreach($imethods as $parent => $methods)
		{
			$file = $methods['file'];
			$methods = $methods['methods'];
			$par = $this->classes->getClass($parent,$file);
			$package = $par->docblock->package;
			usort($methods,array($this,"sortMethod"));
			$a = '..'.PATH_DELIMITER;
			if ($subpackage != '')
			$a .= '..'.PATH_DELIMITER;
			$result['parent_class'] = $this->getClassLink($parent,$package);
			foreach($methods as $method)
			{
				$info = array();
				if ($b = $this->getClassLink($parent,$package, false, false, false))
				{
					$info['ipath'] = $a . $b;
				}
				$qq = '';
				if ($method->isConstructor) $qq = 'constructor ';
				$info['ifunction_name'] = $qq.$method->getName();
				if ($method->docblock)
				$info['ifunction_sdesc'] = $method->docblock->getSDesc($this);
				else
				$info['ifunction_sdesc'] = '';
				$function_call = $qq.$method->getName() . " ( ";
				$tmp = 0;
				foreach($method->listParams() as $param)
				{
					if ($tmp == 0)
					{
						$tmp = 1;
					} else {
						$function_call .= ", ";
					}
					if (!empty($param[1]))
					{
						$function_call .= "[$param[0] = $param[1]]";
					} else {
						$function_call .= $param[0];
					}
				}
				$function_call .= " )";
				$info['ifunction_call'] = $function_call;
				$info['ipage'] = $this->class . $this->render->outputExt;
				$result['inner_loop']["ifunctions"][] = $info;
			}
			$results[] = $result;
			$result = array();
		}
		return $results;
	}

	/**
	* returns a template-enabled array of class trees
	* 
	* @param	string	$package	package to generate a class tree for
	* @see $roots, HTMLConverter::getRootTree()
	*/
	function generateFormattedClassTrees($package)
	{
		if (!isset($this->roots[$package])) return array();
		$roots = $trees = array();
		$roots = $this->roots[$package];
		for($i=0;$i<count($roots);$i++)
		{
			$trees[] = array('class' => $roots[$i],'class_tree' => "<ul>\n".$this->getRootTree($roots[$i],$package,'')."</ul>\n");
		}
		return $trees;
	}
	
	function output($title)
	{
		$this->render->Output($title);
	}

	/**
	* walk through the Classes::$definitechild array, return formatted class list
	*
	* @param string $class name of a class with children
	* @see Classes::$definitechild, generateFormattedClassTrees()
	* @return string
	*/
	function getRootTree($class,$package,$subpackage,$parclass = false)
	{
		if (isset($this->class_packages[$class]))
		{
			$a = $this->class_packages[$class];
			for($i=0; $i < count($this->class_packages[$class]); $i++)
			{
				if ($this->class_packages[$class][$i][0] == $package) $subpackage = $this->class_packages[$class][$i][1];
			}
		} else
		{
			$subpackage = '';
		}
		$my_tree = "<li>";
		$par = $this->classes->getClassByPackage($class,$package);
		if ($par)
		{
			$class_children = $this->classes->getDefiniteChildren($class,$par->curfile);
			if (!$class_children) unset($class_children);
		}
		$par = $this->classes->getClassByPackage($class,$package);
		if (!isset($class_children))
		{
			// special case: parent class is found, but is not part of this package, class has no children
			if (is_array($par->parent) && !$parclass)
			{
				$x = $this->classes->getClass($par->parent[1],$par->parent[0]);
				if ($x->docblock->package != $package)
				{
					$v = '<li>'.$this->returnSee($this->links[$package][$subpackage]['class'][$class], false, false)."</li>\n";
					return '<li>'.$this->returnSee($this->links[$x->docblock->package][$x->docblock->subpackage]['class'][$par->parent[1]], false, false).' <b>(Different package)</b><ul>'.$v.'</ul></li>';
				}
			} else
			{ // class has normal situation, no children
				if (is_string($par->getParent($this)))
				return '<li>'.$par->getExtends().'<ul><li>'.$this->returnSee($this->links[$package][$subpackage]['class'][$class], false, false)."</li></ul>\n\n</li>";
				else
				return '<li>'.$this->returnSee($this->links[$package][$subpackage]['class'][$class], false, false)."</li>\n";
			}
		}
		// special case: parent class is found, but is not part of this package, class has children
		if (is_array($par->parent) && !$parclass)
		{
			$x = $this->classes->getClass($par->parent[1],$par->parent[0]);
			if ($x->docblock->package != $package)
			{
				$v = '<li>'.$this->returnSee($this->links[$package][$subpackage]['class'][$class], false, false)."</li>\n";
				$my_tree .= $this->returnSee($this->links[$x->docblock->package][$x->docblock->subpackage]['class'][$par->parent[1]], false, false).' <b>(Different package)</b><ul>'.$v.'</ul>';
			}
		} else
		$my_tree .= $this->returnSee($this->links[$package][$subpackage]['class'][$class], false, false);
		if (isset($class_children))
		$my_tree .= '<ul>';
		if (isset($class_children))
		{
			foreach($class_children as $chileclass => $chilefile)
			{
				$ch = $this->classes->getClass($chileclass,$chilefile);
				$my_tree .= $this->getRootTree($chileclass,$ch->docblock->package,$ch->docblock->subpackage,$class);
			}
		}
		if (isset($class_children))
		$my_tree .= "</ul>\n";
		$my_tree .= "</li>\n";
		return $my_tree;
	}
	/**
	* Generate alphabetical index of all elements
	*
	* @see $elements, walk()
	*/
	function generateElementIndex()
	{
		$elementindex = array();
		uksort($this->elements,'strnatcasecmp');
		$letters = array();
		$i = 0;
		while(list($letter,) = each($this->elements))
		{
			uasort($this->elements[$letter],array($this,"elementCmp"));
			$letters[]['letter'] = $letter;
			$elindex['letter'] = $letter;
			foreach($this->elements[$letter] as $i => $yuh)
			{
				switch($this->elements[$letter][$i]->type)
				{
					case 'class':
						$elindex['inner_loop']['index'][]['listing'] = $this->getClassLink($this->elements[$letter][$i]->getName(),$this->elements[$letter][$i]->docblock->package,'in file '.$this->elements[$letter][$i]->file.', class '.$this->elements[$letter][$i]->getName(), false, $this->elements[$letter][$i]->file).'<br>';
					break;
					case 'define':
						$elindex['inner_loop']['index'][]['listing'] = $this->getDefineLink($this->elements[$letter][$i]->getName(),$this->elements[$letter][$i]->docblock->package,'in file '.$this->elements[$letter][$i]->file.', constant '.$this->elements[$letter][$i]->getName(), false, $this->elements[$letter][$i]->file).'<br>';
					break;
					case 'function':
						$elindex['inner_loop']['index'][]['listing'] = $this->getFunctionLink($this->elements[$letter][$i]->getName(),$this->elements[$letter][$i]->docblock->package,'in file '.$this->elements[$letter][$i]->file.', function '.$this->elements[$letter][$i]->getName().'()', false, $this->elements[$letter][$i]->file).'<br>';
					break;
					case 'method':
						$elindex['inner_loop']['index'][]['listing'] = $this->getMethodLink($this->elements[$letter][$i]->getName(),$this->elements[$letter][$i]->class, $this->elements[$letter][$i]->docblock->package,'in file '.$this->elements[$letter][$i]->file.', method '.$this->elements[$letter][$i]->class.'::'.$this->elements[$letter][$i]->getName().'()', false, $this->elements[$letter][$i]->file).'<br>';
					break;
					case 'var':
						$elindex['inner_loop']['index'][]['listing'] = $this->getVarLink($this->elements[$letter][$i]->getName(),$this->elements[$letter][$i]->class, $this->elements[$letter][$i]->docblock->package,'in file '.$this->elements[$letter][$i]->file.', variable '.$this->elements[$letter][$i]->class.'::'.$this->elements[$letter][$i]->getName(), false, $this->elements[$letter][$i]->file).'<br>';
					break;
					case 'page':
						$elindex['inner_loop']['index'][]['listing'] = $this->getPageLink($this->elements[$letter][$i]->getFile(),$this->elements[$letter][$i]->package,'procedural page '.$this->elements[$letter][$i]->getFile(), false).'<br>';
					break;
				}
			}
			if (isset($elindex['inner_loop']))
			{
				$elementindex[] = $elindex;
			} else
			{
				unset($letters[count($letters) - 1]);
			}
			$elindex = array();
		}
		return array($elementindex,$letters);
	}
	
	/**
	* Generate alphabetical index of all elements by package and subpackage
	*
	* @param string $package name of a package
	* @see $pkg_elements, walk(), generatePkgElementIndexes()
	*/
	function generatePkgElementIndex($package)
	{
		$elementindex = array();
		$letters = array();
		$letterind = array();
		$used = array();
//		unset($this->elements[0]);
		uksort($this->pkg_elements[$package],'strnatcasecmp');
		$subp = '';
		foreach($this->pkg_elements[$package] as $subpackage => $els)
		{
			if (empty($els)) continue;
			if (!empty($subpackage)) $subp = " (<b>subpackage:</b> $subpackage)"; else $subp = '';
			uksort($els,'strnatcasecmp');
			foreach($els as $letter => $yuh)
			{
				usort($els[$letter],array($this,"elementCmp"));
				if (!isset($used[$letter]))
				{
					$letters[]['letter'] = $letter;
					$letterind[$letter] = count($letters) - 1;
					$used[$letter] = 1;
				}
				$elindex[$letter]['letter'] = $letter;
				foreach($els[$letter] as $i => $yuh)
				{
					switch($els[$letter][$i]->type)
					{
						case 'class':
							$elindex[$letter]['inner_loop']['index'][]['listing'] = $this->getClassLink($els[$letter][$i]->getName(),$els[$letter][$i]->docblock->package,'in file '.$els[$letter][$i]->file.', class '.$els[$letter][$i]->getName(), false, $els[$letter][$i]->file)."$subp<br>";
						break;
						case 'define':
							$elindex[$letter]['inner_loop']['index'][]['listing'] = $this->getDefineLink($els[$letter][$i]->getName(),$els[$letter][$i]->docblock->package,'in file '.$els[$letter][$i]->file.', constant '.$els[$letter][$i]->getName(), false, $els[$letter][$i]->file)."$subp<br>";
						break;
						case 'function':
							$elindex[$letter]['inner_loop']['index'][]['listing'] = $this->getFunctionLink($els[$letter][$i]->getName(),$els[$letter][$i]->docblock->package,'in file '.$els[$letter][$i]->file.', function '.$els[$letter][$i]->getName().'()', false, $els[$letter][$i]->file)."$subp<br>";
						break;
						case 'method':
							$elindex[$letter]['inner_loop']['index'][]['listing'] = $this->getMethodLink($els[$letter][$i]->getName(),$els[$letter][$i]->class,$els[$letter][$i]->docblock->package,'in file '.$els[$letter][$i]->file.', method '.$els[$letter][$i]->class.'::'.$els[$letter][$i]->getName().'()', false, $els[$letter][$i]->file)."$subp<br>";
						break;
						case 'var':
							$elindex[$letter]['inner_loop']['index'][]['listing'] = $this->getVarLink($els[$letter][$i]->getName(),$els[$letter][$i]->class,$els[$letter][$i]->docblock->package,'in file '.$els[$letter][$i]->file.', variable '.$els[$letter][$i]->class.'::'.$els[$letter][$i]->getName(), false, $els[$letter][$i]->file)."$subp<br>";
						break;
						case 'page':
							$elindex[$letter]['inner_loop']['index'][]['listing'] = $this->getPageLink($els[$letter][$i]->getFile(),$els[$letter][$i]->package,'procedural page '.$els[$letter][$i]->getFile(), false)."$subp<br>";
						break;
					}
				}
			}
		}
		if (isset($elindex))
		{
			while(list($letter,$tempel) = each($elindex))
			{
				if (!isset($tempel['inner_loop']))
				{
					unset($letters[$letterind[$tempel['letter']]]);
				} else
				$elementindex[] = $tempel;
			}
		} else $letters = array();
		return array($elementindex,$letters);
	}
	
	/**
	*
	* @see generatePkgElementIndex()
	*/
	function generatePkgElementIndexes()
	{
		$packages = array();
		$package_names = array();
		$pkg = array();
		$letters = array();
		foreach($this->pkg_elements as $package => $trash)
		{
			$pkgs['package'] = $package;
			$pkg['package'] = $package;
			list($pkg['inner_loop']['pindex'],$letters[$package]) = $this->generatePkgElementIndex($package);
			if (count($pkg['inner_loop']['pindex']))
			{
				$packages[] = $pkg;
				$package_names[] = $pkgs;
			}
			unset($pkgs);
			unset($pkg);
		}
		return array($packages,$package_names,$letters);
	}
	
	/**
	* does a nat case sort on the specified second level value of the array
	*
	* @param	mixed	$a
	* @param	mixed	$b
	* @return	int
	* @see		generateElementIndex()
	*/
	function elementCmp ($a, $b)
	{
		return strnatcasecmp($a->getName(), $b->getName());
	}

	function getClassLink($expr,$package,$text = false, $local = true, $with_a = true, $file = false)
	{
		$a = Converter::getClassLink($expr,$package,$file);
		return $this->returnSee($a, $text, $local, $with_a);
	}

	function getFunctionLink($expr,$package,$text = false, $local = true, $file = false)
	{
		$a = Converter::getFunctionLink($expr,$package,$file);
		return $this->returnSee($a, $text, $local);
	}

	function getDefineLink($expr,$package,$text = false, $local = true, $file = false)
	{
		$a = Converter::getDefineLink($expr,$package,$file);
		return $this->returnSee($a, $text, $local);
	}

	function getPageLink($expr,$package,$text = false, $local = true)
	{
		$a = Converter::getPageLink($expr,$package);
		return $this->returnSee($a, $text, $local);
	}

	function getMethodLink($expr,$class,$package,$text = false, $local = true, $file = false)
	{
		$a = Converter::getMethodLink($expr,$class,$package,$file);
		return $this->returnSee($a, $text, $local);
	}

	function getVarLink($expr,$class,$package,$text = false, $local = true, $file = false)
	{
		$a = Converter::getVarLink($expr,$class,$package,$file);
		return $this->returnSee($a, $text, $local);
	}


}
?>
