<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/** The IntermediateParser Class
 *
 *  The Main Data Parser (intermediate between parse and render)
 *
 *  @author Gregory Beaver
 *  @version 0.1
 *  @copyright 2002 Gregory Beaver
 *  @package 	phpDocumentor
 */
/** The IntermediateParser Class
 *
 *  The Main Data Parser (intermediate between parse and render)
 *
 *  @author Gregory Beaver
 *  @version $Id: IntermediateParser.inc,v 1.44 2002/05/23 22:17:07 CelloG Exp $
 *  @copyright 2002 Gregory Beaver
 *  @package 	phpDocumentor
 */
class IntermediateParser
{
	/**
	* @var parserDocBlock
	*/
	var $last	= "";
	
	/**
	* type of the last parser Element handled
	* @var string
	*/
	var $lasttype = '';
	
	/**
	* Name of the class currently being parsed.
	* It is only used (and only valid) when IntermediateParser is parsing a class
	* @var string
	*/
	var $cur_class = '';
	
	/**
	* This variable is used to track whether a page has any elements at all on it.  If it does, it will be put into the index
	* @var boolean
	*/
	var $hasanyelements = false;
	
	/**
	* type of the current parser Element being handled
	* @var string
	*/
	var $type = '';
	
	/**
	* array of methods by package and class
	* format:
	* array(packagename =>
	*         array(classname =>
	*               array(methodname1 => {@link parserMethod} class,
	*                     methodname2 => {@link parserMethod} class,...)
	*					  )
	*              )
	*      )
	* @var array
	* @see Converter
	*/
	var $methods = array();
	
	/**
	* array of class variables by package and class
	* format:
	* array(packagename =>
	*         array(classname =>
	*                array(variablename1 => {@link parserMethod} class,
	*                      variablename2 => {@link parserMethod} class,...
	*                     )
	*              )
	*      )
	* @var array
	* @see Converter
	*/
	var $vars = array();
	
	/**
	* set in {@link phpdoc.inc} to the value of the parserprivate commandline option.
	* If this option is true, elements with an @access private tag will be parsed and displayed
	* @var bool
	*/
	var $parsePrivate = false;
	
	/**
	* this variable is used to prevent parsing of private elements if $parsePrivate is false.
	* it is also used by the packageoutput setting to prevent parsing of elements that aren't in the
	* desired output packages
	* @see $packageoutput
	* @see $parsePrivate
	*/
	var $private_class = false;
	
	/**
	* the workhorse of linking.
	* This array is an array of link objects of format:
	* [package][subpackage][eltype][elname] = descendant of {@link abstractLink}
	* eltype can be page|function|define|class|method|var
	* if eltype is method or var, the array format is:
	* [package][subpackage][eltype][class][elname]
	* @var array
	* @see functionLink, pageLink, classLink, defineLink, methodLink, varLink
	*/
	var $links = array();
	
	/**
	* the workhorse of linking, with allowance for support of multiple elements in different files.
	* This array is an array of link objects of format:
	* [package][subpackage][eltype][file][elname] = descendant of {@link abstractLink}
	* eltype can be function|define|class|method|var
	* if eltype is method or var, the array format is:
	* [package][subpackage][eltype][file][class][elname]
	* @var array
	* @see functionLink, classLink, defineLink, methodLink, varLink
	*/
	var $linkswithfile = array();
	
	/**
	* a tree of class inheritance by name.
	* format:
	* array(childname => parentname,
	*       childname1 => parentname1,
	*       rootname => 0, ...
	*      )
	* @var array
	* @see Converter::generateClassTreeFromClass()
	*/
	var $classtree = array();
	
	/**
	* used in {@link Converter::getClassPackage()} to inherit package from parent classes.
	* format:
	* array(classname => array(array(package,subpackage),
	*                          array(package1,subpackage1),....
	                          )
		   )
	* If a name conflict exists between two packages, automatic inheritance will not work, and the packages will need
	* to be documented separately.
	* @var array
	*/
	var $classpackages = array();
	
	/**
	* used to set the output directory
	* @see setTargetDir()
	*/
	var $targetDir;
	
	/**
	* array of class inheritance indexed by parent class and package
	*
	* Format:
	* array(Packagename => array(ParentClassname1 => array(Child1name,Child2name),
	*                            ParentClassname2 => array(Child1name,Child2name),...
	*                           )
	*      )
	* @see Converter::getRootTree()
	* @var array
	*/
	
	/**
	* An array of extended classes by package and parent class
	* Format:
	* array(packagename => array(parentclass => array(childclassname1,
	*                                                 childclassname2,...
	*                                                )
	*                       )
	*      )
	* @var array
	*/
	var $class_children = array();
	
	/**
	* array of parsed package pages
	* @var array
	*/
	var $package_pages = array();
	
	var $elements = array();
	
	var $pkg_elements = array();

	var $pages = array();
	
	/**
	* array of packages to parser and output documentation for, if not all packages should be documented
	* Format:
	* array(package1,package2,...)
	*   or false if not set
	* Use this option to limit output similar to ignoring files.  If you have some temporary files that you don't want to specify by name
	* but don't want included in output, set a package name for all the elements in your project, and set packageoutput to that name.
	* the default package will be ignored.  Parsing speed does not improve.  If you want to ignore files for speed reasons, use the ignore
	* command-line option
	* @see Io
	* @var mixed
	*/
	var $packageoutput = false;
	
	/**
	* the functions which handle output from the {@link Parser}
	* @see handleEvent(), handleDocBlock(), handlePage(), handleClass(), handleDefine(), handleFunction(), handleMethod(), handleVar(),
	*      handlePackagePage(), handleInclude()
	*/
	var $event_handlers = array(
			'docblock' => 'handleDocBlock',
			'page' => 'handlePage',
			'class' => 'handleClass',
			'define' => 'handleDefine',
			'function' => 'handleFunction',
			'method' => 'handleMethod',
			'var' => 'handleVar',
			'packagepage' => 'handlePackagePage',
			'include' => 'handleInclude',
			);
	
	/**
	* data contains parsed structures for the current page being parsed
	* @var parserData
	* @see parserData
	*/
	var $data;
	
	/**
	* set in {@link phpdoc.inc} to the value of the quitemode commandline option.
	* If this option is true, informative output while parsing will not be displayed (documentation is unaffected)
	* @var bool
	*/
	var $quietMode = false;
	
	/**
	* this should be settable by converter
	* @var string
	*/
	var $outputExt = '.html';
	
	/**
	* location of the current page in the {@link $elements} array
	* @var integer
	*/
	var $indexloc;
	
	/**
	* location of the current page in the {@link $pkg_elements} array
	* @var integer
	*/
	var $pkgindexloc;
	
	/**
	* flag used to remove non-procedural pages from the index
	* @var bool
	*/
	var $is_procpage = false;
	
	/**
	* used to keep track of inheritance at the smartest level possible for a dumb computer
	* @var Classes
	* @see Classes
	*/
	var $classes = false;
	
	/**
	* an array of booleans indexed by converter name
	* @var array
	* @see Converter
	*/
	var $converters = false;

	function IntermediateParser()
	{
		$this->data = new parserData;
		$this->classes = new Classes;
	}
	
	/**
	* handles rendering of include/require/include_once/require_once
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserInclude} class
	*/
	function handleInclude($event,$data)
	{
		if ($this->packageoutput)
		{
			if (!in_array($this->package,$this->packageoutput))
			{
				$this->private_page = true;
				unset($this->last);
				return;
			}
		}
		if ($this->private_page)
		{
			unset($this->last);
			return;
		}
		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new parserDocblock();
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access->getString() == 'private') && (!$this->parsePrivate))
			{
				unset($this->last);
				return;
			}
		}
		$this->hasanyelements = true;

		$this->last->overridePackage($this->package,$this->subpackage,$data->getName(),'include');
		$data->setDocBlock($this->last);
		$this->data->addElement($data);
//		$this->links[$this->last->package][$this->last->subpackage]['include'][$data->getName()] = $this->data->addLink($data);
		$this->elements[substr(strtolower($data->getName()),0,1)][] = $data;
		$this->pkg_elements[$this->last->package][$this->last->subpackage][substr(strtolower($data->getName()),0,1)][] = $data;
		$this->last = false;
		$this->is_procpage = true;
	}
	
	/**
	* handles rendering of Package-level documentation page
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserPackagePage} class
	*/
	function handlePackagePage($event,$data)
	{
		$type = 'packagepage';
		$this->package_pages[$data->package] = &$data;
		$this->last = false;
	}
	
	/**
	* handles rendering of class variables
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserVar} class
	*/
	function handleVar($event,$data)
	{
		if ($this->private_class)
		{
			unset($this->last);
			return;
		}
		$type = 'var';
		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new parserDocblock();
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access->getString() == 'private') && (!$this->parsePrivate))
			{
				unset($this->last);
				return;
			}
		}
		$this->last->overridePackage($this->package,$this->subpackage,$data->getName(),'var');

		if (!$this->last->getKeyword('var'))
		{
			$this->last->addKeyword('var',new parserStringWithInlineTags('mixed'));
		}
		
		$data->setDocBlock($this->last);
		$this->classes->addVar($data);
		$this->last = false;
	}
	
	/**
	* handles rendering of class methods
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserMethod} class
	*/
	function handleMethod($event,$data)
	{
		if ($this->private_class)
		{
			unset($this->last);
			return;
		}
		$type = 'method';

		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new parserDocblock();
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (is_object($access))
			{
				if (($access->getString() == 'private') && (!$this->parsePrivate))
				{
					unset($this->last);
					return;
				}
			}
			else
			{
				// getting here means we had the same keyword twice opps
				// the parser should catch these duplicate keywords are produce errors, but this should keep 
				// things from crashing
				echo "\tYou had a duplicate keyword\n";
			}
		}
		$this->last->overridePackage($this->package,$this->subpackage,$data->getName(),'method');
		foreach($data->listParams() as $param)
		{
			$update_params[] = $param[0];
		}
		if (isset($update_params))
		$this->last->updateParams($update_params);
		unset($update_params);

		if ($data->getName() == $this->cur_class) $data->setConstructor();

		$data->setDocBlock($this->last);
		$this->classes->addMethod($data);
		$this->last = false;
	}
	
	/**
	* handles rendering of functions and class methods
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserFunction} class
	*/
	function handleFunction($event,$data)
	{
		if ($this->private_page)
		{
			unset($this->last);
			return;
		}
		$type = 'function';

		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new parserDocblock();
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (is_object($access))
			{
				if (($access->getString() == 'private') && (!$this->parsePrivate))
				{
					unset($this->last);
					return;
				}
			}
			else
			{
				// getting here means we had the same keyword twice opps
				// the parser should catch these duplicate keywords are produce errors, but this should keep 
				// things from crashing
				echo "\tYou had a duplicate keyword\n";
			}
		}
		$this->last->overridePackage($this->package,$this->subpackage,$data->getName(),'function');

		if ($this->packageoutput)
		{
			if (!in_array($this->package,$this->packageoutput))
			{
				$this->private_page = true;
				unset($this->last);
				return;
			}
		}
		$this->hasanyelements = true;
		foreach($data->listParams() as $param)
		{
			$update_params[] = $param[0];
		}
		if (isset($update_params))
		$this->last->updateParams($update_params);
		unset($update_params);

		$data->setDocBlock($this->last);
		$this->data->addElement($data);
		$this->links[$this->last->package][$this->last->subpackage]['function'][$data->getName()] = $this->data->addLink($data);
		$this->linkswithfile[$this->last->package][$this->last->subpackage]['function'][$this->data->parent->getFile()][$data->getName()] = $this->data->addLink($data);
		$this->elements[substr(strtolower($data->getName()),0,1)][] = $data;
		$this->pkg_elements[$this->last->package][$this->last->subpackage][substr(strtolower($data->getName()),0,1)][] = $data;
		$this->last = false;
		$this->is_procpage = true;
	}
	
	/**
	* handles rendering of constants (defines)
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserDefine} class
	*/
	function handleDefine($event,$data)
	{
		if ($this->private_page)
		{
			unset($this->last);
			return;
		}
		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new parserDocblock();
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access->getString() == 'private') && (!$this->parsePrivate))
			{
				unset($this->last);
				return;
			}
		}

		$this->last->overridePackage($this->package,$this->subpackage,$data->getName(),'define');
		if ($this->packageoutput)
		{
			if (!in_array($this->package,$this->packageoutput))
			{
				$this->private_page = true;
				unset($this->last);
				return;
			}
		}
		$this->hasanyelements = true;
		$data->setDocBlock($this->last);
		$this->data->addElement($data);
		$this->links[$this->last->package][$this->last->subpackage]['define'][$data->getName()] = $this->data->addLink($data);
		$this->linkswithfile[$this->last->package][$this->last->subpackage]['define'][$this->data->parent->getFile()][$data->getName()] = $this->data->addLink($data);
		$this->elements[substr(strtolower($data->getName()),0,1)][] = $data;
		$this->pkg_elements[$this->last->package][$this->last->subpackage][substr(strtolower($data->getName()),0,1)][] = $data;
		$this->last = false;
		$this->is_procpage = true;
	}
	
	/**
	* handles rendering of classes
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserClass} class
	*/
	function handleClass($event,$data)
	{
		$type = 'class';
		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new parserDocblock();
		}

		$data->setDocBlock($this->last);
		$this->cur_class = $name = $data->getName();
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access->getString() == 'private') && (!$this->parsePrivate))
			{
				$this->private_class = true;
				unset($this->last);
				return;
			}
		}
		$this->hasanyelements = true;
		if ($this->packageoutput)
		{
			if (!in_array($this->last->package,$this->packageoutput))
			{
				$this->private_class = true;
				unset($this->last);
				return;
			}
		}
		$this->classes->addClass($data);
		$this->private_class = false;
		$parent = $data->getExtends();
		if ($this->last->package)
		{
			if (!isset($this->package_pages[$this->last->package]))
			{
				if (file_exists(dirname($this->data->parent->getPath()) . SMART_PATH_DELIMITER . $this->last->package . $this->outputExt))
				{
					if ($this->quietMode === false)
					{
						phpdoc_out("Reading package-level file ".$this->last->package . $this->outputExt);
						flush();
					}
					$fp = fopen(dirname($this->data->parent->getPath()) . SMART_PATH_DELIMITER . $this->last->package . $this->outputExt,"r");
					$ret = fread($fp,filesize(dirname($this->data->parent->getPath()) . SMART_PATH_DELIMITER . $this->last->package . $this->outputExt));
					fclose($fp);
					unset($fp);
					if ($this->quietMode === false)
					{
						phpdoc_out(" -- Parsing File\n");
						flush();
					}
					$pageParser = new ppageParser;
					$tempp = $this->package;
					$lp = $this->last;
					$this->package = $this->last->package;
					$pageParser->subscribe('*',$this);
					$pageParser->parse($ret,$this->last->package);
					$this->package = $tempp;
					$this->last = $lp;
					unset($tempp);
					unset($pageParser);
				}
			}
		}
		$this->last = false;
	}
	
	/**
	* handles rendering of procedural pages
	* this event is called at the start of a new page, before the Parser knows whether the
	* page will contain any procedural pages or not
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserPage} class
	*/
	function handlePage($event,$data)
	{
		$type = 'page';
		$this->private_page = false;
		$this->hasanyelements = false;
		$this->data = new parserData;
		$this->links[$GLOBALS['PHPDocumentor_DefaultPackageName']]['']['page'][$data->getFile()] = $this->data->addLink($data);
		$this->package = $GLOBALS['PHPDocumentor_DefaultPackageName'];
		$this->subpackage = '';
		$this->data->setParent($data);
		$this->classes->nextFile($data->getFile());
		$this->elements[substr(strtolower($data->getFile()),0,1)][] = &$data;
		end($this->elements[substr(strtolower($data->getFile()),0,1)]);
		$this->indexloc = key($this->elements[substr(strtolower($data->getFile()),0,1)]);
		reset($this->elements[substr(strtolower($data->getFile()),0,1)]);
		$this->pkg_elements[$GLOBALS['PHPDocumentor_DefaultPackageName']][''][substr(strtolower($data->getFile()),0,1)][] = &$data;
		end($this->pkg_elements[$GLOBALS['PHPDocumentor_DefaultPackageName']]['']);
		$this->pkg_indexloc = key($this->pkg_elements[$GLOBALS['PHPDocumentor_DefaultPackageName']][''][substr(strtolower($data->getFile()),0,1)]);
		reset($this->pkg_elements[$GLOBALS['PHPDocumentor_DefaultPackageName']]['']);
		$this->packageoutput = $data->getPackageOutput();
	}
	
	/**
	* handles rendering of DocBlocks
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link parserDocBlock} class
	*/
	function handleDocBlock($event,$data)
	{
		$type = 'docblock';
		// 2nd docblock in a row, and it's at the top of the file
		if ($this->lasttype == "docblock" && $this->data->isClean())
		{
			$this->data->setDocBlock($this->last);
			$this->package = $this->data->parent->package = $this->data->docblock->package;
			$this->subpackage = $this->data->parent->subpackage = $this->data->docblock->subpackage;
			if ($access = $this->last->getKeyword('access'))
			{
				if (($access->getString() == 'private') && (!$this->parsePrivate))
				{
					$this->private_page = true;
					unset($this->last);
					return;
				}
			}
			unset($this->links[$GLOBALS['PHPDocumentor_DefaultPackageName']]['']['page'][$this->data->parent->getFile()]);
			if (isset($this->pkg_elements[$GLOBALS['PHPDocumentor_DefaultPackageName']]['']))
			unset($this->pkg_elements[$GLOBALS['PHPDocumentor_DefaultPackageName']][''][substr(strtolower($this->data->parent->getFile()),0,1)][$this->pkg_indexloc]);
			if ($this->packageoutput)
			{
				if (!in_array($this->package,$this->packageoutput))
				{
					$this->private_page = true;
					unset($this->last);
					unset($this->elements[substr(strtolower($this->data->parent->getFile()),0,1)][$this->indexloc]);
					return;
				}
			}
			if ($this->package)
			{
				if (!isset($this->package_pages[$this->package]))
				{
					if (file_exists(dirname($this->data->parent->getPath()) . SMART_PATH_DELIMITER . $this->package . $this->outputExt))
					{
						if ($this->quietMode === false)
						{
							phpdoc_out("Reading package-level file ".$this->package . $this->outputExt);
							flush();
						}
						$fp = fopen(dirname($this->data->parent->getPath()) . SMART_PATH_DELIMITER . $this->package . $this->outputExt,"r");
						$ret = fread($fp,filesize(dirname($this->data->parent->getPath()) . SMART_PATH_DELIMITER . $this->package . $this->outputExt));
						fclose($fp);
						unset($fp);
						if ($this->quietMode === false)
						{
							phpdoc_out(" -- Parsing File\n");
							flush();
						}
						$pageParser = new ppageParser;
						$tempp = $this->package;
						$lp = $this->last;
						$this->package = $this->package;
						$pageParser->subscribe('*',$this);
						$pageParser->parse($ret,$this->package);
						$this->package = $tempp;
						$this->last = $lp;
						unset($tempp);
						unset($pageParser);
					}
				}
			}
			$this->data->addLink($this->data->parent);
			$this->links[$this->last->package][$this->last->subpackage]['page'][$this->data->parent->getFile()] = $this->data->addLink($this->data->parent,$this->last->package,$this->last->subpackage);
			$this->pkg_elements[$this->last->package][$this->last->subpackage][substr(strtolower($this->data->parent->getFile()),0,1)][] = &$this->data->parent;
			end($this->pkg_elements[$this->last->package][$this->last->subpackage]);
			$this->pkg_indexloc = key($this->pkg_elements[$this->last->package][$this->last->subpackage]);
			reset($this->pkg_elements[$this->last->package][$this->last->subpackage]);
			$this->elements[strtolower(substr($this->data->parent->getFile(),0,1))][$this->indexloc] = &$this->data->parent;
			// can only have 1 package-level docblock, others are ignored
			$this->data->clean = false;
		}
		$this->last = $data;
	}
	
	/**
	* called via {@link Parser::parse()} and Parser's inherited method {@link Publisher::publishEvent()}
	*
	* @param integer $event event number from {@link Parser.inc}
	* @param mixed $data if $event is PHPDOC_EVENT_NEWSTATE, $data is a {@link PHP_DOC_EVENT_END_PAGE} or {@link STATE_END_CLASS},
	*                    otherwise $data is either a {@link parserDocBlock}, {@link parserPage} or descendant of {@link parserElement}
	*/
	function HandleEvent($event,$data)
	{
		if ($event == PHPDOC_EVENT_NEWSTATE)
		{
			if ($data == STATE_END_CLASS)
			{
			} elseif ($data == PHPDOC_EVENT_END_PAGE)
			{
				if ($this->packageoutput)
				{
					if (!in_array($this->package,$this->packageoutput))
					{
						$this->private_page = true;
					}
				}
				if (!$this->private_page)
				$this->pages[$this->data->parent->getFile()] = $this->data;
				$this->is_procpage = false;
				$this->private_page = false;
				$this->private_class = false;
			}
			//echo $this->state_lookup[$data] . "\n";
			//echo $data."\n";
		} 
		 else 
		{
			$this->lasttype = $this->type;
			$type = $data->getType();
//			fancy_debug($type,$data);
			if (($type != 'page') && ($type != 'docblock') && ($type != 'packagepage'))
			{
				$data->setFile($this->data->parent->getFile());
			}
			$this->type = $type;
			//echo $type . "\n";
			
			if (isset($this->event_handlers[$type]))
			{
				$handle = $this->event_handlers[$type];
				$this->$handle($event,$data);
			}
		}
	}
	
	/**
	* This function is called by {@link Classes::processChild()} when a class, method, or var has been processed for inheritance
	* and is ready to be added to the {@link $links, $linkswithfile, $elements} and {@link $pkg_elements} arrays.
	* @param string $package package name
	* @param string $subpackage subpackage name
	* @param parserBase $data descendant of {@link parserElement}, or {@link parserPage}
	* @param string $file filename that contains the element
	*/
	function addElement($package, $subpackage, $data, $file)
	{
		$file1 = $this->data->parent->file;
		$this->data->parent->file = $file;
		$i = 0;
		if ($data->getType() == 'var') $i++;
		if ($data->getType() == 'var' || $data->getType() == 'method')
		{
			$this->links[$package][$subpackage][$data->getType()][$data->class][$data->getName()] = $this->data->addLink($data,$data->class);
			$this->linkswithfile[$package][$subpackage][$data->getType()][$file][$data->class][$data->getName()] = $this->data->addLink($data,$data->class);
		} else
		{
			$this->links[$package][$subpackage][$data->getType()][$data->getName()] = $this->data->addLink($data);
			$this->linkswithfile[$package][$subpackage][$data->getType()][$file][$data->getName()] = $this->data->addLink($data);
		}
		$this->elements[substr(strtolower($data->getName()),$i,1)][] = $data;
		$this->pkg_elements[$package][$subpackage][substr(strtolower($data->getName()),$i,1)][] = $data;
		$this->data->parent->file = $file1;
	}
	
	/**
	* @see Converter::walk()
	* @see Converter::output()
	*/
	function Convert($title, $converter)
	{
		$converter->walk($this->pages, $this->package_pages);
		phpdoc_out("\nWriting Files\n");
		$converter->output($title);
	}
	
	/**
	* @access private
	*/
	function fixClasses()
	{
		$this->classes->Inherit($this);
		$this->vars = $this->classes->vars;
		$this->methods = $this->classes->methods;
		$this->classtree = $this->classes->classparents;
		$this->classpackages = $this->classes->classpackages;
	}
	
	/**
	* Add a converter name to use to the list of converters
	*/
	function addConverter($name)
	{
		// can't fool me
		@include_once($name . PATH_DELIMITER . $name . ".inc");
		if (class_exists($name))
		{
			$this->converters[$name] = true;
		} else
		{
			addError(PDERROR_CONVERTER_NOT_FOUND,$name);
		}
	}
	
	/**
	* @see Convert()
	*/
	function Output ($title = "Generated Documentation")
	{
		if ($this->packageoutput)
		{
			foreach($this->pkg_elements as $package => $blah)
			{
				if (!in_array($package,$this->packageoutput)) unset($this->pkg_elements[$package]);
			}
		}
		$GLOBALS['PHPDocumentor_errors']->curfile = false;
		$this->fixClasses();
		if (is_array($this->converters))
		{
			foreach($this->converters as $converter => $blah)
			{
				$this->Convert($title, new $converter($this->methods, $this->vars, $this->links, $this->linkswithfile, $this->classtree, $this->packageoutput, $this->classpackages, $this->elements, $this->pkg_elements, $this->parsePrivate, $this->quietMode, $this->classes, $this->templateDir, $this->targetDir));
			}
		} else
		{
			addErrorDie(PDERROR_NO_CONVERTERS);
		}
	}

	/** Sets the output directory of create
	*  @param $dir the output directory
	*/
	function setTargetDir($dir)
	{
		$this->targetDir = $dir;
	}

	/**
	* Set template dir
	*
	* @param	string	$dir
	*/
	function setTemplateDir($dir)
	{
		$this->templateDir = $dir;
	}
	
	/**
	 * set mode (quiet or verbose)
	 *
	 * @param	bool $quietMode
	 */
	function setQuietMode($quietMode) {
	$this->quietMode = $quietMode;
	}
	
	/**
	* set parsing (on or off)
	*
	* @param	bool $parse
	*/
	function setParsePrivate($parse)
	{
		$this->parsePrivate = $parse;
	}
}
?>
