<?php
/**
* @package phpDocumentor
* @subpackage Linker
*/

/**
* linking classes
* @package phpDocumentor
* @subpackage Linker
*/
class abstractLink
{
	var $file = '';
	/**
	* phpdoc alias _phpdoc_inc for phpdoc.inc
	*/
	var $fileAlias = '';
	/**
	* element type linked to.
	* can only be a documentable element
	*/
	var $type = '';
	var $name = '';
	var $package = '';
	var $subpackage = '';

	function addLink($file,$fileAlias,$pagename,$package,$subpackage)
	{
		$this->file = $file;
		$this->fileAlias = $fileAlias;
		$this->name = $pagename;
		$this->package = $package;
		$this->subpackage = $subpackage;
	}
}

class pageLink extends abstractLink
{
	var $type = 'page';
	
}

class functionLink extends abstractLink
{
	var $type = 'function';
}

class defineLink extends abstractLink
{
	var $type = 'define';
}

class classLink extends abstractLink
{
	var $type = 'class';
}

class methodLink extends abstractLink
{
	var $type = 'method';
	var $class = '';
	
	function addLink($class,$file,$fileAlias,$name,$package,$subpackage)
	{
		$this->class = $class;
		abstractLink::addLink($file,$fileAlias,$name,$package,$subpackage);
	}
}

class varLink extends abstractLink
{
	var $type = 'var';
	var $class = '';

	function addLink($class,$file,$fileAlias,$name,$package,$subpackage)
	{
		$this->class = $class;
		abstractLink::addLink($file,$fileAlias,$name,$package,$subpackage);
	}
}

?>