<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/** The Render Class
 *
 *  The Main render engine for Php Documentor
 *
 *  @author Joshua Eichorn
 *  @version $Id: Render.inc,v 1.92 2002/05/25 03:19:00 CelloG Exp $
 *  @copyright 2000-2001 Joshua Eichorn 
 *  @package 	phpDocumentor
 */
/**
* sort function for {@link Render::PreOutput()}
*/
function indexsort($a, $b)
{
	return strnatcasecmp($a['title'],$b['title']);
}
/** The Render Class
 *
 *  The Main render engine for Php Documentor
 *
 *  @author Joshua Eichorn
 *  @version $Id: Render.inc,v 1.92 2002/05/25 03:19:00 CelloG Exp $
 *  @copyright 2000-2001 Joshua Eichorn 
 *  @package 	phpDocumentor
 */
class Render extends Template
{
	var $last	= "";

	var $cur_page = "";

	var $output	=	array();

	var $linker;
	
	var $package;
	
	var $dir;

	/**
	* Where files will be created by render
	*/
	var $targetDir	= "";

	/**
	* Where the template files are located
	*/
	var $templateDir= "";

	/**
	 * suppress all messages like "parsing file etc.".
	 * Usefull for cron jobs.
	 */
	var $quietMode = false;
	
	/**
	* suppress display of private elements marked with @access private in output docs
	*/
	var $parsePrivate = false;

	// buches of vars used as we build files up from templates
	var $page	= array();
	var $constants	= array();

	/**
	* The extenstion that the files will be output with
	*/
	var $outputExt	=	".html";

	/**
	* Holds wheter a page has had something set to it
	*/
	var $outPage	=	array();

	/**
	* The parent object
	*/
	var $parent	=	"";
	
	/**
	* @access private
	*/
	var $private_class = false;

	/**
	* @access private
	*/
	var $private_page = false;

	/**
	* Where vars, constants, and functions are stored til they are registered into the template
	*/
	var $current	= array();

	/**
	* Where vars and methods are stored til they are registered into the template
	*/
	var $currentclass	= array();

	/**
	* Used by the comparision function used in uksort
	*/
	var $rcnatcmpkey	= "";

	/**
	* The current output file
	*/
	var $file	=	"";

	/**
	* The array used to build the package and class index-files
	*/
	var $index	=	array();

	/**
	* The last type of element handled
	*/
	var $lasttype = '';

	/**
	* The current type of element handled
	*/
	var $type = '';

	/**
	* state constant lookup
	*/
	var $state_lookup = array();
	
	/**
	* State variable to find @package tags
	*/
	var $top_docblock = 1;
	
	/**
	* packages to output, from phpdoc.inc
	*/
	var $packageoutput = false;
	
	/**
	* array of registered procedural pages
	* @see registerCurrent()
	*/
	var $registered = array();

	/**
	* The number of times a local link must add ../ to the path to get the correct link
	*/
	var $dir_level = 1;

	/**
	* The number of times a local link must add ../ to the path to get the correct link
	*/
	var $classdir_level = 1;
	
	var $formatted_trees = array();
	
	var $event_handlers = array(
			'docblock' => 'handleDocBlock',
			'page' => 'handlePage',
			'class' => 'handleClass',
			'define' => 'handleDefine',
			'function' => 'handleFunction',
			'var' => 'handleVar',
			'packagepage' => 'handlePackagePage',
			'include' => 'handleInclude',
			);
			
	var $indexes;
	
	var $pkg_indexes;


	function Render()
	{
	}
	/**
	* handles rendering of include/require/include_once/require_once
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataInclude} class
	*/
	function handleInclude($event,$data)
	{
		$type = "include";
		if (count($this->page) > 0)
		{
			if (!isset($this->page['template']->registered['desc']))
			$this->page['template']->register("desc","");
			if (!isset($this->page['template']->registered['sdesc']))
			$this->page['template']->register("sdesc","");
			$this->output[$this->page['package']][$this->page['name']] = $this->page['template'];
			$this->page = array();
		}

		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new DataDocblock();
			$this->last->setDir($this->dir);
		}
		if ($this->packageoutput)
		{
			if (!in_array($this->package,$this->packageoutput))
			{
				$this->private_page = true;
				unset($this->last);
				return;
			}
		}
		if ($this->private_page)
		{
			unset($this->last);
			return;
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access == 'private') && (!$this->parsePrivate))
			{
				unset($this->last);
				return;
			}
		}
		$this->last->nopackages();
		// set the package directory
		$data->setDir($this->last);
		$data->setParent($this->parent);	
		$this->outPage[$this->parent][$this->package] = $this->package;
		$data->setParent($this->parent);	

		$this->current['include'][] = 
			array(
				"include_name" => $data->getName(), 
				"include_value" => $data->getValue(),
				"include_file" => $data->getFile(),
				"include_sdesc" => $this->last->getShortDesc()
			);
		$this->current['include_detail'][] = 
			array(
				"include_name" 	=> $data->getName(), 
				"include_value" 	=> $data->getValue(), 
				"include_file" => $data->getFile(),
				"sdesc" 		=> $this->last->getShortDesc(),
				"desc" 			=> $this->last->getDesc(),
				"inner_loop"		=> array("docblock" => $this->last->listKeywords())
			);

		unset($this->last);
	}
	
	/**
	* handles rendering of Package-level documentation page
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataPackagePage} class
	*/
	function handlePackagePage($event,$data)
	{
		$type = 'packagepage';
		$this->outPage['package_' . $data->package][$data->package] = $data->package;
		$data->dir = $data->package;
		$this->output[$data->package]['package_' . $data->package] = $data;
		unset($data);
	}
	
	/**
	* handles rendering of class variables
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataVar} class
	*/
	function handleVar($event,$data)
	{
		$type = 'var';
		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new DataDocblock();
			$this->last->setDir($this->dir);
		}
		if ($this->private_class)
		{
			unset($this->last);
			return;
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access == 'private') && (!$this->parsePrivate))
			{
				unset($this->last);
				return;
			}
		}
		$this->last->nopackages();
		$data_type = $this->last->getVarType();
		// set the package directory
		$data->setDir($this->last);
		$this->currentclass['var'][] = 
			array(
				"var_name" => $data->getName(), 
				"var_default" => $data->getValue(), 
				"var_sdesc" => $this->last->getShortDesc()
			);
		$this->currentclass['var_detail'][] = 
			array(
				"var_name" => $data->getName(), 
				"var_type" => $data_type,
				"sdesc" => $this->last->getShortDesc(),
				"desc" => $this->last->getDesc(),
				"inner_loop" => array("docblock" => $this->last->listKeywords())
			);
		unset($this->last);
	}
	
	/**
	* handles rendering of functions and class methods
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataFunction} class
	*/
	function handleFunction($event,$data)
	{
		$type = 'function';
		if (count($this->page) > 0)
		{
			if (!isset($this->page['template']->registered['desc']))
			$this->page['template']->register("desc","");
			if (!isset($this->page['template']->registered['sdesc']))
			$this->page['template']->register("sdesc","");
			$this->output[$this->page['package']][$this->page['name']] = $this->page['template'];
			$this->page = array();
		}

		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new DataDocblock();
			$this->last->setDir($this->dir);
		}
		if ($this->parent != $this->cur_page)
		{
			if ($this->private_class)
			{
				unset($this->last);
				return;
			}
		} else
		{
			if ($this->packageoutput)
			{
				if (!in_array($this->package,$this->packageoutput))
				{
					$this->last = $data;
					$this->private_page = true;
					unset($this->last);
					return;
				}
			}
			if ($this->private_page)
			{
				unset($this->last);
				return;
			}
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access == 'private') && (!$this->parsePrivate))
			{
				unset($this->last);
				return;
			}
		}
		$this->last->nopackages();
		$data->setParent($this->parent);	
		$this->outPage[$this->parent][$this->package] = $this->package;

		$a = '';
		if ($data->getReturnsReference()) $a = '&';
		$function_call = $a.$data->getName() . " ( ";
		$tmp = 0;
		foreach($data->listParams() as $param)
		{
			if ($tmp == 0)
			{
				$tmp = 1;
			} else {
				$function_call .= ", ";
			}
			if (!empty($param[1]))
			{
				$function_call .= "[$param[0] = $param[1]]";
			} else {
				$function_call .= $param[0];
			}
			$update_params[] = $param[0];
		}
		if (isset($update_params))
		$this->last->updateParams($update_params);
		unset($update_params);
		$function_call .= " )";

		$fname = $data->getName();
		if ($this->parent != $this->cur_page)
		{
			if ($data->getName() == $this->parent) $fname = 'constructor '.$data->getName();
		}

		if ($this->parent != $this->cur_page)
		{
			$this->currentclass['function'][] = 
				array(
					"function_name" 	=> $fname, // $data->getName(), 
					"function_sdesc" 	=> $this->last->getShortDesc(),
					"function_return"	=> $this->last->getReturnType(),
					"function_call" 	=> $function_call
				);
				/*
				print_r(array(
					"docblock" => $this->last->listKeywords(),
					"params" => $this->last->listParams()));
				//	*/
			$this->currentclass['function_detail'][] = 
				array(
					"function_name" 	=> $fname, // $data->getName(), 
					"sdesc"		 	=> $this->last->getShortDesc(),
					"function_call" 	=> $function_call,
					"function_return"	=> $this->last->getReturnType(),
					"descmethod"	=> $data->getDescendedMethods(),
					"desc" 			=> $this->last->getDesc(),
					"inner_loop"		=> array(
									"docblock" => $this->last->listKeywords(),
									"params" => $this->last->listParams()
									)
				);
		} else
		{
			$this->current['function'][] = 
				array(
					"function_name" 	=> $fname, // $data->getName(), 
					"function_sdesc" 	=> $this->last->getShortDesc(),
					"function_return"	=> $this->last->getReturnType(),
					"function_call" 	=> $function_call
				);
				/*
				print_r(array(
					"docblock" => $this->last->listKeywords(),
					"params" => $this->last->listParams()));
				//	*/
			$this->current['function_detail'][] = 
				array(
					"function_name" 	=> $fname, // $data->getName(), 
					"sdesc"		 	=> $this->last->getShortDesc(),
					"function_return"	=> $this->last->getReturnType(),
					"descmethod"	=> '',
					"function_call" 	=> $function_call,
					"desc" 			=> $this->last->getDesc(),
					"inner_loop"		=> array(
									"docblock" => $this->last->listKeywords(),
									"params" => $this->last->listParams()
									)
				);
		}

		unset($this->last);
	}
	
	/**
	* handles rendering of constants (defines)
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataDefine} class
	*/
	function handleDefine($event,$data)
	{
		$type = 'define';
		if (count($this->page) > 0)
		{
			if (!isset($this->page['template']->registered['desc']))
			$this->page['template']->register("desc","");
			if (!isset($this->page['template']->registered['sdesc']))
			$this->page['template']->register("sdesc","");
			$this->output[$this->page['package']][$this->page['name']] = $this->page['template'];
			$this->page = array();
		}

		if ($this->packageoutput)
		{
			if (!in_array($this->package,$this->packageoutput))
			{
				$this->private_page = true;
				unset($this->last);
				return;
			}
		}
		if ($this->private_page)
		{
			unset($this->last);
			return;
		}
		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new DataDocblock();
			$this->last->setDir($this->dir);
		}
		$this->last->nopackages();
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access == 'private') && (!$this->parsePrivate))
			{
				unset($this->last);
				return;
			}
		}
		// set the package directory
		$data->setDir($this->last);
		$data->setParent($this->parent);	
		$this->outPage[$this->parent][$this->package] = $this->package;

		$this->current['constant'][] = 
			array(
				"constant_name" => $data->getName(), 
				"constant_value" => $data->getValue(),
				"constant_sdesc" => $this->last->getShortDesc()
			);
		$this->current['constant_detail'][] = 
			array(
				"constant_name" 	=> $data->getName(), 
				"constant_value" 	=> $data->getValue(), 
				"sdesc" 		=> $this->last->getShortDesc(),
				"desc" 			=> $this->last->getDesc(),
				"inner_loop"		=> array("docblock" => $this->last->listKeywords())
			);

		$this->constants[$data->getName()] = array(
			"constant" =>
				array(
					"constant_name" => $data->getName(), 
					"constant_value" => $data->getValue(),
					"constant_sdesc" => $this->last->getShortDesc()
				)
			,
			"constant_detail" =>
				array(
					"constant_name" 	=> $data->getName(), 
					"constant_value" 	=> $data->getValue(), 
					"sdesc" 		=> $this->last->getShortDesc(),
					"desc" 			=> $this->last->getDesc(),
					"inner_loop"		=> array("docblock" => $this->last->listKeywords())
				)
		);
		unset($this->last);
	}
	
	/**
	* handles rendering of classes
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataClass} class
	*/
	function handleClass($event,$data)
	{
		$type = 'class';
		if (empty($this->last))
		{
			// we don't have a docblock, create an empty one to get rid of errors
			$this->last = new DataDocblock();
			$this->last->dir = $GLOBALS['PHPDocumentor_DefaultPackageName'];
		}
		// inherit package
		if (!$this->last->getKeyword('package'))
		{
			$packages = $data->getClassPackage();
			if ($packages)
			{
				$this->last->addKeyword('package',$packages[0]);
				if (!empty($packages[1])) $this->last->addKeyword('subpackage',$packages[1]);
			}
		}
		if ($access = $this->last->getKeyword('access'))
		{
			if (($access == 'private') && (!$this->parsePrivate))
			{
				$this->parent = $data->getName();
				$this->private_class = true;
				unset($this->last);
				return;
			}
		}
		$this->private_class = false;
		// set the package directory
		$data->setDir($this->last);
		// We have a new class, so were going to create a new file
		$template = new Template($this->templateDir,"class.html");
		$this->output[$this->last->getKeyword('package')][$data->getName()] =& $template;
		$template->register("type","Method");
		$template->dir = $data->getDir();

		$this->classdir_level = 1;
		// add this class to the index
		if ($this->last->getKeyword('package'))
		{
			if ($this->packageoutput)
			{
				$p = $this->last->getKeyword('package');
				if (!in_array($p,$this->packageoutput))
				{
//								debug('ignoring class '.$data->getName().', package '.$p);
					$this->parent = $data->getName();
					$this->private_class = true; // use this to prevent parsing of members
					unset($this->last);
					unset($this->output[$p][$data->getName()]);
					return;
				}
			}
			if ($this->last->getKeyword('subpackage'))
			{
				$this->classdir_level = 2;
				$this->index[$this->last->getKeyword('package')][$this->last->getKeyword('subpackage')]['_$class'][] = $data->getName();
			} else {
				$this->index[$this->last->getKeyword('package')]['_$class'][] = $data->getName();
			}
		} else {
			if ($this->packageoutput)
			{
				if (!in_array($GLOBALS['PHPDocumentor_DefaultPackageName'],$this->packageoutput))
				{
					$this->parent = $data->getName();
					$this->private_class = true; // use this to prevent parsing of members
					unset($this->last);
					return;
				}
			}
			$this->index[$GLOBALS['PHPDocumentor_DefaultPackageName']]['_$class'][] = $data->getName();
		}

		// Register Nothing to variable that might not be set latter
		//$template->register("vars",array());
		//$template->register("var_detail",array());
		//$template->register("functions",array());
		//$template->register("function_detail",array());
		$a = '../classtrees_';
		if ($this->last->getKeyword('subpackage') != '') $a = "../$a";
		
		$template->register("title","Docs For Class " . $data->getName());
		$template->register("page",$data->getName() . $this->outputExt);
		$template->register("class_name",$data->getName());
		$template->register("sdesc",$this->last->getShortDesc());
		$template->register("package",$a.$this->last->getKeyword('package'));
		$template->register("desc",$this->last->getDesc());
		$template->register("docblock",$this->last->listKeywords());

		$template->register("children", $data->getChildClassList());
		$template->register("class_tree", $data->getClassTree());
		
		$template->register("source_location",$data->getSourceLocation());
		$template->register("date",date("r",time()));

		$this->classpackage = $this->last->getKeyword('package');
		$this->parent = $data->getName();
		$this->outPage[$this->parent][$this->classpackage] = $this->classpackage;

		$inherited_vars = $data->getInheritedVars();
		if (!empty($inherited_vars))
		{
			$template->register("vars_inherited",$inherited_vars);
		}
		$inherited_methods = $data->getInheritedMethods();
		if (!empty($inherited_methods))
		{
			$template->register("inherited_functions",$inherited_methods);
		}
		unset($this->last);
	}
	
	/**
	* handles rendering of procedural pages
	* this event is called at the start of a new page, before the Parser knows whether the
	* page will contain any procedural pages or not
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataPage} class
	*/
	function handlePage($event,$data)
	{
		$type = 'page';
		if (count($this->page) > 0)
		{
			if (!isset($this->page['template']->registered['desc']))
			$this->page['template']->register("desc","");
			if (!isset($this->page['template']->registered['sdesc']))
			$this->page['template']->register("sdesc","");
			$this->output[$this->page['package']][$this->page['name']] = $this->page['template'];
			$this->page = array();
		}
		$this->packageoutput = $data->getPackageOutput();
		$this->private_page = false;
		// Create a new template, this is where non class stuff goes
		$this->page['template'] = new Template($this->templateDir,"page.html");
		if (isset($this->dir))
		$this->page['template']->dir = $this->dir;
		
		// Setting stuff about the page
		$this->file = "_" . $data->getName() . $this->outputExt;
		$this->page_path = $data->getPath();
		$this->parent = $this->cur_page = $this->page['name'] = "_" . $data->getName();
		$this->outPage[$this->parent][$GLOBALS['PHPDocumentor_DefaultPackageName']] = $this->package
		= $this->page['package'] = $this->page['template']->dir = $GLOBALS['PHPDocumentor_DefaultPackageName'];
		$this->index[$GLOBALS['PHPDocumentor_DefaultPackageName']]['_$pro'][] =  $this->page['name'];
		$this->dir_level = 1;

		// registering stuff on the template
		$this->page['template']->register("source_location",$data->getSourceLocation());
		$this->page['template']->filename = $data->getFile();
		$this->page['template']->register("date",date("r",time()));
		$this->page['template']->register("type","Function");
		$this->page['template']->register("classes",$data->getClasses());
		$this->page['template']->register("page",$this->file);
		$this->page['template']->register("title","Docs on page $this->file");
	}
	
	/**
	* handles rendering of DocBlocks
	* @param integer $event Event number from {@link Parser.inc}
	* @param class $data $data is a {@link DataDocBlock} class
	*/
	function handleDocBlock($event,$data)
	{
		$type = 'docblock';
		if ($this->lasttype == "docblock" && isset($this->page['template']))
		{
			if ($this->last->getKeyword('package'))
			{
				if ($this->packageoutput)
				{
					$p = $this->last->getKeyword('package');
					if (!in_array($p,$this->packageoutput))
					{
						$this->last = $data;
						$this->private_page = true;
						unset($this->output[$this->package][$this->parent]);
						unset($this->outPage[$this->parent][$this->package]);
						unset($data);
						return;
					}
				}
			}
			$a = $this->last->getShortDesc();
			if (!is_string($a)) $a = '';
			$this->page['template']->register("sdesc",$a);
			$a = $this->last->getDesc();
			if (!is_string($a)) $a = '';
			$this->page['template']->register("desc",$a);
			unset($a);
			$this->page['template']->register("docblock",$this->last->listKeywords());
			$this->page['template']->register("name", (( is_null($this->last->getKeyword('name')) ) ? $this->file : $this->last->getKeyword('name')) ); // fc@fc.clever-soft.com

			// add this procedural page to the index
			if ($this->last->getKeyword('package'))
			{
				if ($this->packageoutput)
				{
					$p = $this->last->getKeyword('package');
					if (!in_array($p,$this->packageoutput))
					{
						$this->last = $data;
						$this->private_page = true;
						unset($data);
						$this->page = array();
						return;
					}
				}
				$this->dir = $this->package = $this->last->getKeyword('package');
				$a = array_flip($this->index[$GLOBALS['PHPDocumentor_DefaultPackageName']]['_$pro']);
				unset($this->index[$GLOBALS['PHPDocumentor_DefaultPackageName']]['_$pro'][$a[$this->page['name']]]);

				if ($this->last->getKeyword('subpackage'))
				{
					$this->dir_level = 2;
					$this->dir .= PATH_DELIMITER . $this->subpackage = $this->last->getKeyword('subpackage');
					$this->index[$this->last->getKeyword('package')][$this->last->getKeyword('subpackage')]['_$pro'][] = $this->page['name'];
				} else {
					$this->index[$this->last->getKeyword('package')]['_$pro'][] =  $this->page['name'];
				}
			} else
			{
				$this->dir = $GLOBALS['PHPDocumentor_DefaultPackageName'];
				$this->package = $GLOBALS['PHPDocumentor_DefaultPackageName'];
				$this->page['template']->register("desc","");
				$this->page['template']->register("sdesc","");
			}
			$this->page['template']->dir = $this->dir;
			$this->output[$this->package][$this->page['name']] = $this->page['template'];
			$this->page = array();
		}
		$this->last = $data;
	}
	
	// $data is always a class from DataTypes
	function HandleEvent($event,$data)
	{
		if ($event == PHPDOC_EVENT_NEWSTATE)
		{
			if ($data == STATE_END_CLASS)
			{
				$this->registerCurrentClass();
				$this->private_class = false;
				$this->parent = $this->cur_page;
			} elseif ($data == PHPDOC_EVENT_END_PAGE)
			{
				if (count($this->page) > 0)
				{
					if (!isset($this->page['template']->registered['desc']))
					$this->page['template']->register("desc","");
					if (!isset($this->page['template']->registered['sdesc']))
					$this->page['template']->register("sdesc","");
					$this->output[$this->package][$this->page['name']] = $this->page['template'];
					$this->page = array();
				}
				$this->registerCurrent();
				$this->private_page = false;
			}
			//echo $this->state_lookup[$data] . "\n";
			//echo $data."\n";
		} 
		 else 
		{
			$this->lasttype = $this->type;
			$type = $data->getType();
			$this->type = $type;
			//echo $type . "\n";
			
			if (isset($this->event_handlers[$type]))
			{
				$handle = $this->event_handlers[$type];
				$this->$handle($event,$data);
			}
		}
	}

	/**
	* Registers anything that is being stored in $this->current, sorts them first
	*/
	function registerCurrent()
	{
//		if (isset($this->registered[$this->parent])) return;
//		$this->registered[$this->parent] = 1;
		if ($this->parent != $this->cur_page) $this->registerCurrentClass();
		if (!isset($this->output[$this->package][$this->parent])) return;
		if (!empty($this->current['constant']))
		{
			$this->rcnatcmpkey = "constant_name";
			uasort($this->current['constant'],array($this,"rcNatCmp"));
			$this->output[$this->package][$this->parent]->register("constants",$this->current['constant']);
		}
		if (!empty($this->current['constant_detail']))
		{
			$this->rcnatcmpkey = "constant_name";
			uasort($this->current['constant_detail'],array($this,"rcNatCmp"));
			$this->output[$this->package][$this->parent]->register("constant_detail",$this->current['constant_detail']);
		}
		if (!empty($this->current['function']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->current['function'],array($this,"rcNatCmp"));
			$this->output[$this->package][$this->parent]->register("functions",$this->current['function']);
		}
		if (!empty($this->current['include']))
		{
			$this->output[$this->package][$this->parent]->register("includes",$this->current['include']);
		}
		if (!empty($this->current['include_detail']))
		{
			$this->output[$this->package][$this->parent]->register("include_detail",$this->current['include_detail']);
		}
		if (!empty($this->current['function_detail']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->current['function_detail'],array($this,"rcNatCmp"));
//			print_r($this->current['function_detail']);
			$this->output[$this->package][$this->parent]->register("function_detail",$this->current['function_detail']);
		}
		unset($this->current);
	}
	
	function registerCurrentClass()
	{
		if (!empty($this->currentclass['function']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->currentclass['function'],array($this,"rcNatCmp1"));
			$this->output[$this->classpackage][$this->parent]->register("functions",$this->currentclass['function']);
		}
		if (!empty($this->currentclass['function_detail']))
		{
			$this->rcnatcmpkey = "function_name";
			uasort($this->currentclass['function_detail'],array($this,"rcNatCmp1"));
		//	print_R($this->current['function_detail']);
			$this->output[$this->classpackage][$this->parent]->register("function_detail",$this->currentclass['function_detail']);
		}
		if (!empty($this->currentclass['var']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->currentclass['var'],array($this,"rcNatCmp"));
			$this->output[$this->classpackage][$this->parent]->register("vars",$this->currentclass['var']);
		}
		if (!empty($this->currentclass['var_detail']))
		{
			$this->rcnatcmpkey = "var_name";
			uasort($this->currentclass['var_detail'],array($this,"rcNatCmp"));
			$this->output[$this->classpackage][$this->parent]->register("var_detail",$this->currentclass['var_detail']);
		}
		unset($this->currentclass);
		$this->parent = $this->cur_page;
	}

	/**
	* does a nat case sort on the specified second level value of the array
	*
	* @param	mixed	$a
	* @param	mixed	$b
	* @return	int
	*/
	function rcNatCmp ($a, $b)
	{
		$aa = strtoupper($a[$this->rcnatcmpkey]);
		$bb = strtoupper($b[$this->rcnatcmpkey]);
		
		return strnatcasecmp($aa, $bb);
	}
	
	/**
	* does a nat case sort on the specified second level value of the array.
	* this one puts constructors first
	*
	* @param	mixed	$a
	* @param	mixed	$b
	* @return	int
	*/
	function rcNatCmp1 ($a, $b)
	{
		$aa = strtoupper($a[$this->rcnatcmpkey]);
		$bb = strtoupper($b[$this->rcnatcmpkey]);
		
		if (strpos($aa,'CONSTRUCTOR') === 0)
		{
			return -1;
		}
		if (strpos($bb,'CONSTRUCTOR') === 0)
		{
			return 1;
		}
		if (strpos($aa,strtoupper($this->parent)) === 0)
		{
			return -1;
		}
		if (strpos($bb,strtoupper($this->parent)) === 0)
		{
			return -1;
		}
		return strnatcasecmp($aa, $bb);
	}
	
	function setClassTree($package,$classtree)
	{
		$this->formatted_trees[$package] = $classtree;
	}

	function setPkgIndexes($p)
	{
		$this->pkg_indexes = $p;
	}
	
	function setIndex($i)
	{
		$this->indexes = $i;
	}
	
	/** this is where we handle sorting stuff and adding inheirentance information to pages */
	function PreOutput ($title = "Generated Documentation")
	{
		// Create element index page
		list($elindex,$mletters) = $this->indexes;
		$this->output['::']['elementindex'] = new Template($this->templateDir,"elementindex.html");
		$this->output['::']['elementindex']->register("elementindex",$elindex);
		$this->output['::']['elementindex']->register("letters",$mletters);
		$this->output['::']['elementindex']->register("title","Element Index");
		$this->output['::']['elementindex']->register("page","elementindex.html");
		
		list($package_indexes,$packages,$mletters) = $this->pkg_indexes;
		$this->output['::']['elementindex']->register("packageindexes",$packages);
		$this->outPage['elementindex']['::'] = '::';
		for($i=0;$i<count($package_indexes);$i++)
		{
			$template = new Template($this->templateDir,"pkgelementindex.html");
			$this->output['::']['elementindex_'.$package_indexes[$i]['package']] = $template;
			$this->output['::']['elementindex_'.$package_indexes[$i]['package']]->register("pindex",$package_indexes[$i]['inner_loop']['pindex']);
			$this->output['::']['elementindex_'.$package_indexes[$i]['package']]->register("package",$package_indexes[$i]['package']);
			$this->output['::']['elementindex_'.$package_indexes[$i]['package']]->register("letters",$mletters[$package_indexes[$i]['package']]);
			$this->outPage['elementindex_'.$package_indexes[$i]['package']]['::'] = '::';
		}

		reset($this->index);
		// Created index.html
		$index = new Template($this->templateDir,"index.html");
		$this->output['::']['index'] =& $index;
		
		$index->register("date",date("r",time()));
		$index->register("title",$title);
		list($start,) = each($this->index);
		$index->register("start","li_$start" . $this->outputExt);
		if ($start != $GLOBALS['PHPDocumentor_DefaultPackageName'])
		{
			if (isset($this->outPage['package_' . $start]) && $this->outPage['package_' . $start])
			{
				$index->register("blank",$start. PATH_DELIMITER . 'package_'.$start);
			}
			else
			{
				$index->register("blank","blank");
			}
		} else
		{
			$index->register("blank","blank");
		}

		/*
		if (is_array($nonclass_index))
		{
			uksort($nonclass_index,"strnatcasecmp");
		}
		if (is_array($class_index))
		{
			uksort($class_index,"strnatcasecmp");
		}
		*/

		ksort($this->index);
		foreach($this->index as $key => $val)
		{
			$package_index[$key] = array('link' => "li_$key". $this->outputExt, 'title' => $key);
		}
		if (!isset($package_index)) $package_index = array();
		//uksort($package_index,"strnatcasecmp");

		// Create package index
		$package = new Template($this->templateDir,"packages.html");
		$package->register("date",date("r",time()));
		$package->register("packages",$package_index);

		$this->output['::']['packages'] = $package;

		// create indexes for each package
		foreach($this->index as $key => $val)
		{
			unset($nonclass_index);
			unset($class_index);
			unset($subpackage_index);
			// loop through subpackages and classes in package
			foreach($val as $ikey => $ival)
			{
				if ($ikey == '_$pro')
				{
					if (is_array($ival))
					foreach($ival as $cval)
					{
						if (isset($this->outPage[$cval]))
						{
							foreach($this->outPage[$cval] as $i)
							{
								if ($i == $key)
								$nonclass_index[] = array("link" => $this->output[$i][$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $this->output[$i][$cval]->filename);
							}
						}
					}
				} 
				else if ($ikey == '_$class')
				{
					foreach($ival as $cval)
					{
						foreach($this->outPage[$cval] as $i)
						{
							if ($i == $key)
							$class_index[] = array("link" => $this->output[$i][$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $cval);
						}
					}
				} 
				else 
				{
					$tpro = array();
					$tclass = array();
					foreach($ival as $iikey => $iival)
					{
						if ($iikey == '_$pro')
						{
							foreach($iival as $cval)
							{
								if (isset($this->outPage[$cval]))
								{
									foreach($this->outPage[$cval] as $i)
									{
										if ($i == $key)
										$tpro[] = array("link" => $this->output[$i][$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $this->output[$i][$cval]->filename);
									}
								}
							}
						} 
						else if ($iikey == '_$class')
						{
							foreach($iival as $cval)
							{
								foreach($this->outPage[$cval] as $i)
								{
									if ($i == $key)
									$tclass[] = array("link" => $this->output[$i][$cval]->dir.PATH_DELIMITER.$cval . $this->outputExt, "title" => $cval);
								}
							}
						}
					}
					if (is_array($tpro))
					{
						usort($tpro,"indexsort");
					}
					if (is_array($tclass))
					{
						usort($tclass,"indexsort");
					}
					$subpackage_index[] = array("subpackage" => $ikey, 
						"inner_loop" => array("classes" => $tclass,"procedural" => $tpro));
				}
			}

			if (!isset($subpackage_index)) $subpackage_index = false;
			if (!isset($class_index)) $class_index = false;
			if (!isset($nonclass_index)) $nonclass_index = false;
			
			if (is_array($nonclass_index))
			{
				usort($nonclass_index,"indexsort");
			}
			if (is_array($class_index))
			{
				usort($class_index,"indexsort");
			}

			$this->output['::']["li_$key"] = new Template($this->templateDir,"left.html");
			$this->output['::']["li_$key"]->register("date",date("r",time()));
			$this->output['::']["li_$key"]->register("nonclass",$nonclass_index);
			$this->output['::']["li_$key"]->register("class",$class_index);
			$this->output['::']["li_$key"]->register("subpackages",$subpackage_index);
			$this->output['::']["li_$key"]->register("packagename",$key);
			$this->output['::']["li_$key"]->register("phpdocversion",PHPDOC_VER);
			$this->output['::']["li_$key"]->register("phpdocwebsite",PHPDOC_WEBSITE);
			if (isset($this->output[$key]['package_'.$key]))
			{
				$this->output['::']["li_$key"]->register("packagedoc",'<a target="right" href="' . $key . PATH_DELIMITER . 'package_' . $key . $this->outputExt . '">'.$key.' Package-level Docs</a><br>');
			} else
			{
				$this->output['::']["li_$key"]->register("packagedoc","");
			}
			$this->output['::']["li_$key"]->register("classtreepage","classtrees_$key");
			$this->output['::']["li_$key"]->register("elementindex","elementindex_$key");

			$this->outPage["li_$key"] = '::';

			// Create class tree page
			$this->output['::']["classtrees_$key"] = new Template($this->templateDir,"classtrees.html");
			if (isset($this->formatted_trees[$key]))
			$this->output['::']["classtrees_$key"]->register("classtrees",$this->formatted_trees[$key]);
			else
			$this->output['::']["classtrees_$key"]->register("classtrees",'');
			$this->output['::']["classtrees_$key"]->register("package",$key);
			$this->output['::']["classtrees_$key"]->register("title","Class Trees for Package $key");
			$this->outPage["classtrees_$key"] = '::';
		}

		

		// Create constants page
/*		$this->output['constants'] = new Template($this->templateDir,"constant.html");
		
		// Natural Order constants by name
		uksort($this->constants,"strnatcasecmp");

		if (!isset($this->constants['constant'])) $this->constants['constant'] = false;
		if (!isset($this->constants['constant_detail'])) $this->constants['constant_detail'] = false;
		// Register constants
		$this->output['constants']->register("constants",$this->constants['constant']);
		$this->output['constants']->register("constant_detail",$this->constants['constant_detail']);
*/

		$this->outPage['index'] = '::';
		$this->outPage['packages'] = '::';
//		$this->outPage['constants'] = 1;
	}

	function Output ($title = "Generated Documentation")
	{
		$this->registerCurrent();
		$this->PreOutput($title);
		$wroteto = array();
		$target = $this->targetDir;
		// Thanks to Robert Hoffmann (half-dead on sf.net) for fix below
		$ignore = array(".",".."); 
		$d = dir($this->templateDir); 
		$template_images = array();
		while($entry = $d->read())
		{
			if ( !in_array($entry, $ignore) )
			{
				$sp = explode(".", $entry); 
				if ( preg_match("/\.(gif|jpg|png)$/i", $entry) )
				{
					$template_images[] = $entry;
				}
			}
		}
		// Thanks to Robert Hoffmann ^^
		foreach($this->output as $package => $output)
		{
			foreach($output as $page => $data)
			{
				if (isset($this->outPage[$page]) && $this->outPage[$page])
				{
					if (isset($data->dir)) $data->dir .= SMART_PATH_DELIMITER; else $data->dir = '';
					$this->setTargetdir($target.SMART_PATH_DELIMITER.$data->dir);
					if (!empty($data->dir) && !isset($wroteto[$target.SMART_PATH_DELIMITER.$data->dir]))
					{
						$wroteto[$target.SMART_PATH_DELIMITER.$data->dir] = 1;
						if ( $this->quietMode === false ) 
						{
							echo "Writing stylesheet.css to ".$target.SMART_PATH_DELIMITER.$data->dir."\n";
						}
						$this->copyFile("stylesheet.css");
						if ( $this->quietMode === false ) 
						{
							echo "Copying Any Template Images to ".$target.SMART_PATH_DELIMITER.$data->dir."\n";
						}
						foreach($template_images as $image)
						{
							if (file_exists($this->templateDir.$image))
							{
								phpdoc_out("Writing $image\n");
								$this->copyFile($image);
							}
						}
						foreach($template_images as $image)
						{
							if (file_exists($this->templateDir.$image))
							{
								$this->writeFile($image,implode("",file($this->templateDir.$image)));
							}
						}
					}
					if ( $this->quietMode == false ) 
					{
						echo "Writing ".$this->targetDir."$page$this->outputExt\n";
					}
					$this->writeFile($page . $this->outputExt,$data->ret());
				}
			}
		}

		$this->setTargetdir($target);
		if ( $this->quietMode === false ) 
		{
			phpdoc_out("Writing stylesheet.css\n");
		}
		$this->copyFile("stylesheet.css");
//		$this->writeFile("stylesheet.css",implode("",file($this->templateDir."/stylesheet.css"))); // fc@fc.clever-soft.com
		if ( $this->quietMode === false ) 
		{
			phpdoc_out("Writing blank.html\n");
		}
		$blank  = <<< EOF
<html><head></head>
<body>
<b>Welcome to PHPDocumentor!</b><br>
<br>
To begin, click a Package name in the upper left, or a class or procedural page on the lower left
</body></html>
EOF;
		$this->writeFile("blank.html",$blank);
		if ( $this->quietMode === false ) 
		{
			echo "Copying Any Template Images\n";
		}
		foreach($template_images as $image)
		{
			if (file_exists($this->templateDir.$image))
			{
				phpdoc_out("Writing $image\n");
				$this->copyFile($image);
			}
		}
	}

	/** Sets the output directory of create
	*  @param $dir the output directory
	*/
	function setTargetDir($dir)
	{
		if (strlen($dir) > 0) 
		{
			$this->targetDir = $dir;
			// if directory does exist create it, this should have more error checking in the future
			if (!file_exists($dir))
			{
				$tmp = str_replace(array("/","\\"),SMART_PATH_DELIMITER,$dir);
				if (substr($tmp,-1) == SMART_PATH_DELIMITER)
				{
					$tmp = substr($tmp,0,(strlen($tmp)-1));
				}
				$tmp = explode(SMART_PATH_DELIMITER,$tmp);
				array_pop($tmp);
				$parent = implode(SMART_PATH_DELIMITER,$tmp);
				if (!file_exists($parent))
				{
					echo "Creating Parent Directory $parent\n";
					mkdir($parent,0775);
				}
				echo "Creating Directory $dir\n";
				mkdir($dir,0775);
			} 
			 else if (!is_dir($dir))
			{
				echo "Output path: '$dir' is not a directory\n";
				die();
			}
		} else {
			echo "a target directory must be specified\n try phpdoc -h\n";
			die();
		}
	}

	/**
	* Set template dir
	*
	* @param	string	$dir
	*/
	function setTemplateDir($dir)
	{
		$this->templateDir = $dir;
	}

	/**
	 * set mode (quiet or verbose)
	 *
	 * @param	bool $quietMode
	 */
	function setQuietMode($quietMode) {
		$this->quietMode = $quietMode;
	}
	
	/**
	* set parsing (on or off)
	*
	* @param	bool $parse
	*/
	function setParsePrivate($parse)
	{
		$this->parsePrivate = $parse;
	}

	/**
	* Writes a file to target dir
	*/
	function writeFile($file,$data)
	{
		if (!file_exists($this->targetDir))
		{
			mkdir($this->targetDir,0775);
		}
		$fp = fopen($this->targetDir . PATH_DELIMITER . $file,"w");
		set_file_buffer( $fp, 0 );
		fwrite($fp,$data,strlen($data));
		fclose($fp);
	}
	
	/**
	* thanks to Robert Hoffmann for this fix
	*/
	function copyFile($file)
	{
		if (!file_exists($this->targetDir))
		{
			mkdir($this->targetDir,0775); 
		}
		copy($this->templateDir . $file, $this->targetDir . PATH_DELIMITER . $file); 
	} 
}

?>
