<?php
/**
* @package phpDocumentor
*/
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/** Debugging output */
function debug($s)
{
	echo "$s\n";
}

/** Debug Constant */
define("DEBUG",false);	// set to true to get debug output from the parser

// fix from David Norman, make things work with non-standard php.ini settings
//ini_set('register_argc_argv',1);
ini_set('register_globals',1);

if (isset($_SERVER['argv']))
{
	$argv = $_SERVER['argv'];
	$argc = $_SERVER['argc'];
}
// Include all needed files
require("Io.inc");
require("Template.inc");
require("Publisher.inc");
require("Render.inc");
require("Classes.inc");
require("IntermediateParser.inc");
require("WordParser.inc");
require("EventStack.inc");
require("DataTypes.inc");
require("ParserData.inc");
require("Parser.inc");
require("LinkClasses.inc");
require("Converter.inc");
require("Errors.inc");


// set runtime to a large value since this can take quite a while
set_time_limit(0);	// six minute timeout
ini_set("memory_limit","64M");
$parse_start_time = time();
define('SMART_PATH_DELIMITER', (substr(PHP_OS, 0, 3) == 'WIN') ? '\\' : '/' ); // set the correct path delimiter
// we just replace all the \ with / so that we can just operate on /
define('PATH_DELIMITER', '/' ); // set the correct path delimiter
$PHPDOC_PHPFILE_EXTS = array("php","php3","phtml","inc","php4");
// html tags that will not be escaped in docblocks
$PHPDOC_HTML_ALLOWED
	= array("ul",
			"ol",
			"li",
			"dt",
			"dd",
			"dl",
			"p",
			"br",
			"blockquote",
			"hr",
			"img",
			"font",
			"sub",
			"sup",
			"b",
			"i",
			"em",
			"strong",
			"pre",
			"a",
			"code",
			);

$PHPDOC_TAGS_ALLOWED
	= array("abstract",
			"access",
			"author",
			"copyright",
			"deprec",
			"deprecated",
			"exception",
			"global",
			"link",
			"magic",
			"name",
			"package",
			"param",
			"return",
			"returns", // alias for @return
			"see",
			"since",
			"static",
			"subpackage",
			"throws",
			"todo",
			"TODO",
			"var",
			"version",
			// compat tags, things wont parse right in incorrectly documented code without them
			// hopefully better error handling in handleDockeyword allows these to go away
			"extends", // this is a dumb tag included for pear compatability see bug# 558028
			"private", // see above
			"public"   // see above	
			);

$PHPDOC_INLINETAGS_ALLOWED
	= array("link");

$___htmltemp = array_flip($PHPDOC_HTML_ALLOWED);
$___html1 = array();
foreach($___htmltemp as $tag => $trans)
{
	$___html1['<'.$tag.'>'] = htmlentities('<'.$tag.'>');
	$___html1['</'.$tag.'>'] = htmlentities('</'.$tag.'>');
	$___html = array_flip($___html1);
}
unset($___htmltemp);
unset($___html1);

// This function lives here cause i don't know howto make uksort call a function in a class
// use a array like array($this,allUCstrCmp) to do this call from the class, but i don't know where the call comes from anywmore
function allUCstrCmp ($a, $b) {   
	$a = strtoupper($a);
	$b = strtoupper($b);
	return strcmp($a,$b); 
}


// create new classes
$setup = new Io;
$parse = new Parser;
//$linker = new Linker;
$render = new IntermediateParser;
//$linker->setRenderer(&$render);

/**
* Returns a formatted var_dump for debugging purposes.
* @param string $s string to display
* @param mixed $v variable to display with var_dump()
* @param mixed $v... unlimited number of additional variables to display with var_dump()
*/
function fancy_debug($s,$v)
{
	if (isset($GLOBALS['dont_debug']) && $GLOBALS['dont_debug']) return;
	debug($s."\n\n</pre><blockquote><pre>");
	var_dump($v);
	if (func_num_args()>2)
	{
		for($i=2;$i<func_num_args();$i++)
		{
			$a = func_get_arg($i);
//			debug(" ");
			var_dump($a);
		}
	}
	debug("</pre></blockquote><pre>\n\n");
}

if (isset($_POST))
{
	if (isset($_POST['interface'])) $interface = $_POST['interface'];
	if (isset($_POST['setting'])) $setting = $_POST['setting'];
}


function phpdoc_out($string)
{
	global $setting;
	if (!isset($setting['quiet']) || !$setting['quiet']) print $string;
}

error_reporting(E_ALL);

// subcribe $render class to $parse class events
if (!isset($interface) && !isset($_POST['interface']))
{
	// Parse the argv settings
	$setting = $setup->parseArgv();
}
if (!isset($setting['junk'])) $setting['junk'] = '';
if (!isset($setting['title'])) $setting['title'] = 'Generated Documentation';
if (isset($setting['help']) || $setting['junk'] == "-h" || $setting['junk'] == "--help")
{
	echo $setup->displayHelpMsg();
	die();
}

if (!isset($setting['hidden'])) $setting['hidden'] = 'off';
if (!isset($ignore_dirs)) $ignore_dirs = false;

// set to parse elements marked private with @access private
if (isset($setting['parseprivate']) && $setting['parseprivate'] == 'on')
{
	$render->setParsePrivate(true);
}

if (isset($setting['converters']) && !empty($setting['converters']))
{
	$c = explode(',',$setting['converters']);
	for($i=0; $i< count($c); $i++)
	{
		$render->addConverter(trim($c[$i]));
	}
} else
{
	$render->addConverter('HTMLConverter');
}
if (empty($render->converters)) addErrorDie(PDERROR_NO_CONVERTERS);

$GLOBALS['PHPDocumentor_DefaultPackageName'] = 'default';

// set to change the default package name from "default" to whatever you want
if (isset($setting['defaultpackagename']))
{
	$GLOBALS['PHPDocumentor_DefaultPackageName'] = trim($setting['defaultpackagename']);
}

// set the mode (quiet or verbose)
if ( isset($setting['quiet']) || strcasecmp($setting['junk'], "-q") == 0 || strcasecmp($setting['junk'], "--quiet") == 0) 
{
	$render->setQuietMode(true);
}

// Setup the different classes
if (isset($setting['target']))
{
	$render->setTargetDir($setting['target']);
}
else
{
	echo "a target directory must be specified\n try phpdoc -h\n";
	die();
}
	

if (!file_exists($setting['template']))
{
	die("Template Directory '$setting[template]' does not exists, please check template path you are passing phpdoc\n");
}
else
{
	// make sure it has a / on the end
	$setting['template'] = str_replace("\\","/",$setting['template']);
	if (substr($setting['template'],-1) != "/")
	{
		$setting['template'] .= "/";
	}
}
$render->setTemplateDir($setting['template']);

// setup ignore  list
$ignore_files =array();
if(isset($setting['ignore']))
{
	if (strstr($setting['ignore'],","))
	{
		$ignore_files = explode(",",$setting['ignore']);
	} else {
		$ignore_files = array($setting['ignore']);
	}
}

$packages = false;
if (!empty($setting['packageoutput']))
{
	$packages = explode(",",$setting['packageoutput']);
}

for($count = 1; $count < 2;$count++)
{
	switch($count)
	{
		case 0:
			$parse->subscribe("*",$linker);
			phpdoc_out("\n\nCreate Inheritance Trees and @see lookup tables\n\n");
			flush();
		break;
		case 1:
			phpdoc_out("\n\nGeneral Parsing Stage\n\n");
			flush();
			$parse->subscribe("*",$render);
		break;
	}
	// parse the directory
	if (!empty($setting['filename']))
	{
		$files = explode(",",$setting['filename']);
		foreach($files as $file)
		{
			$file = trim($file);
			$test = $setup->getAllFiles($file);
			if ($test)
			{
				foreach($test as $file)
				{
					$dir = dirname($file);
					$dir = strtr($dir, "\\", "/");
					$dir = str_replace('//','/',$dir);
					// strip trailing directory seperator
					if (substr($dir,-1) == "/" || substr($dir,-1) == "\\")
					{
						$dir = substr($dir,0,-1);
					}
					$base = count(explode("/",$dir));
					$file = strtr($file, "\\", "/");
					$file = str_replace('//','/',$file);
					phpdoc_out("Parsing file $file");
					flush();
		
					if (!$setup->checkIgnore(basename($file),dirname($file),$ignore_files))
					{
						$parse->parse($setup->readPhpFile($file, $render->quietMode),str_replace('\\','/',$file),$base,$packages);
					} else {
						phpdoc_out(" File Ignored\n");
					}
				}
			} else
			{
				$dir = dirname($file);
				$dir = strtr($dir, "\\", "/");
				$dir = str_replace('//','/',$dir);
				// strip trailing directory seperator
				if (substr($dir,-1) == "/" || substr($dir,-1) == "\\")
				{
					$dir = substr($dir,0,-1);
				}
				$base = count(explode("/",$dir));
				$file = strtr($file, "\\", "/");
				$file = str_replace('//','/',$file);
				phpdoc_out("Parsing file $file");
				flush();
	
				if (!$setup->checkIgnore(basename($file),dirname($file),$ignore_files))
				{
					$parse->parse($setup->readPhpFile($file, $render->quietMode),str_replace('\\','/',$file),$base,$packages);
				} else {
					phpdoc_out(" File Ignored\n");
				}
			}
		}
	}

	if (!empty($setting['directory']))
	{
		$dirs = explode(",",$setting['directory']);
		foreach($dirs as $dir)
		{
			$dir = strtr($dir, "\\", "/");
			$dir = str_replace('//','/',$dir);
			// strip trailing directory seperator
			if (substr($dir,-1) == "/" || substr($dir,-1) == "\\")
			{
				$dir = substr($dir,0,-1);
			}
			$base = count(explode("/",$dir));

			$files = $setup->dirList($dir,$setting['hidden']);
			if (is_array($files))
			{
				foreach($files as $file)
				{
					// Make sure the file isn't a hidden file
					$file = strtr($file, "\\", "/");
					$test = array_pop(explode("/",$file));
					if (substr($test,0,1) != ".") 
					{
						if ( $render->quietMode === false ) 
						{
							phpdoc_out("Reading file $file");
							flush();
						}
						if (!$setup->checkIgnore(basename($file),str_replace('\\','/',dirname($file)),$ignore_files))
						{
							$parse->parse($setup->readPhpFile($file),str_replace('\\','/',$file),$base,$packages);
						} else {
							phpdoc_out(" File Ignored\n");
						}
					}
				}
			}
		}
	}
}

// render output
phpdoc_out("\nConverting From Abstract Parsed Data\n");
$render->output($setting['title']);
$a = (time() - $parse_start_time);
phpdoc_out("\nTotal Documentation Time: $a seconds\n");
?>
