<?php
//
// +------------------------------------------------------------------------+
// | phpDocumentor                                                          |
// +------------------------------------------------------------------------+
// | Copyright (c) 2000-2003 Joshua Eichorn, Gregory Beaver                 |
// | Email         jeichorn@phpdoc.org, cellog@phpdoc.org                   |
// | Web           http://www.phpdoc.org                                    |
// | Mirror        http://phpdocu.sourceforge.net/                          |
// | PEAR          http://pear.php.net/package-info.php?pacid=137           |
// +------------------------------------------------------------------------+
// | This source file is subject to version 3.00 of the PHP License,        |
// | that is available at http://www.php.net/license/3_0.txt.               |
// | If you did not receive a copy of the PHP license and are unable to     |
// | obtain it through the world-wide-web, please send a note to            |
// | license@php.net so we can mail you a copy immediately.                 |
// +------------------------------------------------------------------------+
//
/**
 * Helper class, extension to ezpdf
 * @package Converters
 * @subpackage PDFdefault
 */

/** ezPdf libraries */
include_once 'phpDocumentor/Converters/PDF/default/class.ezpdf.php';
include_once 'phpDocumentor/Converters/PDF/default/ParserPDF.inc';

// define a class extension to allow the use of a callback to get the table of
// contents, and to put the dots in the toc
/**
 * @package Converters
 * @subpackage PDFdefault
 */
class phpdocpdf extends Cezpdf
{
    var $reportContents = array();
    var $indexContents = array();
    var $indents = array();
    var $font_dir = false;
    var $set_pageNumbering = false;
    var $converter;
    var $_save = '';

    function phpdocpdf(&$pdfconverter,$fontdir,$paper='a4',$orientation='portrait')
    {
        Cezpdf::Cezpdf($paper,$orientation);
        $this->converter = $pdfconverter;
        $this->font_dir = $fontdir;
    }
    
    function rf($info)
    {
        $tmp = $info['p'];
        $lvl = $tmp[0];
        $lbl = rawurldecode(substr($tmp,1));
        $num=$this->ezWhatPageNumber($this->ezGetCurrentPageNumber());
        $this->reportContents[] = array($lbl,$num,$lvl );
        $this->addDestination('toc'.(count($this->reportContents)-1),'FitH',$info['y']+$info['height']);
    }
    
    function index($info)
    {
        $res = explode('|||',rawurldecode($info['p']));
        $name = $res[0];
        $descrip = $res[1];
        $letter = $name[0];
        if ($letter == '$') $letter = $name[1];
        $this->indexContents[strtoupper($letter)][] = array($name,$descrip,$this->ezWhatPageNumber($this->ezGetCurrentPageNumber()),count($this->reportContents) - 1);
    }
    
    function IndexLetter($info)
    {
        $letter = $info['p'];
        $this->transaction('start');
        $ok=0;
        while (!$ok){
          $thisPageNum = $this->ezPageCount;
          $this->saveState();
          $this->setColor(0.9,0.9,0.9);
          $this->filledRectangle($this->ez['leftMargin'],$this->y-$this->getFontHeight(18)+$this->getFontDecender(18),$this->ez['pageWidth']-$this->ez['leftMargin']-$this->ez['rightMargin'],$this->getFontHeight(18));
          $this->restoreState();
          $this->_ezText($letter,18,array('justification'=>'left'));
          if ($this->ezPageCount==$thisPageNum){
            $this->transaction('commit');
            $ok=1;
          } else {
            // then we have moved onto a new page, bad bad, as the background colour will be on the old one
            $this->transaction('rewind');
            $this->ezNewPage();
          }
        }
    }
    
    function dots($info)
    {
        // draw a dotted line over to the right and put on a page number
        $tmp = $info['p'];
        $lvl = $tmp[0];
        $lbl = substr($tmp,1);
        $xpos = 520;
        
        switch($lvl)
        {
            case '1':
                $size=16;
                $thick=1;
            break;
            case '2':
                $size=14;
                $thick=1;
            break;
            case '3':
                $size=12;
                $thick=1;
            break;
            case '4':
                $size=11;
                $thick=1;
            break;
        }
        
        $adjust = 0;
        if ($size != 16) $adjust = 1;
        $this->saveState();
        $this->setLineStyle($thick,'round','',array(0,10));
        $this->line($xpos - (5*$adjust),$info['y'],$info['x']+5,$info['y']);
        $this->restoreState();
        $this->addText($xpos - (5*$adjust)+5,$info['y'],$size,$lbl);
    }
    
    /**
     * @uses PDFParser extracts all meta-tags and processes text for output
     */
    function ezText($text,$size=0,$options=array(),$test=0)
    {
        $text = str_replace("\t","   ",$text);
        // paragraph breaks
        $text = str_replace("<##P##>","\n    ",$text);
        $text = str_replace("<<c:i",'< <c:i',$text);
        $text = str_replace("ilink>>","ilink> >",$text);
        $this->_save .= $text;
    }
    
    function setupTOC()
    {
        $parser = new PDFParser;
        $parser->parse($this->_save,$this->font_dir,$this);
        $this->_save = '';
    }
    
    function ezOutput($debug = false)
    {
        if ($debug) return $this->_save;
        $parser = new PDFParser;
        $parser->parse($this->_save,$this->font_dir,$this,$debug);
        return parent::ezOutput();
    }
    
    function _ezText($text,$size=0,$options=array(),$test=0)
    {
//        fancy_debug($text,$size,$options);
        return parent::ezText($text,$size,$options,$test);
    }
    
    function getYPlusOffset($offset)
    {
        return $this->y + $offset;
    }
    
    function addMessage($message)
    {
        return parent::addMessage($message);
        phpDocumentor_out($message."\n");
        flush();
    }
    
    function ezProcessText($text){
      // this function will intially be used to implement underlining support, but could be used for a range of other
      // purposes
      $text = parent::ezProcessText($text);
      $text = str_replace(array('<UL>','</UL>','<LI>','</LI>','<OL>','</OL>','<ol>','</ol>','<blockquote>','</blockquote>'),
                          array('<ul>','</ul>','<li>','</li>','<ul>','</ul>','<ul>','</ul>',"<C:indent:20>\n","<C:indent:-20>"),$text);
      $text = str_replace("\n<ul>","<ul>",$text);
      $text = str_replace("<ul>\n","<ul>",$text);
      $text = str_replace("\n<li>","<li>",$text);
      $text = str_replace("<li>\n","<li>",$text);
      $text = str_replace("<mybr>","\n",$text);
      $text = str_replace('</li></ul>','</ul>',$text);
      $search = array('<ul>','</ul>','<li>','</li>');
      $replace = array("<C:indent:20>\n","<C:indent:-20>",'<C:bullet:*>',"\n");
      return str_replace($search,$replace,$text);
    }
    
    function indent($info)
    {
        $this->ez['leftMargin']+=$info['p'];
    }
    
    function bullet($info)
    {
        $this->addText($info['x']-20,$info['y']-1,10,$info['p']);
    }
    
    function ezNewPage($debug=false)
    {
        parent::ezNewPage();
        if (!$this->set_pageNumbering)
        {
            $template = $this->converter->newSmarty();
            $parser = new PDFParser;
            $parser->parse($template->fetch('pagenumbering.tpl'),$this->font_dir,$this);
        }
        $this->set_pageNumbering = true;
    }
}
?>
