////////////////////////////////////////////////////////////////////////////
// Name:        stc.h
// Purpose:     A wxWindows implementation of Scintilla.  This class is the
//              one meant to be used directly by wx applications.  It does not
//              derive directly from the Scintilla classes, and in fact there
//              is no mention of Scintilla classes at all in this header.
//              This class delegates all method calls and events to the
//              Scintilla objects and so forth.  This allows the use of
//              Scintilla without polluting the namespace with all the
//              classes and itentifiers from Scintilla.
//
// Author:      Robin Dunn
//
// Created:     13-Jan-2000
// RCS-ID:      $Id: stc.h,v 1.4 2001/02/16 08:18:44 robind Exp $
// Copyright:   (c) 2000 by Total Control Software
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

#ifndef __stc_h__
#define __stc_h__


#include <wx/wx.h>

//----------------------------------------------------------------------
// BEGIN generated section.  The following code is automatically generated
//       by gen_iface.py.  Do not edit this file.  Edit stc.h.in instead
//       and regenerate

#define wxSTC_INVALID_POSITION -1
#define wxSTC_START 2000
#define wxSTC_OPTIONAL_START 3000
#define wxSTC_LEXER_START 4000
#define wxSTC_CMD_REDO 2011
#define wxSTC_CMD_SELECTALL 2013
#define wxSTC_WS_INVISIBLE 0
#define wxSTC_WS_VISIBLEALWAYS 1
#define wxSTC_WS_VISIBLEAFTERINDENT 2
#define wxSTC_EOL_CRLF 0
#define wxSTC_EOL_CR 1
#define wxSTC_EOL_LF 2

// The SC_CP_UTF8 value can be used to enter Unicode mode.
// This is the same value as CP_UTF8 in Windows
#define wxSTC_CP_UTF8 65001
#define wxSTC_MARKER_MAX 31
#define wxSTC_MARK_CIRCLE 0
#define wxSTC_MARK_ROUNDRECT 1
#define wxSTC_MARK_ARROW 2
#define wxSTC_MARK_SMALLRECT 3
#define wxSTC_MARK_SHORTARROW 4
#define wxSTC_MARK_EMPTY 5
#define wxSTC_MARK_ARROWDOWN 6
#define wxSTC_MARK_MINUS 7
#define wxSTC_MARK_PLUS 8
#define wxSTC_MARKNUM_FOLDER 30
#define wxSTC_MARKNUM_FOLDEROPEN 31
#define wxSTC_MARGIN_SYMBOL 0
#define wxSTC_MARGIN_NUMBER 1
#define wxSTC_STYLE_DEFAULT 32
#define wxSTC_STYLE_LINENUMBER 33
#define wxSTC_STYLE_BRACELIGHT 34
#define wxSTC_STYLE_BRACEBAD 35
#define wxSTC_STYLE_CONTROLCHAR 36
#define wxSTC_STYLE_INDENTGUIDE 37
#define wxSTC_STYLE_MAX 127

// Character set identifiers are used in StyleSetCharacterSet.
// The values are the same as the Windows *_CHARSET values.
#define wxSTC_CHARSET_ANSI 0
#define wxSTC_CHARSET_DEFAULT 1
#define wxSTC_CHARSET_BALTIC 186
#define wxSTC_CHARSET_CHINESEBIG5 136
#define wxSTC_CHARSET_EASTEUROPE 238
#define wxSTC_CHARSET_GB2312 134
#define wxSTC_CHARSET_GREEK 161
#define wxSTC_CHARSET_HANGUL 129
#define wxSTC_CHARSET_MAC 77
#define wxSTC_CHARSET_OEM 255
#define wxSTC_CHARSET_RUSSIAN 204
#define wxSTC_CHARSET_SHIFTJIS 128
#define wxSTC_CHARSET_SYMBOL 2
#define wxSTC_CHARSET_TURKISH 162
#define wxSTC_CHARSET_JOHAB 130
#define wxSTC_CHARSET_HEBREW 177
#define wxSTC_CHARSET_ARABIC 178
#define wxSTC_CHARSET_VIETNAMESE 163
#define wxSTC_CHARSET_THAI 222
#define wxSTC_INDIC_MAX 7
#define wxSTC_INDIC_PLAIN 0
#define wxSTC_INDIC_SQUIGGLE 1
#define wxSTC_INDIC_TT 2
#define wxSTC_INDIC_DIAGONAL 3
#define wxSTC_INDIC_STRIKE 4
#define wxSTC_INDIC0_MASK 32
#define wxSTC_INDIC1_MASK 64
#define wxSTC_INDIC2_MASK 128
#define wxSTC_INDICS_MASK 32 | 64 | 128

// PrintColourMode - use same colours as screen.
#define wxSTC_PRINT_NORMAL 0

// PrintColourMode - invert the light value of each style for printing.
#define wxSTC_PRINT_INVERTLIGHT 1

// PrintColourMode - force black text on white background for printing.
#define wxSTC_PRINT_BLACKONWHITE 2
#define wxSTC_FIND_DOWN 1
#define wxSTC_FIND_WHOLEWORD 2
#define wxSTC_FIND_MATCHCASE 4
#define wxSTC_FIND_WORDSTART 0x00100000

// SCFIND_REGEXP is not yet implemented.
#define wxSTC_FIND_REGEXP 0x00200000
#define wxSTC_CMD_UNDO 2176
#define wxSTC_CMD_CUT 2177
#define wxSTC_CMD_COPY 2178
#define wxSTC_CMD_PASTE 2179
#define wxSTC_FOLDLEVELBASE 0x400
#define wxSTC_FOLDLEVELWHITEFLAG 0x1000
#define wxSTC_FOLDLEVELHEADERFLAG 0x2000
#define wxSTC_FOLDLEVELNUMBERMASK 0x0FFF
#define wxSTC_CMD_LINEDOWN 2300
#define wxSTC_CMD_LINEDOWNEXTEND 2301
#define wxSTC_CMD_LINEUP 2302
#define wxSTC_CMD_LINEUPEXTEND 2303
#define wxSTC_CMD_CHARLEFT 2304
#define wxSTC_CMD_CHARLEFTEXTEND 2305
#define wxSTC_CMD_CHARRIGHT 2306
#define wxSTC_CMD_CHARRIGHTEXTEND 2307
#define wxSTC_CMD_WORDLEFT 2308
#define wxSTC_CMD_WORDLEFTEXTEND 2309
#define wxSTC_CMD_WORDRIGHT 2310
#define wxSTC_CMD_WORDRIGHTEXTEND 2311
#define wxSTC_CMD_HOME 2312
#define wxSTC_CMD_HOMEEXTEND 2313
#define wxSTC_CMD_LINEEND 2314
#define wxSTC_CMD_LINEENDEXTEND 2315
#define wxSTC_CMD_DOCUMENTSTART 2316
#define wxSTC_CMD_DOCUMENTSTARTEXTEND 2317
#define wxSTC_CMD_DOCUMENTEND 2318
#define wxSTC_CMD_DOCUMENTENDEXTEND 2319
#define wxSTC_CMD_PAGEUP 2320
#define wxSTC_CMD_PAGEUPEXTEND 2321
#define wxSTC_CMD_PAGEDOWN 2322
#define wxSTC_CMD_PAGEDOWNEXTEND 2323
#define wxSTC_CMD_EDITTOGGLEOVERTYPE 2324
#define wxSTC_CMD_CANCEL 2325
#define wxSTC_CMD_DELETEBACK 2326
#define wxSTC_CMD_TAB 2327
#define wxSTC_CMD_BACKTAB 2328
#define wxSTC_CMD_NEWLINE 2329
#define wxSTC_CMD_FORMFEED 2330
#define wxSTC_CMD_VCHOME 2331
#define wxSTC_CMD_VCHOMEEXTEND 2332
#define wxSTC_CMD_ZOOMIN 2333
#define wxSTC_CMD_ZOOMOUT 2334
#define wxSTC_CMD_DELWORDLEFT 2335
#define wxSTC_CMD_DELWORDRIGHT 2336
#define wxSTC_CMD_LINECUT 2337
#define wxSTC_CMD_LINEDELETE 2338
#define wxSTC_CMD_LINETRANSPOSE 2339
#define wxSTC_CMD_LOWERCASE 2340
#define wxSTC_CMD_UPPERCASE 2341
#define wxSTC_CMD_LINESCROLLDOWN 2342
#define wxSTC_CMD_LINESCROLLUP 2343
#define wxSTC_EDGE_NONE 0
#define wxSTC_EDGE_LINE 1
#define wxSTC_EDGE_BACKGROUND 2

// Show caret within N lines of edge when it's scrolled to view
#define wxSTC_CARET_SLOP 0x01

// Center caret on screen when it's scrolled to view
#define wxSTC_CARET_CENTER 0x02

// OR this with CARET_CENTER to reposition even when visible, or
// OR this with CARET_SLOP to reposition whenever outside slop border
#define wxSTC_CARET_STRICT 0x04

// Notifications
// Type of modification and the action which caused the modification
// These are defined as a bit mask to make it easy to specify which notifications are wanted.
// One bit is set from each of SC_MOD_* and SC_PERFORMED_*.
#define wxSTC_MOD_INSERTTEXT 0x1
#define wxSTC_MOD_DELETETEXT 0x2
#define wxSTC_MOD_CHANGESTYLE 0x4
#define wxSTC_MOD_CHANGEFOLD 0x8
#define wxSTC_PERFORMED_USER 0x10
#define wxSTC_PERFORMED_UNDO 0x20
#define wxSTC_PERFORMED_REDO 0x40
#define wxSTC_LASTSTEPINUNDOREDO 0x100
#define wxSTC_MOD_CHANGEMARKER 0x200
#define wxSTC_MOD_BEFOREINSERT 0x400
#define wxSTC_MOD_BEFOREDELETE 0x800
#define wxSTC_MODEVENTMASKALL 0xF77

// Symbolic key codes and modifier flags
// ASCII and other printable characters below 256
// Extended keys above 300
#define wxSTC_KEY_DOWN 300
#define wxSTC_KEY_UP 301
#define wxSTC_KEY_LEFT 302
#define wxSTC_KEY_RIGHT 303
#define wxSTC_KEY_HOME 304
#define wxSTC_KEY_END 305
#define wxSTC_KEY_PRIOR 306
#define wxSTC_KEY_NEXT 307
#define wxSTC_KEY_DELETE 308
#define wxSTC_KEY_INSERT 309
#define wxSTC_KEY_ESCAPE 7
#define wxSTC_KEY_BACK 8
#define wxSTC_KEY_TAB 9
#define wxSTC_KEY_RETURN 13
#define wxSTC_KEY_ADD 310
#define wxSTC_KEY_SUBTRACT 311
#define wxSTC_KEY_DIVIDE 312
#define wxSTC_SCMOD_SHIFT 1
#define wxSTC_SCMOD_CTRL 2
#define wxSTC_SCMOD_ALT 4

// For SciLexer.h
#define wxSTC_LEX_CONTAINER 0
#define wxSTC_LEX_NULL 1
#define wxSTC_LEX_PYTHON 2
#define wxSTC_LEX_CPP 3
#define wxSTC_LEX_HTML 4
#define wxSTC_LEX_XML 5
#define wxSTC_LEX_PERL 6
#define wxSTC_LEX_SQL 7
#define wxSTC_LEX_VB 8
#define wxSTC_LEX_PROPERTIES 9
#define wxSTC_LEX_ERRORLIST 10
#define wxSTC_LEX_MAKEFILE 11
#define wxSTC_LEX_BATCH 12
#define wxSTC_LEX_XCODE 13
#define wxSTC_LEX_LATEX 14
#define wxSTC_LEX_LUA 15
#define wxSTC_LEX_DIFF 16

// Lexical states for SCLEX_PYTHON
#define wxSTC_P_DEFAULT 0
#define wxSTC_P_COMMENTLINE 1
#define wxSTC_P_NUMBER 2
#define wxSTC_P_STRING 3
#define wxSTC_P_CHARACTER 4
#define wxSTC_P_WORD 5
#define wxSTC_P_TRIPLE 6
#define wxSTC_P_TRIPLEDOUBLE 7
#define wxSTC_P_CLASSNAME 8
#define wxSTC_P_DEFNAME 9
#define wxSTC_P_OPERATOR 10
#define wxSTC_P_IDENTIFIER 11
#define wxSTC_P_COMMENTBLOCK 12
#define wxSTC_P_STRINGEOL 13

// Lexical states for SCLEX_CPP, SCLEX_VB
#define wxSTC_C_DEFAULT 0
#define wxSTC_C_COMMENT 1
#define wxSTC_C_COMMENTLINE 2
#define wxSTC_C_COMMENTDOC 3
#define wxSTC_C_NUMBER 4
#define wxSTC_C_WORD 5
#define wxSTC_C_STRING 6
#define wxSTC_C_CHARACTER 7
#define wxSTC_C_UUID 8
#define wxSTC_C_PREPROCESSOR 9
#define wxSTC_C_OPERATOR 10
#define wxSTC_C_IDENTIFIER 11
#define wxSTC_C_STRINGEOL 12
#define wxSTC_C_VERBATIM 13

// Lexical states for SCLEX_HTML, SCLEX_XML
#define wxSTC_H_DEFAULT 0
#define wxSTC_H_TAG 1
#define wxSTC_H_TAGUNKNOWN 2
#define wxSTC_H_ATTRIBUTE 3
#define wxSTC_H_ATTRIBUTEUNKNOWN 4
#define wxSTC_H_NUMBER 5
#define wxSTC_H_DOUBLESTRING 6
#define wxSTC_H_SINGLESTRING 7
#define wxSTC_H_OTHER 8
#define wxSTC_H_COMMENT 9
#define wxSTC_H_ENTITY 10

// XML and ASP
#define wxSTC_H_TAGEND 11
#define wxSTC_H_XMLSTART 12
#define wxSTC_H_XMLEND 13
#define wxSTC_H_SCRIPT 14
#define wxSTC_H_ASP 15
#define wxSTC_H_ASPAT 16
#define wxSTC_H_CDATA 17
#define wxSTC_H_QUESTION 18

// More HTML
#define wxSTC_H_VALUE 19

// Embedded Javascript
#define wxSTC_HJ_START 40
#define wxSTC_HJ_DEFAULT 41
#define wxSTC_HJ_COMMENT 42
#define wxSTC_HJ_COMMENTLINE 43
#define wxSTC_HJ_COMMENTDOC 44
#define wxSTC_HJ_NUMBER 45
#define wxSTC_HJ_WORD 46
#define wxSTC_HJ_KEYWORD 47
#define wxSTC_HJ_DOUBLESTRING 48
#define wxSTC_HJ_SINGLESTRING 49
#define wxSTC_HJ_SYMBOLS 50
#define wxSTC_HJ_STRINGEOL 51

// ASP Javascript
#define wxSTC_HJA_START 55
#define wxSTC_HJA_DEFAULT 56
#define wxSTC_HJA_COMMENT 57
#define wxSTC_HJA_COMMENTLINE 58
#define wxSTC_HJA_COMMENTDOC 59
#define wxSTC_HJA_NUMBER 60
#define wxSTC_HJA_WORD 61
#define wxSTC_HJA_KEYWORD 62
#define wxSTC_HJA_DOUBLESTRING 63
#define wxSTC_HJA_SINGLESTRING 64
#define wxSTC_HJA_SYMBOLS 65
#define wxSTC_HJA_STRINGEOL 66

// Embedded VBScript
#define wxSTC_HB_START 70
#define wxSTC_HB_DEFAULT 71
#define wxSTC_HB_COMMENTLINE 72
#define wxSTC_HB_NUMBER 73
#define wxSTC_HB_WORD 74
#define wxSTC_HB_STRING 75
#define wxSTC_HB_IDENTIFIER 76
#define wxSTC_HB_STRINGEOL 77

// ASP VBScript
#define wxSTC_HBA_START 80
#define wxSTC_HBA_DEFAULT 81
#define wxSTC_HBA_COMMENTLINE 82
#define wxSTC_HBA_NUMBER 83
#define wxSTC_HBA_WORD 84
#define wxSTC_HBA_STRING 85
#define wxSTC_HBA_IDENTIFIER 86
#define wxSTC_HBA_STRINGEOL 87

// Embedded Python
#define wxSTC_HP_START 90
#define wxSTC_HP_DEFAULT 91
#define wxSTC_HP_COMMENTLINE 92
#define wxSTC_HP_NUMBER 93
#define wxSTC_HP_STRING 94
#define wxSTC_HP_CHARACTER 95
#define wxSTC_HP_WORD 96
#define wxSTC_HP_TRIPLE 97
#define wxSTC_HP_TRIPLEDOUBLE 98
#define wxSTC_HP_CLASSNAME 99
#define wxSTC_HP_DEFNAME 100
#define wxSTC_HP_OPERATOR 101
#define wxSTC_HP_IDENTIFIER 102

// ASP Python
#define wxSTC_HPA_START 105
#define wxSTC_HPA_DEFAULT 106
#define wxSTC_HPA_COMMENTLINE 107
#define wxSTC_HPA_NUMBER 108
#define wxSTC_HPA_STRING 109
#define wxSTC_HPA_CHARACTER 110
#define wxSTC_HPA_WORD 111
#define wxSTC_HPA_TRIPLE 112
#define wxSTC_HPA_TRIPLEDOUBLE 113
#define wxSTC_HPA_CLASSNAME 114
#define wxSTC_HPA_DEFNAME 115
#define wxSTC_HPA_OPERATOR 116
#define wxSTC_HPA_IDENTIFIER 117

// PHP
#define wxSTC_HPHP_DEFAULT 118
#define wxSTC_HPHP_HSTRING 119
#define wxSTC_HPHP_SIMPLESTRING 120
#define wxSTC_HPHP_WORD 121
#define wxSTC_HPHP_NUMBER 122
#define wxSTC_HPHP_VARIABLE 123
#define wxSTC_HPHP_COMMENT 124
#define wxSTC_HPHP_COMMENTLINE 125
#define wxSTC_HPHP_STRINGEOL 126

// Lexical states for SCLEX_PERL
#define wxSTC_PL_DEFAULT 0
#define wxSTC_PL_HERE 1
#define wxSTC_PL_COMMENTLINE 2
#define wxSTC_PL_POD 3
#define wxSTC_PL_NUMBER 4
#define wxSTC_PL_WORD 5
#define wxSTC_PL_STRING 6
#define wxSTC_PL_CHARACTER 7
#define wxSTC_PL_PUNCTUATION 8
#define wxSTC_PL_PREPROCESSOR 9
#define wxSTC_PL_OPERATOR 10
#define wxSTC_PL_IDENTIFIER 11
#define wxSTC_PL_SCALAR 12
#define wxSTC_PL_ARRAY 13
#define wxSTC_PL_HASH 14
#define wxSTC_PL_SYMBOLTABLE 15
#define wxSTC_PL_REF 16
#define wxSTC_PL_REGEX 17
#define wxSTC_PL_REGSUBST 18
#define wxSTC_PL_LONGQUOTE 19
#define wxSTC_PL_BACKTICKS 20
#define wxSTC_PL_DATASECTION 21

// Lexical states for SCLEX_LATEX
#define wxSTC_L_DEFAULT 0
#define wxSTC_L_COMMAND 1
#define wxSTC_L_TAG 2
#define wxSTC_L_MATH 3
#define wxSTC_L_COMMENT 4

// Lexical states for SCLEX_LUA
#define wxSTC_LUA_DEFAULT 0
#define wxSTC_LUA_COMMENT 1
#define wxSTC_LUA_COMMENTLINE 2
#define wxSTC_LUA_COMMENTDOC 3
#define wxSTC_LUA_NUMBER 4
#define wxSTC_LUA_WORD 5
#define wxSTC_LUA_STRING 6
#define wxSTC_LUA_CHARACTER 7
#define wxSTC_LUA_LITERALSTRING 8
#define wxSTC_LUA_PREPROCESSOR 9
#define wxSTC_LUA_OPERATOR 10
#define wxSTC_LUA_IDENTIFIER 11
#define wxSTC_LUA_STRINGEOL 12
#define wxSTC_ERR_DEFAULT 0
#define wxSTC_ERR_PYTHON 1
#define wxSTC_ERR_GCC 2
#define wxSTC_ERR_MS 3
#define wxSTC_ERR_CMD 4
#define wxSTC_ERR_BORLAND 5
#define wxSTC_ERR_PERL 6

// END of generated section
//----------------------------------------------------------------------
// Others

#define wxSTC_MASK_FOLDERS ((1 << wxSTC_MARKNUM_FOLDER) | (1 << wxSTC_MARKNUM_FOLDEROPEN))



//----------------------------------------------------------------------

class  ScintillaWX;                      // forward declare
class  WordList;
struct SCNotification;


extern const wxChar* wxSTCNameStr;

//----------------------------------------------------------------------

class wxStyledTextCtrl : public wxControl {
public:

#ifdef SWIG
    wxStyledTextCtrl(wxWindow *parent, wxWindowID id,
                     const wxPoint& pos = wxDefaultPosition,
                     const wxSize& size = wxDefaultSize, long style = 0,
                     const char* name = "styledtext");
#else
    wxStyledTextCtrl(wxWindow *parent, wxWindowID id,
                     const wxPoint& pos = wxDefaultPosition,
                     const wxSize& size = wxDefaultSize, long style = 0,
                     const wxString& name = wxSTCNameStr);
#endif


#ifndef SWIG
    ~wxStyledTextCtrl();
#endif

//----------------------------------------------------------------------
// BEGIN generated section.  The following code is automatically generated
//       by gen_iface.py.  Do not edit this file.  Edit stc.h.in instead
//       and regenerate


    // Add text to the document
    void AddText(const wxString& text);

    // Add array of cells to document
    void AddStyledText(const wxString& text);

    // Insert string at a position
    void InsertText(int pos, const wxString& text);

    // Delete all text in the document
    void ClearAll();

    // Set all style bytes to 0, remove all folding information
    void ClearDocumentStyle();

    // The number of characters in the document
    int GetLength();

    // Returns the character byte at the position
    int GetCharAt(int pos);

    // Returns the position of the caret
    int GetCurrentPos();

    // Returns the position of the opposite end of the selection to the caret
    int GetAnchor();

    // Returns the style byte at the position
    int GetStyleAt(int pos);

    // Redoes the next action on the undo history
    void Redo();

    // Choose between collecting actions into the undo
    // history and discarding them.
    void SetUndoCollection(bool collectUndo);

    // Select all the text in the document.
    void SelectAll();

    // Remember the current position in the undo history as the position
    // at which the document was saved.
    void SetSavePoint();

    // Retrieve a buffer of cells.
    wxString GetStyledText(int startPos, int endPos);

    // Are there any redoable actions in the undo history.
    bool CanRedo();

    // Retrieve the line number at which a particular marker is located
    int MarkerLineFromHandle(int handle);

    // Delete a marker.
    void MarkerDeleteHandle(int handle);

    // Is undo history being collected?
    bool GetUndoCollection();

    // Are white space characters currently visible?
    // Returns one of SCWS_* constants.
    int GetViewWhiteSpace();

    // Make white space characters invisible, always visible or visible outside indentation.
    void SetViewWhiteSpace(int viewWS);

    // Find the position from a point within the window.
    int PositionFromPoint(wxPoint pt);

    // Set caret to start of a line and ensure it is visible.
    void GotoLine(int line);

    // Set caret to a position and ensure it is visible.
    void GotoPos(int pos);

    // Set the selection anchor to a position. The anchor is the opposite
    // end of the selection from the caret.
    void SetAnchor(int posAnchor);

    // Retrieve the text of the line containing the caret.
    // Returns the index of the caret on the line.
    wxString GetCurLine(int* OUTPUT=NULL);

    // Retrieve the position of the last correctly styled character.
    int GetEndStyled();

    // Convert all line endings in the document to use the current mode.
    void ConvertEOLs();

    // Retrieve the current end of line mode - one of CRLF, CR, or LF.
    int GetEOLMode();

    // Set the current end of line mode.
    void SetEOLMode(int eolMode);

    // Set the current styling position to pos and the styling mask to mask.
    // The styling mask can be used to protect some bits in each styling byte from
    // modification.
    void StartStyling(int pos, int mask);

    // Change style from current styling position for length characters to a style
    // and move the current styling position to after this newly styled segment.
    void SetStyling(int length, int style);

    // Is drawing done first into a buffer or direct to the screen.
    bool GetBufferedDraw();

    // If drawing is buffered then each line of text is drawn into a bitmap buffer
    // before drawing it to the screen to avoid flicker.
    void SetBufferedDraw(bool buffered);

    // Change the visible size of a tab to be a multiple of the width of a space
    // character.
    void SetTabWidth(int tabWidth);

    // Retrieve the visible size of a tab.
    int GetTabWidth();

    // Set the code page used to interpret the bytes of the document as characters.
    // The SC_CP_UTF8 value can be used to enter Unicode mode.
    void SetCodePage(int codePage);

    // Set the symbol used for a particular marker number,
    // and optionally the for and background colours.
    void MarkerDefine(int markerNumber, int markerSymbol,
                         const wxColour& foreground = wxNullColour,
                         const wxColour& background = wxNullColour);

    // Set the foreground colour used for a particular marker number.
    void MarkerSetForeground(int markerNumber, const wxColour& fore);

    // Set the background colour used for a particular marker number.
    void MarkerSetBackground(int markerNumber, const wxColour& back);

    // Add a marker to a line.
    void MarkerAdd(int line, int markerNumber);

    // Delete a marker from a line
    void MarkerDelete(int line, int markerNumber);

    // Delete all markers with a particular number from all lines
    void MarkerDeleteAll(int markerNumber);

    // Get a bit mask of all the markers set on a line.
    int MarkerGet(int line);

    // Find the next line after lineStart that includes a marker in mask.
    int MarkerNext(int lineStart, int markerMask);

    // Find the previous line before lineStart that includes a marker in mask.
    int MarkerPrevious(int lineStart, int markerMask);

    // Set a margin to be either numeric or symbolic.
    void SetMarginType(int margin, int marginType);

    // Retrieve the type of a margin.
    int GetMarginType(int margin);

    // Set the width of a margin to a width expressed in pixels.
    void SetMarginWidth(int margin, int pixelWidth);

    // Retrieve the width of a margin in pixels.
    int GetMarginWidth(int margin);

    // Set a mask that determines which markers are displayed in a margin.
    void SetMarginMask(int margin, int mask);

    // Retrieve the marker mask of a margin.
    int GetMarginMask(int margin);

    // Make a margin sensitive or insensitive to mouse clicks.
    void SetMarginSensitive(int margin, bool sensitive);

    // Retrieve the mouse click sensitivity of a margin.
    bool GetMarginSensitive(int margin);

    // Clear all the styles and make equivalent to the global default style.
    void StyleClearAll();

    // Set the foreground colour of a style.
    void StyleSetForeground(int style, const wxColour& fore);

    // Set the background colour of a style.
    void StyleSetBackground(int style, const wxColour& back);

    // Set a style to be bold or not.
    void StyleSetBold(int style, bool bold);

    // Set a style to be italic or not.
    void StyleSetItalic(int style, bool italic);

    // Set the size of characters of a style.
    void StyleSetSize(int style, int sizePoints);

    // Set the font of a style.
    void StyleSetFaceName(int style, const wxString& fontName);

    // Set a style to have its end of line filled or not.
    void StyleSetEOLFilled(int style, bool filled);

    // Reset the default style to its state at startup
    void StyleResetDefault();

    // Set a style to be underlined or not.
    void StyleSetUnderline(int style, bool underline);

    // Set the foreground colour of the selection and whether to use this setting.
    void SetSelForeground(bool useSetting, const wxColour& fore);

    // Set the background colour of the selection and whether to use this setting.
    void SetSelBackground(bool useSetting, const wxColour& back);

    // Set the foreground colour of the caret.
    void SetCaretForeground(const wxColour& fore);

    // When key+modifier combination km is pressed perform msg.
    void CmdKeyAssign(int key, int modifiers, int cmd);

    // When key+modifier combination km do nothing.
    void CmdKeyClear(int key, int modifiers);

    // Drop all key mappings.
    void CmdKeyClearAll();

    // Set the styles for a segment of the document.
    void SetStyleBytes(int length, char* styleBytes);

    // Set a style to be visible or not.
    void StyleSetVisible(int style, bool visible);

    // Get the time in milliseconds that the caret is on and off.
    int GetCaretPeriod();

    // Get the time in milliseconds that the caret is on and off. 0 = steady on.
    void SetCaretPeriod(int periodMilliseconds);

    // Set the set of characters making up words for when moving or selecting
    // by word.
    void SetWordChars(const wxString& characters);

    // Start a sequence of actions that is undone and redone as a unit.
    // May be nested.
    void BeginUndoAction();

    // End a sequence of actions that is undone and redone as a unit.
    void EndUndoAction();

    // Set an indicator to plain, squiggle or TT.
    void IndicatorSetStyle(int indic, int style);

    // Retrieve the style of an indicator.
    int IndicatorGetStyle(int indic);

    // Set the foreground colour of an indicator.
    void IndicatorSetForeground(int indic, const wxColour& fore);

    // Retrieve the foreground colour of an indicator.
    wxColour IndicatorGetForeground(int indic);

    // Divide each styling byte into lexical class bits (default:5) and indicator
    // bits (default:3). If a lexer requires more than 32 lexical states, then this
    // is used to expand the possible states.
    void SetStyleBits(int bits);

    // Retrieve number of bits in style bytes used to hold the lexical state.
    int GetStyleBits();

    // Used to hold extra styling information for each line.
    void SetLineState(int line, int state);

    // Retrieve the extra styling information for a line.
    int GetLineState(int line);

    // Retrieve the last line number that has line state.
    int GetMaxLineState();

    // Display a auto-completion list.
    // The lenEntered parameter indicates how many characters before
    // the caret should be used to provide context.
    void AutoCompShow(int lenEntered, const wxString& itemList);

    // Remove the auto-completion list from the screen.
    void AutoCompCancel();

    // Is there an auto-completion list visible?
    bool AutoCompActive();

    // Retrieve the position of the caret when the auto-completion list was
    // displayed.
    int AutoCompPosStart();

    // User has selected an item so remove the list and insert the selection.
    void AutoCompComplete();

    // Define a set of character that when typed cancel the auto-completion list.
    void AutoCompStops(const wxString& characterSet);

    // Change the separator character in the string setting up an auto-completion
    // list. Default is space but can be changed if items contain space.
    void AutoCompSetSeparator(int separatorCharacter);

    // Retrieve the auto-completion list separator character.
    int AutoCompGetSeparator();

    // Select the item in the auto-completion list that starts with a string.
    void AutoCompSelect(const wxString& text);

    // Should the auto-completion list be cancelled if the user backspaces to a
    // position before where the box was created.
    void AutoCompSetCancelAtStart(bool cancel);

    // Retrieve whether auto-completion cancelled by backspacing before start.
    bool AutoCompGetCancelAtStart();

    // Define a set of character that when typed fills up the selected word.
    void AutoCompSetFillUps(const wxString& characterSet);

    // Should a single item auto-completion list automatically choose the item.
    void AutoCompSetChooseSingle(bool chooseSingle);

    // Retrieve whether a single item auto-completion list automatically choose the item.
    bool AutoCompGetChooseSingle();

    // Set whether case is significant when performing auto-completion searches.
    void AutoCompSetIgnoreCase(bool ignoreCase);

    // Retrieve state of ignore case flag.
    bool AutoCompGetIgnoreCase();

    // Set the number of spaces used for one level of indentation.
    void SetIndent(int indentSize);

    // Retrieve indentation size.
    int GetIndent();

    // Indentation will only use space characters if useTabs is false, otherwise
    // it will use a combination of tabs and spaces.
    void SetUseTabs(bool useTabs);

    // Retrieve whether tabs will be used in indentation.
    bool GetUseTabs();

    // Change the indentation of a line to a number of columns.
    void SetLineIndentation(int line, int indentSize);

    // Retrieve the number of columns that a line is indented.
    int GetLineIndentation(int line);

    // Retrieve the position before the first non indentation character on a line.
    int GetLineIndentPosition(int line);

    // Retrieve the column number of a position, taking tab width into account.
    int GetColumn(int pos);

    // Show or hide the horizontal scroll bar.
    void SetUseHorizontalScrollBar(bool show);

    // Is the horizontal scroll bar visible?
    bool GetUseHorizontalScrollBar();

    // Show or hide indentation guides.
    void SetIndentationGuides(bool show);

    // Are the indentation guides visible?
    bool GetIndentationGuides();

    // Set the highlighted indentation guide column.
    // 0 = no highlighted guide.
    void SetHighlightGuide(int column);

    // Get the highlighted indentation guide column.
    int GetHighlightGuide();

    // Get the position after the last visible characters on a line.
    int GetLineEndPosition(int line);

    // Get the code page used to interpret the bytes of the document as characters.
    int GetCodePage();

    // Get the foreground colour of the caret.
    wxColour GetCaretForeground();

    // In read-only mode?
    bool GetReadOnly();

    // Sets the position of the caret.
    void SetCurrentPos(int pos);

    // Sets the position that starts the selection - this becomes the anchor.
    void SetSelectionStart(int pos);

    // Returns the position at the start of the selection.
    int GetSelectionStart();

    // Sets the position that ends the selection - this becomes the currentPosition.
    void SetSelectionEnd(int pos);

    // Returns the position at the end of the selection.
    int GetSelectionEnd();

    // Sets the print magnification added to the point size of each style for printing.
    void SetPrintMagnification(int magnification);

    // Returns the print magnification.
    int GetPrintMagnification();

    // Modify colours when printing for clearer printed text.
    void SetPrintColourMode(int mode);

    // Returns the print colour mode.
    int GetPrintColourMode();

    // Find some text in the document.
    int FindText(int minPos, int maxPos,
                               const wxString& text,
                               bool caseSensitive, bool wholeWord);

    // On Windows will draw the document into a display context such as a printer.
    int FormatRange(bool   doDraw,
                               int    startPos,
                               int    endPos,
                               wxDC*  draw,
                               wxDC*  target,  // Why does it use two? Can they be the same?
                               wxRect renderRect,
                               wxRect pageRect);

    // Retrieve the line at the top of the display.
    int GetFirstVisibleLine();

    // Retrieve the contents of a line.
    wxString GetLine(int line);

    // Returns the number of lines in the document. There is always at least one.
    int GetLineCount();

    // Sets the size in pixels of the left margin.
    void SetMarginLeft(int width);

    // Returns the size in pixels of the left margin.
    int GetMarginLeft();

    // Sets the size in pixels of the right margin.
    void SetMarginRight(int width);

    // Returns the size in pixels of the right margin.
    int GetMarginRight();

    // Is the document different from when it was last saved?
    bool GetModify();

    // Select a range of text.
    void SetSelection(int start, int end);

    // Retrieve the selected text.
    wxString GetSelectedText();

    // Retrieve a range of text.
    wxString GetTextRange(int startPos, int endPos);

    // Draw the selection in normal style or with selection highlighted.
    void HideSelection(bool normal);

    // Retrieve the line containing a position.
    int LineFromPosition(int pos);

    // Retrieve the position at the start of a line.
    int PositionFromLine(int line);

    // Scroll horizontally and vertically.
    void LineScroll(int columns, int lines);

    // Ensure the caret is visible.
    void EnsureCaretVisible();

    // Replace the selected text with the argument text.
    void ReplaceSelection(const wxString& text);

    // Set to read only or read write.
    void SetReadOnly(bool readOnly);

    // Will a paste succeed?
    bool CanPaste();

    // Are there any undoable actions in the undo history.
    bool CanUndo();

    // Delete the undo history.
    void EmptyUndoBuffer();

    // Undo one action in the undo history.
    void Undo();

    // Cut the selection to the clipboard.
    void Cut();

    // Copy the selection to the clipboard.
    void Copy();

    // Paste the contents of the clipboard into the document replacing the selection.
    void Paste();

    // Clear the selection.
    void Clear();

    // Replace the contents of the document with the argument text.
    void SetText(const wxString& text);

    // Retrieve all the text in the document.
    wxString GetText();

    // Retrieve the number of characters in the document.
    int GetTextLength();

    // Set to overtype (true) or insert mode
    void SetOvertype(bool overtype);

    // Returns true if overtype mode is active otherwise false is returned.
    bool GetOvertype();

    // Show a call tip containing a definition near position pos.
    void CallTipShow(int pos, const wxString& definition);

    // Remove the call tip from the screen.
    void CallTipCancel();

    // Is there an active call tip?
    bool CallTipActive();

    // Retrieve the position where the caret was before displaying the call tip.
    int CallTipPosAtStart();

    // Highlight a segment of the definition.
    void CallTipSetHighlight(int start, int end);

    // Set the background colour for the call tip.
    void CallTipSetBackground(const wxColour& back);

    // Find the display line of a document line taking hidden lines into account.
    int VisibleFromDocLine(int line);

    // Find the document line of a display line taking hidden lines into account.
    int DocLineFromVisible(int lineDisplay);

    // Set the fold level of a line.
    // This encodes an integer level along with flags indicating whether the
    // line is a header and whether it is effectively white space.
    void SetFoldLevel(int line, int level);

    // Retrieve the fold level of a line.
    int GetFoldLevel(int line);

    // Find the last child line of a header line.
    int GetLastChild(int line, int level);

    // Find the parent line of a child line.
    int GetFoldParent(int line);

    // Make a range of lines visible.
    void ShowLines(int lineStart, int lineEnd);

    // Make a range of lines invisible.
    void HideLines(int lineStart, int lineEnd);

    // Is a line visible?
    bool GetLineVisible(int line);

    // Show the children of a header line.
    void SetFoldExpanded(int line, bool expanded);

    // Is a header line expanded?
    bool GetFoldExpanded(int line);

    // Switch a header line between expanded and contracted.
    void ToggleFold(int line);

    // Ensure a particular line is visible by expanding any header line hiding it.
    void EnsureVisible(int line);

    // Set some debugging options for folding
    void SetFoldFlags(int flags);

    // How many characters are on a line, not including end of line characters.
    int LineLength(int line);

    // Highlight the characters at two positions.
    void BraceHighlight(int pos1, int pos2);

    // Highlight the character at a position indicating there is no matching brace.
    void BraceBadLight(int pos);

    // Find the position of a matching brace or INVALID_POSITION if no match.
    int BraceMatch(int pos);

    // Are the end of line characters visible.
    bool GetViewEOL();

    // Make the end of line characters visible or invisible
    void SetViewEOL(bool visible);

    // Retrieve a pointer to the document object.
    void* GetDocPointer();

    // Change the document object used.
    void SetDocPointer(void* docPointer);

    // Set which document modification events are sent to the container.
    void SetModEventMask(int mask);

    // Retrieve the column number which text should be kept within.
    int GetEdgeColumn();

    // Set the column number of the edge.
    // If text goes past the edge then it is highlighted.
    void SetEdgeColumn(int column);

    // Retrieve the edge highlight mode.
    int GetEdgeMode();

    // The edge may be displayed by a line (EDGE_LINE) or by highlighting text that
    // goes beyond it (EDGE_BACKGROUND) or not displayed at all (EDGE_NONE).
    void SetEdgeMode(int mode);

    // Retrieve the colour used in edge indication.
    wxColour GetEdgeColour();

    // Change the colour used in edge indication.
    void SetEdgeColour(const wxColour& edgeColour);

    // Sets the current caret position to be the search anchor.
    void SearchAnchor();

    // Find some text starting at the search anchor.
    int SearchNext(int flags, const wxString& text);

    // Find some text starting at the search anchor and moving backwards.
    int SearchPrev(int flags, const wxString& text);

    // Set the way the line the caret is on is kept visible.
    void SetCaretPolicy(int caretPolicy, int caretSlop);

    // Retrieves the number of lines completely visible.
    int LinesOnScreen();

    // Set whether a pop up menu is displayed automatically when the user presses
    // the wrong mouse button.
    void UsePopUp(bool allowPopUp);

    // Is the selection a rectangular. The alternative is the more common stream selection.
    bool SelectionIsRectangle();

    // Set the zoom level. This number of points is added to the size of all fonts.
    // It may be positive to magnify or negative to reduce.
    void SetZoom(int zoom);

    // Retrieve the zoom level.
    int GetZoom();

    // Create a new document object.
    // Starts with reference count of 1 and not selected into editor.
    void* CreateDocument();

    // Extend life of document.
    void AddRefDocument(void* docPointer);

    // Release a reference to the document, deleting document if it fades to black.
    void ReleaseDocument(void* docPointer);

    // Get which document modification events are sent to the container.
    int GetModEventMask();

    // Start notifying the container of all key presses and commands.
    void StartRecord();

    // Stop notifying the container of all key presses and commands.
    void StopRecord();

    // Set the lexing language of the document.
    void SetLexer(int lexer);

    // Retrieve the lexing language of the document.
    int GetLexer();

    // Colourise a segment of the document using the current lexing language.
    void Colourise(int start, int end);

    // Set up a value that may be used by a lexer for some optional feature.
    void SetProperty(const wxString& key, const wxString& value);

    // Set up the key words used by the lexer.
    void SetKeyWords(int keywordSet, const wxString& keyWords);

// END of generated section
//----------------------------------------------------------------------
// Others...


    // Returns the line number of the line with the caret.
    int GetCurrentLine();

    // Extract style settings from a spec-string which is composed of one or
    // more of the following comma separated elements:
    //
    //      bold                    turns on bold
    //      italic                  turns on italics
    //      fore:#RRGGBB            sets the foreground colour
    //      back:#RRGGBB            sets the background colour
    //      face:[facename]         sets the font face name to use
    //      size:[num]              sets the font size in points
    //      eol                     turns on eol filling
    //      underline               turns on underlining
    //
    void StyleSetSpec(int styleNum, const wxString& spec);



    // Set style size, face, bold, italic, and underline attributes from
    // a wxFont's attributes.
    void StyleSetFont(int styleNum, wxFont& font);



    // Set all font style attributes at once.
    void StyleSetFontAttr(int styleNum, int size,
                          const wxString& faceName,
                          bool bold, bool italic,
                          bool underline);



    // Perform one of the operations defined by the wxSTC_CMD_* constants.
    void CmdKeyExecute(int cmd);



    // Set the left and right margin in the edit area, measured in pixels.
    void SetMargins(int left, int right);


    // Retrieve the start and end positions of the current selection.
#ifdef SWIG
    void GetSelection(int* OUTPUT, int* OUTPUT);
#else
    void GetSelection(int* startPos, int* endPos);
#endif

    // Retrieve the point in the window where a position is displayed.
    wxPoint PointFromPosition(int pos);


    // Scroll enough to make the given line visible
    void ScrollToLine(int line);


    // Scroll enough to make the given column visible
    void ScrollToColumn(int column);

//----------------------------------------------------------------------


#ifndef SWIG
private:
    // Event handlers
    void OnPaint(wxPaintEvent& evt);
    void OnScrollWin(wxScrollWinEvent& evt);
    void OnSize(wxSizeEvent& evt);
    void OnMouseLeftDown(wxMouseEvent& evt);
    void OnMouseMove(wxMouseEvent& evt);
    void OnMouseLeftUp(wxMouseEvent& evt);
    void OnMouseRightUp(wxMouseEvent& evt);
    void OnChar(wxKeyEvent& evt);
    void OnKeyDown(wxKeyEvent& evt);
    void OnLoseFocus(wxFocusEvent& evt);
    void OnGainFocus(wxFocusEvent& evt);
    void OnSysColourChanged(wxSysColourChangedEvent& evt);
    void OnEraseBackground(wxEraseEvent& evt);
    void OnMenu(wxCommandEvent& evt);
    void OnListBox(wxCommandEvent& evt);


    // Turn notifications from Scintilla into events
    void NotifyChange();
    void NotifyParent(SCNotification* scn);

    long SendMsg(int msg, long wp=0, long lp=0);

private:
    DECLARE_EVENT_TABLE()
    DECLARE_CLASS(wxStyledTextCtrl)

    ScintillaWX*        m_swx;
    wxStopWatch         m_stopWatch;


    friend class ScintillaWX;
    friend class Platform;
#endif
};

//----------------------------------------------------------------------

class wxStyledTextEvent : public wxCommandEvent {
public:
    wxStyledTextEvent(wxEventType commandType=0, int id=0);
    ~wxStyledTextEvent() {}

    void SetPosition(int pos)        { m_position = pos; }
    void SetKey(int k)               { m_key = k; }
    void SetModifiers(int m)         { m_modifiers = m; }
    void SetModificationType(int t)  { m_modificationType = t; }
    void SetText(const char* t)      { m_text = t; }
    void SetLength(int len)          { m_length = len; }
    void SetLinesAdded(int num)      { m_linesAdded = num; }
    void SetLine(int val)            { m_line = val; }
    void SetFoldLevelNow(int val)    { m_foldLevelNow = val; }
    void SetFoldLevelPrev(int val)   { m_foldLevelPrev = val; }
    void SetMargin(int val)          { m_margin = val; }
    void SetMessage(int val)         { m_message = val; }
    void SetWParam(int val)          { m_wParam = val; }
    void SetLParam(int val)          { m_lParam = val; }

    int  GetPosition() const         { return m_position; }
    int  GetKey()  const             { return m_key; }
    int  GetModifiers() const        { return m_modifiers; }
    int  GetModificationType() const { return m_modificationType; }
    wxString GetText() const         { return m_text; }
    int  GetLength() const           { return m_length; }
    int  GetLinesAdded() const       { return m_linesAdded; }
    int  GetLine() const             { return m_line; }
    int  GetFoldLevelNow() const     { return m_foldLevelNow; }
    int  GetFoldLevelPrev() const    { return m_foldLevelPrev; }
    int  GetMargin() const           { return m_margin; }
    int  GetMessage() const          { return m_message; }
    int  GetWParam() const           { return m_wParam; }
    int  GetLParam() const           { return m_lParam; }

    bool GetShift() const;
    bool GetControl() const;
    bool GetAlt() const;

    void CopyObject(wxObject& obj) const;

#ifndef SWIG
private:
    DECLARE_DYNAMIC_CLASS(wxStyledTextEvent)

    int  m_position;
    int  m_key;
    int  m_modifiers;

    int  m_modificationType;    // wxEVT_STC_MODIFIED
    wxString m_text;
    int  m_length;
    int  m_linesAdded;
    int  m_line;
    int  m_foldLevelNow;
    int  m_foldLevelPrev;

    int  m_margin;              // wxEVT_STC_MARGINCLICK

    int  m_message;             // wxEVT_STC_MACRORECORD
    int  m_wParam;
    int  m_lParam;
#endif
};


// Event types
enum {
    wxEVT_STC_CHANGE = 1650,
    wxEVT_STC_STYLENEEDED,
    wxEVT_STC_CHARADDED,
    wxEVT_STC_UPDATEUI,
    wxEVT_STC_SAVEPOINTREACHED,
    wxEVT_STC_SAVEPOINTLEFT,
    wxEVT_STC_ROMODIFYATTEMPT,
    wxEVT_STC_DOUBLECLICK,
    wxEVT_STC_MODIFIED,
    wxEVT_STC_KEY,
    wxEVT_STC_MACRORECORD,
    wxEVT_STC_MARGINCLICK,
    wxEVT_STC_NEEDSHOWN,
    wxEVT_STC_POSCHANGED
};


#ifndef SWIG
typedef void (wxEvtHandler::*wxStyledTextEventFunction)(wxStyledTextEvent&);

#define EVT_STC_CHANGE(id, fn) { wxEVT_STC_CHANGE, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_STYLENEEDED(id, fn) { wxEVT_STC_STYLENEEDED, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_CHARADDED(id, fn) { wxEVT_STC_CHARADDED, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_UPDATEUI(id, fn) { wxEVT_STC_UPDATEUI, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_SAVEPOINTREACHED(id, fn) { wxEVT_STC_SAVEPOINTREACHED, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_SAVEPOINTLEFT(id, fn) { wxEVT_STC_SAVEPOINTLEFT, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_ROMODIFYATTEMPT(id, fn) { wxEVT_STC_ROMODIFYATTEMPT, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_DOUBLECLICK(id, fn) { wxEVT_STC_DOUBLECLICK, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_MODIFIED(id, fn) { wxEVT_STC_MODIFIED, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_KEY(id, fn) { wxEVT_STC_KEY, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_MACRORECORD(id, fn) { wxEVT_STC_MACRORECORD, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_MARGINCLICK(id, fn) { wxEVT_STC_MARGINCLICK, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_NEEDSHOWN(id, fn) { wxEVT_STC_NEEDSHOWN, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },
#define EVT_STC_POSCHANGED(id, fn) { wxEVT_STC_POSCHANGED, id, -1, (wxObjectEventFunction) (wxEventFunction) (wxStyledTextEventFunction) & fn, (wxObject *) NULL },

#endif

//----------------------------------------------------------------------
//----------------------------------------------------------------------
#endif


