#----------------------------------------------------------------------------
# Name:         ImageEditor.py
# Purpose:      Image Editor for pydocview
#
# Author:       Morgan Hua
#
# Created:      12/24/04
# Copyright:    (c) 2004-2005 ActiveGrid, Inc.
# CVS-ID:       $Id: ImageEditor.py,v 1.1 2005/04/08 22:51:51 RD Exp $
# License:      wxWindows License
#----------------------------------------------------------------------------
import wx
import wx.lib.docview
_ = wx.GetTranslation


class ImageDocument(wx.lib.docview.Document):
    pass


class ImageView(wx.lib.docview.View):


    #----------------------------------------------------------------------------
    # Overridden methods
    #----------------------------------------------------------------------------

    def __init__(self):
        wx.lib.docview.View.__init__(self)
        self._ctrl = None


    def OnCreate(self, doc, flags):
        if len(doc.GetFilename()) == 0:
            wx.MessageBox(_("Cannot create a new image file.\n%s has no paint capability.") % wx.GetApp().GetAppName(),
                                _("New Image File"),
                                wx.OK | wx.ICON_EXCLAMATION)
            return False

        frame = wx.GetApp().CreateDocumentFrame(self, doc, flags)
        panel = wx.Panel(frame, -1)            
        bitmap = wx.Image(doc.GetFilename()).ConvertToBitmap()
        self._ctrl = wx.StaticBitmap(panel, -1, bitmap, (0,0), (bitmap.GetWidth(), bitmap.GetHeight()))
        panel.SetClientSize(bitmap.GetSize())
        frame.SetClientSize(panel.GetSize())
        self.Activate()
        return True


    def OnClose(self, deleteWindow = True):
        statusC = wx.GetApp().CloseChildDocuments(self.GetDocument())
        statusP = wx.lib.docview.View.OnClose(self, deleteWindow = deleteWindow)
        if not (statusC and statusP):
            return False
        self.Activate(False)
        if deleteWindow:
            self.GetFrame().Destroy()
        return True


#----------------------------------------------------------------------------
# Icon Bitmaps - generated by encode_bitmaps.py
#----------------------------------------------------------------------------
from wx import ImageFromStream, BitmapFromImage
from wx import EmptyIcon
import cStringIO


def getImageData():
    return \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x0f\x00\x00\x00\x0e\x08\x06\
\x00\x00\x00\xf0\x8aF\xef\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\
\x00\x00\x97IDAT(\x91\x9d\x93Q\n\xc4 \x0cD\'\xda\xd3\xa9\xe9ac\xdb\x8bx\xa0\
\xf4C"\xd6mAw@\x0c1/\t\x03\x123+\x16\x95s\x06\x00l\x00p\x9c\x17\xad\xc0\xe4<\
R\x0c\xeaf\x81\x14\x83\xa6\x18\x1e[N\xc1)\x06\x15\x01Dj\xbc\x04\x7fi\x9b):\
\xce\x8b\xf6\xbdN\xec\xfd\x99\x82G\xc8\xf4\xba\xf6\x9b9o\xfa\x81\xab9\x02\
\x11i\xe6|6cf%\xe7A\xce\x83\x99\xd5\xc4\xccZJ\xd11\xd7\xd76\xd8\x8aJ)\xed\
\xb6c\x8d,~\xc0\xe3\xe3L\xdc\xe0~\xcaJ\x03\xfa\xe7c\x98n\x01\x88\xc6k\xb1\
\x83\x04\x87\x00\x00\x00\x00IEND\xaeB`\x82' 


def getImageBitmap():
    return BitmapFromImage(getImageImage())

def getImageImage():
    stream = cStringIO.StringIO(getImageData())
    return ImageFromStream(stream)

def getImageIcon():
    icon = EmptyIcon()
    icon.CopyFromBitmap(getImageBitmap())
    return icon

