#----------------------------------------------------------------------------
# Name:         ImageEditor.py
# Purpose:      Image Editor for pydocview
#
# Author:       Morgan Hua
#
# Created:      12/24/04
# Copyright:    (c) 2004-2005 ActiveGrid, Inc.
# CVS-ID:       $Id: ImageEditor.py,v 1.4 2005/05/31 21:41:10 RD Exp $
# License:      wxWindows License
#----------------------------------------------------------------------------
import wx
import wx.lib.docview
_ = wx.GetTranslation


class ImageDocument(wx.lib.docview.Document):
    pass


class ImageView(wx.lib.docview.View):


    #----------------------------------------------------------------------------
    # Overridden methods
    #----------------------------------------------------------------------------

    def __init__(self):
        wx.lib.docview.View.__init__(self)
        self._ctrl = None


    def OnCreate(self, doc, flags):
        if len(doc.GetFilename()) == 0:
            wx.MessageBox(_("Cannot create a new image file.\n%s has no paint capability.") % wx.GetApp().GetAppName(),
                                _("New Image File"),
                                wx.OK | wx.ICON_EXCLAMATION)
            return False

        frame = wx.GetApp().CreateDocumentFrame(self, doc, flags)
        panel = wx.Panel(frame, -1)            
        self._bitmap = wx.Image(doc.GetFilename()).ConvertToBitmap()
        self._ctrl = wx.StaticBitmap(panel, -1, self._bitmap, (0,0), (self._bitmap.GetWidth(), self._bitmap.GetHeight()))
        wx.EVT_LEFT_DOWN(self._ctrl, self.OnFocus)
        wx.EVT_LEFT_DCLICK(self._ctrl, self.OnFocus)
        wx.EVT_RIGHT_DOWN(self._ctrl, self.OnFocus)
        wx.EVT_RIGHT_DCLICK(self._ctrl, self.OnFocus)
        wx.EVT_MIDDLE_DOWN(self._ctrl, self.OnFocus)
        wx.EVT_MIDDLE_DCLICK(self._ctrl, self.OnFocus)
        panel.SetClientSize(self._bitmap.GetSize())
        frame.SetClientSize(panel.GetSize())
        self.Activate()
        return True


    def OnFocus(self, event):
        self._ctrl.SetFocus()
        event.Skip()


    def OnClose(self, deleteWindow = True):
        statusC = wx.GetApp().CloseChildDocuments(self.GetDocument())
        statusP = wx.lib.docview.View.OnClose(self, deleteWindow = deleteWindow)
        if not (statusC and statusP):
            return False
        self.Activate(False)
        if deleteWindow:
            self.GetFrame().Destroy()
        return True


    def OnDraw(self, dc):
        """ for Print Preview and Print """
        dc.BeginDrawing()
        dc.DrawBitmap(self._bitmap, 10, 10, True)
        dc.EndDrawing()
        

#----------------------------------------------------------------------------
# Icon Bitmaps - generated by encode_bitmaps.py
#----------------------------------------------------------------------------
from wx import ImageFromStream, BitmapFromImage
import cStringIO


def getImageData():
    return \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x02\
\x00\x00\x00\x90\x91h6\x00\x00\x00\x03sBIT\x08\x08\x08\xdb\xe1O\xe0\x00\x00\
\x00\x9aIDAT(\x91\x95\x92\xc1\r\xc50\x08C\xdd\xaa\xeb\xc12\xec\x90\x9b\x97!\
\x0b\xb0\x03\x19\xe8\x1fR\xa9U\xf2\xd5\xb4>DH\xf8\t\x13\xb1E\x04\xbe\xe8\x00\
@\xf2\x8d\xb5\xd6z\x02\x00\xccl\t\x98\x19\xc9}\xe9#y\x8f\xb0\x00H\xba\xc3\
\xfd\x8a\xbd\x9e0\xe8xn\x9b\x99*q[r\x01`\xfa\x8f?\x91\x86-\x07\x8d\x00Iww\
\xf7\xce\xcc\xf0>\xbb\x01\xa8j)e\x80G\xa0\xb7[k\x00J)\xfdU\xd5\xd6Z\x87O_D\
\x88\x88\x88dff>\x17"r\x02y\xd33\xb3E\xc4\xcb\xe3\xeb\xda\xbe\x9e\xf7\x0f\
\xa0B\x86\xd5X\x16\xcc\xea\x00\x00\x00\x00IEND\xaeB`\x82' 


def getImageBitmap():
    return BitmapFromImage(getImageImage())

def getImageImage():
    stream = cStringIO.StringIO(getImageData())
    return ImageFromStream(stream)

def getImageIcon():
    return wx.IconFromBitmap(getImageBitmap())

