//
// From SwiftUI by Example by Paul Hudson (@twostraws)
// https://www.hackingwithswift.com/quick-start/swiftui
// License: https://www.hackingwithswift.com/license
//

import ImagePlayground
import SwiftUI

struct ContentView: View {
    @State private var imageDescription = ""
    @State private var isShowingImagePlayground = false
    @State private var imageURL: URL?

    var body: some View {
        VStack(spacing: 20) {
            TextField("Describe an image", text: $imageDescription)
                .textFieldStyle(.roundedBorder)

            Button("Image Playground", systemImage: "apple.image.playground") {
                isShowingImagePlayground = true
            }

            AsyncImage(url: imageURL) { image in
                image
                    .resizable()
                    .scaledToFit()
            } placeholder: {
                Text("(No image)")
            }
        }
        .padding()
        .imagePlaygroundSheet(isPresented: $isShowingImagePlayground, concept: imageDescription) { url in
            if let imageURL {
                try? FileManager.default.removeItem(at: imageURL)
            }

            let newImageURL = URL.documentsDirectory.appending(path: "\(UUID()).png")
            try? FileManager.default.moveItem(at: url, to: newImageURL)
            imageURL = newImageURL
        }
    }
}