package cz.eman.jsonrpc.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

import org.apache.log4j.Logger;

public class TcpJsonClient implements ClientProvider {

	protected static final Logger log = Logger.getLogger(TcpJsonClient.class);

	protected Socket socket;

	protected PrintWriter writer = null;

	protected BufferedReader reader = null;

	protected InetSocketAddress address;

	public TcpJsonClient(final InetSocketAddress address) throws IOException {
		this(address, true);
	}

	public TcpJsonClient(final InetSocketAddress address, final boolean initialConnect) throws IOException {
		this.address = address;
		if (initialConnect) {
			connect();
		}
	}

	public synchronized String sendContent(final String content) throws IOException {
		if (socket == null || socket.isClosed() || !socket.isConnected()) {
			connect();
		}
		log.debug("Sending content: " + content);
		writer.println(content);
		writer.flush();
		String result = reader.readLine();
		log.debug("Result: " + result);
		return result;
	}

	@Override
	public void close() throws IOException {
		if (socket != null) {
			socket.close();
		}
	}

	public void connect() throws IOException {
		if (socket != null && socket.isConnected() && !socket.isClosed()) {
			log.warn("socket: " + socket + " already connected!");
			return;
		}
		this.socket = new Socket();
		socket.connect(address);
		log.debug("connected to address: " + address);
		writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
		reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
	}
}
