/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.wrappergen.c;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class ClassAnalyzer {
    private Class cl;
    static /* synthetic */ Class class$java$lang$Object;

    public ClassAnalyzer(Class cl) {
        this.cl = cl;
    }

    public Class getClassObject() {
        return this.cl;
    }

    public String getMangledName() {
        return this.cl.getName().replace('.', '_').replaceAll("\\$", "__");
    }

    public String getNamespacedName() {
        return this.cl.getName().replaceAll("\\.", "::").replaceAll("\\$", "__");
    }

    public String[] getNamespaces() {
        return this.cl.getName().replaceAll("\\$", "__").split("\\.");
    }

    public String getSlashedName() {
        return this.cl.getName().replace('.', '/');
    }

    public Class getSuperClass() {
        Class parent = this.cl.getSuperclass();
        if (parent == null && this.cl.isInterface()) {
            parent = class$java$lang$Object == null ? (class$java$lang$Object = ClassAnalyzer.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return parent;
    }

    private Class findArrayType(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public Class[] getAllRequiredClasses() {
        ArrayList<Class> ret = new ArrayList<Class>();
        Class<?> temp = this.getSuperClass();
        if (temp != null && !ret.contains(temp)) {
            ret.add(temp);
        }
        Class<?>[] interfaces = this.cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            temp = interfaces[i];
            if (temp == null || ret.contains(temp)) continue;
            ret.add(temp);
        }
        Constructor<?>[] constructors = this.cl.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            Class<?>[] params = constructor.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                temp = params[j];
                if (temp.isArray()) {
                    temp = this.findArrayType(temp);
                }
                if (temp.isPrimitive() || ret.contains(temp)) continue;
                ret.add(temp);
            }
        }
        Method[] methods = this.cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers())) continue;
            temp = method.getReturnType();
            if (temp.isArray()) {
                temp = this.findArrayType(temp);
            }
            if (!temp.isPrimitive() && !ret.contains(temp)) {
                ret.add(temp);
            }
            Class<?>[] params = method.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                temp = params[j];
                if (temp.isArray()) {
                    temp = this.findArrayType(temp);
                }
                if (temp.isPrimitive() || ret.contains(temp)) continue;
                ret.add(temp);
            }
        }
        Field[] fields = this.cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!Modifier.isPublic(field.getModifiers())) continue;
            temp = field.getType();
            if (temp.isArray()) {
                temp = this.findArrayType(temp);
            }
            if (temp.isPrimitive() || ret.contains(temp)) continue;
            ret.add(temp);
        }
        return ret.toArray(new Class[ret.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

