/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.wrappergen.c;

import java.lang.reflect.Constructor;
import org.kapott.wrappergen.c.Datatype;

public class ConstructorAnalyzer {
    private Constructor constructor;

    public ConstructorAnalyzer(Constructor constructor) {
        this.constructor = constructor;
    }

    protected ConstructorAnalyzer() {
    }

    public String getNativeSignature() {
        return this.generateNativeSignature(this.constructor.getParameterTypes());
    }

    protected String generateNativeSignature(Class[] params) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            Class param = params[i];
            Datatype datatype = Datatype.getInstance(param);
            if (i != 0) {
                ret.append(", ");
            }
            ret.append(datatype.getNativeSignature() + " arg" + (i + 1));
        }
        return ret.toString();
    }

    public String getJavaSignature() {
        return this.generateJavaSignature(this.constructor.getParameterTypes());
    }

    protected String generateJavaSignature(Class[] params) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            Class param = params[i];
            Datatype datatype = Datatype.getInstance(param);
            ret.append(datatype.getJavaSignature());
        }
        return ret.toString();
    }
}

