/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.wrappergen.c;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.kapott.wrappergen.c.ClassAnalyzer;
import org.kapott.wrappergen.c.ConstructorAnalyzer;
import org.kapott.wrappergen.c.Datatype;
import org.kapott.wrappergen.c.FieldAnalyzer;
import org.kapott.wrappergen.c.MethodAnalyzer;

public class Main {
    public static final boolean DEBUG = false;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) throws Exception {
        new Main().start(args);
    }

    private Main() {
    }

    private void start(String[] args) throws Exception {
        String line;
        List<String> keywords = Arrays.asList("delete");
        ArrayList<Class> classesToDo = new ArrayList<Class>();
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        Properties config = new Properties();
        while ((line = reader.readLine()) != null) {
            String[] keyvalue = line.split("=", 2);
            if (keyvalue.length != 2) continue;
            String key = keyvalue[0].trim();
            String value = keyvalue[1].trim();
            Iterator<Object> i = config.keySet().iterator();
            while (i.hasNext()) {
                String vname = (String)i.next();
                String vvalue = config.getProperty(vname);
                value = value.replaceAll("\\$\\{" + vname + "\\}", vvalue);
            }
            config.setProperty(key, value);
        }
        reader.close();
        String targetPath = config.getProperty("targetpath", ".");
        boolean verbose = config.getProperty("verbose", "").equals("true");
        reader = new BufferedReader(new FileReader(config.getProperty("classfile")));
        while ((line = reader.readLine()) != null) {
            String clName = line.trim();
            if (clName.length() == 0) continue;
            classesToDo.add(Class.forName(clName));
        }
        reader.close();
        PrintWriter classIncludefile = new PrintWriter(new FileWriter(targetPath + File.separator + "java_classes.h"));
        classIncludefile.println("#ifndef JAVA_CLASSES_H");
        classIncludefile.println("#define JAVA_CLASSES_H");
        for (int c = 0; c < classesToDo.size(); ++c) {
            int i;
            int i2;
            String name;
            int i3;
            Class cl = (Class)classesToDo.get(c);
            ClassAnalyzer cla = new ClassAnalyzer(cl);
            String className = cl.getName();
            String classNameMangled = cla.getMangledName();
            String classNameSlashed = cla.getSlashedName();
            String classNameNamespaced = cla.getNamespacedName();
            String[] classNamespaces = cla.getNamespaces();
            String classNamePlain = classNamespaces[classNamespaces.length - 1];
            boolean isBaseObject = cl.equals(class$java$lang$Object == null ? Main.class$("java.lang.Object") : class$java$lang$Object);
            if (verbose) {
                System.out.println("generating c++-wrapper for " + className);
            }
            classIncludefile.println("#include <" + classNameMangled + ".h>");
            PrintWriter outputH = new PrintWriter(new FileWriter(targetPath + File.separator + classNameMangled + ".h"));
            outputH.println("#ifndef " + classNameMangled + "_H");
            outputH.println("#define " + classNameMangled + "_H");
            outputH.println("#include <jni.h>");
            outputH.println("#include <java_marker.h>");
            Class[] requiredClasses = cla.getAllRequiredClasses();
            Class parent = cla.getSuperClass();
            for (i3 = 0; i3 < requiredClasses.length; ++i3) {
                Class requiredClass = requiredClasses[i3];
                ClassAnalyzer requiredCLA = new ClassAnalyzer(requiredClass);
                String requiredMangled = requiredCLA.getMangledName();
                String[] requiredNamespaces = requiredCLA.getNamespaces();
                String requiredPlain = requiredNamespaces[requiredNamespaces.length - 1];
                if (requiredMangled.equals(classNameMangled)) continue;
                if (requiredClass.equals(parent)) {
                    outputH.println("#include <" + requiredMangled + ".h>");
                } else {
                    int n;
                    outputH.println();
                    String[] namespaces = requiredCLA.getNamespaces();
                    for (n = 0; n < namespaces.length - 1; ++n) {
                        outputH.println("namespace " + namespaces[n] + " {");
                    }
                    outputH.println("class " + requiredPlain + ";");
                    for (n = 0; n < namespaces.length - 1; ++n) {
                        outputH.println("}");
                    }
                }
                if (classesToDo.contains(requiredClass)) continue;
                classesToDo.add(requiredClass);
            }
            if (isBaseObject) {
                outputH.println("#include <java_base_class.h>");
            }
            outputH.println("class JavaByteArray;");
            outputH.println("class JavaBooleanArray;");
            outputH.println("class JavaCharArray;");
            outputH.println("class JavaIntArray;");
            outputH.println("class JavaShortArray;");
            outputH.println("class JavaLongArray;");
            outputH.println("class JavaDoubleArray;");
            outputH.println("class JavaFloatArray;");
            outputH.println("class JavaObjectArray;");
            outputH.println();
            for (i3 = 0; i3 < classNamespaces.length - 1; ++i3) {
                outputH.println("namespace " + classNamespaces[i3] + " {");
            }
            outputH.print("class " + classNamePlain);
            if (parent != null) {
                outputH.print(" : public " + new ClassAnalyzer(parent).getNamespacedName());
            } else {
                outputH.print(" : public JavaBaseClass");
            }
            outputH.println(" {");
            outputH.println("  public:");
            outputH.println("    " + classNamePlain + "(JavaMarker* dummy);");
            outputH.println("    " + classNamePlain + "(jobject obj);");
            Constructor<?>[] constructors = cl.getDeclaredConstructors();
            List<String> signatures = new ArrayList<String>();
            for (int i4 = 0; i4 < constructors.length; ++i4) {
                Constructor<?> constructor = constructors[i4];
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                ConstructorAnalyzer cona = new ConstructorAnalyzer(constructor);
                String signature = cona.getNativeSignature();
                if (!signatures.contains(signature)) {
                    outputH.println("    " + classNamePlain + "(" + signature + "); // " + constructor.toString());
                    signatures.add(signature);
                    continue;
                }
                if (!verbose) continue;
                System.out.println("skipping constructor " + classNameNamespaced + "(" + signature + ") because of duplicate native signature");
            }
            outputH.println();
            outputH.println("    virtual void updateAllVariables(JavaMarker* dummy);");
            outputH.println("    virtual void updateAllNonFinalVariables(JavaMarker* dummy);");
            Method[] methods = cl.getDeclaredMethods();
            Hashtable<String, List<String>> signatureMap = new Hashtable<String, List<String>>();
            for (int i5 = 0; i5 < methods.length; ++i5) {
                Method method = methods[i5];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                MethodAnalyzer methoda = new MethodAnalyzer(method);
                String signature = methoda.getNativeSignature();
                name = method.getName();
                if (keywords.contains(name)) {
                    name = name + "_";
                }
                if ((signatures = (List)signatureMap.get(name)) == null) {
                    signatures = new ArrayList();
                    signatureMap.put(name, signatures);
                }
                if (!signatures.contains(signature)) {
                    outputH.println("    virtual " + methoda.getNativeReturnType() + " " + name + "(" + signature + "); // " + method.toString());
                    signatures.add(signature);
                    continue;
                }
                if (!verbose) continue;
                System.out.println("skipping method " + classNameNamespaced + "." + name + "(" + signature + ") because of duplicate native signature");
            }
            outputH.println();
            Field[] fields = cl.getDeclaredFields();
            for (i2 = 0; i2 < fields.length; ++i2) {
                Field field = fields[i2];
                if (!Modifier.isPublic(field.getModifiers())) continue;
                FieldAnalyzer fielda = new FieldAnalyzer(field);
                name = field.getName();
                if (keywords.contains(name)) {
                    name = name + "_";
                }
                outputH.println("    " + fielda.getNativeType() + " " + name + "; // " + field.toString());
            }
            outputH.println("};");
            for (i2 = 0; i2 < classNamespaces.length - 1; ++i2) {
                outputH.println("}");
            }
            outputH.println("#endif");
            outputH.close();
            PrintWriter outputC = new PrintWriter(new FileWriter(targetPath + File.separator + classNameMangled + ".cpp"));
            outputC.println("#include <string.h>");
            outputC.println("#include <jni.h>");
            outputC.println("#include <java_marker.h>");
            outputC.println("#include <java_array.h>");
            outputC.println("#include <" + classNameMangled + ".h>");
            for (i = 0; i < requiredClasses.length; ++i) {
                Class requiredClass = requiredClasses[i];
                name = new ClassAnalyzer(requiredClass).getMangledName();
                if (name.equals(classNameMangled)) continue;
                outputC.println("#include <" + name + ".h>");
            }
            if (isBaseObject) {
                outputH.println("#include <java_base_class.h>");
            }
            outputC.println("extern JNIEnv     *javaEnv;");
            outputC.println("extern JavaMarker *wrapperIntern;");
            outputC.println();
            for (i = 0; i < classNamespaces.length - 1; ++i) {
                outputC.println("namespace " + classNamespaces[i] + " {");
            }
            outputC.println();
            outputC.println(classNamePlain + "::" + classNamePlain + "(JavaMarker* dummy)");
            if (parent != null) {
                outputC.println("  : " + new ClassAnalyzer(parent).getNamespacedName() + "(dummy)");
            } else {
                outputC.println("  : JavaBaseClass(dummy)");
            }
            outputC.println("{");
            outputC.println("  updateAllVariables(wrapperIntern);");
            outputC.println("}");
            outputC.println();
            outputC.println(classNamePlain + "::" + classNamePlain + "(jobject obj)");
            if (parent != null) {
                outputC.println("  : " + new ClassAnalyzer(parent).getNamespacedName() + "(obj)");
            } else {
                outputC.println("  : JavaBaseClass(obj)");
            }
            outputC.println("{");
            outputC.println("  updateAllVariables(wrapperIntern);");
            outputC.println("}");
            signatures.clear();
            for (i = 0; i < constructors.length; ++i) {
                int l;
                String[] code;
                Datatype dt;
                Class<?> param;
                int j;
                ConstructorAnalyzer cona;
                String signature;
                Constructor<?> constructor = constructors[i];
                if (!Modifier.isPublic(constructor.getModifiers()) || signatures.contains(signature = (cona = new ConstructorAnalyzer(constructor)).getNativeSignature())) continue;
                outputC.println();
                outputC.println(classNamePlain + "::" + classNamePlain + "(" + signature + ")");
                if (parent != null) {
                    outputC.println("  : " + new ClassAnalyzer(parent).getNamespacedName() + "(wrapperIntern)");
                } else {
                    outputC.println("  : JavaBaseClass(wrapperIntern)");
                }
                outputC.println("{");
                outputC.println("  jclass    cls = javaEnv->FindClass(\"" + classNameSlashed + "\");");
                outputC.println("  handleJavaException(wrapperIntern);");
                outputC.println("  jmethodID mid = javaEnv->GetMethodID(cls, \"<init>\", \"(" + cona.getJavaSignature() + ")V\");");
                outputC.println("  handleJavaException(wrapperIntern);");
                Class<?>[] params = constructor.getParameterTypes();
                for (j = 0; j < params.length; ++j) {
                    param = params[j];
                    dt = Datatype.getInstance(param);
                    code = dt.native2JavaPre("arg" + (j + 1), "jarg" + (j + 1));
                    for (l = 0; l < code.length; ++l) {
                        if (code[l] == null) continue;
                        outputC.println("  " + code[l]);
                    }
                }
                outputC.print("  jobject o = javaEnv->NewObject(cls, mid");
                for (j = 0; j < params.length; ++j) {
                    outputC.print(", jarg" + (j + 1));
                }
                outputC.println(");");
                outputC.println("  handleJavaException(wrapperIntern);");
                outputC.println("  setJavaObject(o);");
                outputC.println("  javaEnv->DeleteLocalRef(o);");
                for (j = 0; j < params.length; ++j) {
                    param = params[j];
                    dt = Datatype.getInstance(param);
                    code = dt.native2JavaPost("arg" + (j + 1), "jarg" + (j + 1));
                    for (l = 0; l < code.length; ++l) {
                        if (code[l] == null) continue;
                        outputC.println("  " + code[l]);
                    }
                }
                outputC.println("  updateAllVariables(wrapperIntern);");
                outputC.println("}");
                signatures.add(signature);
            }
            for (int methodIdx = 0; methodIdx < 2; ++methodIdx) {
                outputC.println();
                String methodName = methodIdx == 0 ? "updateAllVariables" : "updateAllNonFinalVariables";
                outputC.println("void " + classNamePlain + "::" + methodName + "(JavaMarker* dummy)");
                outputC.println("{");
                outputC.println("  jclass cls = javaEnv->FindClass(\"" + classNameSlashed + "\");");
                outputC.println("  handleJavaException(wrapperIntern);");
                for (int i6 = 0; i6 < fields.length; ++i6) {
                    Field field = fields[i6];
                    int modifier = field.getModifiers();
                    if (!Modifier.isPublic(modifier) || methodIdx == 1 && Modifier.isFinal(modifier)) continue;
                    FieldAnalyzer fielda = new FieldAnalyzer(field);
                    String name2 = field.getName();
                    if (Modifier.isStatic(modifier)) {
                        outputC.println("  jfieldID fid_" + name2 + " = javaEnv->GetStaticFieldID(cls, \"" + name2 + "\", \"" + fielda.getJavaSignature() + "\");");
                    } else {
                        outputC.println("  jfieldID fid_" + name2 + " = javaEnv->GetFieldID(cls, \"" + name2 + "\", \"" + fielda.getJavaSignature() + "\");");
                    }
                    outputC.println("  handleJavaException(wrapperIntern);");
                    outputC.print("  " + fielda.getJNIReturnType() + " jresult_" + name2 + " = ");
                    if (Modifier.isStatic(modifier)) {
                        outputC.println("javaEnv->GetStatic" + fielda.getReturnTypeName() + "Field(cls, fid_" + name2 + ");");
                    } else {
                        outputC.println("javaEnv->Get" + fielda.getReturnTypeName() + "Field(this->getJavaObject(), fid_" + name2 + ");");
                    }
                    outputC.println("  handleJavaException(wrapperIntern);");
                    String[] code = Datatype.getInstance(field.getType()).java2Native("jresult_" + name2, "result_" + name2);
                    for (int l = 0; l < code.length; ++l) {
                        if (code[l] == null) continue;
                        outputC.println("  " + code[l]);
                    }
                    outputC.println("  this->" + name2 + " = result_" + name2 + ";");
                }
                outputC.println("}");
            }
            signatureMap.clear();
            for (i = 0; i < methods.length; ++i) {
                int j;
                Method method = methods[i];
                int modifier = method.getModifiers();
                if (!Modifier.isPublic(modifier)) continue;
                MethodAnalyzer methoda = new MethodAnalyzer(method);
                String signature = methoda.getNativeSignature();
                String name3 = method.getName();
                if (keywords.contains(name3)) {
                    name3 = name3 + "_";
                }
                if ((signatures = (List)signatureMap.get(name3)) == null) {
                    signatures = new ArrayList();
                    signatureMap.put(name3, signatures);
                }
                if (signatures.contains(signature)) continue;
                outputC.println();
                outputC.println(methoda.getNativeReturnType() + " " + classNamePlain + "::" + name3 + "(" + signature + ")");
                outputC.println("{");
                outputC.println("  jclass    cls = javaEnv->FindClass(\"" + classNameSlashed + "\");");
                outputC.println("  handleJavaException(wrapperIntern);");
                if (Modifier.isStatic(modifier)) {
                    outputC.println("  jmethodID mid = javaEnv->GetStaticMethodID(cls, \"" + name3 + "\", \"(" + methoda.getJavaSignature() + ")" + methoda.getJavaReturnType() + "\");");
                } else {
                    outputC.println("  jmethodID mid = javaEnv->GetMethodID(cls, \"" + name3 + "\", \"(" + methoda.getJavaSignature() + ")" + methoda.getJavaReturnType() + "\");");
                }
                outputC.println("  handleJavaException(wrapperIntern);");
                Class<?>[] params = method.getParameterTypes();
                for (int j2 = 0; j2 < params.length; ++j2) {
                    Class<?> param = params[j2];
                    Datatype dt = Datatype.getInstance(param);
                    String[] code = dt.native2JavaPre("arg" + (j2 + 1), "jarg" + (j2 + 1));
                    for (int l = 0; l < code.length; ++l) {
                        if (code[l] == null) continue;
                        outputC.println("  " + code[l]);
                    }
                }
                boolean isVoid = methoda.getReturnTypeName().equals("Void");
                outputC.print("  ");
                if (!isVoid) {
                    outputC.print(methoda.getJNIReturnType() + " jresult=");
                }
                if (Modifier.isStatic(modifier)) {
                    outputC.print("javaEnv->CallStatic" + methoda.getReturnTypeName() + "Method(cls, mid");
                } else {
                    outputC.print("javaEnv->Call" + methoda.getReturnTypeName() + "Method(this->getJavaObject(), mid");
                }
                for (j = 0; j < params.length; ++j) {
                    outputC.print(", jarg" + (j + 1));
                }
                outputC.println(");");
                outputC.println("  handleJavaException(wrapperIntern);");
                for (j = 0; j < params.length; ++j) {
                    Class<?> param = params[j];
                    Datatype dt = Datatype.getInstance(param);
                    String[] code = dt.native2JavaPost("arg" + (j + 1), "jarg" + (j + 1));
                    for (int l = 0; l < code.length; ++l) {
                        if (code[l] == null) continue;
                        outputC.println("  " + code[l]);
                    }
                }
                if (!isVoid) {
                    String[] code = Datatype.getInstance(method.getReturnType()).java2Native("jresult", "result");
                    for (int l = 0; l < code.length; ++l) {
                        if (code[l] == null) continue;
                        outputC.println("  " + code[l]);
                    }
                    outputC.println("  return result;");
                }
                outputC.println("  updateAllNonFinalVariables(wrapperIntern);");
                outputC.println("}");
                signatures.add(signature);
            }
            for (i = 0; i < classNamespaces.length - 1; ++i) {
                outputC.println("}");
            }
            outputC.close();
        }
        classIncludefile.println("#endif");
        classIncludefile.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

