from __future__ import division
import sys

from cbook import True, False
from transforms import RWRef

class DPI(RWRef):
    'DPI as a read/write reference'
    pass
    
    
class Artist:
    """
    Abstract base class for someone who renders into a Figure

    Public attributes
      dpi  : a DPI instance
      bbox : a Bound2D instance in display coords
      transform : a Transform instance
    """

    aname = 'Artist'
    def __init__(self, dpi, bbox, clipOn=True):        
        self._drawable = None
        self._lod = False
        self.dpi = dpi
        self.bbox = bbox
        self._clipOn = True

    def get_clip_on(self):
        'Return whether artist uses clipping'
        return self._clipOn

    def set_clip_on(self, b):
        'Set whether artist is clipped to bbox'        
        self.set_child_attr('_clipOn', b)


    def set_transform(self, transform):
        """
        Set the artist transform for self and all children
        """
        self.set_child_attr('transform', transform)
        

    def set_child_attr(self, attr, val):
        """
        Set attribute attr for self, and all child artists
        """
        setattr(self, attr, val)
        for c in self.get_child_artists():
            c.set_child_attr(attr, val)

    def get_child_artists(self):
        'Return all artists contained in self'
        return []

    def get_window_extent(self, renderer=None):
        'Return the window extent of the Artist as a Bound2D instance'
        raise NotImplementedError('Derived must override')


    def get_dpi(self):
        """
        Get the DPI of the display
        """
        return self._dpi


    def draw(self, drawable=None, *args, **kwargs):
        'Derived classes drawing method'
        if drawable is None: drawable = self._drawable
        if drawable is None: return
        self._draw(drawable, *args, **kwargs)

    def _draw(self, drawable, *args, **kwargs):
        'Derived classes drawing method'
        raise NotImplementedError, 'Derived must override'

    def set_lod(self, on):
        """
        Set Level of Detail on or off.  If on, the artists may examine
        things like the pixel width of the axes and draw a subset of
        their contents accordingly
        """
        self._lod = on

        


