#!/usr/bin/env python
import os, sys

import pygtk
pygtk.require('2.0')
import gtk
from gtk import gdk

import gd
from matplotlib._gtkgd import gd_to_gtk_drawable

os.environ["GDFONTPATH"] = "."
FONT = "adventure"


def make_gd_image():
    im = gd.image((200, 200))


    white = im.colorAllocate((255, 255, 255))
    red = im.colorAllocate((255, 0, 0))
    blue = im.colorAllocate((0, 0, 255))
    black = im.colorAllocate((0, 0, 0))
    
    im.colorTransparent(white)
    im.interlace(1)


    im.arc((100,100),(195,175),0,360,blue)
    im.fill((100,100),red)
    im.rectangle((0,0),(199,199),black)
    
    im.string_ttf(FONT, 20.0, 0.0, (10, 100), "Hello Python", black)
    if 0:
        f=file("xx.png","w")
        im.writePng(f)
        f.close()
    return im

def gd2gtktest(widget):
    drawable = widget.window
    im = make_gd_image()
    print gd_to_gtk_drawable(drawable, im)
    
def draw(widget):
    print 'draw'
    gc = widget.window.new_gc()
    #widget.window.draw_rectangle( gc, 1, 100,100,100,100)
    gd2gtktest(widget)
    
def configure_event(widget, event):
    print 'config'
    draw(widget)
    return gtk.TRUE

def expose_event(widget, event):
    print 'expose'
    #draw(widget)
    return gtk.TRUE

def realize(widget):
    print 'realize'
    #draw(widget)
    return gtk.TRUE

win = gtk.Window()
win.set_size_request(640, 480)
win.show()


vbox = gtk.VBox()
vbox.show()
win.add(vbox)

da = gtk.DrawingArea()
da.connect('configure_event', configure_event)
da.connect('expose_event', configure_event)
da.connect('realize', realize)
da.show()
vbox.pack_start(da, gtk.TRUE, gtk.TRUE)


button = gtk.Button('Quit')
button.show()
vbox.pack_start(button, gtk.FALSE, gtk.FALSE)
button.connect('clicked', gtk.mainquit)

gtk.mainloop()
