import matplotlib
#matplotlib.use('PS')

from matplotlib.matlab import *
from matplotlib.table import Table


N = 6

ind = arange(N)
bottom = [0] * N
labels = []
handles = []
for row, colour in zip(xrange(N), 'rgbcmyw'):
    data = abs(randn(N))
    patches = bar(ind, data, bottom=bottom, color=colour, width=0.8)
    set(gca(), 'xticklabels', [])
    set(gca(), 'xticks', [])
    bottom = bottom + data
    labels.append(['%3.2f' % x for x in data])
    handles.append(patches)

labels.reverse()
handles.reverse()

for xpos in ('left', 'right', ''):
    for ypos in ('top', 'bottom', ''):
        pos = ' '.join([x for x in [ypos, xpos] if x])
        if pos:
            row_offset = 0
            if pos.find(' ') >= 0:
                row_offset = 1
            table = Table(gca(), [1.0 / N] * N, labels, handles, loc=pos, grid='k-', rowOffset=row_offset)
            gca().add_table(table)

# add some inner tables
for xpos in ('left', 'right'):
    for ypos in ('upper', 'lower'):
        pos = ' '.join([x for x in [ypos, xpos] if x])
        if pos:
            table = Table(gca(), [0.3], [['hello']], [[handles[0][0]]],
                                                      loc=pos)
            gca().add_table(table)

show()
