import matplotlib
#matplotlib.use('PS')

from RandomArray import exponential

from matplotlib.matlab import *
from matplotlib.table import Table

axes([0.3, 0.3, 0.6, 0.6])
means = {
    'Quake': 1e6,
    'Wind':  7e5,
    'Flood': 5e5,
    'Freeze': 4e5,
    }
perils = means.keys()
perils.sort()

my_colours='rgbcy'
rows = len(my_colours)
plot_data = {}
for peril in perils:
    data = exponential(means[peril], rows)
    data = sort(data)
    plot_data[peril] = data

N = len(perils)
yoff = array([0.0] * N)
ind = arange(N)  # the x locations for the groups
ind = ind + .3
width = 0.4     # the width of the bars

labels = []
handles = []
#for values, color in zip(plot_data, my_colours):

for row in xrange(rows):

    data = [plot_data[peril][row] for peril in perils]
    data = data - yoff
    patches = bar(ind, data, width, bottom=yoff, color=my_colours[row])
    yoff = data + yoff
    labels.append(['%d' % (val / 1000,) for val in yoff])
    handles.append([patches[0]])

labels.append(perils)

set(gca(), 'xticks', [])
#set(gca(), 'yticks', [])

labels.reverse()
table = Table(gca(), [1.0 / N] * N, labels, loc='bottom')
gca().add_table(table)

row_labels = []
for x in range(rows):
    row_labels.append('%d year' % ((rows / (1.0 + x)) + 0.5,))
row_labels.reverse()
handles.reverse()
table2 = Table(gca(), [0.2], row_labels, handles, loc='bottom left',
               rowOffset=1)
gca().add_table(table2)

show()
