from __future__ import division

import os, sys, math

try:  # todo: test this with default RHL8 install.
    import pygtk
    pygtk.require('2.0')
except:
    print sys.exc_info()[1]
    print >>sys.stderr, 'matplotlib requires pygtk-1.99.16 or greater -- trying anyway.  Please hold on'


import gobject
import gtk
from gtk import gdk
import pango

import matplotlib
from Numeric import Int16, asarray

from matplotlib.cbook import is_string_like,  enumerate, True, False
from matplotlib.transforms import Bound2D

from matplotlib.backend_bases import \
     RendererBase, GraphicsContextBase, FigureManagerBase, FigureCanvasBase
from matplotlib._matlab_helpers import Gcf
from matplotlib.figure import Figure

# enable ps save from gtk backend
from backend_ps import FigureCanvasPS

# the true dots per inch on the screen; should be display dependent
# see http://groups.google.com/groups?q=screen+dpi+x11&hl=en&lr=&ie=UTF-8&oe=UTF-8&safe=off&selm=7077.26e81ad5%40swift.cs.tcd.ie&rnum=5 for some info about screen dpi
PIXELS_PER_INCH = 75

def round(x):
    return int(math.floor(x+0.5))


class ColorManagerGTK:
    _cached = {}  # a map from get_color args to colors
    _cmap = None
    
    def set_drawing_area(self, da):
        self._cmap = da.get_colormap()

    def get_color(self, rgb):
        """
        RGB is a unit RGB tuple, return a gtk.gdk.Color
        """

        try: return self._cached[tuple(rgb)]
        except KeyError: pass
        
        if self._cmap is None:
            raise RuntimeError('First set the drawing area!')

        #print 'rgb is', rgb
        r,g,b = rgb
        color = self._cmap.alloc_color(int(r*65025),int(g*65025),int(b*65025))
        self._cached[tuple(rgb)] = color
        return color

    def get_rgb(self, color):
        """
        RGB is a unit RGB tuple, return a gtk.gdk.Color
        """

        return [val/65535 for val in (color.red, color.green, color.blue)]

colorManager = ColorManagerGTK()

class RendererGTK(RendererBase):

    fontweights = {'normal' : pango.WEIGHT_NORMAL,
                   'bold' : pango.WEIGHT_BOLD,
                   'heavy' : pango.WEIGHT_HEAVY,
                   'light' : pango.WEIGHT_LIGHT,
                   'normal' : pango.WEIGHT_NORMAL,
                   'ultrabold' : pango.WEIGHT_ULTRABOLD,
                   'ultralight' : pango.WEIGHT_ULTRALIGHT,
                   }
    fontangles = {
        'italic': pango.STYLE_ITALIC,
        'normal' : pango.STYLE_NORMAL,
        'oblique' : pango.STYLE_OBLIQUE,
        }


    def __init__(self, gtkDA, gdkDrawable, dpi):
        self.gtkDA = gtkDA
        self.gdkDrawable = gdkDrawable
        self.width, self.height = self.gdkDrawable.get_size()
        self.dpi = dpi
        self.layoutd = {}  # a map from text prop tups to pango layouts

    def compute_text_offsets(self, t):
        """
        Return the (x,y) offsets to adjust for the alignment
        specifications
        """

        layout = self.get_pango_layout(t)

        inkRect, logicalRect = layout.get_pixel_extents()
        rect = inkRect
        l, b, w, h = rect



        rotation = t.get_rotation()
        halign = t.get_horizontalalignment()
        valign = t.get_verticalalignment()
        
        if rotation=='vertical':
            w, h = h, w
            l,b = b, l
            if halign=='center': offsetx = -w/2
            elif halign=='right': offsetx = -w
            else: offsetx = -b
            
            if valign=='center': offsety = -h/2-b
            elif valign=='top': offsety = 0
            else: offsety = -h
        else:
            if halign=='center': offsetx = -w/2
            elif halign=='right': offsetx = -w
            else: offsetx = 0

            if valign=='center': offsety = h/2
            elif valign=='top': offsety = 0
            else: offsety = h

        return (offsetx-l, offsety+b)

    
    def draw_arc(self, gc, faceColor, x, y, width, height, angle1, angle2):
        """
        Draw an arc centered at x,y with width and height
        """
        x, y = int(x-0.5*width), self.height-int(y+0.5*height)
        w, h = int(width)+1, int(height)+1
        a1, a2 = int(angle1*64), int(angle2*64)

        if faceColor is not None:            
            rgb = gc.get_rgb()
            gc.set_foreground(faceColor)
            self.gdkDrawable.draw_arc(gc.gdkGC, True, x, y, w, h, a1, a2)
            gc.set_foreground(rgb)
        self.gdkDrawable.draw_arc(gc.gdkGC, False, x, y, w, h, a1, a2)
            
    def draw_line(self, gc, x1, y1, x2, y2):
        """
        Draw a single line from x1,y1 to x2,y2
        """
        self.gdkDrawable.draw_line(
            gc.gdkGC, int(x1), self.height-int(y1),
            int(x2), self.height-int(y2))


    def draw_lines(self, gc, x, y):
        y = self.height - y.astype(Int16)
        x = x.astype(Int16)
        self.gdkDrawable.draw_lines(gc.gdkGC, zip(x,y))

    def draw_point(self, gc, x, y):
        """
        Draw a single point at x,y
        """
        self.gdkDrawable.draw_point(
            gc.gdkGC, int(x), self.height-int(y))

    def draw_polygon(self, gc, faceColor, points):
        """
        Draw a polygon.  points is a len vertices tuple, each element
        giving the x,y coords a vertex

        If faceColor is not None, fill the rectangle with it.  gcEdge
        is a GraphicsContext instance

        """
        points = [(int(x), self.height-int(y)) for x,y in points]
        if faceColor is not None:
            rgb = gc.get_rgb()  #cache color
            gc.set_foreground(faceColor)
            self.gdkDrawable.draw_polygon(gc.gdkGC, False, points)
            gc.set_foreground(rgb)  # restore color
        self.gdkDrawable.draw_polygon(gc.gdkGC, True, points)


    def draw_rectangle(self, gc, faceColor, x, y, width, height):
        """
        Draw a rectangle at lower left x,y with width and height
        If filled=True, fill the rectangle with the gc foreground
        gc is a GraphicsContext instance
        """
        
        #x, y = int(x), self.height-int(y+height)
        #w, h = int(width), int(height)
        x, y = int(x), self.height-int(math.ceil(y+height))
        w, h = int(math.ceil(width)), int(math.ceil(height))


        needEdge=True

        # this is a hack.  high res pcolor was mindnumbingly slow and
        # I found some bottlenecks here in the profiler. I am trying
        # to do some speedups by avoiding the proper function calls
        # and using protected attributes in their place.  Work on
        # improving this!
        if faceColor is not None:
            # cache color; using protected attribute for performace.
            # me = bad, bad
            oldRGB = gc._rgb  
            oldFG = gc.gdkGC.foreground

            
            gc.set_foreground(faceColor)
            self.gdkDrawable.draw_rectangle(gc.gdkGC, True, x, y, w, h)
            if gc._rgb==oldRGB: needEdge = False 

            # restore old colors
            gc._rgb = oldRGB
            gc.gdkGC.foreground = oldFG

        if needEdge:
            self.gdkDrawable.draw_rectangle(gc.gdkGC, False, x, y, w, h)

    def _draw_rotated_text(self, x, y, t, layout, gc):
        """
        Draw the text rotated 90 degrees
        """

        gdrawable = self.gdkDrawable
        ggc = gc.gdkGC


        inkRect, logicalRect = layout.get_pixel_extents()
        rect = logicalRect
        w, h = int(rect[2]), int(rect[3])

        # get the background image
        ox, oy = self.compute_text_offsets(t)
        y = self.height-y

        xox = max(0,int(x+ox))
        yoy = max(0,int(y+oy))

        imgBack = gdrawable.get_image(xox, yoy, h, w)
        if imgBack is None: return 0

        pixmap = gtk.gdk.Pixmap(self.gtkDA.window, w, h)
        

        # rotate the background image to horizontal to fill the pixmap
        # background
        imageHoriz = gtk.gdk.Image(type=0,
                                   visual=pixmap.get_visual(),
                                   width=w, height=h)
        imageHoriz.set_colormap(imgBack.get_colormap())
        for i in range(w):
            for j in range(h):
                imageHoriz.put_pixel(i, j, imgBack.get_pixel(j,w-i-1) )
                



        pixmap.draw_image(ggc, imageHoriz, 0, 0, 0, 0, w, h)

        pixmap.draw_layout(ggc, x=0, y=0, layout=layout)
        imageIn = pixmap.get_image(x=0, y=0, width=w, height=h)
        imageOut = gtk.gdk.Image(type=0,
                                 visual=pixmap.get_visual(),
                                 width=h, height=w)
        imageOut.set_colormap(imageIn.get_colormap())
        for i in range(w):
            for j in range(h):
                imageOut.put_pixel(j, i, imageIn.get_pixel(w-i-1,j) )


        pixbuf = gtk.gdk.Pixbuf(colorspace=gtk.gdk.COLORSPACE_RGB,
                                has_alpha=0, bits_per_sample=8,
                                width=h, height=w)
        pixbuf.get_from_image(src=imageOut, cmap=imageIn.get_colormap(),
                              src_x=0, src_y=0, dest_x=0, dest_y=0,
                              width=h, height=w)

        pixbuf.render_to_drawable(gdrawable, ggc,
                                  src_x=0, src_y=0,
                                  dest_x=xox, dest_y=yoy,
                                  width=h, height=w,
                                  dither=0, x_dither=0, y_dither=0)
        return True



    def draw_text(self, gc, x, y, t):
        if t.get_text()=='': return

        layout = self.get_pango_layout(t)

        ox, oy = self.compute_text_offsets(t)

        if t.get_rotation()=='vertical':            
            drawn = self._draw_rotated_text(x, y, t, layout, gc)
        else:
            xox = int(x+ox)
            yoy = self.height - int(y+oy)

            self.gdkDrawable.draw_layout(
                gc.gdkGC, x=xox, y=yoy,
                layout=layout)


        
    def get_pango_layout(self, t):
        """
        Return a pango layout instance for Text instance t.  cache to
        layoutd
        """
        props = t.get_prop_tup()
        layout = self.layoutd.get(props)
        if layout is not None: return layout

        font = pango.FontDescription(
            '%s' % t.get_fontname())
        font.set_weight(self.fontweights[t.get_fontweight()])
        font.set_style(self.fontangles[t.get_fontangle()])

        scale = self.get_text_scale(t)
        font.set_size(int(scale*t.get_fontsize()*1024))
        context = self.gtkDA.create_pango_context()
        layout  = self.gtkDA.create_pango_layout(t.get_text())
        layout.set_font_description(font)    

        self.layoutd[props] = layout
        return layout


    def get_text_extent(self, t):
        'Return the text extent in display coords as a Bound2D instance'

        layout = self.get_pango_layout(t)
        
        inkRect, logicalRect = layout.get_pixel_extents()
        rect = inkRect
        l,b,w,h = rect
        x, y  = t.get_xy_display()
        ox, oy = self.compute_text_offsets(t)
        x = x+ox
        y = y+oy

        if t.get_rotation()=='vertical':
            w, h = h, w
            left = x
            bottom = y
            left = x+b
        else:
            left = x+l
            bottom = y-h-b

        return Bound2D(left, bottom, w, h)
        

    def get_text_scale(self, t):
        """
        Return the scale factor for fontsize taking screendpi and pixels per
        inch into account
        """
        return t.dpi.get()/PIXELS_PER_INCH

    def points_to_pixels(self, points):
        'Convert points to pixels'
        return points*PIXELS_PER_INCH/72.0*self.dpi.get()/72.0


    def new_gc(self):
        return GraphicsContextGTK(self.gdkDrawable.new_gc(), self)


class GraphicsContextGTK(GraphicsContextBase):

    _joind = {
        'bevel' : gdk.JOIN_BEVEL,
        'miter' : gdk.JOIN_MITER,
        'round' : gdk.JOIN_ROUND,
        }

    _capd = {
        'butt' : gdk.CAP_BUTT,
        'projecting' : gdk.CAP_PROJECTING,
        'round' : gdk.CAP_ROUND,
        }

              
    def __init__(self, gdkGC, renderer):
            GraphicsContextBase.__init__(self)
            self.gdkGC = gdkGC
            self.renderer = renderer


    def set_clip_rectangle(self, rectangle):
        GraphicsContextBase.set_clip_rectangle(self, rectangle)
        l,b,w,h = rectangle
        rectangle = (int(l), self.renderer.height-int(b+h),
                     int(w), int(h))
        self.gdkGC.set_clip_rectangle(rectangle)        


    def set_dashes(self, dash_offset, dash_list):
        GraphicsContextBase.set_dashes(self, dash_offset, dash_list)

        def one_or_round(val):
            if val<1: return 1
            else: return round(val)

        if dash_list is not None:
            pixels = self.renderer.points_to_pixels(asarray(dash_list))
            self.gdkGC.line_style = gdk.LINE_ON_OFF_DASH
            
            dl = [one_or_round(val) for val in pixels]
            self.gdkGC.set_dashes(dash_offset, dl)
        else:
            self.gdkGC.line_style = gdk.LINE_SOLID

    def set_foreground(self, fg):
        """
        Set the foreground color.  fg can be a matlab format string, a
        html hex color string, an rgb unit tuple, or a float between 0
        and 1.  In the latter case, grayscale is used.
        """
        GraphicsContextBase.set_foreground(self, fg)
        self.gdkGC.foreground = self._get_gdk_color()

    def set_graylevel(self, frac):
        """
        Set the foreground color to be a gray level with frac frac
        """
        GraphicsContextBase.set_graylevel(self, frac)
        self.gdkGC.foreground = self._get_gdk_color()
        

    def set_linewidth(self, lw):
        GraphicsContextBase.set_linewidth(self, lw)

        pixels = self.renderer.points_to_pixels(lw)
        if pixels<1: pixels = 1
        else: pixels = round(pixels)

        self.gdkGC.line_width = pixels

    def set_linestyle(self, style):
        GraphicsContextBase.set_linestyle(self, style)
        offset, dashes = self._dashd[style]
        self.set_dashes(offset, dashes)
                                               
    def set_capstyle(self, cs):
        """
        Set the capstyle as a string in ('butt', 'round', 'projecting')
        """
        GraphicsContextBase.set_capstyle(self, cs)
        self.gdkGC.cap_style = self._capd[self._capstyle]

    def set_joinstyle(self, js):
        """
        Set the join style to be one of ('miter', 'round', 'bevel')
        """
        GraphicsContextBase.set_joinstyle(self, js)
        self.gdkGC.join_style = self._joind[self._joinstyle]

    def _get_gdk_color(self):
        return colorManager.get_color(self.get_rgb())


    def _update_gc_line_attributes(self):
        lw = self._linewidth
        js = self._joind[self._joinstyle]
        cs = self._capd[self._capstyle]


        

def raise_msg_to_str(msg):
    """msg is a return arg from a raise.  Join with new lines"""
    if not is_string_like(msg):
        msg = '\n'.join(map(str, msg))
    return msg
    
def error_msg_gtk(msg, parent=None):
    dialog = gtk.MessageDialog(
        parent         = None,
        type           = gtk.MESSAGE_ERROR,
        buttons        = gtk.BUTTONS_OK,
        message_format = msg)
    if parent is not None:
        dialog.set_transient_for(parent)
    dialog.show()
    dialog.run()
    dialog.destroy()
    return None



def draw_if_interactive():
    if matplotlib.is_interactive():
        figManager =  Gcf.get_active()
        if figManager is not None:
            figManager.canvas.draw()
            #fig.queue_draw()


def show():
    """
    Show all the figures and enter the gtk mainloop

    This should be the last line of your script
    """

    for manager in Gcf.get_all_fig_managers():
        manager.window.show()
        
    gtk.mainloop()


def _quit_after_print_xvfb(*args):

    for manager in Gcf.get_all_fig_managers():
        if len(manager.drawingArea._printQued): break
    else: gtk.mainquit()

def show_xvfb():
    """
    Print the pending figures only then quit, no screen draw
    """
    for manager in Gcf.get_all_fig_managers():
        manager.canvas.set_do_plot(False)
        manager.window.show()
        
    gtk.idle_add(_quit_after_print_xvfb)
    gtk.mainloop()                


def new_figure_manager(num, figsize, dpi):
    """
    Create a new figure manager instance
    """
    figure = Figure(figsize, dpi, facecolor=0.7, edgecolor='w')

    canvas = FigureCanvasGTK(figure)
    return FigureManagerGTK(canvas, num)

class FigureCanvasGTK(gtk.DrawingArea, FigureCanvasBase):
    def __init__(self, figure):
        FigureCanvasBase.__init__(self, figure)
        gtk.DrawingArea.__init__(self)

        self._inExpose = False
        self._isConfigured = False
        self._isRealized = False
        self._gpixmap = None
        self._doplot = True
        self._printQued = []


        w = figure.bbox.x.interval()
        h = figure.bbox.y.interval()
        self.set_size_request(int(w), int(h))
        self.set_double_buffered(gtk.FALSE)
        self.connect('key_press_event', self.key_press_event)
        self.connect('key_release_event', self.key_release_event)
        self.connect('expose_event', self.expose_event)
        self.connect('configure_event', self.configure_event)
        self.connect('realize', self.realize)
        self.connect('motion_notify_event', self.motion_notify_event)
        self.connect('button_press_event', self.button_press_event)
        self.connect('button_release_event', self.button_release_event)

        self.set_events(
            #gdk.FOCUS_CHANGE_MASK|
            gdk.KEY_PRESS_MASK|
            gdk.KEY_RELEASE_MASK|
            gdk.EXPOSURE_MASK |
            gdk.LEAVE_NOTIFY_MASK |
            gdk.BUTTON_PRESS_MASK |
            gdk.BUTTON_RELEASE_MASK |
            gdk.POINTER_MOTION_MASK )

    
    def button_press_event(self, widget, event):  pass
    def button_release_event(self, widget, event): pass
    def motion_notify_event(self, widget, event): pass
    def key_press_event(self, widget, event): pass
    def key_release_event(self, widget, event): pass
                
    def configure_event(self, widget, event=None):

        if widget.window is None: return 

        w,h = widget.window.get_size()
        if w==1 or h==1: return # empty fig

        self.figure.bbox.set_bounds(0, 0, w, h)
        for a in self.figure.axes: a.resize()
        
        if self._isConfigured and self._isRealized:
            self.draw()

        self._isConfigured = True
        return gtk.TRUE
        

    def draw(self):
        if not self._doplot: return
        drawable = self.window        
        if drawable is None: return
        
        width = int(self.figure.bbox.x.interval())
        height = int(self.figure.bbox.y.interval())

        gpixmap = gtk.gdk.Pixmap( drawable, width, height)
        pixmap = RendererGTK(self, gpixmap, self.figure.dpi)

        self.figure.draw(pixmap)

        ggc = drawable.new_gc()
        drawable.draw_drawable(
            ggc, gpixmap, 0, 0, 0, 0, width, height)
        self._gpixmap = gpixmap
        self._ggc = ggc

    def expose_event(self, widget, event):
        if widget.window is None: return 

        if self._gpixmap is not None:
            r = event.area
            # redraw from pixmap
            widget.window.draw_drawable(
                self._ggc, self._gpixmap,
                r.x, r.y, r.x, r.y, r.width, r.height)
        else: self.draw()

        return gtk.TRUE


    def print_figure(self, filename, dpi=150, facecolor='w', edgecolor='w'):
        root, ext = os.path.splitext(filename)
        
        ext = ext.lower()[1:]
        if not len(ext):
            filename = filename + '.png'
            ext = 'png'

        if ext=='png': type = 'png'
        elif ext in ('jpg', 'jpeg'): type = 'jpeg'
        elif ext.find('ps')>=0: pass
        else:
            error_msg_gtk('Can only save to formats PNG, JPEG, PS or EPS')            
            return

        if not self._isRealized:
            self._printQued.append((filename, dpi))
            return


        if ext.find('ps')>=0:
            origDPI = self.figure.dpi.get()
            ps = self.switch_backends(FigureCanvasPS)
            ps.figure.dpi.set(72)
            for a in ps.figure.axes: a.resize()
            ps.print_figure(filename, 72, facecolor, edgecolor)
            self.figure.dpi.set(origDPI)
            for a in self.figure.axes: a.resize()
            return

        origfacecolor = self.figure.get_facecolor()
        origedgecolor = self.figure.get_edgecolor()
        self.figure.set_facecolor(facecolor)
        self.figure.set_edgecolor(edgecolor)

        origBounds = self.figure.bbox.get_bounds()
        origDPI = self.figure.dpi.get()
        dpi = 72.0/PIXELS_PER_INCH*dpi

        self.figure.dpi.set(dpi)        
        width = int(self.figure.figsize[0]*dpi)
        height = int(self.figure.figsize[1]*dpi)
        
        self.figure.bbox.set_bounds(0, 0, width, height)


        for a in self.figure.axes: a.resize()

        gdrawable = self.window
        ggc = gdrawable.new_gc()

        gpixmap = gtk.gdk.Pixmap(gdrawable, width, height)
        pixmap = RendererGTK(
            self, gpixmap, self.figure.dpi)

        self.figure.draw(pixmap)
        
        pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, 0, 8, width, height)
        pixbuf.get_from_drawable(gpixmap, gdrawable.get_colormap(),
                                 0, 0, 0, 0, width, height)

        self.figure.set_facecolor(origfacecolor)
        self.figure.set_edgecolor(origedgecolor)
        self.figure.dpi.set(origDPI)
        self.figure.bbox.set_bounds(*origBounds)
        self.configure_event(self, 'configure')

        try: pixbuf.save(filename, type)
        except gobject.GError, msg:
            msg = raise_msg_to_str(msg)
            # note the error must be displayed here because trapping
            # the error on a call or print_figure may not work because
            # printing can be qued and called from realize
            error_msg_gtk('Could not save figure to %s\n\n%s' % (
                filename, msg))

    def realize(self, widget):
        if widget is None: return 
        colorManager.set_drawing_area(widget)

        self._isRealized = True
        for fname, dpi in self._printQued:
            self.print_figure(fname, dpi)
        self._printQued = []
        return gtk.TRUE


    def is_realized(self):
        return self._isRealized


    def set_do_plot(self, b):
        'True if you want to render to screen, False is hardcopy only'
        self._doplot = b


class FigureManagerGTK(FigureManagerBase):
    """
    Public attributes

    canvas      : The FigureCanvas instance
    num         : The Figure number
    toolbar     : The gtk.Toolbar
    window      : The gtk.Window
    
    """
    def __init__(self, canvas, num):
        FigureManagerBase.__init__(self, canvas, num)
        

        self.window = gtk.Window()
        self.window.set_title("Figure %d" % num)
        self.window.set_border_width(5)

        vbox = gtk.VBox(spacing=3)
        self.window.add(vbox)
        vbox.show()

        self.canvas.show()
        vbox.pack_start(self.canvas, gtk.TRUE, gtk.TRUE)

        # must be inited after the window, drawingArea and figure
        # attrs are set
        self.toolbar = NavigationToolbar( canvas, self.window )
        self.toolbar.show()
        vbox.pack_end(self.toolbar, gtk.FALSE, gtk.FALSE )

        def destroy(*args): Gcf.destroy(num)
        self.window.connect("destroy", destroy)

        if matplotlib.is_interactive():
            self.window.show()


    def add_subplot(self, *args, **kwargs):
        a = FigureManagerBase.add_subplot(self, *args, **kwargs)
        self.toolbar.update()
        return a
    
    def add_axes(self, rect, axisbg):
        a = FigureManagerBase.add_axes(self, rect, axisbg)
        self.toolbar.update()
        return a
    
    def set_current_axes(self, a):
        if a not in self.axes.values():
            error_msg_gtk2('Axes is not in current figure')
        FigureManagerBase.set_current_axes(self, a)

    def destroy(self, *args):
        self.window.destroy()
        if Gcf.get_num_fig_managers()==0 and not matplotlib.is_interactive():
            gtk.mainquit()


        

        
class Dialog_MeasureTool(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self)
        self.set_title("Axis measurement tool")
        self.vbox.set_spacing(1)
        tooltips = gtk.Tooltips()

        self.posFmt =   'Position: x=%1.4f y=%1.4f'
        self.deltaFmt = 'Delta   : x=%1.4f y=%1.4f'

        self.positionLabel = gtk.Label(self.posFmt % (0,0))
        self.vbox.pack_start(self.positionLabel)
        self.positionLabel.show()
        tooltips.set_tip(self.positionLabel,
                         "Move the mouse to data point over axis")

        self.deltaLabel = gtk.Label(self.deltaFmt % (0,0))
        self.vbox.pack_start(self.deltaLabel)
        self.deltaLabel.show()

        tip = "Left click and hold while dragging mouse to measure " + \
              "delta x and delta y"
        tooltips.set_tip(self.deltaLabel, tip)
                         
        self.show()

    def update_position(self, x, y):
        self.positionLabel.set_text(self.posFmt % (x,y))

    def update_delta(self, dx, dy):
        self.deltaLabel.set_text(self.deltaFmt % (dx,dy))


class NavigationToolbar(gtk.Toolbar):
    """
    Public attriubutes

      canvas   - the FigureCanvas  (gtk.DrawingArea)
      win   - the gtk.Window

    """
    def __init__(self, canvas, window=None):
        """
        figManager is the FigureManagerGTK instance that contains the
        toolbar, with attributes figure, window and drawingArea
        
        """
        gtk.Toolbar.__init__(self)
        
        self.canvas = canvas
        self.win = window
        
        iconSize = gtk.ICON_SIZE_SMALL_TOOLBAR
        self.set_border_width(5)
        self.set_style(gtk.TOOLBAR_ICONS)


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_BACK, iconSize)
        self.bLeft = self.append_item(
            'Left',
            'Pan left with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.panx,
            -1)
        self.bLeft.connect("scroll_event", self.panx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_FORWARD, iconSize)
        self.bRight = self.append_item(
            'Right',
            'Pan right with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.panx,
            1)
        self.bRight.connect("scroll_event", self.panx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_IN, iconSize)
        self.bZoomInX = self.append_item(
            'Zoom In X',
            'Zoom in X (shrink the x axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomx,
            1)
        self.bZoomInX.connect("scroll_event", self.zoomx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_OUT, iconSize)
        self.bZoomOutX = self.append_item(
            'Zoom Out X',
            'Zoom Out X (expand the x axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomx,
            -1)
        self.bZoomOutX.connect("scroll_event", self.zoomx)

        self.append_space()
        
        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_UP, iconSize)
        self.bUp = self.append_item(
            'Up',
            'Pan up with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.pany,
            1)
        self.bUp.connect("scroll_event", self.pany)


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_DOWN, iconSize)
        self.bDown = self.append_item(
            'Down',
            'Pan down with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.pany,
            -1)
        self.bDown.connect("scroll_event", self.pany)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_IN, iconSize)
        self.bZoomInY = self.append_item(
            'Zoom In Y',
            'Zoom in Y (shrink the y axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomy,
            1)
        self.bZoomInY.connect("scroll_event", self.zoomy)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_OUT, iconSize)
        self.bZoomOutY = self.append_item(
            'Zoom Out Y',
            'Zoom Out Y (expand the y axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomy,
            -1)
        self.bZoomOutY.connect("scroll_event", self.zoomy)

        self.append_space()


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_SAVE, iconSize)
        self.bSave = self.append_item(
            'Save',
            'Save the figure',
            'Private',
            iconw,
            self.save_figure)

        self.append_space()


        def destroy_clicked(button):
            win = self.win
            if win is not None: win.destroy()
            else: gtk.mainquit()

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_QUIT, iconSize)
        self.bQuit = self.append_item(
            'Close',
            'Close the figure',
            'Private',
            iconw,
            destroy_clicked)

        self.append_space()

        self.update()

    def make_axis_menu(self):

        def toggled(item, label):
            if item==itemAll:
                for item in items: item.set_active(1)
            elif item==itemInvert:
                for item in items:
                    item.set_active(not item.get_active())

            ind = [i for i,item in enumerate(items) if item.get_active()]
            self.set_active(ind)


                        
            
        menu = gtk.Menu()

        label = "All"
        itemAll = gtk.MenuItem(label)
        menu.append(itemAll)
        itemAll.connect("activate", toggled, label)
        itemAll.show()

        label = "Invert"
        itemInvert = gtk.MenuItem(label)
        menu.append(itemInvert)
        itemInvert.connect("activate", toggled, label)
        itemInvert.show()

        items = []
        for i in range(len(self._axes)):
            
            label = "Axis %d" % (i+1)
            item = gtk.CheckMenuItem(label)
            menu.append(item)
            item.connect("toggled", toggled, label)
            item.show()
            item.set_active(1)
            items.append(item)

        return menu

    def set_active(self, ind):
        self._ind = ind
        self._active = [ self._axes[i] for i in self._ind ]
        
    def panx(self, button, arg):

        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.panx(direction)
        self.canvas.draw()

        return gtk.TRUE
    
    def pany(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1
        for a in self._active:
            a.pany(direction)
        self.canvas.draw()
        return gtk.TRUE
    
    def zoomx(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:            
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.zoomx(direction)
        self.canvas.draw()
        return gtk.TRUE

    def zoomy(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.zoomy(direction)
        self.canvas.draw()
        return gtk.TRUE

    def menu_clicked(self, button):
        if event.button==3:
            self._axisMenu.popup(None, None, None, 0, 0)


    def save_figure(self, button):
                
        def print_ok(button):
            fname = fs.get_filename()
            self.lastDir = os.path.dirname(fname)
            fs.destroy()
            try: self.canvas.print_figure(fname)
            except IOError, msg:                
                err = '\n'.join(map(str, msg))
                msg = 'Failed to save %s: Error msg was\n\n%s' % (
                    fname, err)
                error_msg_gtk(msg)
            
        fs = gtk.FileSelection(title='Save the figure')
        win = self.win
        if win is not None:
            fs.set_transient_for(win)
        try: self.lastDir
        except AttributeError: pass
        else: fs.set_filename(self.lastDir + os.sep)

        fs.ok_button.connect("clicked", print_ok)
        fs.cancel_button.connect("clicked", lambda b: fs.destroy())
        fs.show()


    def update(self):
        self._axes = self.canvas.figure.axes
        self.set_active(range(len(self._axes)))
        if len(self._axes)>1:

            try: self.omenu
            except AttributeError:
                self.omenu = gtk.OptionMenu()
                self.omenu.set_border_width(3)
                self.omenu.show()
                self.insert_widget(
                    self.omenu,
                    'Select axes that controls affect',
                    'Private', 0)
                
            # set up the axis menu
            menu = self.make_axis_menu()
            self.omenu.set_menu(menu)
        self.set_active(range(len(self._axes)))

FigureManager = FigureManagerGTK
error_msg = error_msg_gtk
