import sys
import matplotlib

backend = matplotlib.get_backend()
def error_msg(m):
    print >>sys.stderr, m
    sys.exit()
    
def draw_if_interactive():  pass
def show(): pass

if backend=='Template':
    from backend_template import \
         error_msg, draw_if_interactive, show, new_figure_manager
elif backend=='GTK':
    from backend_gtk import  \
         error_msg, draw_if_interactive, show, new_figure_manager
elif backend=='Paint':
    from backend_paint import  \
         error_msg, new_figure_manager
elif backend=='Agg':
    from backend_agg import new_figure_manager
elif backend=='SVG':
    from backend_svg import new_figure_manager
elif backend=='GTKAgg':
    from backend_gtkagg import error_msg, draw_if_interactive, show, new_figure_manager
elif backend=='FltkAgg':
    from backend_fltkagg import error_msg, draw_if_interactive, show, new_figure_manager
elif backend=='TkAgg':
    from backend_tkagg import error_msg, draw_if_interactive, show, new_figure_manager
elif backend=='PS':
    from backend_ps import new_figure_manager
elif backend=='GD':
    from backend_gd import new_figure_manager
elif backend=='WX':
    from backend_wx import \
         error_msg, draw_if_interactive, show, new_figure_manager, Toolbar
elif backend=='WXAgg':
    from backend_wxagg import \
         error_msg, draw_if_interactive, show, new_figure_manager, Toolbar
else:
    raise ValueError, 'Unrecognized backend %s' % backend
    
