"""
font data tables for truetype and afm computer modern fonts
"""

# this dict maps symbol names to fontnames, glyphindex.  To get the
# glyph index from the character code, you have to use a reverse
# dictionary grom font.get_charmaps, eg,
"""
from matplotlib.ft2font import FT2Font
font = FT2Font('/usr/local/share/matplotlib/cmr10.ttf')
codes = font.get_charmap().items()
rd = dict([(charcode, glyphind) for glyphind,charcode in codes])
items = rd.items()
items.sort()

for charcode, glyphind in items:
    print charcode, glyphind
"""

latex_to_bakoma = {

    r'\oint'                : ('cmex10',  45),
    r'\bigodot'             : ('cmex10',  50),
    r'\bigoplus'            : ('cmex10',  55),
    r'\bigotimes'           : ('cmex10',  59),
    r'\sum'                 : ('cmex10',  51),
    r'\prod'                : ('cmex10',  24),
    r'\int'                 : ('cmex10',  56),
    r'\bigcup'              : ('cmex10',  28),
    r'\bigcap'              : ('cmex10',  60),
    r'\biguplus'            : ('cmex10',  32),
    r'\bigwedge'            : ('cmex10',   4),
    r'\bigvee'              : ('cmex10',  37),
    r'\coprod'              : ('cmex10',  42),
    r'\Leftbracket'         : ('cmex10',  29),
    r'\Rightbracket'        : ('cmex10',  61),
    r'\Leftbrace'           : ('cmex10',  43),
    r'\Rightbrace'          : ('cmex10',  16),
    r'\sqrt'                : ('cmex10',  48),
    r'\Sqrt'                : ('cmex10',  21),
    r'\SQRT'                : ('cmex10',  53),
    r'\leftbrace'           : ('cmex10',  92),
    r'{'                    : ('cmex10',  92),
    r'\rightbrace'          : ('cmex10', 130),
    r'}'                    : ('cmex10', 130),
    r'\leftangle'           : ('cmex10',  97),
    r'\rightangle'          : ('cmex10',  64),
    r'\Leftparen'           : ('cmex10', 112),
    r'\Rightparen'          : ('cmex10',  81),
    r'\LEFTparen'           : ('cmex10', 119),
    r'\RIGHTparen'          : ('cmex10',  87),
    r'\LEFTbracket'         : ('cmex10', 125),
    r'\RIGHTbracket'        : ('cmex10',  93),
    r'\LEFTbrace'           : ('cmex10',  70),
    r'\RIGHTbrace'          : ('cmex10', 107),
    r'\LEFTangle'           : ('cmex10',  76),
    r'\RIGHTangle'          : ('cmex10', 113),
    
    r'\omega'               : ('cmmi10',  29),
    r'\varepsilon'          : ('cmmi10',  20),
    r'\vartheta'            : ('cmmi10',  22),
    r'\varrho'              : ('cmmi10',  61),
    r'\varsigma'            : ('cmmi10',  41),
    r'\varphi'              : ('cmmi10',   6),
    r'\leftharpoonup'       : ('cmmi10', 108),
    r'\leftharpoondown'     : ('cmmi10',  68),
    r'\rightharpoonup'      : ('cmmi10', 117),
    r'\rightharpoondown'    : ('cmmi10',  77),
    r'\triangleright'       : ('cmmi10', 130),
    r'\triangleleft'        : ('cmmi10',  89),
    r'.'                    : ('cmmi10',  51),
    r','                    : ('cmmi10',  44),
    r'<'                    : ('cmmi10',  99),
    r'/'                    : ('cmmi10',  98),
    r'>'                    : ('cmmi10', 107),
    r'\flat'                : ('cmmi10', 131),
    r'\natural'             : ('cmmi10',  90),
    r'\sharp'               : ('cmmi10',  50),
    r'\smile'               : ('cmmi10',  97),
    r'\frown'               : ('cmmi10',  58),
    r'\ell'                 : ('cmmi10', 102),
    r'\imath'               : ('cmmi10',   8),
    r'\jmath'               : ('cmmi10',  65),
    r'\wp'                  : ('cmmi10',  14),
    r'\Gamma'               : ('cmmi10',  37),
    r'\Delta'               : ('cmmi10',  11),
    r'\Theta'               : ('cmmi10',  12),
    r'\Lambda'              : ('cmmi10',  26),
    r'\Xi'                  : ('cmmi10',   4),
    r'\Pi'                  : ('cmmi10',  33),
    r'\Sigma'               : ('cmmi10',  16),
    r'\Upsilon'             : ('cmmi10',  19),
    r'\Phi'                 : ('cmmi10',  15),
    r'\Psi'                 : ('cmmi10',  27),
    r'\Omega'               : ('cmmi10',  23),
    r'\alpha'               : ('cmmi10',  13),
    r'\beta'                : ('cmmi10',  35),
    r'\gamma'               : ('cmmi10',  24),
    r'\delta'               : ('cmmi10',  38),
    r'\epsilon'             : ('cmmi10',  54),
    r'\zeta'                : ('cmmi10',  10),
    r'\eta'                 : ('cmmi10',   5),
    r'\theta'               : ('cmmi10',  18),
    r'\iota'                : ('cmmi10',  28),
    r'\lambda'              : ('cmmi10',   9),
    r'\mu'                  : ('cmmi10',  32),
    r'\nu'                  : ('cmmi10',  34),
    r'\xi'                  : ('cmmi10',   7),
    r'\pi'                  : ('cmmi10',  36),
    r'\kappa'               : ('cmmi10',  30),    
    r'\rho'                 : ('cmmi10',  39),
    r'\sigma'               : ('cmmi10',  21),
    r'\tau'                 : ('cmmi10',  43),
    r'\upsilon'             : ('cmmi10',  25),
    r'\phi'                 : ('cmmi10',  42),
    r'\chi'                 : ('cmmi10',  17),
    r'\psi'                 : ('cmmi10',  31),

    r'('                    : ('cmr10',  119),
    r'\leftparen'           : ('cmr10',  119),
    r'\rightparen'          : ('cmr10',   68),
    r')'                    : ('cmr10',   68),
    r'+'                    : ('cmr10',   76),
    r'0'                    : ('cmr10',   40),
    r'1'                    : ('cmr10',  100),
    r'2'                    : ('cmr10',   49),
    r'3'                    : ('cmr10',  110),
    r'4'                    : ('cmr10',   59),
    r'5'                    : ('cmr10',  120),
    r'6'                    : ('cmr10',   69),
    r'7'                    : ('cmr10',  127),
    r'8'                    : ('cmr10',   77),
    r'9'                    : ('cmr10',   22),
    r':'                    : ('cmr10',   85),
    r';'                    : ('cmr10',   31),
    r'='                    : ('cmr10',   41),
    r'\leftbracket'         : ('cmr10',   62),
    r'['                    : ('cmr10',   62),
    r'\rightbracket'        : ('cmr10',   72),
    r']'                    : ('cmr10',   72),

    # these are mathml names, I think.  I'm just using them for the
    # tex methods noted
    r'\circumflexaccent'    : ('cmr10',   124), # for \hat
    r'\combiningbreve'      : ('cmr10',   81),  # for \breve
    r'\combiningoverline'   : ('cmr10',   131),  # for \bar
    r'\combininggraveaccent' : ('cmr10', 114), # for \grave
    r'\combiningacuteaccent' : ('cmr10', 63), # for \accute
    r'\combiningdiaeresis' : ('cmr10', 91), # for \ddot
    r'\combiningtilde' : ('cmr10', 75), # for \tilde
    r'\combiningrightarrowabove' : ('cmmi10', 110), # for \vec
    r'\combiningdotabove' : ('cmr10', 26), # for \dot

    r'\leftarrow'           : ('cmsy10',  12),
    r'\uparrow'             : ('cmsy10',  25),
    r'\downarrow'           : ('cmsy10',  28),
    r'\leftrightarrow'      : ('cmsy10',  24),
    r'\nearrow'             : ('cmsy10',  99),
    r'\searrow'             : ('cmsy10',  57),
    r'\simeq'               : ('cmsy10', 108),
    r'\Leftarrow'           : ('cmsy10', 104),
    r'\Rightarrow'          : ('cmsy10', 112),
    r'\Uparrow'             : ('cmsy10',  60),
    r'\Downarrow'           : ('cmsy10',  68),
    r'\Leftrightarrow'      : ('cmsy10',  51),
    r'\nwarrow'             : ('cmsy10',  65),
    r'\swarrow'             : ('cmsy10', 116),
    r'\propto'              : ('cmsy10',  15),
    r'\prime'               : ('cmsy10',  73),
    r'\infty'               : ('cmsy10',  32),
    r'\in'                  : ('cmsy10',  59),
    r'\ni'                  : ('cmsy10', 122),
    r'\bigtriangleup'       : ('cmsy10',  80),
    r'\bigtriangledown'     : ('cmsy10', 132),
    r'\slash'               : ('cmsy10',  87),
    r'\forall'              : ('cmsy10',  21),
    r'\exists'              : ('cmsy10',   5),
    r'\neg'                 : ('cmsy10',  20),
    r'\emptyset'            : ('cmsy10',  33),
    r'\Re'                  : ('cmsy10',  95),
    r'\Im'                  : ('cmsy10',  52),
    r'\top'                 : ('cmsy10', 100),
    r'\bot'                 : ('cmsy10',  11),
    r'\aleph'               : ('cmsy10',  26),
    r'\cup'                 : ('cmsy10',   6),
    r'\cap'                 : ('cmsy10',  19),
    r'\uplus'               : ('cmsy10',  58),
    r'\wedge'               : ('cmsy10',  43),
    r'\vee'                 : ('cmsy10',  96),
    r'\vdash'               : ('cmsy10', 109),
    r'\dashv'               : ('cmsy10',  66),
    r'\lfloor'              : ('cmsy10', 117),
    r'\rfloor'              : ('cmsy10',  74),
    r'\lceil'               : ('cmsy10', 123),
    r'\rceil'               : ('cmsy10',  81),
    r'\lbrace'              : ('cmsy10',  92),
    r'\rbrace'              : ('cmsy10', 105),
    r'\langle'              : ('cmsy10',   3),
    r'\rangle'              : ('cmsy10',  88),
    r'\mid'                 : ('cmsy10',  47),
    r'\vert'                : ('cmsy10',  47),
    r'\Vert'                : ('cmsy10',  44),
    r'\updownarrow'         : ('cmsy10',  94),
    r'\Updownarrow'         : ('cmsy10',  53),
    r'\backslash'           : ('cmsy10', 126),
    r'\wr'                  : ('cmsy10', 101),
    r'\nabla'               : ('cmsy10', 110),
    r'\sqcup'               : ('cmsy10',  67),
    r'\sqcap'               : ('cmsy10', 118),
    r'\sqsubseteq'          : ('cmsy10',  75),
    r'\sqsupseteq'          : ('cmsy10', 124),
    r'\S'                   : ('cmsy10', 129),
    r'\dag'                 : ('cmsy10',  71),
    r'\ddag'                : ('cmsy10', 127),
    r'\P'                   : ('cmsy10', 130),
    r'\clubsuit'            : ('cmsy10',  18),
    r'\diamondsuit'         : ('cmsy10',  34),
    r'\heartsuit'           : ('cmsy10',  22),
    r'-'                    : ('cmsy10',  17),
    r'\cdot'                : ('cmsy10',  78),
    r'\times'               : ('cmsy10',  13),
    r'*'                    : ('cmsy10',   9),
    r'\ast'                 : ('cmsy10',   9),
    r'\div'                 : ('cmsy10',  31),
    r'\diamond'             : ('cmsy10',  48),
    r'\pm'                  : ('cmsy10',   8),
    r'\mp'                  : ('cmsy10',  98),
    r'\oplus'               : ('cmsy10',  16),
    r'\ominus'              : ('cmsy10',  56),
    r'\otimes'              : ('cmsy10',  30),
    r'\oslash'              : ('cmsy10', 107),
    r'\odot'                : ('cmsy10',  64),
    r'\bigcirc'             : ('cmsy10', 115),
    r'\circ'                : ('cmsy10',  72),
    r'\bullet'              : ('cmsy10',  84),
    r'\asymp'               : ('cmsy10', 121),
    r'\equiv'               : ('cmsy10',  35),
    r'\subseteq'            : ('cmsy10', 103),
    r'\supseteq'            : ('cmsy10',  42),
    r'\leq'                 : ('cmsy10',  14),
    r'\geq'                 : ('cmsy10',  29),
    r'\preceq'              : ('cmsy10',  79),
    r'\succeq'              : ('cmsy10', 131),
    r'\sim'                 : ('cmsy10',  27),
    r'\approx'              : ('cmsy10',  23),
    r'\subset'              : ('cmsy10',  50),
    r'\supset'              : ('cmsy10',  86),
    r'\ll'                  : ('cmsy10',  85),
    r'\gg'                  : ('cmsy10',  40),
    r'\prec'                : ('cmsy10',  93),
    r'\succ'                : ('cmsy10',  49),
    r'\rightarrow'          : ('cmsy10',  10),
    r'\spadesuit'           : ('cmsy10',   7),
    }


ams_type1 = {
    r'\Leftbracket'       : ( 'cmex10', '02'),
    r'\Rightbracket'      : ( 'cmex10', '03'),
    r'\Leftbrace'         : ( 'cmex10', '08'),
    r'\leftbrace'         : ( 'cmex10', '08'),
    '{'                   : ( 'cmex10', '08'),
    r'\Rightbrace'        : ( 'cmex10', '09'),
    r'\rightbrace'        : ( 'cmex10', '09'),
    '}'                   : ( 'cmex10', '09'),
    r'\Leftparen'         : ( 'cmex10', '10'),
    r'\Rightparen'        : ( 'cmex10', '11'),
    r'\LEFTparen'         : ( 'cmex10', '20'),
    r'\RIGHTparen'        : ( 'cmex10', '21'),
    r'\LEFTbracket'       : ( 'cmex10', '22'),
    r'\RIGHTbracket'      : ( 'cmex10', '23'),
    '6'                   : ( 'cmex10', '26'),
    '('                   : ( 'cmex10', '28'),
    r'\LEFTbrace'         : ( 'cmex10', '28'),
    r'\leftparen'         : ( 'cmex10', '28'),
    ')'                   : ( 'cmex10', '29'),
    r'\RIGHTbrace'        : ( 'cmex10', '29'),
    r'\rightparen'        : ( 'cmex10', '29'),
    r'\LEFTangle'         : ( 'cmex10', '2A'),
    '+'                   : ( 'cmex10', '2B'),
    '0'                   : ( 'cmex10', '30'),
    '1'                   : ( 'cmex10', '31'),
    '2'                   : ( 'cmex10', '32'),
    '3'                   : ( 'cmex10', '33'),
    '4'                   : ( 'cmex10', '34'),
    '5'                   : ( 'cmex10', '35'),
    '7'                   : ( 'cmex10', '37'),
    '8'                   : ( 'cmex10', '38'),
    '9'                   : ( 'cmex10', '39'),
    ':'                   : ( 'cmex10', '3A'),
    ';'                   : ( 'cmex10', '3B'),
    '='                   : ( 'cmex10', '3D'),
    r'\leftangle'         : ( 'cmex10', '44'),
    r'\rightangle'        : ( 'cmex10', '45'),
    r'\oint'              : ( 'cmex10', '49'),
    r'\bigodot'           : ( 'cmex10', '4B'),
    r'\bigoplus'          : ( 'cmex10', '4D'),
    r'\bigotimes'         : ( 'cmex10', '4F'),
    r'\sum'               : ( 'cmex10', '58'),
    r'\prod'              : ( 'cmex10', '59'),
    r'\int'               : ( 'cmex10', '5A'),
    '['                   : ( 'cmex10', '5B'),
    r'\bigcup'            : ( 'cmex10', '5B'),
    r'\leftbracket'       : ( 'cmex10', '5B'),
    r'\bigcap'            : ( 'cmex10', '5C'),
    r'\biguplus'          : ( 'cmex10', '5D'),
    r'\rightbracket'      : ( 'cmex10', '5D'),
    ']'                   : ( 'cmex10', '5D'),
    r'\bigwedge'          : ( 'cmex10', '5E'),
    r'\bigvee'            : ( 'cmex10', '5F'),
    r'\coprod'            : ( 'cmex10', '61'),
    r'\Sqrt'              : ( 'cmex10', '70'),
    r'\sqrt'              : ( 'cmex10', '70'),
    r'\SQRT'              : ( 'cmex10', '72'),
    r'\Sigma'             : ( 'cmmi10', '06'),
    r'\Upsilon'           : ( 'cmmi10', '07'),
    r'\Phi'               : ( 'cmmi10', '08'),
    r'\Psi'               : ( 'cmmi10', '09'),
    r'\alpha'             : ( 'cmmi10', '0B'),
    r'\beta'              : ( 'cmmi10', '0C'),
    r'\gamma'             : ( 'cmmi10', '0D'),
    r'\delta'             : ( 'cmmi10', '0E'),
    r'\epsilon'           : ( 'cmmi10', '0F'),
    r'\zeta'              : ( 'cmmi10', '10'),
    r'\eta'               : ( 'cmmi10', '11'),
    r'\theta'             : ( 'cmmi10', '12'),
    r'\iota'              : ( 'cmmi10', '13'),
    r'\lambda'            : ( 'cmmi10', '15'),
    r'\mu'                : ( 'cmmi10', '16'),
    r'\nu'                : ( 'cmmi10', '17'),
    r'\xi'                : ( 'cmmi10', '18'),
    r'\pi'                : ( 'cmmi10', '19'),
    r'\kappa'             : ( 'cmmi10', '19'),    
    r'\rho'               : ( 'cmmi10', '1A'),
    r'\sigma'             : ( 'cmmi10', '1B'),
    r'\tau'               : ( 'cmmi10', '1C'),
    r'\upsilon'           : ( 'cmmi10', '1D'),
    r'\phi'               : ( 'cmmi10', '1E'),
    r'\chi'               : ( 'cmmi10', '1F'),
    r'\psi'               : ( 'cmmi10', '20'),
    r'\omega'             : ( 'cmmi10', '21'),
    r'\varepsilon'        : ( 'cmmi10', '22'),
    r'\vartheta'          : ( 'cmmi10', '23'),
    r'\varrho'            : ( 'cmmi10', '25'),
    r'\varsigma'          : ( 'cmmi10', '26'),    
    r'\varphi'            : ( 'cmmi10', '27'),
    r'\leftharpoonup'     : ( 'cmmi10', '28'),
    r'\leftharpoondown'   : ( 'cmmi10', '29'),
    r'\rightharpoonup'    : ( 'cmmi10', '2A'),
    r'\rightharpoondown'  : ( 'cmmi10', '2B'),
    r'\triangleright'     : ( 'cmmi10', '2E'),
    r'\triangleleft'      : ( 'cmmi10', '2F'),
    '.'                   : ( 'cmmi10', '3A'),
    ','                   : ( 'cmmi10', '3B'),
    '<'                   : ( 'cmmi10', '3C'),
    '/'                   : ( 'cmmi10', '3D'),
    '>'                   : ( 'cmmi10', '3E'),
    r'\flat'              : ( 'cmmi10', '5B'),
    r'\natural'           : ( 'cmmi10', '5C'),
    r'\sharp'             : ( 'cmmi10', '5D'),
    r'\smile'             : ( 'cmmi10', '5E'),
    r'\frown'             : ( 'cmmi10', '5F'),
    r'\ell'               : ( 'cmmi10', '60'),
    r'\imath'             : ( 'cmmi10', '7B'),    
    r'\jmath'             : ( 'cmmi10', '7C'),
    r'\wp'                : ( 'cmmi10', '7D'),    
    r'\Gamma'             : ( 'cmr10', '00'),
    r'\Delta'             : ( 'cmr10', '01'),
    r'\Theta'             : ( 'cmr10', '02'),
    r'\Lambda'            : ( 'cmr10', '03'),
    r'\Xi'                : ( 'cmr10', '04'),
    r'\Pi'                : ( 'cmr10', '05'),
    r'\Omega'             : ( 'cmr10', '0A'),
    '-'                   : ( 'cmsy10', '00'),
    r'\cdot'              : ( 'cmsy10', '01'),        
    r'\times'             : ( 'cmsy10', '02'),
    '*'                   : ( 'cmsy10', '03'),
    r'\ast'               : ( 'cmsy10', '03'),        
    r'\div'               : ( 'cmsy10', '04'),
    r'\diamond'           : ( 'cmsy10', '05'),
    r'\pm'                : ( 'cmsy10', '06'),
    r'\mp'                : ( 'cmsy10', '07'),    
    r'\oplus'             : ( 'cmsy10', '08'),
    r'\ominus'            : ( 'cmsy10', '09'),
    r'\otimes'            : ( 'cmsy10', '0A'),
    r'\oslash'            : ( 'cmsy10', '0B'),
    r'\odot'              : ( 'cmsy10', '0C'),
    r'\bigcirc'           : ( 'cmsy10', '0D'),
    r'\circ'              : ( 'cmsy10', '0E'),    
    r'\bullet'            : ( 'cmsy10', '0F'),
    r'\simeq'             : ( 'cmsy10', '10'),
    r'\asymp'             : ( 'cmsy10', '11'),
    r'\subseteq'          : ( 'cmsy10', '12'),
    r'\supseteq'          : ( 'cmsy10', '13'),
    r'\leq'               : ( 'cmsy10', '14'),
    r'\geq'               : ( 'cmsy10', '15'),
    r'\preceq'            : ( 'cmsy10', '16'),
    r'\succeq'            : ( 'cmsy10', '17'),
    r'\sim'               : ( 'cmsy10', '18'),
    r'\approx'            : ( 'cmsy10', '19'),    
    r'\subset'            : ( 'cmsy10', '1A'),
    r'\supset'            : ( 'cmsy10', '1B'),
    r'\ll'                : ( 'cmsy10', '1C'),
    r'\gg'                : ( 'cmsy10', '1D'),
    r'\prec'              : ( 'cmsy10', '1E'),
    r'\succ'              : ( 'cmsy10', '1F'),
    r'\rightarrow'        : ( 'cmsy10', '20'),
    r'\leftarrow'         : ( 'cmsy10', '21'),
    r'\uparrow'           : ( 'cmsy10', '22'),
    r'\downarrow'         : ( 'cmsy10', '23'),
    r'\leftrightarrow'    : ( 'cmsy10', '24'),
    r'\nearrow'           : ( 'cmsy10', '25'),
    r'\searrow'           : ( 'cmsy10', '26'),
    r'\Leftarrow'         : ( 'cmsy10', '28'),
    r'\Rightarrow'        : ( 'cmsy10', '29'),
    r'\Uparrow'           : ( 'cmsy10', '2A'),
    r'\Downarrow'         : ( 'cmsy10', '2B'),
    r'\Leftrightarrow'    : ( 'cmsy10', '2C'),
    r'\nwarrow'           : ( 'cmsy10', '2D'),
    r'\swarrow'           : ( 'cmsy10', '2E'),
    r'\propto'            : ( 'cmsy10', '2F'),
    r'\prime'             : ( 'cmsy10', '30'),
    r'\infty'             : ( 'cmsy10', '31'),
    r'\in'                : ( 'cmsy10', '32'),
    r'\ni'                : ( 'cmsy10', '33'),
    r'\bigtriangleup'     : ( 'cmsy10', '34'),
    r'\bigtriangledown'   : ( 'cmsy10', '35'),
    r'\slash'             : ( 'cmsy10', '36'),
    r'\forall'            : ( 'cmsy10', '38'),
    r'\exists'            : ( 'cmsy10', '39'),
    r'\neg'               : ( 'cmsy10', '3A'),
    r'\emptyset'          : ( 'cmsy10', '3B'),
    r'\Re'                : ( 'cmsy10', '3C'),
    r'\Im'                : ( 'cmsy10', '3D'),
    r'\top'               : ( 'cmsy10', '3E'),
    r'\bot'               : ( 'cmsy10', '3F'),    
    r'\aleph'             : ( 'cmsy10', '40'),
    r'\cup'               : ( 'cmsy10', '5B'),
    r'\cap'               : ( 'cmsy10', '5C'),
    r'\uplus'             : ( 'cmsy10', '5D'),
    r'\wedge'             : ( 'cmsy10', '5E'),
    r'\vee'               : ( 'cmsy10', '5F'),
    r'\vdash'             : ( 'cmsy10', '60'),
    r'\dashv'             : ( 'cmsy10', '61'),
    r'\lfloor'            : ( 'cmsy10', '62'),
    r'\rfloor'            : ( 'cmsy10', '63'),
    r'\lceil'             : ( 'cmsy10', '64'),
    r'\rceil'             : ( 'cmsy10', '65'),
    r'\lbrace'            : ( 'cmsy10', '66'),
    r'\rbrace'            : ( 'cmsy10', '67'),
    r'\langle'            : ( 'cmsy10', '68'),
    r'\rangle'            : ( 'cmsy10', '69'),
    r'\mid'               : ( 'cmsy10', '6A'),
    r'\vert'              : ( 'cmsy10', '6A'),
    r'\Vert'              : ( 'cmsy10', '6B'),
    r'\updownarrow'       : ( 'cmsy10', '6C'),
    r'\Updownarrow'       : ( 'cmsy10', '6D'),
    r'\backslash'         : ( 'cmsy10', '6E'),
    r'\wr'                : ( 'cmsy10', '6F'),
    r'\nabla'             : ( 'cmsy10', '72'),    
    r'\sqcup'             : ( 'cmsy10', '74'),
    r'\sqcap'             : ( 'cmsy10', '75'),
    r'\sqsubseteq'        : ( 'cmsy10', '76'),
    r'\sqsupseteq'        : ( 'cmsy10', '77'),
    r'\S'                 : ( 'cmsy10', '78'),
    r'\dag'               : ( 'cmsy10', '79'),
    r'\ddag'              : ( 'cmsy10', '7A'),
    r'\P'                 : ( 'cmsy10', '7B'),    
    r'\clubsuit'          : ( 'cmsy10', '7C'),
    r'\diamondsuit'       : ( 'cmsy10', '7D'),
    r'\heartsuit'         : ( 'cmsy10', '7E'),
    r'\spadesuit'         : ( 'cmsy10', '7F'),
}

"""
no mlname for \RIGHTangle
no type1 key \equiv      # could not find in ASM
no type1 key \kappa      # could not find kappa
no type1 key \RIGHTangle # could not find
"""
