#!/usr/bin/env python
# Demonstrating the improvements and options of the proposed new ScalarFormatter
from pylab import *
from matplotlib.ticker import OldScalarFormatter

x=frange(0,1,.01)
f=figure(figsize=(6,6))
f.text(0.5,0.975,'The old formatter',horizontalalignment='center',verticalalignment='top')
subplot(221)
plot(x*1e5+1e10,x*1e-10+1e-5)
gca().xaxis.set_major_formatter(OldScalarFormatter())
gca().yaxis.set_major_formatter(OldScalarFormatter())
subplot(222)
plot(x*1e5,x*1e-4)
gca().xaxis.set_major_formatter(OldScalarFormatter())
gca().yaxis.set_major_formatter(OldScalarFormatter())
subplot(223)
plot(-x*1e5-1e10,-x*1e-5-1e-10)
gca().xaxis.set_major_formatter(OldScalarFormatter())
gca().yaxis.set_major_formatter(OldScalarFormatter())
subplot(224)
plot(-x*1e5,-x*1e-4)

x=frange(0,1,.01)
f=figure(figsize=(6,6))
f.text(0.5,0.975,'The new formatter, default settings',horizontalalignment='center',
       verticalalignment='top')
subplot(221)
plot(x*1e5+1e10,x*1e-10+1e-5)
gca().xaxis.set_major_formatter(ScalarFormatter())
gca().yaxis.set_major_formatter(ScalarFormatter())
subplot(222)
plot(x*1e5,x*1e-4)
gca().xaxis.set_major_formatter(ScalarFormatter())
gca().yaxis.set_major_formatter(ScalarFormatter())
subplot(223)
plot(-x*1e5-1e10,-x*1e-5-1e-10)
gca().xaxis.set_major_formatter(ScalarFormatter())
gca().yaxis.set_major_formatter(ScalarFormatter())
subplot(224)
plot(-x*1e5,-x*1e-4)
gca().xaxis.set_major_formatter(ScalarFormatter())
gca().yaxis.set_major_formatter(ScalarFormatter())

x=frange(0,1,.01)
f=figure(figsize=(6,6))
f.text(0.5,0.975,'The new formatter, no numerical offset',horizontalalignment='center',
       verticalalignment='top')
subplot(221)
plot(x*1e5+1e10,x*1e-10+1e-5)
gca().xaxis.set_major_formatter(ScalarFormatter(useOffset=False))
gca().yaxis.set_major_formatter(ScalarFormatter(useOffset=False))
subplot(222)
plot(x*1e5,x*1e-4)
gca().xaxis.set_major_formatter(ScalarFormatter(useOffset=False))
gca().yaxis.set_major_formatter(ScalarFormatter(useOffset=False))
subplot(223)
plot(-x*1e5-1e10,-x*1e-5-1e-10)
gca().xaxis.set_major_formatter(ScalarFormatter(useOffset=False))
gca().yaxis.set_major_formatter(ScalarFormatter(useOffset=False))
subplot(224)
plot(-x*1e5,-x*1e-4)
gca().xaxis.set_major_formatter(ScalarFormatter(useOffset=False))
gca().yaxis.set_major_formatter(ScalarFormatter(useOffset=False))

x=frange(0,1,.01)
f=figure(figsize=(6,6))
f.text(0.5,0.975,'The new formatter, with mathtext',horizontalalignment='center',
       verticalalignment='top')
subplot(221)
plot(x*1e5+1e10,x*1e-10+1e-5)
gca().xaxis.set_major_formatter(ScalarFormatter(useMathText=True))
gca().yaxis.set_major_formatter(ScalarFormatter(useMathText=True))
subplot(222)
plot(x*1e5,x*1e-4)
gca().xaxis.set_major_formatter(ScalarFormatter(useMathText=True))
gca().yaxis.set_major_formatter(ScalarFormatter(useMathText=True))
subplot(223)
plot(-x*1e5-1e10,-x*1e-5-1e-10)
gca().xaxis.set_major_formatter(ScalarFormatter(useMathText=True))
gca().yaxis.set_major_formatter(ScalarFormatter(useMathText=True))
subplot(224)
plot(-x*1e5,-x*1e-4)
gca().xaxis.set_major_formatter(ScalarFormatter(useMathText=True))
gca().yaxis.set_major_formatter(ScalarFormatter(useMathText=True))
show()
