/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import php.java.bridge.HexOutputBuffer;
import php.java.bridge.JavaBridge;

class Base64EncodingOutputBuffer
extends HexOutputBuffer {
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final char[] lookUpBase64Alphabet;

    Base64EncodingOutputBuffer(JavaBridge javaBridge) {
        super(javaBridge);
    }

    void appendBase64(byte[] byArray) {
        byte by;
        int n;
        int n2;
        if (byArray == null) {
            return;
        }
        int n3 = byArray.length * 8;
        if (n3 == 0) {
            return;
        }
        int n4 = n3 % 24;
        int n5 = n3 / 24;
        int n6 = n4 != 0 ? n5 + 1 : n5;
        int n7 = (n6 - 1) / 19 + 1;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n2 = 0; n2 < n7 - 1; ++n2) {
            for (n = 0; n < 19; ++n) {
                by4 = byArray[n8++];
                by5 = byArray[n8++];
                by6 = byArray[n8++];
                by3 = (byte)(by5 & 0xF);
                by2 = (byte)(by4 & 3);
                by = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
                byte by7 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
                byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
                this.write(lookUpBase64Alphabet[by]);
                this.write(lookUpBase64Alphabet[by7 | by2 << 4]);
                this.write(lookUpBase64Alphabet[by3 << 2 | by8]);
                this.write(lookUpBase64Alphabet[by6 & 0x3F]);
                ++n9;
            }
            this.write(10);
        }
        while (n9 < n5) {
            by4 = byArray[n8++];
            by5 = byArray[n8++];
            by6 = byArray[n8++];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n2 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
            this.write(lookUpBase64Alphabet[n2]);
            this.write(lookUpBase64Alphabet[n | by2 << 4]);
            this.write(lookUpBase64Alphabet[by3 << 2 | by]);
            this.write(lookUpBase64Alphabet[by6 & 0x3F]);
            ++n9;
        }
        if (n4 == 8) {
            by4 = byArray[n8];
            by2 = (byte)(by4 & 3);
            n2 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            this.write(lookUpBase64Alphabet[n2]);
            this.write(lookUpBase64Alphabet[by2 << 4]);
            this.write(61);
            this.write(61);
        } else if (n4 == 16) {
            by4 = byArray[n8];
            by5 = byArray[n8 + 1];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n2 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            this.write(lookUpBase64Alphabet[n2]);
            this.write(lookUpBase64Alphabet[n | by2 << 4]);
            this.write(lookUpBase64Alphabet[by3 << 2]);
            this.write(61);
        }
        this.write(10);
    }

    static {
        int n;
        lookUpBase64Alphabet = new char[64];
        for (n = 0; n <= 25; ++n) {
            Base64EncodingOutputBuffer.lookUpBase64Alphabet[n] = (char)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64EncodingOutputBuffer.lookUpBase64Alphabet[n] = (char)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64EncodingOutputBuffer.lookUpBase64Alphabet[n] = (char)(48 + n2);
            ++n;
            ++n2;
        }
        Base64EncodingOutputBuffer.lookUpBase64Alphabet[62] = 43;
        Base64EncodingOutputBuffer.lookUpBase64Alphabet[63] = 47;
    }
}

