/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import php.java.bridge.IJavaBridgeFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.SimpleJavaBridgeClassLoader;

public final class PhpProcedure
implements InvocationHandler {
    private IJavaBridgeFactory bridge;
    private long object;
    private Map names;
    protected String name;

    protected PhpProcedure(IJavaBridgeFactory iJavaBridgeFactory, long l, String string, Map map) {
        this.bridge = iJavaBridgeFactory;
        this.object = l;
        this.names = map;
        this.name = string;
    }

    protected static Object createProxy(IJavaBridgeFactory iJavaBridgeFactory, String string, Map map, Class[] classArray, long l) {
        PhpProcedure phpProcedure = new PhpProcedure(iJavaBridgeFactory, l, string, map);
        SimpleJavaBridgeClassLoader simpleJavaBridgeClassLoader = iJavaBridgeFactory.getJavaBridgeClassLoader();
        ClassLoader classLoader = simpleJavaBridgeClassLoader.getClassLoader();
        Object object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)phpProcedure);
        return object;
    }

    public static Object createProxy(Class[] classArray, PhpProcedure phpProcedure) {
        return PhpProcedure.createProxy(phpProcedure.bridge, phpProcedure.name, phpProcedure.names, classArray, phpProcedure.object);
    }

    private Object invoke(Object object, String string, Class clazz, Object[] objectArray) throws Throwable {
        String string2;
        JavaBridge javaBridge = this.bridge.getBridge();
        if (javaBridge.logLevel > 3) {
            javaBridge.logDebug("invoking callback: " + string);
        }
        if (this.name != null) {
            string2 = this.name;
        } else {
            string2 = (String)this.names.get(string);
            if (string2 == null) {
                string2 = string;
            }
        }
        javaBridge.request.response.setResultProcedure(this.object, string2, string, objectArray);
        Object[] objectArray2 = javaBridge.request.handleSubRequests();
        if (javaBridge.logLevel > 3) {
            javaBridge.logDebug("result from cb: " + Arrays.asList(objectArray2));
        }
        return javaBridge.coerce(clazz, objectArray2[0], javaBridge.request.response);
    }

    private void checkPhpContinuation() throws IllegalStateException {
        if (this.bridge.isNew()) {
            throw new IllegalStateException("Cannot call closure anymore: the closed-over PHP script continuation has been terminated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, String string, Object[] objectArray) throws Throwable {
        this.checkPhpContinuation();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(this.bridge.getBridge().getClassLoader().getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Object object2 = this.invoke(object, string, Object.class, objectArray);
            return object2;
        }
        finally {
            try {
                thread.setContextClassLoader(classLoader);
            }
            catch (SecurityException securityException) {}
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        this.checkPhpContinuation();
        return this.invoke(object, method.getName(), method.getReturnType(), objectArray);
    }

    static long unwrap(Object object) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        PhpProcedure phpProcedure = (PhpProcedure)invocationHandler;
        return phpProcedure.object;
    }
}

