/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

class Session
implements ISession {
    protected Map map;
    protected String name;
    private static int sessionCount = 0;
    boolean isNew = true;
    protected long creationTime;
    protected long lastAccessedTime;
    protected long timeout;

    public Object get(Object object) {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.map.get(object);
    }

    public void put(Object object, Object object2) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.map.put(object, object2);
    }

    public Object remove(Object object) {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.map.remove(object);
    }

    Session(String string) {
        this.name = string;
        ++sessionCount;
        this.map = Collections.synchronizedMap(new HashMap());
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
        this.timeout = 1440000L;
    }

    public void setTimeout(int n) {
        this.timeout = n * 1000;
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public int getTimeout() {
        return (int)(this.timeout / 1000L);
    }

    public int getSessionCount() {
        return sessionCount;
    }

    public boolean isNew() {
        return this.isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        --sessionCount;
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            if (JavaBridge.sessionHash != null) {
                JavaBridge.sessionHash.remove(this.name);
            }
        }
    }

    public void invalidate() {
        this.destroy();
    }

    public void putAll(Map map) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.map.putAll(map);
    }

    public Map getAll() {
        this.lastAccessedTime = System.currentTimeMillis();
        return new HashMap(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void expire() {
        if (JavaBridge.sessionHash == null) {
            return;
        }
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            Iterator iterator = JavaBridge.sessionHash.values().iterator();
            while (iterator.hasNext()) {
                Session session = (Session)iterator.next();
                if (session.timeout <= 0L || session.lastAccessedTime + session.timeout > System.currentTimeMillis()) continue;
                --sessionCount;
                iterator.remove();
                if (Util.logLevel <= 3) continue;
                Util.logDebug("Session " + session.name + " expired.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        if (JavaBridge.sessionHash == null) {
            return;
        }
        HashMap hashMap = JavaBridge.sessionHash;
        synchronized (hashMap) {
            Iterator iterator = JavaBridge.sessionHash.values().iterator();
            while (iterator.hasNext()) {
                Session session = (Session)iterator.next();
                --sessionCount;
                iterator.remove();
                if (Util.logLevel <= 3) continue;
                Util.logDebug("Session " + session.name + " destroyed.");
            }
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }
}

