/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;

final class StringCache {
    private Map map;
    private JavaBridge bridge;

    private void init() {
        this.map = new HashMap();
    }

    public StringCache(JavaBridge javaBridge) {
        this.bridge = javaBridge;
        this.init();
    }

    protected String get(Entry entry) {
        return (String)this.map.get(entry);
    }

    protected void put(Entry entry, String string) {
        byte[] byArray = new byte[entry.length];
        System.arraycopy(entry.name, entry.start, byArray, 0, entry.length);
        entry.start = 0;
        entry.name = byArray;
        this.map.put(entry, string);
    }

    protected Entry getEntry(byte[] byArray, int n, int n2, String string) {
        return new Entry(byArray, n, n2, string);
    }

    private String createString(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.bridge.printStackTrace(unsupportedEncodingException);
            return new String(byArray, n, n2);
        }
    }

    public String getString(byte[] byArray, int n, int n2, String string) {
        Entry entry = this.getEntry(byArray, n, n2, string);
        String string2 = this.get(entry);
        if (string2 == null) {
            string2 = this.createString(byArray, n, n2, string);
            this.put(entry, string2);
        }
        return string2;
    }

    public void clear() {
        this.init();
    }

    protected static class Entry {
        byte[] name;
        String enc;
        int start;
        int length;
        private boolean hasResult = false;
        private int result = 1;

        protected Entry() {
        }

        protected Entry(byte[] byArray, int n, int n2, String string) {
            this.name = byArray;
            this.start = n;
            this.length = n2;
            this.enc = string;
        }

        public int hashCode() {
            if (this.hasResult) {
                return this.result;
            }
            int n = this.start + this.length;
            for (int i = this.start; i < n; ++i) {
                this.result = this.result * 7 + this.name[i];
            }
            this.result = this.result * 31 + this.length;
            this.result = this.result * 31 + this.enc.hashCode();
            this.hasResult = true;
            return this.result;
        }

        public boolean equals(Object object) {
            Entry entry = (Entry)object;
            if (this.enc != entry.enc) {
                return false;
            }
            if (this.length != entry.length) {
                return false;
            }
            if (entry.start != 0) {
                throw new RuntimeException("bleh");
            }
            int n = this.length;
            while (n-- > 0) {
                if (this.name[n + this.start] == entry.name[n]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            try {
                return new String(this.name, this.start, this.length, this.enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Util.printStackTrace(unsupportedEncodingException);
                return new String(this.name, this.start, this.length);
            }
        }
    }
}

