/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.util.Iterator;
import java.util.LinkedList;
import php.java.bridge.Util;

public class ThreadPool {
    private String name;
    private int threads = 0;
    private int idles = 0;
    private int poolMaxSize;
    private int poolReserve;
    private LinkedList runnables = new LinkedList();
    private LinkedList threadList = new LinkedList();

    protected Delegate createDelegate(String string) {
        return new Delegate(string);
    }

    protected void startNewThread(String string) {
        Delegate delegate = this.createDelegate(string);
        this.threadList.add(delegate);
        delegate.start();
    }

    protected synchronized boolean checkReserve() {
        return this.threads - this.idles < this.poolReserve;
    }

    private synchronized Runnable getNextRunnable() throws InterruptedException {
        while (this.runnables.isEmpty()) {
            ++this.idles;
            this.wait();
            --this.idles;
        }
        return (Runnable)this.runnables.removeFirst();
    }

    public synchronized void start(Runnable runnable) {
        this.runnables.add(runnable);
        if (this.idles == 0 && this.threads < this.poolMaxSize) {
            ++this.threads;
            this.startNewThread(this.name + "#" + String.valueOf(this.threads));
        } else {
            this.notify();
        }
    }

    protected void init(String string, int n) {
        this.name = string;
        this.poolMaxSize = n;
        this.poolReserve = (n >>> 2) * 3;
    }

    public void destroy() {
        Iterator iterator = this.threadList.iterator();
        while (iterator.hasNext()) {
            Delegate delegate = (Delegate)iterator.next();
            delegate.terminate = true;
            delegate.interrupt();
        }
    }

    public ThreadPool(String string, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("poolMaxSize must be >0");
        }
        this.init(string, n);
    }

    protected class Delegate
    extends Thread {
        protected boolean terminate;

        public Delegate(String string) {
            super(string);
            this.terminate = false;
        }

        public Delegate(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.terminate = false;
        }

        protected void terminate() {
        }

        protected void end() {
        }

        protected void createThread(String string) {
            ThreadPool.this.startNewThread(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.terminate) {
                    ThreadPool.this.getNextRunnable().run();
                    this.end();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                Util.printStackTrace(throwable);
                this.createThread(this.getName());
            }
            finally {
                this.terminate();
            }
        }
    }
}

