/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import php.java.bridge.Util;
import php.java.script.IScriptReader;

public class URLReader
extends Reader
implements IScriptReader {
    private URL url;
    private HttpURLConnection conn;
    private HostnameVerifier hostNameVerifier;
    private SSLSocketFactory sslSocketFactory;

    private HostnameVerifier getHostNameVerifier() {
        if (this.hostNameVerifier != null) {
            return this.hostNameVerifier;
        }
        this.hostNameVerifier = new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        return this.hostNameVerifier;
    }

    private SSLSocketFactory getSslSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        X509TrustManager x509TrustManager = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        KeyManager[] keyManagerArray = null;
        TrustManager[] trustManagerArray = new X509TrustManager[]{x509TrustManager};
        SSLContext sSLContext = null;
        sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        this.sslSocketFactory = sSLContext.getSocketFactory();
        return this.sslSocketFactory;
    }

    public URLReader(URL uRL) throws UnknownHostException, IOException {
        this.url = uRL;
        this.conn = (HttpURLConnection)uRL.openConnection();
        if (this.conn instanceof HttpsURLConnection) {
            this.allowSelfSignedCertificates();
        }
        this.conn.setDoInput(true);
        this.conn.setRequestMethod("GET");
    }

    public URLReader(HttpURLConnection httpURLConnection) {
        this.conn = httpURLConnection;
    }

    private void allowSelfSignedCertificates() {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.conn;
        try {
            httpsURLConnection.setSSLSocketFactory(this.getSslSocketFactory());
        }
        catch (KeyManagementException keyManagementException) {
            Util.printStackTrace((Throwable)keyManagementException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Util.printStackTrace((Throwable)noSuchAlgorithmException);
        }
        httpsURLConnection.setHostnameVerifier(this.getHostNameVerifier());
    }

    public URL getURL() {
        return this.url;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        throw new IllegalStateException("Use urlReader.read(Hashtable, OutputStream) or use a FileReader() instead.");
    }

    private void appendListValues(StringBuffer stringBuffer, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("; ");
        }
    }

    public void read(Map map, OutputStream outputStream, Util.HeaderParser headerParser) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            Object object;
            CharSequence charSequence;
            byte[] byArray = new byte[8192];
            for (int i = 0; i < IScriptReader.HEADER.length; ++i) {
                charSequence = IScriptReader.HEADER[i];
                object = (String)map.get(charSequence);
                if (object == null) continue;
                this.conn.setRequestProperty((String)charSequence, (String)object);
            }
            String string = (String)map.get("X_JAVABRIDGE_OVERRIDE_HOSTS");
            if (string != null) {
                this.conn.setRequestProperty("X_JAVABRIDGE_OVERRIDE_HOSTS", string);
                this.conn.setRequestProperty("X_JAVABRIDGE_OVERRIDE_HOSTS_REDIRECT", string);
            }
            inputStream = this.conn.getInputStream();
            if (headerParser != Util.DEFAULT_HEADER_PARSER) {
                charSequence = new StringBuffer();
                object = this.conn.getHeaderFields().entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    List list = (List)entry.getValue();
                    if (list.size() == 1) {
                        headerParser.addHeader(String.valueOf(entry.getKey()), String.valueOf(list.get(0)));
                        continue;
                    }
                    this.appendListValues((StringBuffer)charSequence, list);
                    headerParser.addHeader(String.valueOf(entry.getKey()), ((StringBuffer)charSequence).toString());
                    ((StringBuffer)charSequence).setLength(0);
                }
            }
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            Util.printStackTrace((Throwable)iOException);
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void close() throws IOException {
    }

    public String toString() {
        return String.valueOf(this.url);
    }
}

