/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import java.io.InputStream;
import php.java.bridge.IJavaBridgeFactory;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;

public abstract class JavaBridgeFactory
implements IJavaBridgeFactory {
    protected JavaBridge bridge = null;

    public abstract ISession getSession(String var1, short var2, int var3);

    public abstract IContext getContext();

    protected JavaBridge checkBridge() {
        return this.bridge;
    }

    public JavaBridge getBridge() {
        if (this.bridge != null) {
            return this.bridge;
        }
        this.bridge = new JavaBridge(this);
        if (Util.logLevel >= 4) {
            Util.logDebug("created new bridge: " + this.bridge);
        }
        return this.bridge;
    }

    public boolean isNew() {
        return this.bridge == null;
    }

    public void recycle() {
    }

    public void destroy() {
        this.bridge = null;
    }

    public void parseHeader(Request req, InputStream in) throws IOException {
        in.read();
        byte option = (byte)(0xFF & in.read());
        if (option == -1) {
            throw new IllegalStateException("not within a JEE environment");
        }
        req.init(option);
    }
}

