/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.SSLServerSocketHelper;
import php.java.bridge.Standalone;
import php.java.bridge.Util;
import php.java.bridge.http.ChunkedInputStream;
import php.java.bridge.http.ChunkedOutputStream;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.HttpRequest;
import php.java.bridge.http.HttpResponse;
import php.java.bridge.http.HttpServer;
import php.java.bridge.http.RemoteHttpContextFactory;

public class JavaBridgeRunner
extends HttpServer {
    protected static JavaBridgeRunner runner;
    protected final ContextServer contextServer = new ContextServer("", Util.JAVABRIDGE_PROMISCUOUS);
    private byte[] cache;

    protected JavaBridgeRunner(String serverPort, boolean isSecure) throws IOException {
        super(serverPort, isSecure);
    }

    protected JavaBridgeRunner(String serverPort) throws IOException {
        this(serverPort, false);
    }

    protected JavaBridgeRunner() throws IOException {
        this(null);
    }

    public ContextServer getContextServer() {
        return this.contextServer;
    }

    public static synchronized JavaBridgeRunner getRequiredInstance(String serverPort, boolean isSecure) throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeRunner(serverPort, isSecure);
        return runner;
    }

    public static synchronized JavaBridgeRunner getInstance(String serverPort, boolean isSecure) {
        if (runner != null) {
            return runner;
        }
        try {
            runner = new JavaBridgeRunner(serverPort, isSecure);
        }
        catch (IOException e) {
            Util.printStackTrace(e);
        }
        return runner;
    }

    public static synchronized JavaBridgeRunner getRequiredInstance(String serverPort) throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeRunner(serverPort);
        return runner;
    }

    public static synchronized JavaBridgeRunner getInstance(String serverPort) {
        if (runner != null) {
            return runner;
        }
        try {
            runner = new JavaBridgeRunner(serverPort);
        }
        catch (IOException e) {
            Util.printStackTrace(e);
        }
        return runner;
    }

    public static synchronized JavaBridgeRunner getRequiredInstance() throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeRunner();
        return runner;
    }

    public ISocketFactory bind(String addr) throws IOException {
        this.socket = JavaBridge.bind(addr);
        return this.socket;
    }

    public ISocketFactory bindSecure(String addr) throws IOException {
        boolean isLocal = true;
        if (addr.startsWith("INET_LOCAL:")) {
            addr = addr.substring(11);
        } else if (addr.startsWith("INET:")) {
            isLocal = false;
            addr = addr.substring(5);
        }
        return SSLServerSocketHelper.bind(Integer.parseInt(addr), 20, isLocal);
    }

    private static String getHeader(String key, HttpRequest req) {
        String val = req.getHeader(key);
        if (val == null) {
            return null;
        }
        if (val.length() == 0) {
            val = null;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpRequest req, HttpResponse res) throws IOException {
        ChunkedInputStream sin = null;
        ChunkedOutputStream sout = null;
        String transferEncoding = JavaBridgeRunner.getHeader("Transfer-Encoding", req);
        boolean isChunked = "chunked".equals(transferEncoding);
        if (!isChunked) {
            throw new IllegalStateException("Please use a JEE server or servlet engine.");
        }
        sin = new ChunkedInputStream(req.getInputStream());
        sout = new ChunkedOutputStream(res.getOutputStream());
        RemoteHttpContextFactory ctx = new RemoteHttpContextFactory(req, res);
        res.setHeader("X_JAVABRIDGE_CONTEXT", ctx.getId());
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Keep-Alive", "timeout=-1, max=-1");
        try {
            ctx.getBridge().handleRequests(sin, sout);
            sin.eof();
            sout.eof();
        }
        finally {
            ctx.destroy();
        }
    }

    protected boolean showDirectory(String fullName, File f, int length, HttpRequest req, HttpResponse res) throws IOException {
        if (!f.isDirectory()) {
            return false;
        }
        ByteArrayOutputStream xout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)xout, "UTF-8")));
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Directory Listing for " + fullName + "/</title>");
        out.println("<STYLE><!--H1{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} H3{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} BODY{font-family : sans-serif,Arial,Tahoma;color : black;background-color : white;} B{color : white;background-color : #0086b2;} A{color : black;} HR{color : #0086b2;} --></STYLE> </head>");
        File parentFile = f.getParentFile();
        String parentName = parentFile == null ? "/" : parentFile.getName();
        out.println("<body><h1>Directory Listing for " + fullName + " - <a href=\"../\"><b>Up To " + parentName + "</b></a></h1><HR size=\"1\" noshade><table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">");
        out.println("<tr>");
        out.println("<td align=\"left\"><font size=\"+1\"><strong>Filename</strong></font></td>");
        out.println("<td align=\"left\"><font size=\"+1\"><strong>Type</strong></font></td>");
        out.println("<td align=\"center\"><font size=\"+1\"><strong>Size</strong></font></td>");
        out.println("<td align=\"right\"><font size=\"+1\"><strong>Last Modified</strong></font></td>");
        out.println("");
        out.println("</tr>");
        File[] dir = f.listFiles();
        int count = 0;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < dir.length; ++i) {
            boolean even;
            File file = dir[i];
            if (file.isHidden()) continue;
            boolean bl = even = count++ % 2 == 0;
            if (even) {
                out.println("<tr>");
            } else {
                out.println("<tr bgcolor=\"eeeeee\">");
            }
            if (fullName.length() != 0 && !fullName.endsWith("/")) {
                b.append(f.getName());
                b.append("/");
            }
            b.append(file.getName());
            if (file.isDirectory()) {
                b.append("/");
            }
            out.println("<td align=\"left\">&nbsp;&nbsp;");
            if (file.isDirectory()) {
                out.println("<a href=\"" + b.toString() + "\"><tt>" + file.getName() + "/</tt></a></td>");
                out.println("<td align=\"left\">&nbsp;&nbsp;");
                out.println("<a href=\"" + b.toString() + "?edit\"><tt>directory</tt></a></td>");
            } else {
                out.println("<a href=\"" + b.toString() + "\"><tt>" + file.getName() + "</tt></a></td>");
                out.println("<td align=\"left\">&nbsp;&nbsp;");
                out.println("<a href=\"" + b.toString() + "?show\"><tt>file</tt></a></td>");
            }
            out.println("<td align=\"right\"><tt>" + file.length() + "</tt></td>");
            out.println("<td align=\"right\"><tt>" + Util.formatDateTime(file.lastModified()) + "</tt></td>");
            out.println("</tr>");
            b.setLength(0);
        }
        out.println("</table>");
        out.println("<HR size=\"1\" noshade><h3>Simple JSR 223 enabled web server version 0.0.1</h3>");
        out.println("<h4>Available script engines</h4><ul>");
        try {
            Class<?> c = Class.forName("javax.script.ScriptEngineManager");
            Object o = c.newInstance();
            Method ex = c.getMethod("getEngineByExtension", String.class);
            if (ex.invoke(o, (Object[])new String[]{"php"}) == null) {
                out.println("Warning: php-script.jar not found. Please copy it to the directory containing JavaBridge.jar before starting JavaBridge.<br><br>");
            }
            Method e = c.getMethod("getEngineFactories", new Class[0]);
            List factories = (List)e.invoke(o, new Object[0]);
            StringBuffer buf = new StringBuffer();
            Iterator ii = factories.iterator();
            while (ii.hasNext()) {
                o = ii.next();
                Method getName = o.getClass().getMethod("getEngineName", new Class[0]);
                Method getVersion = o.getClass().getMethod("getEngineVersion", new Class[0]);
                Method getNames = o.getClass().getMethod("getNames", new Class[0]);
                Method getExtensions = o.getClass().getMethod("getExtensions", new Class[0]);
                buf.append("<li>");
                buf.append(getName.invoke(o, new Object[0]));
                buf.append(", ");
                buf.append("ver.: ");
                buf.append(getVersion.invoke(o, new Object[0]));
                buf.append(", ");
                buf.append("alias: ");
                buf.append(getNames.invoke(o, new Object[0]));
                buf.append(", ");
                buf.append(".ext: ");
                buf.append(getExtensions.invoke(o, new Object[0]));
                buf.append("</li>");
                out.println(buf);
                buf.setLength(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.println("</font></ul>");
        out.println("</body>");
        out.println("</html>");
        res.addHeader("Content-Type", "text/html; charset=UTF-8");
        res.addHeader("Last-Modified", Util.formatDateTime(f.lastModified()));
        out.close();
        int outLength = xout.size();
        res.setContentLength(outLength);
        xout.writeTo(res.getOutputStream());
        return true;
    }

    protected boolean handleScriptContent(String name, String params, File f, int length, HttpRequest req, HttpResponse res) throws IOException {
        return true;
    }

    protected void showTextFile(String name, String params, File f, int length, HttpRequest req, HttpResponse res, boolean show) throws IOException {
        int c;
        if (Util.logLevel > 4) {
            Util.logDebug("web server: show text file:" + name);
        }
        res.addHeader("Last-Modified", Util.formatDateTime(f.lastModified()));
        if (show) {
            res.addHeader("Content-Type", "text/plain");
        }
        res.setContentLength(length);
        FileInputStream in = new FileInputStream(f);
        byte[] buf = new byte[8192];
        OutputStream out = res.getOutputStream();
        while ((c = ((InputStream)in).read(buf)) != -1) {
            out.write(buf, 0, c);
        }
        ((InputStream)in).close();
    }

    protected void doGet(HttpRequest req, HttpResponse res) throws IOException {
        this.handleDoGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDoGet(HttpRequest req, HttpResponse res) throws IOException {
        String name = req.getRequestURI();
        if (name == null) {
            super.doGet(req, res);
            return;
        }
        if (!name.startsWith("/JavaBridge")) {
            File f;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            String params = null;
            int idx = name.indexOf(63);
            if (idx != -1) {
                params = name.substring(idx + 1);
                name = name.substring(0, idx);
            }
            if ((f = Standalone.getCanonicalWindowsFile(name)) == null || !f.exists()) {
                f = new File(Util.HOME_DIR, name);
            }
            if (f == null || !f.exists()) {
                return;
            }
            if (f.isHidden()) {
                return;
            }
            long l = f.length();
            if (l >= Integer.MAX_VALUE) {
                throw new IOException("file " + name + " too large");
            }
            int length = (int)l;
            if (this.showDirectory(name, f, length, req, res)) {
                return;
            }
            if (this.handleScriptContent(name, params, f, length, req, res)) {
                return;
            }
            this.showTextFile(name, params, f, length, req, res, !name.endsWith(".html") || "show".equals(params));
            return;
        }
        if (this.cache != null && name.endsWith("Java.inc")) {
            res.setContentLength(this.cache.length);
            res.getOutputStream().write(this.cache);
            return;
        }
        if (Util.JAVA_INC != null && name.endsWith("Java.inc")) {
            try {
                Field f = Util.JAVA_INC.getField("bytes");
                byte[] buf = (byte[])f.get(Util.JAVA_INC);
                this.cache = buf;
                res.setContentLength(buf.length);
                OutputStream out = res.getOutputStream();
                out.write(buf);
                return;
            }
            catch (SecurityException e) {
            }
            catch (Exception e) {
                Util.printStackTrace(e);
            }
        }
        name = name.replaceFirst("/JavaBridge", "META-INF");
        InputStream in = JavaBridgeRunner.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            name = name.replaceFirst("Java\\.inc", "JavaBridge.inc");
            in = JavaBridgeRunner.class.getClassLoader().getResourceAsStream(name);
            if (in == null) {
                res.setContentLength(ERROR.length);
                res.getOutputStream().write(ERROR);
                return;
            }
            if (Util.logLevel > 4) {
                Util.logDebug("Java.inc not found, using JavaBridge.inc instead");
            }
        }
        try {
            int c;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((c = in.read(buf)) > 0) {
                bout.write(buf, 0, c);
            }
            res.addHeader("Last-Modified", "Wed, 17 Jan 2007 19:52:43 GMT");
            res.setContentLength(bout.size());
            OutputStream out = res.getOutputStream();
            out.write(bout.toByteArray());
        }
        catch (IOException e) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public void waitFor() throws InterruptedException {
        JavaBridgeRunner.runner.httpServer.join();
    }

    public static void destroyRunner() {
        if (runner != null) {
            runner.destroy();
        }
    }
}

